{****************************************************************************}
{                                                                            }
{          Copyright (C) Christian Baumgarten, Hamburg 1993.                 }
{                                                                            }
{ Das Programm demonstriert den Umgang mit den FCB-Funktionen des Intr. 21h: }
{ Eine Datei FCBDEMO.DAT wird im aktuellen Pfad erzeugt und mit einem String }
{ beschrieben. Der jeweils altuelle Zustand des FCBs wird bei jedem Schritt  }
{ dargestellt. Wer mag, kann an den entsprechenden Stellen z.B. die Record-  }
{ gre variieren o..                                                       }
{                                                                            }
{****************************************************************************}

program fcbdemo1;

uses codes;
type
    pFileCtrl=^tFileCtrl;
    tFileCtrl=record { 32+1=33 Byte }
      LW:byte;
      Name:Array[1..11] of Char;
      Current:word;
      RecSize:Word;
      size:longint;
      date:word;
      time:word;
       Attribut: Byte;  { Bit  7 6 5 4 3 2 1 0 }
                        {      R A ? ? ? ? ? ? }
       Fill:Word;
       StartClust:Word;
       DirSector:Word;
       DirEntry:Byte;
      CurRec:Byte;
      RelRec:Longint;
     end;


function AttributString(attr:byte):string;
var s:string[8];
 begin
  s:='';
  if (attr and 1)>0 then s:='R';
  if (attr and 2)>0 then s:='H'+s;
  if (attr and 4)>0 then s:='S'+s;
  if (attr and 8)>0 then s:='L'+s;
  if (attr and $10)>0 then s:='<DIR>'+s;
  if (attr and $20)>0 then s:='A'+s;
  while length(s)<8 do s:=s+' ';
  AttributString:=s;
 end;

function TimeString(Time:word):string;
var Hour,Min:word;
    m,s:string[5];
 begin
  Hour:=Time shr 11;
  Min:=(Time shr 5) and $3F;
  str(Hour,s);
  if length(s)<2 then s:=' '+s;
  str(Min,m);
  if length(m)<2 then m:='0'+m;
  s:=s+':'+m;
  TimeString:=s;
 end;

function DateString(Date:word):string;
var Day,Year,Month:word;
    s,m:string[8];
 begin
  Year:=Date shr 9+80;
  Month:=(Date shr 5) and $F;
  Day:=Date and $1F;
  str(Year,s);
  str(Month,m);
  if length(m)<2 then m:='0'+m;
  s:=m+'.'+s;
  str(Day,m);
  if length(m)<2 then m:='0'+m;
  s:=m+'.'+s;
  DateString:=s;
 end;

procedure SetDTA(where:pointer); assembler;
 asm
  push ds
  lds  dx,where
  mov  ah,$1A
  int  21h
  pop  ds
 end;

function  GetDTAptr:pointer; assembler;
 asm
  mov  ah,$2F
  push ds
  int  21h
  pop  ds
  mov  dx,es
  mov  ax,bx
 end;

function CreateFile(var FCB:tFileCtrl):byte; assembler;
 asm
  push ds
  mov  ah,$16
  lds  dx,fcb
  int  21H
  pop  ds
 end;

function Write2File(var FCB:tFileCtrl):byte; assembler;
 asm
  push ds
  mov  ah,$15
  lds  dx,fcb
  int  21H
  pop  ds
 end;

function ReadFile(var FCB:tFileCtrl):byte; assembler;
 asm
  push ds
  mov  ah,$14
  lds  dx,fcb
  int  21H
  pop  ds
 end;

function OpenFile(var FCB:tFileCtrl):byte; assembler;
 asm
  push ds
  mov  ah,$0F
  lds  dx,fcb
  int  21H
  pop  ds
 end;

Function RenameFile(var FCB:tFileCtrl):byte; assembler;
 asm
  push ds
  mov  ah,$17
  lds  dx,fcb
  int  21H
  pop  ds
 end;

Function CloseFile(var FCB:tFileCtrl):byte; assembler;
 asm
  push ds
  mov  ah,$10
  lds  dx,fcb
  int  21H
  pop  ds
 end;

procedure DisplayFCB(var FCB:tFileCtrl);
 var i:byte;
 begin
  writeln;
  writeln('Laufwerk: ',Char(FCB.lw+64));
  writeln('Name    : ',FCB.name);
  writeln('Current : ',FCB.current);
  writeln('RecSize : ',FCB.RecSize);
  writeln('Gre   : ',FCB.Size);
  writeln('Date    : ',DateString(FCB.Date));
  writeln('Time    : ',TimeString(FCB.Time));
  writeln('Attribut: ',hexbyte(fcb.attribut));
  writeln('Fill    : ',fcb.fill,' ',Hexword(fcb.fill));
  writeln('StartCluster: ',fcb.startclust);
  writeln('DirSektor: ',fcb.dirsector);
  writeln('DirEntry : ',fcb.direntry);
  writeln('Current Record: ',fcb.CurRec);
  writeln('Relativ Record: ',fcb.RelRec);
  readln;
 end;

var F1,F2:tFileCtrl;
const S:String= 'Dies ist ein String ist ein String ist ein String ist ein String ist ein String ist ein String '+
                ' ist ein String ist ein String ist ein String ist ein String ist ein String ist ein String';
begin
 { Disktransfer-Area auf den String setzen: }
 SetDTA(@S[1]);
 { FCB vorbereiten: }
 Fillchar(F1,sizeof(f1),0);
 F1.LW:=0;
 F1.Name:='FCBDEMO DAT';
 { Datei erzeugen:  }
 Writeln(CreateFile(F1));
 DisplayFCB(f1);
 { Einen Datensatz schreiben (=128 Byte): }
 Writeln(Write2File(F1));
 DisplayFCB(f1);
 { Datei schlieen: }
 Writeln(CloseFile(F1));
 DisplayFCB(f1);
end.