{***************************************************************************}
{                                                                           }
{          Copyright (C) Christian Baumgarten, Hamburg 1993.                }
{                                                                           }
{       Unit fr das Dateimanagement mit Hilfe der FCB-Funktionen           }
{                                                                           }
{***************************************************************************}

UNIT FCBS;

INTERFACE

type
    DosStr=string[12];

    DosName=array[1..11] of char;

    DosExt=array[1..3] of char;

    DosPreName=array[1..8] of char;

    pDirEntry=^tDirEntry;
    tDirEntry=record    { Entspricht einem Verzeichniseintrag           }
     PreName:DosPreName;
     Ext:DosExt;
                        { Name[1]=$00           : unbenutzter Eintrag   }
                        { Name[1]=$05/$E5  ='' : gelschter  Eintrag   }
                        { Name[1]=$2E      ='.' : SELF                  }
                        { Name[1..2]=$2E2E ='..': UPDIR                 }
     attr:byte;         { __ADVSHR =Archive,Dir,Vol_ID,Sys,Hid,ReadOnly }
     Reserved:Array[1..10] of byte;
     time:word;         { HHHH HMMM MMMS SSSS ,Hour:Minute:Second       }
     date:word;         { YYYY YYYM MMMD DDDD ,Year:Month:Day           }
     startclust:word;   { Erster Datencluster des Files                 }
     size:longint;
    end;

    pFileCtrl=^tFileCtrl;
    tFileCtrl=record
      LW:byte;
      case byte of
      0:(dir:tDirEntry;);
      1:(Name:Dosname;
         attr:byte;
         fill:array[1..10] of byte;
         time:word;
         date:word;
         startclust:word;
         size:longint;);
      end;

     tXFileCtrl=record { 41+33=74 Byte }
      flag:byte; { =$FF  }
      res:array[1..5] of byte;
      attr:byte;
      {------}
      SLW:byte;
      sname:Dosname;
      sattr:byte;
      DirEntry:word;
      DirClust:word;
      res1:array[1..16] of byte; { Verwendung unbekannt }
      case byte of
      0:(FCB:tFileCtrl;);
      1:(LW:byte;
         Name:Dosname;
         fattr:byte;
         fill:array[1..10] of byte;
         time:word;
         date:word;
         startclust:word;
         size:longint;);
     end;

procedure GetFirstFCB(name:Dosstr;attr:byte;var FCB:tXFileCtrl);
procedure GetNextFCB(var FCB:tXFileCtrl);
procedure SetDTA(where:pointer);
function  GetDTAptr:pointer;

IMPLEMENTATION

USES  DOS;

procedure SetDTA(where:pointer); assembler;
 asm
  push ds
  lds  dx,where
  mov  ah,$1A
  int  21h
  pop  ds
 end;

function  GetDTAptr:pointer; assembler;
 asm
  mov  ah,$2F
  push ds
  int  21h
  pop  ds
  mov  dx,es
  mov  ax,bx
 end;

procedure GetFirstFCB(name:Dosstr;attr:byte;var FCB:tXFileCtrl);
 begin
  fillchar(FCB,sizeof(tXFileCtrl),0);
  FCB.Flag:=$FF;
  if length(name)<12 then name[length(name)+1]:=#0;
  Move(name[1],name[0],12);
  name[12]:=#0;
  {----------- INTR $21 FKT. $29: Parse File Name -------------}
   asm
    mov  ax,$2900
    push ds
    les  di,fcb
    add  di,7
    lea  si,name
    push ss
    pop  ds
    int  21h
    pop  ds
   end;
   fcb.flag:=$FF;
   fcb.attr:=attr;
   asm
    push ds
    lds  dx,FCB
  {------------ INTR $21 FKT. $11: Search For First Entry ------------- }
    mov  ah,$11
    Int  $21
    pop  ds
    or   al,al
    jne  @@error
  {----------- INTR $21 FKT. $2F: Get DISK Tranfer Area -------------- }
    mov  ah,$2F
    push ds
    Int  $21
    push es
    pop  ds
    mov  si,bx
    add  si,7
    mov  cx,33
    les  di,FCB
    add  di,40
    cld
    rep  movsb
    pop  ds
    xor  ax,ax
    jmp  @@OK
@@error:
    xor  ah,ah
@@OK:
    mov  doserror,ax
   end;
 end;

procedure GetNextFCB(var FCB:tXFileCtrl);
 begin
  asm
 {----------- INTR $21 FKT. $12: Search for next Entry -------------- }
    mov  ah,$12
    push ds
    lds  dx,FCB
    Int  $21
    pop  ds
    or   al,al
    jne  @@error
 {----------- INTR $21 FKT. $2F: Get DISK Tranfer Area -------------- }
    mov  ah,$2F
    push ds
    Int  $21
    push es
    pop  ds
    mov  si,bx
    add  si,7
    mov  cx,33
    les  di,FCB
    add  di,40
    cld
    rep  movsb
    pop  ds
    xor  ax,ax
    jmp  @@OK
@@error:
    xor  ah,ah
@@OK:
    mov  doserror,ax
   end;
 end;


END.