;***************************************************************;
;                                                               ;
;    Copyright (c) 1993 by CHRISTIAN BAUMGARTEN, Hamburg        ;
;                                                               ;
;    FLOATING POINT EMULATOR FR 80386er PROZESSOREN UND        ;
;                                                               ;
;             80 BIT-FLIESSKOMMAFORMAT (EXTENDED)               ;
;                                                               ;
;***************************************************************;

        TITLE FLOAT386

        LOCALS

B_1     EQU DWORD PTR [BP+6]
B_2     EQU DWORD PTR [BP+10]

B4      EQU  WORD PTR [BP+12]
B_E     EQU  WORD PTR [BP+14]

A_1     EQU DWORD PTR [BP+16]
A_2     EQU DWORD PTR [BP+20]

A4      EQU  WORD PTR [BP+22]
A_E     EQU  WORD PTR [BP+24]

C_1     EQU DWORD PTR [BP-10]
C_2     EQU DWORD PTR [BP-6]

C4      EQU  WORD PTR [BP-4]
C_E     EQU  WORD PTR [BP-2]

F_BIAS  EQU 16383
F_WORDS EQU 4
F_SIZE  EQU 8

.386P

DATA	SEGMENT	BYTE PUBLIC USE16

DATA	ENDS

CODE	SEGMENT	BYTE PUBLIC USE16

	ASSUME	CS:CODE,DS:DATA

;***************************************************************************;
; Alle Routinen gehen davon aus, von einer Turbo-Pascal-Funktion der Form   ;
; 'Function F(A,B:Extended):Extended;' aufgerufen zu werden.                ;
; D.h., da die Eingabewerte auf dem Stack liegen und @Result an der        ;
; Stelle ss:[bp-10] ist ! (Vergl. obige Definitionen)                       ;
;                       Alle Routinen sind near !!                          ;
; Fr die Division exestieren zur Verdeutlichung zwei Routinen. Die erste,  ;
; FDIV386 dividiert die Mantissen, wie man auf dem Papier dividiert:        ;
; Durch sukzessive Subtraktion. Die zweite (wesentlich schnellere) FQDIV386 ;
; nutzt den ASM-Befehl DIV geschickt aus, um die Mantissen zu dividieren.   ;
;***************************************************************************;

; Aufruf dieser Funktionen: FXXX(A,B:extended):extended

        PUBLIC  FMUL386, FADD386, FSUB386, FDIV386, FQDIV386

; Aufruf dieser Funktionen: FXXX(A:extended):extended

        PUBLIC  FSQR386,FSQRT386,FLOG2386

; Hilfsroutine, die Null oder NaN zurckliefert:

FILL_C386  PROC      NEAR
            MOV     C_1,EAX
            MOV     C_2,EAX
            MOV     C_E,AX
           RET
FILL_C386  ENDP

NaN386:     MOV  EAX,0FFFFFFFFH
            JMP   FILL_C386
Zero386:    XOR  EAX,EAX
            JMP   FILL_C386

; Hilfsroutine, die Vorzeichen & Exponenten multipliziert

MUL_SIGNS  PROC      NEAR
            mov  ax,a_e
            mov  bx,ax
            and  ax,07fffh
            mov  cx,b_e
            mov  dx,cx
            and  cx,07fffh
            sub  cx,f_bias
            sub  ax,f_bias
            add  ax,cx
            add  ax,f_bias
            xor  bx,dx
            and  bx,08000h
           RET
MUL_SIGNS  ENDP

; Hilfsroutine, die die Vorzeichen liefert:
; A negativ == Bit 1 in CX gesetzt
; B negativ == Bit 0 in CX gesetzt

GETSIGNS    PROC      NEAR
             XOR  CX,CX
             MOV  AX,A_E
             MOV  BX,B_E
             RCL  AX,1
             RCL  CX,1
             RCL  BX,1
             RCL  CX,1
             SHR  AX,1
             SHR  BX,1
             SUB  AX,F_BIAS
             SUB  BX,F_BIAS
            RET
GETSIGNS    ENDP

;  Hilfsroutine, die das Ergebnis von A nach C schiebt:

MOV_C_A386  PROC     NEAR
             MOV   EAX,A_1
             MOV   C_1,EAX
             MOV   EAX,A_2
             MOV   C_2,EAX
             MOV   AX,A_E
             MOV   C_E,AX
             RET
MOV_C_A386  ENDP

; Hilfsroutine, die B mit CL nach rechts rotiert (Fr Addition/Subtraktion)

ROTR_B386    PROC     NEAR
              PUSH EAX
              mov  eax,b_2
              shrd b_1,eax,cl
              shr  b_2,cl
              POP  EAX
              RET
ROTR_B386    ENDP

; Hilfsroutine, die die Eingabewerte austauscht

XCHG_A_B386  PROC   NEAR
              MOV  EDX,A_1
              XCHG EDX,B_1
              MOV  A_1,EDX
              MOV  EDX,A_2
              XCHG EDX,B_2
              MOV  A_2,EDX
              MOV  DX,A_E
              XCHG DX,B_E
              MOV  A_E,DX
             RET
XCHG_A_B386  ENDP

; Hilfsroutine, die die Mantisse von B zu A addiert

ADD_A_B386   PROC  NEAR
              SUB  AX,BX
              JNS  short @@1
              CALL XCHG_A_B386
              NEG  AX
@@1:          CMP  AX , F_WORDS * 16
              JAE  short @@OK
              OR   AX,AX
              JZ   short @@2
              CLC
              MOV  CX,AX
              CALL ROTR_B386
@@2:          mov  eax,b_1
              add  a_1,eax
              mov  eax,b_2
              adc  a_2,eax
              jnc  short @@OK
              shr  a_2,1
              rcr  a_1,1
              inc  a_E
@@OK:         RET
ADD_A_B386   ENDP

; Hilfsroutine, die die Eingabemantissen vergleicht (entspr. CMP A,B)

MCMP386      PROC   NEAR
              PUSH  EAX
              MOV   EAX,A_2
              CMP   EAX,B_2
              JNE   short @@EXIT
              MOV   EAX,A_1
              CMP   EAX,B_1
@@EXIT:       POP   EAX
              RET
MCMP386      ENDP

; Hilfsroutine, die die Mantisse von B von A abzieht

SUB_A_B386   PROC   NEAR
                CMP  AX,BX
                JG   short @@1
                JL   short @@X
                CALL MCMP386
                JE   @@ZERO
                JA   short @@1
@@X:            CALL XCHG_A_B386
                XCHG AX,BX
                CALL SUB_A_B386
                XOR  A_E,08000H
                RET
@@1:            SUB  AX,BX
                CMP  AX, F_WORDS * 16
                JAE  short @@4
                OR   AX,AX
                JZ   short @@2
                MOV  CX,AX
                CALL ROTR_B386
@@2:            mov  eax,b_1
                sub  a_1,eax
                mov  eax,b_2
                sbb  a_2,eax
                JNZ  short @@3
                xor  eax,eax
                xchg eax,a_1
                mov  a_2,eax
                sub  a_e,32
                or   eax,eax
                jz   short @@3a
@@3:            TEST a4,08000H
                jnz  short @@4
                shl  a_1,1
                rcl  a_2,1
                dec  a_e
                JMP  @@3
@@3a:           and  a_e,08000H
@@4:            RET
@@ZERO:         XOR  EAX,EAX
                MOV  A_1,EAX
                MOV  A_2,EAX
                MOV  A_E,AX
                RET
SUB_A_B386    ENDP

FADD386        PROC      NEAR
                CALL  GETSIGNS
                CMP   CX,1
                JNE   short @@1
                XOR   B_E,08000H
                CALL  SUB_A_B386
                JMP   short @@ENDE
@@1:            CMP   CX,2
                JNE   short @@2
                XOR   A_E,08000H
                CALL  XCHG_A_B386
                XCHG  AX,BX
                CALL  SUB_A_B386
                JMP   short @@ENDE
@@2:            CMP   CX,3
                PUSHF
                JNE   short @@3
                XOR   A_E,08000H
                XOR   B_E,08000H
@@3:            CALL  ADD_A_B386
                POPF
                JNE   short @@ENDE
                XOR   a_E,08000H
@@ENDE:         CALL  MOV_C_A386
                RET
FADD386        ENDP

FSUB386        PROC      NEAR
                CALL  GETSIGNS
                OR    CX,CX
                JE    short @@3
                CMP   CX,2
                JNE   short @@1
                XOR   A_E,08000H
                CALL  ADD_A_B386
                XOR   A_E,08000H
                JMP   short @@ENDE
@@1:            CMP   CX,1
                JNE   @@2
                XOR   B_E,08000H
                CALL  ADD_A_B386
                JMP   short @@ENDE
@@2:            CMP   CX,3
                JNE   short @@3
                XOR   A_E,08000H
                XOR   B_E,08000H
                CALL  XCHG_A_B386
                XCHG  AX,BX
@@3:            CALL  SUB_A_B386
@@ENDE:         CALL  MOV_C_A386
                RET
FSUB386        ENDP

FMUL386    PROC      NEAR
             mov  ax,a_e
             or   ax,ax
             je    zero386
             cmp  ax,0FFFFH
             je    NaN386

             mov  ax,b_e
             or   ax,ax
             je    zero386
             cmp  ax,0FFFFH
             je    NaN386

             mov  esi,b_1
             mov  edi,b_2
             mov  ebx,a_2
             mov  eax,ebx
             mul  edi
             mov  c_1,eax
             mov  c_2,edx

             mov  eax,ebx
             mul  esi
             mov  ecx,eax
             add  c_1,edx
             adc  c_2,0

             mov  ebx,a_1

             mov  eax,ebx
             mul  edi
             add  ecx,eax
             adc  c_1,edx
             adc  c_2,0

             mov  eax,ebx
             mul  esi
             add  ecx,edx
             add  c_1,0
             adc  c_2,0

             CALL MUL_SIGNS

             test c4,08000h
             jnz  short @@1
             shl  c_1,1
             rcl  c_2,1
             jmp  short @@2
@@1:         inc  ax
@@2:         or   ax,bx
             mov  C_E,ax
            RET
FMUL386     ENDP

FDIV386        PROC      NEAR
                mov  ax,a_e
                or   ax,ax
                je    zero386
                cmp  ax,0FFFFH
                je    NaN386

                mov  ax,b_e
                or   ax,ax
                je    NaN386
                cmp  ax,0FFFFH
                je    Zero386

                mov  ax,A_E       ; Exponentenberechnung:
                mov  bx,ax        ;
                and  ax,07fffh    ; AX = Exponent(A)
                mov  cx,B_E
                mov  dx,cx
                and  cx,07fffh    ; CX = Exponent(B)
                add  ax,f_bias
                sub  ax,cx
                xor  bx,dx
                and  bx,08000H    ; BX = SIGN(A/B)
                mov  ecx,b_1
                mov  edx,b_2
                call mcmp386
                ja   short @@1
                shr  edx,1
                rcr  ecx,1
                dec  ax
@@1:            or   ax,bx
                mov  c_e,ax
                xor  esi,esi
                xor  edi,edi
                jmp  short @@4
@@3:            shr  edx,1
                rcr  ecx,1
@@4:            mov  eax,a_1
                mov  ebx,a_2
                sub  eax,ecx
                sbb  ebx,edx
                jc   short @@2
                mov  a_1,eax
                mov  a_2,ebx
@@2:            cmc
                rcl  esi,1
                rcl  edi,1
                or   edi,edi
                jns  @@3
                mov  c_1,esi
                mov  c_2,edi
                RET
FDIV386        ENDP

QDIV           PROC  NEAR
               XOR   CX,CX
@@_1:          OR    EDI,EDI
               JE    short @@1
               SHR   EDI,1
               RCR   EDX,1
               RCR   EAX,1
               INC   CX
               JMP   @@_1
@@1:           TEST  EDX,0C0000000H
               JE    short @@2
               SHR   EDX,1
               RCR   EAX,1
               INC   CX
               JMP   @@1
@@2:           DIV   EBX
               XOR   EDX,EDX
               JCXZ  short @@4
               SHLD  EDX,EAX,CL
               SHL   EAX,CL
@@4:           RET
QDIV           ENDP

FQDIV386       PROC  NEAR
                mov  ax,a_e
                or   ax,ax
                je    zero386
                cmp  ax,0FFFFH
                je    NaN386

                mov  ax,b_e
                or   ax,ax
                je    NaN386
                cmp  ax,0FFFFH
                je    Zero386

                mov  ax,A_E       ; Exponentenberechnung:
                mov  bx,ax        ;
                and  ax,07fffh    ; AX = Exponent(A)
                mov  cx,B_E
                mov  dx,cx
                and  cx,07fffh    ; CX = Exponent(B)
                add  ax,f_bias
                sub  ax,cx
                xor  bx,dx
                and  bx,08000H    ; BX = SIGN(A/B)
                shr  A_2,1
                rcr  A_1,1
                or   ax,bx
                mov  c_e,ax       ; C_E = Exponent(A) - Exponent(B)
                xor  edi,edi
                mov  edx,A_2
                mov  eax,A_1
                mov  ebx,B_2
                call qDiv
                MOV  C_2,EAX
@@1:            MOV  ESI,EAX
                MUL  EBX
                PUSH A_2
                PUSH A_1
                SUB  A_1,EAX
                SBB  A_2,EDX
                MOV  EAX,B_1
                MUL  ESI
                SUB  A_1,EDX
                SBB  A_2,0
                JNC  Short @@2
                POP  A_1
                POP  A_2
                DEC  C_2
                MOV  EAX,C_2
                JMP  @@1
@@2:            ADD  SP,8
                MOV  EDI,A_2
                MOV  EDX,A_1
                XOR  EAX,EAX
                CALL QDIV
                MOV  C_1,EAX
                ADD  C_2,EDX
@@3:            TEST C4,08000H
                JNE  short @@X
                SHL  C_1,1
                RCL  C_2,1
                DEC  C_E
                JMP  @@3
@@X:           RET
FQDIV386       ENDP

SQR_SIGN      PROC   NEAR
               mov  ax,b_E
               and  ax,07FFFH
               jz    zero386
               sub  ax,f_bias
               shl  ax,1
               add  ax,f_bias
               or   ax,ax
              RET
SQR_SIGN      ENDP


FSQR386    PROC      NEAR
             mov  ax,b_e
             or   ax,ax
             jz    Zero386
             cmp  ax,0FFFFH
             je    NaN386

             mov  esi,b_1
             mov  edi,b_2

             mov  eax,edi
             mul  edi
             mov  c_1,eax
             mov  c_2,edx

             mov  eax,edi
             mul  esi
             shl  eax,1
             rcl  edx,1
             mov  ecx,eax
             add  c_1,edx
             adc  c_2,0

             mov  eax,esi
             mul  esi
             add  ecx,edx
             add  c_1,0
             adc  c_2,0

             call sqr_sign
             js   NaN386

             test c4,08000h
             jnz  short @@1
             shl  c_1,1
             rcl  c_2,1
             jmp  short @@2
@@1:         inc  ax
@@2:         mov  c_e,ax
            RET
FSQR386     ENDP

;-------------------------------------------------------------------------
;  Die Mantisse einer Fliekommazahl besteht aus zwei Doppelworten.
;  Sei das Ergebnis (c,d) und die Eingabe (a,b). Dann soll gelten:
;  a = hi(c*c) , b = lo(c * c) + 2 * hi(c * d)
;  => c = isqrt(a)
;  => d = ((a,b) - c * c) / 2 / c
;  Die Wurzel wird in drei Schritten gezogen:
;  1) Exponent halbieren
;  2) c als "Integerwurzel" von a berechnen
;  3) i  )  Das Quadrat von c von (a,b) abziehen.
;     ii )  Das Ergebnis durch 2 teilen.
;     iii)  Das Ergebnis durch c teilen (incl. Normalisierung fr Division)
;-------------------------------------------------------------------------
FSQRT386    PROC  NEAR
            TEST  B_E,08000H
            JNE   ZERO386
            MOV   AX,B_E
            SUB   AX,f_bias
            test  ax,1           ; Exponenten geradzahlig machen:
            je    short @@start
            inc   ax
            shr   B_2,1
            rcr   B_1,1
@@start:    sar   ax,1
            add   ax,f_bias
            mov   c_e,ax
            shr   b_2,1    ; Input normalisieren (1. DWord entspr. 2^-32 !)
            rcr   B_1,1
            mov   ebx,0AAAAAAAAH  ; Willkrlichen hohen (!) Startwert setzen
            ; Iterationsschleife Xn <= (Xn + A/Xn ) / 2 :
@@1:        mov   edx,b_2    ; A / Xn berechnen:
            mov   eax,b_1
            div   ebx
            add   eax,ebx    ; Xn addieren:
            rcr   eax,1      ; Durch 2 teilen
            mov   edi,eax    ; Abbruchbedingung testen
            cmp   edi,ebx
            jz    short @@2
            dec   edi
            cmp   edi,ebx
            jz    short @@2
            mov   ebx,eax    ; Xn := Xn+1
            jmp   short @@1
@@2:        mov   edi,eax    ; Rest berechnen:
            mul   eax
            sub   b_1,eax
            sbb   b_2,edx
            mov   eax,b_1
            mov   edx,b_2
            xor   ecx,ecx
            xor   ebx,ebx
            mov   esi,0C0000000H
@@21:       shr   edx,1
            rcr   eax,1
            rcr   ebx,1
            or    edx,edx
            jz    short @@22
            inc   cx
            jmp   @@21
@@22:       test  eax,esi
            jz    short @@23
            inc   cx
            jmp   @@21
@@23:       mov   edx,eax
            mov   eax,ebx
            div   edi
            xor   edx,edx
            jcxz  short @@25
@@24:       shl   eax,1
            rcl   edx,1
            loop  @@24
@@25:       mov   c_1,eax
            mov   c_2,edi
@@3:        test  c4,08000H
            jne   short @@4
            shl   c_1,1
            rcl   c_2,1
            dec   c_e
            jmp   @@3
@@4:        RET
FSQRT386    ENDP

SQR_M       PROC  NEAR   ; Zwischenergebnis in EDI:ESI:EBX
            MOV   EAX,B_2  ; B_2 * B_2
            MUL   EAX
            MOV   EDI,EDX
            MOV   ESI,EAX
            MOV   EAX,B_2  ; B_2 * B_1
            MUL   B_1
            ADD   ESI,EDX
            ADC   EDI,0
            ADD   ESI,EDX
            ADC   EDI,0
            MOV   B_1,ESI
            MOV   B_2,EDI
            RET
SQR_M       ENDP

FLOG2386    PROC  NEAR
            XOR   EAX,EAX
            MOV   C_1,EAX
            MOV   C_2,EAX
            CMP   B_2,080000000H
            JNE   short @@_1
            CMP   B_1,0
            JNZ   short @@_1
            MOV   C_E,AX
            RET
@@_1:       MOV   C_E,03FFEH
            MOV   ECX,F_Words * 16 + 1
@@1:        CMP   B_2,080000000H
            PUSHF
            RCL   C_1,1
            RCL   C_2,1
            POPF
            JNC   Short @@4
            RCL   B_1,1
            RCL   B_2,1
@@4:        CALL  SQR_M
            LOOP  @@1
            XOR   EAX,EAX
            XOR   EBX,EBX
            SUB   EBX,C_1
            SBB   EAX,C_2
            MOV   C_1,EBX
            MOV   C_2,EAX
@@5:        TEST  C4,08000H
            JNE   @@6
            SHL   C_1,1
            RCL   C_2,1
            DEC   C_E
            JMP   @@5
@@6:        RET
FLOG2386    ENDP


CODE	ENDS
	END
