;******************************************************************;
;                                                                  ;
;        Copyright (c) 1993 by CHRISTIAN BAUMGARTEN 1993           ;
;                                                                  ;
;       FLOATING POINT EMULATOR FR 8086er Prozessoren und         ;
;             80 Bit-Fliekommaformat (Extended)                   ;
;                                                                  ;
;******************************************************************;

        TITLE FLOAT86

        LOCALS

B1      EQU  WORD PTR [BP+6]
B2      EQU  WORD PTR [BP+8]
B3      EQU  WORD PTR [BP+10]
B4      EQU  WORD PTR [BP+12]
B_E     EQU  WORD PTR [BP+14]

A1      EQU  WORD PTR [BP+16]
A2      EQU  WORD PTR [BP+18]
A3      EQU  WORD PTR [BP+20]
A4      EQU  WORD PTR [BP+22]
A_E     EQU  WORD PTR [BP+24]

C1      EQU  WORD PTR [BP-10]
C2      EQU  WORD PTR [BP-8]
C3      EQU  WORD PTR [BP-6]
C4      EQU  WORD PTR [BP-4]
C_E     EQU  WORD PTR [BP-2]

F_BIAS  EQU 16383
F_WORDS EQU 4
F_SIZE  EQU 8


DATA	SEGMENT	BYTE PUBLIC

DATA	ENDS

CODE	SEGMENT	BYTE PUBLIC

	ASSUME	CS:CODE,DS:DATA

;***************************************************************************;
; Alle Routinen gehen davon aus, von einer Turbo-Pascal-Funktion der Form   ;
; 'Function F(A,B:Extended):Extended;' aufgerufen zu werden.                ;
; D.h., da die Eingabewerte auf dem Stack liegen und @Result an der        ;
; Stelle ss:[bp-10] ist ! (Vergl. obige Definitionen)                       ;
;                       Alle Routinen sind near !!                          ;
; Multiplikationen und Additive Operationen werden sehr schnell bearbeitet, ;
; die Division hingegen bentigt etwas mehr Zeit.                           ;
;***************************************************************************;

; Aufruf von Function Sqr(a:extended):extended

     PUBLIC  FMUL86, FADD86, FSUB86, FDIV86, FQDIV86, FLOG2_86
     PUBLIC  FSQR86,FSQRT86


; Hilfsroutine, die Vorzeichen & Exponenten multipliziert

MUL_SIGNS  PROC      NEAR
            mov  ax,a_e
            mov  bx,ax
            and  ax,07fffh
            mov  cx,b_e
            mov  dx,cx
            and  cx,07fffh
            sub  cx,f_bias
            sub  ax,f_bias
            add  ax,cx
            add  ax,f_bias
            xor  bx,dx
            and  bx,08000h
           RET
MUL_SIGNS  ENDP

; Hilfsroutine, die die Vorzeichen liefert:
; A negativ == Bit 1 in CX gesetzt
; B negativ == Bit 0 in CX gesetzt

GETSIGNS    PROC      NEAR
             XOR  CX,CX
             MOV  AX,A_E
             MOV  BX,B_E
             RCL  AX,1
             RCL  CX,1
             RCL  BX,1
             RCL  CX,1
             SHR  AX,1
             SHR  BX,1
             SUB  AX,F_BIAS
             SUB  BX,F_BIAS
            RET
GETSIGNS    ENDP

;  Hilfsroutine, die das Ergebnis von A nach C schiebt:

MOV_C_A     PROC     NEAR
             MOV   AX,A1
             MOV   C1,AX
             MOV   AX,A2
             MOV   C2,AX
             MOV   AX,A3
             MOV   C3,AX
             MOV   AX,A4
             MOV   C4,AX
             MOV   AX,A_E
             MOV   C_E,AX
             RET
MOV_C_A     ENDP

; Hilfsroutine, die B mit CL nach rechts rotiert (Fr Addition/Subtraktion)

ROTR_B       PROC     NEAR
@@1:          shr  b4,1
              rcr  b3,1
              rcr  b2,1
              rcr  b1,1
              loop @@1
              RET
ROTR_B       ENDP

; Hilfsroutine, die die Eingabewerte austauscht

XCHG_A_B     PROC   NEAR
              MOV  DX,A1
              XCHG DX,B1
              MOV  A1,DX
              MOV  DX,A2
              XCHG DX,B2
              MOV  A2,DX
              MOV  DX,A3
              XCHG DX,B3
              MOV  A3,DX
              MOV  DX,A4
              XCHG DX,B4
              MOV  A4,DX
              MOV  DX,A_E
              XCHG DX,B_E
              MOV  A_E,DX
             RET
XCHG_A_B     ENDP

; Hilfsroutine, die die Mantisse von B zu A addiert

ADD_A_B      PROC  NEAR
              SUB  AX,BX
              JNS  @@1
              CALL XCHG_A_B
              NEG  AX
@@1:          CMP  AX , F_WORDS * 16
              JB   @@11
              RET
@@11:         OR   AX,AX
              JZ   @@2
              MOV  CX,AX
              CALL ROTR_B
@@2:          mov  ax,b1
              add  a1,ax
              mov  ax,b2
              adc  a2,ax
              mov  ax,b3
              adc  a3,ax
              mov  ax,b4
              adc  a4,ax
              jnc  @@OK
              rcr  a4,1
              rcr  a3,1
              rcr  a2,1
              rcr  a1,1
              inc  a_E
@@OK:         RET
ADD_A_B      ENDP

; Hilfsroutine, die die Eingabemantisse vergleicht

MCMP86       PROC   NEAR
              PUSH  AX
              MOV   AX,A4
              CMP   AX,B4
              JNE   @@EXIT
              MOV   AX,A3
              CMP   AX,B3
              JNE   @@EXIT
              MOV   AX,A2
              CMP   AX,B2
              JNE   @@EXIT
              MOV   AX,A1
              CMP   AX,B1
@@EXIT:       POP   AX
              RET
MCMP86       ENDP

; Hilfsroutine, die die Mantisse von B von A abzieht

SUB_A_B      PROC   NEAR
                CMP  AX,BX
                JG   @@1
                JL   @@X
                CALL MCMP86
                JA   @@1
                JNE  @@X
                JMP  @@Z
@@X:            CALL XCHG_A_B
                XCHG AX,BX
                CALL SUB_A_B
                XOR  A_E,08000H
                RET
@@1:            SUB  AX,BX
                JZ   @@2
                CMP  AX, F_WORDS * 16
                JB   @@11
                RET
@@11:           MOV  CX,AX
                CALL ROTR_B
@@2:            mov  ax,b1
                sub  a1,ax
                mov  ax,b2
                sbb  a2,ax
                mov  ax,b3
                sbb  a3,ax
                mov  ax,b4
                sbb  a4,ax
                jnz  @@3
                mov  cx,4
                xor  ax,ax
@@20:           xchg a1,ax
                xchg a2,ax
                xchg a3,ax
                mov  a4,ax
                sub  a_e,16
                or   ax,ax
                loopz @@20
                JZ    @@3a
@@3:            TEST a4,08000H
                jnz  @@4
                shl  a1,1
                rcl  a2,1
                rcl  a3,1
                rcl  a4,1
                dec  a_e
                jmp  @@3
@@3a:           and  a_e,08000H
@@4:            RET
@@Z:            XOR  AX,AX
                PUSH SS
                POP  ES
                CLD
                LEA  DI,A1
                MOV  CX,F_Words+1
                REP  STOSW
                RET
SUB_A_B      ENDP

FADD86         PROC      NEAR
                CALL  GETSIGNS
                CMP   CX,1
                JNE   @@1
                XOR   B_E,08000H
                CALL  SUB_A_B
                JMP   @@ENDE
@@1:            CMP   CX,2
                JNE   @@2
                XOR   A_E,08000H
                CALL  XCHG_A_B
                XCHG  AX,BX
                CALL  SUB_A_B
                JMP   @@ENDE
@@2:            CMP   CX,3
                PUSHF
                JNE   @@3
                XOR   A_E,08000H
                XOR   B_E,08000H
@@3:            CALL  ADD_A_B
                POPF
                JNE   @@ENDE
                XOR   a_E,08000H
@@ENDE:         CALL  MOV_C_A
                RET
FADD86         ENDP

FSUB86         PROC      NEAR
                CALL  GETSIGNS
                CMP   CX,2
                JNE   @@1
                XOR   A_E,08000H
                CALL  ADD_A_B
                XOR   A_E,08000H
                JMP   @@ENDE
@@1:            CMP   CX,1
                JNE   @@2
                XOR   B_E,08000H
                CALL  ADD_A_B
                JMP   @@ENDE
@@2:            CMP   CX,3
                JNE   @@3
                XOR   A_E,08000H
                XOR   B_E,08000H
                CALL  XCHG_A_B
                XCHG  AX,BX
@@3:            CALL  SUB_A_B
@@ENDE:         CALL  MOV_C_A
                RET
FSUB86         ENDP

; Hilfsroutine, die Null oder NaN zurckliefert:

FILL_C     PROC      NEAR
            MOV     C1,AX
            MOV     C2,AX
            MOV     C3,AX
            MOV     C4,AX
            MOV     C_E,AX
           RET
FILL_C     ENDP


FMUL86      PROC      NEAR
             mov  ax,a_e
             or   ax,ax
             jne  @@_1
             jmp  zero86
@@_1:        cmp  ax,0FFFFH
             jne  @@_2
             jmp  NaN86
@@_2:        mov  ax,b_e
             or   ax,ax
             jne  @@_3
             jmp  zero86
@@_3:        cmp  ax,0FFFFH
             jne  @@_4
             jmp  NaN86
@@_4:        mov  ax,a4
             mul  b4
             mov  c3,ax
             mov  c4,dx

             mov  ax,a4
             mul  b3
             mov  c2,ax
             add  c3,dx
             adc  c4,0

             mov  ax,a3
             mul  b4
             add  c2,ax
             adc  c3,dx
             adc  c4,0

             mov  ax,a3
             mul  b3
             mov  c1,ax
             add  c2,dx
             adc  c3,0
             adc  c4,0

             mov  ax,a4
             mul  b2
             add  c1,ax
             adc  c2,dx
             adc  c3,0
             adc  c4,0

             mov  ax,a2
             mul  b4
             add  c1,ax
             adc  c2,dx
             adc  c3,0
             adc  c4,0

             mov  ax,a1
             mul  b4
             mov  cx,ax
             add  c1,dx
             adc  c2,0
             adc  c3,0
             adc  c4,0

             mov  ax,a4
             mul  b1
             add  cx,ax
             adc  c1,dx
             adc  c2,0
             adc  c3,0
             adc  c4,0

             mov  ax,a2
             mul  b3
             add  cx,ax
             adc  c1,dx
             adc  c2,0
             adc  c3,0
             adc  c4,0

             mov  ax,a3
             mul  b2
             add  cx,ax
             adc  c1,dx
             adc  c2,0
             adc  c3,0
             adc  c4,0

             CALL MUL_SIGNS

             test c4,08000h
             jnz  @@1
             shl  c1,1
             rcl  c2,1
             rcl  c3,1
             rcl  c4,1
             jmp  @@2
@@1:         inc  ax
@@2:         or   ax,bx
             mov  C_E,ax
            RET
FMUL86     ENDP

NaN86:      MOV   AX,0FFFFH
            JMP   FILL_C
Zero86:     XOR   AX,AX
            JMP   FILL_C

FDIV86        PROC      NEAR
                mov  ax,a_e
                or   ax,ax
                je    zero86
                cmp  ax,0FFFFH
                je    NaN86

                mov  ax,b_e
                or   ax,ax
                je    NaN86
                cmp  ax,0FFFFH
                je    Zero86

                XOR  AX,AX
                MOV  C1,AX
                MOV  C2,AX
                MOV  C3,AX
                MOV  C4,AX
                MOV  C_E,AX
                mov  ax,A_E
                mov  bx,ax
                and  ax,07fffh
                mov  cx,B_E
                mov  dx,cx
                and  cx,07fffh
                add  ax,f_bias
                sub  ax,cx
                xor  bx,dx
                and  bx,08000H
                call mcmp86
                ja   @@1
                shr  b4,1
                rcr  b3,1
                rcr  b2,1
                rcr  b1,1
                dec  ax
@@1:            or   ax,bx    ; Start der eigentlichen Berechnung:
                mov  c_e,ax
                jmp  @@4
@@3:            shr  b4,1
                rcr  b3,1
                rcr  b2,1
                rcr  b1,1
@@4:            mov  ax,a1
                mov  bx,a2
                mov  cx,a3
                mov  dx,a4
                sub  ax,b1
                sbb  bx,b2
                sbb  cx,b3
                sbb  dx,b4
                jc   @@2
                mov  a1,ax
                mov  a2,bx
                mov  a3,cx
                mov  a4,dx
@@2:            cmc
                rcl  c1,1
                rcl  c2,1
                rcl  c3,1
                rcl  c4,1
                test c4,08000H
                jz   @@3
                RET
FDIV86        ENDP

QDIV           PROC  NEAR
               XOR   CX,CX
@@_1:          OR    DI,DI
               JE    @@1
               SHR   DI,1
               RCR   DX,1
               RCR   AX,1
               INC   CX
               JMP   @@_1
@@1:           TEST  DX,0C000H
               JE    @@2
               SHR   DX,1
               RCR   AX,1
               INC   CX
               JMP   @@1
@@2:           DIV   BX
               XOR   DX,DX
               JCXZ  @@4
@@3:           SHL   AX,1
               RCL   DX,1
               LOOP  @@3
@@4:           RET
QDIV           ENDP

FQDIV86       PROC  NEAR
                mov  ax,a_e
                or   ax,ax
                jne  @@_1
                jmp  Zero86
@@_1:           cmp  ax,0FFFFH
                jne  @@_2
                jmp  NaN86
@@_2:
                mov  ax,b_e
                or   ax,ax
                jne  @@_3
                jmp  NaN86
@@_3:           cmp  ax,0FFFFH
                jne  @@_4
                jmp  Zero86
@@_4:
                mov  ax,A_E       ; Exponentenberechnung:
                mov  bx,ax        ;
                and  ax,07fffh    ; AX = Exponent(A)
                mov  cx,B_E
                mov  dx,cx
                and  cx,07fffh    ; CX = Exponent(B)
                add  ax,f_bias
                sub  ax,cx
                xor  bx,dx
                and  bx,08000H    ; BX = SIGN(A/B)
                shr  A4,1
                rcr  A3,1
                rcr  A2,1
                rcr  A1,1
                or   ax,bx
                mov  c_e,ax       ; C_E = Exponent(A) - Exponent(B)
                xor  di,di
                mov  dx,A4
                mov  ax,A3
                mov  bx,B4
                call qDiv
                MOV  C4,AX
@@1:             PUSH A4
                 PUSH A3
                 PUSH A2
                 PUSH A1
                MOV  SI,AX
                MUL  BX      ; C4 * B4
                SUB  A3,AX
                SBB  A4,DX
                JC   @@2
                MOV  AX,B3
                MUL  SI      ; C4 * B3
                SUB  A2,AX
                SBB  A3,DX
                SBB  A4,0
                JC   @@2
                MOV  AX,SI
                MUL  B2      ; C4 * B2
                SUB  A1,AX
                SBB  A2,DX
                SBB  A3,0
                SBB  A4,0
                JC   @@2
                MOV  AX,SI   ; C4 * B1
                MUL  B1
                SUB  A1,DX
                SBB  A2,0
                SBB  A3,0
                SBB  A4,0
                JNC  @@21
@@2:            POP  A1
                POP  A2
                POP  A3
                POP  A4
                DEC  C4
                MOV  AX,C4
                JMP  @@1
@@21:           ADD  SP,8
                MOV  DI,A4
                MOV  DX,A3
                MOV  AX,A2
                CALL QDIV
                MOV  C3,AX
                MOV  SI,AX
                OR   DX,DX
                JE   @@3
                ADD  C4,DX
@@31:           SUB  A3,BX
                SBB  A4,0
                MOV  AX,B3
                SUB  A2,AX
                SBB  A3,0
                SBB  A4,0
                MOV  AX,B2
                SUB  A1,AX
                SBB  A2,0
                SBB  A3,0
                SBB  A4,0
                DEC  DX
                JNZ  @@31
@@3:            PUSH A4
                PUSH A3
                PUSH A2
                PUSH A1
                MOV  AX,SI
                MUL  B3    ; C3 * B3
                SUB  A1,AX
                SBB  A2,DX
                SBB  A3,0
                SBB  A4,0
                JC   @@4
                MOV  AX,SI
                MUL  B2
                SUB  A1,DX ; C3 * B2
                SBB  A2,0
                SBB  A3,0
                SBB  A4,0
                JC   @@4
                MOV  AX,SI ; C3 * B4
                MUL  BX
                SUB  A2,AX
                SBB  A3,DX
                SBB  A4,0
                JNC  @@5
@@4:            POP  A1
                POP  A2
                POP  A3
                POP  A4
                DEC  C3
                MOV  SI,C3
                JMP  @@3
@@5:            ADD  SP,8
                MOV  DI,A3
                MOV  DX,A2
                MOV  AX,A1
                CALL QDIV
                MOV  C2,AX
                MOV  SI,AX
                OR   DX,DX
                JE   @@51
                ADD  C3,DX
                ADC  C4,0
@@50:           SUB  A2,BX
                SBB  A3,0
                SBB  A4,0
                MOV  AX,B3
                SUB  A1,AX
                SBB  A2,0
                SBB  A3,0
                SBB  A4,0
                DEC  DX
                JNZ  @@50
@@51:           PUSH A1
                PUSH A3
                PUSH A2
                PUSH A1
                MOV  AX,SI
                MUL  BX     ; C2 * B4
                SUB  A1,AX
                SBB  A2,DX
                SBB  A3,0
                SBB  A4,0
                JC   @@6
                MOV  AX,SI
                MUL  B3      ; C2 * B3
                SUB  A1,DX
                SBB  A2,0
                SBB  A3,0
                SBB  A4,0
                JNC  @@61
@@6:            POP  A1
                POP  A2
                POP  A3
                POP  A4
                DEC  C2
                MOV  SI,C2
                JMP  @@51
@@61:           ADD  SP,8
                MOV  DI,A2
                MOV  DX,A1
                XOR  AX,AX
                CALL QDIV
                MOV  C1,AX
                ADD  C2,DX
                ADC  C3,0
                ADC  C4,0
@@E:            TEST C4,08000H
                JNE  short @@X
                SHL  C1,1
                RCL  C2,1
                RCL  C3,1
                RCL  C4,1
                DEC  C_E
                JMP  @@E
@@X:           RET
FQDIV86       ENDP


SQR_SIGN      PROC   NEAR
               mov  ax,b_E
               and  ax,07FFFH
               jnz  @@_1
               jmp  zero86
@@_1:          sub  ax,f_bias
               shl  ax,1
               add  ax,f_bias
               or   ax,ax
              RET
SQR_SIGN      ENDP

FSQR86      PROC      NEAR
             mov  ax,b_e
             or   ax,ax
             jnz  @@_1
             jmp  Zero86
@@_1:        cmp  ax,0FFFFH
             jne  @@_2
             jmp  NaN86
@@_2:
             mov  di,b4
             mov  si,b3
             mov  bx,b2

             mov  ax,di
             mul  di
             mov  c3,ax
             mov  c4,dx

             mov  ax,di
             mul  si
             mov  c2,ax
             add  c3,dx
             adc  c4,0

             add  c2,ax
             adc  c3,dx
             adc  c4,0

             mov  ax,si
             mul  si
             mov  c1,ax
             add  c2,dx
             adc  c3,0
             adc  c4,0

             mov  ax,di
             mul  bx
             shl  ax,1
             rcl  dx,1
             add  c1,ax
             adc  c2,dx
             adc  c3,0
             adc  c4,0

             mov  ax,b1
             mul  di
             shl  ax,1
             rcl  dx,1
             mov  cx,ax
             add  c1,dx
             adc  c2,0
             adc  c3,0
             adc  c4,0

             mov  ax,bx
             mul  si
             shl  ax,1
             rcl  dx,1
             mov  cx,ax
             add  c1,dx
             adc  c2,0
             adc  c3,0
             adc  c4,0

             CALL SQR_SIGN
             jns  @@_3
             jmp  NaN86
@@_3:        test c4,08000h
             jnz  @@1
             shl  c1,1
             rcl  c2,1
             rcl  c3,1
             rcl  c4,1
             jmp  @@2
@@1:         inc  ax
@@2:         mov  C_E,ax
            RET
FSQR86     ENDP

;  Hilfsroutine fr FSQRT86:

DoDiv       Proc  Near
             push  cx
             xor   cx,cx
             xor   bx,bx
@@1:         shr   dx,1
             rcr   ax,1
             rcr   bx,1
             or    dx,dx
             jz    @@2
             inc   cx
             jmp   @@1
@@2:        test  ax,0C000H
             jz    @@3
             inc   cx
             jmp   @@1
@@3:        mov   dx,ax
            mov   ax,bx
            div   di
            xor   dx,dx
            jcxz  @@5
@@4:        shl   ax,1
            rcl   dx,1
            loop  @@4
@@5:        pop   cx
            ret
DoDiv      endp

;-------------------------------------------------------------------------
;  Die Mantisse einer Fliekommazahl besteht aus vier Worten.
;  Sei das Ergebnis (c,d) und die Eingabe (a,b). Dann soll gelten:
;  a = hi(c*c) , b = lo(c * c) + 2 * hi(c * d)
;  => c = isqrt(a)
;  => d = ((a,b) - c * c) / 2 / c
;  Die Wurzel wird in drei Schritten gezogen:
;  1) Exponent halbieren
;  2) c als "Integerwurzel" von a berechnen
;  3) i  )  Das Quadrat von c von (a,b) abziehen.
;     ii )  Das Ergebnis durch 2 teilen.
;     iii)  Das Ergebnis durch c teilen (incl. Normalisierung fr Division)
;-------------------------------------------------------------------------
fsqrt86   Proc near
            TEST  B_E,08000H
            JE    @@_1
            JMP   ZERO86
@@_1:       MOV   AX,B_E
            SUB   AX,f_bias
            test  ax,1           ; Exponenten geradzahlig machen:
            je    @@start
            inc   ax
            shr   B4,1
            rcr   B3,1
            rcr   B2,1
            rcr   B1,1
@@start:    sar   ax,1
            add   ax,f_bias
            mov   C_E,ax
            shr   B4,1     ; Input normalisieren (1. Word entspr. 2^-16 !)
            rcr   B3,1
            rcr   B2,1
            rcr   B1,1
            mov   bx,0AAAAH  ; Willkrlichen hohen (!) Startwert setzen
            ; Iterationsschleife Xn <= (Xn + A/Xn ) / 2 :
@@1:        mov   dx,B4    ; A / Xn berechnen:
            mov   ax,B3
            div   bx
            add   ax,bx    ; Xn addieren:
            rcr   ax,1     ; Durch 2 teilen
            mov   di,ax    ; Abbruchbedingung testen
            cmp   di,bx
            jz    @@2
            dec   di
            cmp   di,bx
            jz    @@2
            mov   bx,ax    ; Xn := Xn+1
            jmp   @@1
@@2:        mov   di,ax    ; Rest berechnen:
            mul   ax       ; a * a berechnen
            sub   B3,ax    ; und abziehen
            sbb   B4,dx
            mov   dx,B4
            mov   ax,B3
           call   DoDiv    ; (DX:) AX / DI berechnen
            mov   C4,di    ; a ist fertig
@@B:        mov   C3,ax    ; b ist fertig
            mov   si,ax    ; b sichern
           call  @@5
            mov   ax,si
            mul   ax             ; b * b berechnen
             sub   B1,ax    ; und abziehen
             sbb   B2,dx
             sbb   B3,0
             sbb   B4,0
            mov   ax,si          ; a * b berechnen
            mul   di
             sub   B2,ax    ; und zweimal abziehen
             sbb   B3,dx
             sbb   B4,0
             sub   B2,ax
             sbb   B3,dx
             sbb   B4,0
            jns   @@20
           call  @@6
            mov   ax,si
            dec   ax
            jmp   @@B
@@20:       add   sp,8
            mov   dx,B3
            mov   ax,B2
            call  DoDiv
             add   C3,dx
             adc   C4,0
             mov   cx,dx
@@C:        mov   C2,ax    ; c ist fertig
            mov   bx,ax         ; c sichern
            call  @@5
            mov   ax,bx
            mul   di            ; a * c berechnen
            push  cx   ; evtl. bertrag aus Division sichern
            jcxz  @@26
            xor   cx,cx
            add   dx,di
            adc   cx,0
@@26:        sub   B1,ax   ; und zweimal abziehen :
             sbb   B2,dx
             sbb   B3,cx
             sbb   B4,0
             sub   B1,ax
             sbb   B2,dx
             sbb   B3,cx
             sbb   B4,0
            pop   cx
            mov   ax,bx         ; b * c berechnen :
            mul   si
            xor   ax,ax
            jcxz  @@27          ; bertrag ?
            add   dx,si
            adc   ax,0
@@27:        sub   B1,dx   ; und zweimal abziehen :
             sbb   B2,ax
             sbb   B3,0
             sbb   B4,0
             sub   B1,dx
             sbb   B2,ax
             sbb   B3,0
             sbb   B4,0
            jns   @@44
            call  @@6
            mov   ax,bx
            dec   ax
            jmp   @@C
@@44:       add   sp,8
            mov   dx,B2
            mov   ax,B1
            call  dodiv
@@45:        mov  C1,ax  ; d ist fertig
             add  C2,dx
             adc  C3,0
             adc  C4,0
@@450:      test  C4,08000H
            jne   @@4
@@3:        ; Darstellung normalisieren:
            shl   C1,1
            rcl   C2,1
            rcl   C3,1
            rcl   C4,1
            dec   C_E
            test  C4,08000H
            je    @@3
@@4:        RET
@@5:        pop   ax ; Rcksprungaddresse vom Stack nach AX
            push  b4
            push  b3
            push  b2
            push  b1
            jmp   ax ; Entspricht RET
@@6:        pop   ax ; Rcksprungaddresse vom Stack nach AX
            pop   B1
            pop   B2
            pop   B3
            pop   B4
            jmp   ax ; Entspricht RET
FSQRT86    endp

SQR_M       PROC  NEAR ; Zwischenergebnis in DI:SI:CX:BX
            PUSH  CX
            XOR   BX,BX
            MOV   AX,B4   ; B4 * B4
            MUL   AX
            MOV   SI,AX
            MOV   DI,DX
            MOV   AX,B4   ; B4 * B3
            MUL   B3
            MOV   CX,AX
            ADD   SI,DX
            ADC   DI,0
            ADD   CX,AX
            ADC   SI,DX
            ADC   DI,0
            MOV   AX,B3   ; B3 * B3
            MUL   AX
            CALL  @@2
            MOV   AX,B4   ; B4 * B2
            MUL   B2
            CALL  @@2
            CALL  @@2
            MOV   AX,B4    ; B4 * B1
            MUL   B1
            CALL  @@1
            MOV   AX,B3    ; B3 * B2
            MUL   B2
            CALL  @@1
            MOV   B4,DI
            MOV   B3,SI
            MOV   B2,CX
            MOV   B1,BX
            POP   CX
            RET
@@1:        MOV   AX,DX
            XOR   DX,DX
            SHL   AX,1
            RCL   DX,1
@@2:        ADD   BX,AX
            ADC   CX,DX
            ADC   SI,0
            ADC   DI,0
            RET
SQR_M       ENDP

FLOG2_86    PROC  NEAR
            XOR   AX,AX
            MOV   C1,AX
            MOV   C2,AX
            MOV   C3,AX
            MOV   C4,AX
            CMP   B4,08000H
            JNE   @@1
            CMP   B3,0
            JNE   @@1
            CMP   B2,0
            JNE   @@1
            CMP   B1,0
            JNE   @@1
            MOV   C_E,AX
            RET
@@1:        MOV   C_E,03FFEH
            MOV   CX,F_Words * 16+1
@@2:        CMP   B4,08000H
            PUSHF
            RCL   C1,1
            RCL   C2,1
            RCL   C3,1
            RCL   C4,1
            POPF
            JNC   Short @@4
            SHL   B1,1
            RCL   B2,1
            RCL   B3,1
            RCL   B4,1
@@4:        CALL  SQR_M
            LOOP  @@2
            XOR   AX,AX
            XOR   BX,BX
            XOR   CX,CX
            XOR   DX,DX
            SUB   DX,C1
            SBB   CX,C2
            SBB   BX,C3
            SBB   AX,C4
            MOV   C1,DX
            MOV   C2,CX
            MOV   C3,BX
            MOV   C4,AX
@@5:        TEST  C4,08000H
            JNE   @@6
            SHL   C1,1
            RCL   C2,1
            RCL   C3,1
            RCL   C4,1
            DEC   C_E
            JMP   @@5
@@6:        RET
FLOG2_86    ENDP



CODE	ENDS
	END
