
; *******************************************************
; *							*
; *	80X87-Funktionen				*
; *							*
; *     Copyright (c) Christian Baumgarten 1993         *
; *							*
; *******************************************************

	TITLE	FPU

        LOCALS @@

; Short-Cut-Konstanten:

scSin		EQU	90ECH
scCos		EQU	90EEH
scTan		EQU	90F0H
scArcTan	EQU	90F2H
scLog		EQU	90F4H
scLog2		EQU	90F6H
scLog10		EQU	90F8H
scExp		EQU	90FAH
scExp2		EQU	90FCH
scExp10		EQU	90FEH

; Laufzeitfehlerkonstanten

FpuOverflow     EQU     205
FpuUnderflow    EQU     206
FpuInvalid      EQU     207

; Funktionskonstanten

FpuSin         EQU 100
FpuCos         EQU 101
FpuTan         EQU 102
FpuCot         EQU 103
FpuArcSin      EQU 104
FpuArcCos      EQU 105
FpuArcTan      EQU 106
FpuArcCot      EQU 107
FpuSinh        EQU 108
FpuCosh        EQU 109
FpuTanh        EQU 110
FpuCoth        EQU 111
FpuArSinh      EQU 112
FpuArCosh      EQU 113
FpuArTanh      EQU 114
FpuArCoth      EQU 115

FpuExp         EQU 116
FpuLn          EQU 117
FpuLog         EQU 118
FpuLd          EQU 119


DATA	SEGMENT	WORD PUBLIC

	EXTRN	Test8087:BYTE,__PI2:TBYTE,__PI_2:TBYTE
        EXTRN   MATHERRORPROC:DWORD
        EXTRN   TEMPWORD:WORD;

DATA	ENDS

CODE	SEGMENT	BYTE PUBLIC

	ASSUME	CS:CODE,DS:DATA

	PUBLIC	FRSin,FRCos,FRSinCos,FRArcTan
        PUBLIC  FRExp,FRLn,FRLog,FRLd

; Keine Emulation fr FRSin/FRCos/FRSinCos:

        NOEMUL

FRCos   proc near
  cmp   Test8087,0
  jne   short @@2
  INT	3EH
  DW	scCos
  RET
@@2:
  fld   __pi_2
  faddp st(1),st
  jmp   @1X
FRSin   proc near
  cmp   test8087,0
  jne   short @1X
  INT	3EH
  DW	scSin
  RET
@1X:
  cmp    test8087,3
  jb     short @@287
        .386
        .387
  fsin
  ret
        .8086
        .8087
@@287:
  fld    __pi2
  fxch   st(1)  ; ST = X, ST(1) = 2*PI
  ftst          ; X < 0 => SIN(X) = - SIN(-X)
  fstsw  tempword
  mov    ax,tempword
  sahf
  pushf
  jns    short @@1
  fchs
@@1:
  fprem        ; St:= X Mod (2*pi)
  fstp   st(1)
  fldpi        ; ST = PI, ST(1)=X
  fcomp  st(1) ; X > PI (?) => SIN(X) = - SIN(X-PI)
  fstsw  TempWord
  mov    ax,Tempword
  sahf
  pushf
  ja     short @@2
  fldpi
  fsubp  st(1),st
@@2:
  fld    __pi_2       ; ST = PI/2, ST(1) = X
  fcomp  st(1)        ; ST = X
  fstsw  TempWord     ; X > PI/2 (?) => SIN(X) = SIN(PI-X)
  mov    ax,tempword
  sahf
  ja     short @@3
  fldpi
  fsubrp st(1),st
@@3:
  fld1
  fchs
  fxch   st(1)    ; ST = X , ST(1) = -1
  fscale          ; ST = X/2, fr die Formel:
                  ; SIN(X) = 2 * TAN(X/2) / (1 + TAN(X/2))
                  ; Das Argument liegt immer zwischen 0 und pi/4 !!
  fstp   st(1)	  ; ST = X/2
  fptan           ; ST = 1, ST(1) = TAN(X/2)
  fld    st(2)    ; ST = TAN(X/2) , ST = 1 , ST(2) = TAN(X/2)
  fmul   st,st    ; ST = TAN(X/2), ST(1) = 1 , ST(2) = TAN(X/2)
  faddp  st(1),st ; ST = TAN(X/2) + 1, ST(1) = TAN(X/2)
  fdivp  st(1),st ; ST = TAN(X/2) / (1+TAN(X/2))
  fld1
  fxch   st(1)
  fscale          ; ST = 2 * TAN(X/2) / (1+TAN(X/2)) , ST(1) = 1
  fstp   st(1)
  popf
  ja     short @@20
  fchs
@@20:
  popf
  jns    short @@10
  fchs
@@10:
  ret
FRSin endp
FRCos endp

FRSinCos proc near
  cmp    test8087,3
  jb     short @@287
        .386
        .387
  fsincos
  ret
        .8086
        .8087
        EMUL
@@287:
  fld    __pi2
  fxch   st(1)  ; ST = X, ST(1) = 2*PI
  ftst          ; X < 0 => SIN(X) = - SIN(-X) , COS(X) = COS(-X)
  fstsw  tempword
  mov    ax,tempword
  sahf
  pushf
  jns    short @@1
  fchs
@@1:
  fprem        ; St:= X Mod (2*pi)
  fstp   st(1)
  fldpi        ; ST = PI, ST(1)=X
  fcomp  st(1) ; X > PI (?) => SIN(X) = - SIN(X-PI), COS(X) = - COS(X-pi)
  fstsw  TempWord
  mov    ax,Tempword
  sahf
  pushf
  ja     short @@2
  fldpi
  fsubp  st(1),st
@@2:
  fld    __pi_2       ; ST = PI/2, ST(1) = X
  fcomp  st(1)        ; ST = X
  fstsw  TempWord     ; X > PI/2 (?) => SIN(X) = SIN(PI-X)
  mov    ax,tempword  ;               & COS(X) = - COS(pi-X)
  sahf
  pushf
  ja     short @@3
  fldpi
  fsubrp st(1),st
@@3:
  fld1
  fchs
  fxch   st(1)    ; ST = X , ST(1) = -1
  fscale          ; ST = X/2, fr die Formel:
                  ; SIN(X) = 2 * TAN(X/2) / (1 + TAN(X/2))
                  ; Das Argument liegt immer zwischen 0 und pi/4 !!
  fstp   st(1)	  ; ST = X/2
  fptan           ; ST = 1, ST(1) = TAN(X/2)
  fld    st(2)    ; ST = TAN(X/2) , ST = 1 , ST(2) = TAN(X/2)
  fmul   st,st    ; ST = TAN(X/2), ST(1) = 1 , ST(2) = TAN(X/2)
  fadd   st(1),st ; ST = TAN(X/2), ST(1) = 1 + TAN(X/2), ST(2) = TAN(X/2)
  fld1
  fsubrp st(1),st ; ST = 1 - TAN(X/2), ST(1) = 1 + TAN(X/2), ST(2) = TAN(X/2)
  fdiv   st,st(1) ; ST = (1-TAN(X/2))/(1+TAN(X/2)) = COS(X)
                  ; ST(1) = 1 + TAN(X/2), ST(2) = TAN(X/2)
  fstp   st(3)    ; ST = 1 + TAN(X/2), ST(1) = TAN(X/2)
                  ; ST(2) = (1-TAN(X/2))/(1+TAN(X/2)) = COS(X)
  fdivp  st(1),st ; ST = TAN(X/2) / (1+TAN(X/2))
                  ; ST(1) = (1-TAN(X/2))/(1+TAN(X/2)) = COS(X)
  fadd   st,st    ; ST = 2 * TAN(X/2) / (1+TAN(X/2)) = SIN(X)
                  ; ST(1) = (1-TAN(X/2))/(1+TAN(X/2)) = COS(X)
  fxch   st(1)    ; ST = (1-TAN(X/2))/(1+TAN(X/2)) = COS(X)
                  ; ST(1) = 2 * TAN(X/2) / (1+TAN(X/2)) = SIN(X)
  popf
  ja     short @@30
  fchs
@@30:
  popf
  ja     short @@20
  fchs
  fxch   st(1)
  fchs
  fxch   st(1)
@@20:
  popf
  jns    short @@10
  fxch   st(1)
  fchs
  fxch   st(1)
@@10:
         ret
FRSinCos Endp

FRArctan proc near
    cmp  test8087,0
    jne  @@1
    INT	 3EH
    DW	 scArcTan
    RET
@@1:fld1
    fpatan
    RET
FRArctan endp

FRExp proc near
  cmp  test8087,0
  jne  short @@1
  INT	3EH
  DW	scExp
  RET
@@1:
  fldl2e
  fmulp st(1),st
  fld  st
  frndint
  fsub st(1),st
  fxch st(1)
  f2xm1
  fld1
  faddp st(1),st
  fscale
  fstp  st(1)
  ret
FRExp endp

; Logarithmen zu verschiedener Basis:

FRLog proc near   ; LOG = Basis 10
  cmp   Test8087,0
  jne   short @@1
  INT	3EH
  DW	scLog10
  RET
@@1:
  FldLg2
  jmp   @Ln
FRLd proc near    ; LD = Basis 2
  cmp   Test8087,0
  jne   short @@2
  INT	3EH
  DW	scLog2
  RET
@@2:
  fld1
  jmp   @Ln
FRLn proc near    ; LN = Basis e
  cmp   Test8087,0
  jne   short @@3
  INT	3EH
  DW	scLog
  RET
@@3:
  fldln2
@Ln:
  fxch   st(1)
  fyl2x
  ret
FRLn endp
FRLd endp
FRlog endp

CODE	ENDS

	END
