{***************************************************************************}
{                                                                           }
{          Copyright (C) Christian Baumgarten, Hamburg 1993.                }
{                                                                           }
{                   Floating Point Processing Unit                          }
{                                                                           }
{***************************************************************************}

UNIT FPU;
{$N+,E+}

INTERFACE
Type  Float = double;

const Floatlen = SizeOf(Float);
      ____PI2: Array[0..9] of byte =
             ($35,$C2,$68,$21,$A2,$DA,$0F,$C9,$01,$40);
      ____PI_2: Array[0..9] of byte  =
             ($35,$C2,$68,$21,$A2,$DA,$0F,$C9,$FF,$3F);
var   __pi2  :extended absolute ____pi2;
      __pi_2 :extended absolute ____pi_2;

const
      FpuOverflow    = 205;
      FpuUnderflow   = 206;
      FpuInvalid     = 207;

      FpuSin         = 100;
      FpuCos         = 101;
      FpuTan         = 102;
      FpuCot         = 103;
      FpuArcSin      = 104;
      FpuArcCos      = 105;
      FpuArcTan      = 106;
      FpuArcCot      = 107;
      FpuSinh        = 108;
      FpuCosh        = 109;
      FpuTanh        = 110;
      FpuCoth        = 111;
      FpuArSinh      = 112;
      FpuArCosh      = 113;
      FpuArTanh      = 114;
      FpuArCoth      = 115;

      FpuExp         = 116;
      FpuLn          = 117;
      FpuLog         = 118;
      FpuLd          = 119;

procedure MathError(code,func:integer);

const  MathErrorProc:Procedure(code,func:integer) = MathError;

Function Sin(x:float):float;
Function Cos(x:float):float;
Function Tan(x:float):float;
Function Cot(x:float):float;

Function Sinh(x:float):float;
Function Cosh(x:float):float;
Function Tanh(x:float):float;
Function Coth(x:float):float;

Function ArcSin(x:float):float;
Function ArcCos(x:float):float;
Function ArcTan(x:float):float;
Function ArcCot(x:float):float;

Function ArSinh(x:float):float;
Function ArCosh(x:float):float;
Function ArTanh(x:float):float;
Function ArCoth(x:float):float;

Function Exp(x:float):float;
Function Log(x:float):float;
Function Ln(x:float):float;
Function Ld(x:float):float;

Function Y_POW(x,y:float):float;
Function N_POW(x:float;N:word):float;
function n_over_k(n,k:word):float;
function Scale(k:integer):float;
function XScale(x:float;k:integer):float;

IMPLEMENTATION

var Tempword:word;

Procedure FRSin; external;
Procedure FRCos; external;
Procedure FRSinCos; external;
Procedure FRArcTan; external;
Procedure FRExp; external;
Procedure FRLog; external;
Procedure FRLn; external;
Procedure FRLd; external;

{$L FPU.OBJ}

procedure MathError(code,func:integer);
 begin
  RunError(code);
 end;

procedure FRTan; near; assembler;
asm
  fptan
  ffree st
  fincstp
end;

procedure FRcot; near; assembler;
asm
  fptan
  fdivrp st(1),st
end;

procedure FRArcSin; near; assembler;
asm
{ if abs(x)<1 then arcsin:=-arctan(x/sqrt(1-x)) }
{ else if x=1 then arcsin:=pi/2                  }
{ else if x=-1 then arcsin:=-pi/2                }
      fld1
      fcom  st(1)
      fstsw tempword
      mov   ax,tempword
      sahf
      pushf
      fchs
      fcomp st(1)
      fstsw tempword
      mov   ax,tempword
      sahf
      jz     @@1
      ja     @@3
      popf
      jz     @@2
      jb     @@3
      fld    st         { ST = X, ST(1) = X              }
      fmul   st,st      { ST = X, ST(1) = X             }
      fld1
      fsubrp st(1),st  { ST = 1-X, ST(1) = X           }
      fsqrt
      fdivp  st(1),st  { ST = X/SQRT(1-X)              }
      call   FRArcTan
      fchs             { ST = - ARCTAN(X/SQRT(1-X))    }
      ret
@@1:  pop   ax
      fld   __pi_2
      fstp  st(1)
      fchs
      ret
@@2:  fld   __pi_2
      fstp  st(1)
      ret
@@3:  mov   ax,fpuinvalid
      push  ax
      mov   ax,fpuArcSin
      push  ax
      call  dword ptr MathErrorProc
end;

procedure FRArcCos; near; assembler;
asm
{     arccos:=pi/2 - arcsin(x)          }
      call    FRarcsin
      fld     __pi_2
      fsubrp  st(1),st
end;

procedure FRArcCot; near; assembler;
asm
{   arccot:=pi/2 - arctan(x)                             }
      call   FRarctan
      fld    __pi_2
      fsubrp st(1),st
end;

{ Hilfsroutinen fr die Hyperbelfunktionen: }

procedure FHyperHelp1; near; assembler;
asm
       call   FRExp
       fld    st
       fld1             { ST = 1, ST(1) = ST(2) = EXP(X)  }
       fdivrp st(1),st  { ST = 1/EXP(X), ST(1) = EXP(X)   }
end;

procedure FHyperHelp2; near; assembler;
asm
       fld1             { ST = 1, ST(1) = exp(x)  1/exp(x)     }
       fchs
       fxch   st(1)
       fscale
       fstp   st(1)
end;

procedure FHyperHelp3; near; assembler;
asm
fld     st           {  ST = 1/EXP(X), ST(1) = 1/EXP(X), ST(2) = EXP(X)        }
fadd    st,st(2)     {  ST = 1/EXP(X)+EXP(X), ST(1) = 1/EXP(X), ST(2) = EXP(X) }
fxch    st(2)        {  ST = EXP(X), ST(1) = 1/EXP(X), ST(2) = 1/EXP(X)+EXP(X) }
fsubrp  st(1),st     {  ST = EXP(X) - 1/EXP(X), ST(1) = 1/EXP(X)+EXP(X)        }
end;

procedure FRSinh; near; assembler;
asm
{       e:=exp(x)               }
{       sinh:= (e-1/e)/2        }
       call   FHyperHelp1 { ST = 1/EXP(X), ST(1) = EXP(X) }
       fsubp  st(1),st    { ST = exp(x) - 1/exp(x)        }
       call   FHyperHelp2 { ST = (exp(x) - 1/exp(x))/2    }
end;

procedure FRCosh; near; assembler;
asm
{       e:=exp(x);                                         }
{       cosh:= (e+1/e)/2;                                  }
       call   FHyperHelp1  { ST = 1/EXP(X), ST(1) = EXP(X) }
       faddp  st(1),st     { ST = exp(x) + 1/exp(x)        }
       call   FHyperHelp2  { ST = (exp(x) + 1/exp(x))/2    }
end;

procedure FRSinhCosh; near; assembler;
asm
       call   FHyperHelp1  { ST = 1/EXP(X), ST(1) = EXP(X)                              }
       fld    st           { ST = 1/EXP(X), ST(1) = 1/EXP(X), ST(2) = EXP(X)            }
       fadd   st,st(2)
       fxch   st(1)        { ST = 1/EXP(X), ST(1) = EXP(X)+1/EXP(X), ST(2) = EXP(X)     }
       fsubp  st(2),st     { ST = EXP(X)+1/EXP(X), ST(2) = EXP(X)-1/EXP(X)              }
       fld1
       fchs
       fxch   st(1)        { ST = COSH(X)*2, ST(1) = -1, ST(2) = 2*SINH(X)              }
       fscale              { ST = COSH(X), ST(1) = -1, ST(2) = 2*SINH(X)                }
       fxch   st(2)
       fscale              { ST = SINH(X), ST(1) = -1, ST(2) = COSH(X)                  }
       fxch   st(2)
       fstp   st(1)        { ST = COSH(X), ST(1) = SINH(X)                              }
end;

procedure FRTanh; near; assembler;
asm
{       e:=exp(x);                                                                       }
{       tanh:=(e-1/e)/(e+1/e);                                                           }
       call    FHyperHelp1  {  ST = 1/EXP(X), ST(1) = EXP(X)                             }
       Call    FHyperHelp3  {  ST = EXP(X) - 1/EXP(X), ST(1) = 1/EXP(X)+EXP(X)           }
       fdivrp  st(1),st     {  ST = (EXP(X) - 1/EXP(X))/(EXP(X)+1/EXP(X))                }
end;

procedure FRCoth; near; assembler;
asm
{      e:=exp(x);               }
{      coth:=(e+1/e)/(e-1/e);   }
       ftst
       fstsw   tempword
       mov     ax,tempword
       sahf
       jz       @@1
       call    FHyperHelp1  {  ST = 1/EXP(X), ST(1) = EXP(X)                   }
       Call    FHyperHelp3  {  ST = EXP(X) - 1/EXP(X), ST(1) = 1/EXP(X)+EXP(X) }
       fdivp   st(1),st     {  ST = (EXP(X) + 1/EXP(X))/(EXP(X)-1/EXP(X))      }
       ret
@@1:   mov     ax,FpuInvalid
       push    ax
       mov     ax,FpuCoth
       push    ax
       call    dword ptr MatherrorProc
end;

procedure FRArSinh; near; assembler;
asm
{        arsinh:=ln(x + sqrt(x + 1));     }
         fld   st
         fmul  st,st
         fld1
         faddp st(1),st
         fsqrt
         faddp st(1),st
         call  FRLn
end;

procedure FRArCosh; near; assembler;
asm
{        Nur fr x > 1 !!                   }
{        arcosh:=ln(x + sqrt(x-1))         }
         fld1
         fcomp  st(1)
         fstsw  tempword
         mov    ax,tempword
         sahf
         ja     @@1
         fld    st
         fmul   st,st
         fld1
         fsubp  st(1),st
         fsqrt
         faddp  st(1),st
         call   FRLn
         ret
@@1:     mov     ax,FpuInvalid
         push    ax
         mov     ax,FpuArCosh
         push    ax
         call    dword ptr MatherrorProc
end;

procedure FRArTanh; near; assembler;
asm
{        Nur fr |x|<1 !!               }
{        artanh:=0.5*ln((1+x)/(1-x))    }
         fld     st
         fabs
         fld1
         fcompp
         fstsw   tempword
         mov     ax,tempword
         sahf
         jb       @@1
         fld1
         fadd    st,st(1)  { ST = 1 + X, ST(1) = X              }
         fld1
         fsubrp  st(2),st  { ST = 1 + X, ST(1) = 1 - X          }
         fdivrp  st(1),st  { ST = (1+X)/(1-X)                   }
         fsqrt
         call    FRLn
         ret
@@1:     mov     ax,FpuInvalid
         push    ax
         mov     ax,FpuArTanh
         push    ax
         call    dword ptr MatherrorProc
end;

procedure FRArCoth; near; assembler;
asm
{        if abs(x)>1 then                                        }
{        arcoth:=0.5*ln((x+1)/(x-1));                            }
         fld     st
         fabs
         fld1
         fcompp
         fstsw   tempword
         mov     ax,tempword
         sahf
         ja       @@1
         fld1
         fadd    st,st(1)  { ST = 1 + X, ST(1) = X                }
         fld1
         fsubp   st(2),st  { ST = 1 + X, ST(1) = X - 1            }
         fdivrp  st(1),st  { ST = (X+1)/(X-1)                     }
         fsqrt
         call    FRLn
         ret
@@1:     mov     ax,FpuInvalid
         push    ax
         mov     ax,FpuArCoth
         push    ax
         call    dword ptr MatherrorProc
end;

Function Sin(x:float):float; assembler;
 asm
  fld  x
  call FRSin
 end;

Function Cos(x:float):float; assembler;
 asm
  fld  x
  call FRCos
 end;

Function Tan(x:float):float; assembler;
 asm
  fld  x
  call FRTan
 end;

Function Cot(x:float):float; assembler;
 asm
  fld  x
  call FRCot
 end;

Function ArcSin(x:float):float; assembler;
 asm
  fld  x
  call FRArcSin
 end;

Function ArcCos(x:float):float; assembler;
 asm
  fld  x
  call FRArcCos
 end;

Function ArcTan(x:float):float; assembler;
 asm
  fld  x
  call FRArcTan
 end;

Function ArcCot(x:float):float; assembler;
 asm
  fld  x
  call FRArcCot
 end;

Function Sinh(x:float):float; assembler;
 asm
  fld  x
  call FRSinh
 end;

Function Cosh(x:float):float; assembler;
 asm
  fld  x
  call FRCosh
 end;

Function Tanh(x:float):float; assembler;
 asm
  fld  x
  call FRTanh
 end;

Function Coth(x:float):float; assembler;
 asm
  fld  x
  call FRCoth
 end;

Function ArSinh(x:float):float; assembler;
 asm
  fld  x
  call FRArSinh
 end;

Function ArCosh(x:float):float; assembler;
 asm
  fld  x
  call FRArCosh
 end;

Function ArTanh(x:float):float; assembler;
 asm
  fld  x
  call FRArTanh
 end;

Function ArCoth(x:float):float; assembler;
 asm
  fld  x
  call FRArCoth
 end;

Function Exp(x:float):float; assembler;
 asm
  fld  x
  call FRExp
 end;

Function Log(x:float):float; assembler;
 asm
  fld  x
  call FRLog
 end;

Function Ln(x:float):float;  assembler;
 asm
  fld  x
  call FRLn
 end;

Function Ld(x:float):float;  assembler;
 asm
  fld  x
  call FRLd
 end;

Function Y_POW(x,y:float):float; assembler;
 asm
   fld   x
   fabs
   call  FRLn
   fmul  y
   call  FRexp
 end;

Function N_POW(x:float;N:word):float; assembler;
 asm
     mov   ax,n
     fld   x
     fld1
     xor   cx,cx
@@1: inc   cx
     shr   ax,1
     pushf
     jnz   @@1
@@2: fmul  st,st
     popf
     jnc   @@3
     fmul  st,st(1)
@@3: loop  @@2
     fstp  st(1)
 end;

function Scale(k:integer):float; assembler;
 asm
  fild  k
  fld1
  fscale
  fstp  st(1)
 end;

function XScale(x:float;k:integer):float; assembler;
 asm
  fild  k
  fld   x
  fscale
  fstp  st(1)
 end;


function n_over_k(n,k:word):float; assembler;
 asm
     mov  cx,k
     jcxz @@1
     cmp  cx,n
     jae  @@1
     cmp  cx,1
     je   @@2
     mov  ax,1
     fld1
@@3: fimul n
     fidiv k
     dec   n
     dec   k
     loop  @@3
     jmp  @@exit
@@2: fild n
     jmp  @@exit
@@1: fld1
@@exit:
 end;


END.