{***************************************************************************}
{                                                                           }
{          Copyright (C) Christian Baumgarten, Hamburg 1993.                }
{                                                                           }
{       Unit fr das Dateimanagement mit Hilfe der Handlefunktionen         }
{                                                                           }
{***************************************************************************}

UNIT HANDLES;

INTERFACE
const
     { modus=0 anzahl entspr. offset ab anfang        }
     { modus=1 anzahl entspr. offset ab akt. position }
     { modus=2 anzahl entspr. (neg.) offset ab Dateiende     }
     { sm = Seek Mode }

       sm_start  = 0;
       sm_actual = 1;
       sm_end    = 2;

     { mode=0: Nur Lesen         }
     { mode=1: Nur Schreiben     }
     { mode=2: Lesen & Schreiben }
     { om = Open Mode            }

       om_read   = 0;
       om_write  = 1;
       om_access = 2;


     { Standard-Handles von DOS: }
     h_kbd  = $0000;
     h_crt  = $0001;
     h_Aux  = $0003;
     h_LPT  = $0004;

     hIOResult:integer = 0;


procedure hTruncate(handle:word);
 function hFileSize(Handle:word):longint;
 function hFilePos(Handle:word):longint;
procedure hSeekeof(Handle:word);
 function hEOF(Handle:word):boolean;
procedure hRewrite(var Handle:word;s:string;attr:word);
procedure hCreate(var Handle:word;s:string;attr:word);
procedure hOpen(var Handle:word;s:string;mode:byte);
procedure hCreateTemp(var Handle:word;var path:string);
procedure hClose(Handle:word);
procedure hWrite(Handle:word;var puffer;Anzahl:word;var ergebnis:word);
procedure hRead(Handle:word;var puffer;Anzahl:word;var ergebnis:word);
procedure hWriteln(Handle:word;s:string);
procedure hReadln(Handle:word;var s:string);
 function hSeek(Handle:word;anzahl:longint;modus:byte):longint;
procedure hOutCTRLChar(handle:word;var s:string);
procedure hInCTRLChar(handle:word;var s:string);

IMPLEMENTATION

procedure hOutCTRLChar(handle:word;var s:string); assembler;
 asm
   cld
   push ds
   lds  si,s
   lodsb
   mov  cl,al
   xor  ch,ch
   mov  ax,$4403
   mov  bx,handle
   mov  dx,si
   int  $21
   pop  ds
 end;

procedure hInCTRLChar(handle:word;var s:string); assembler;
 asm
   push ds
   lds  dx,s
   mov  cx,255
   mov  ax,$4402
   mov  bx,handle
   int  $21
   pop  ds
 end;

procedure hCreateTemp(var Handle:word;var path:string); assembler;
 asm
  mov  ah,$5A
  xor  cx,cx    { Dateiattribut = 0 }
  push ds
  push bp
  lds  di,path
  mov  bl,[di]
  inc  di
  xor  bh,bh
  xor  al,al
  mov  [di+bx],al
  mov  dx,di
  int  $21
  push ds
  pop  es
  pop  bp
  pop  ds
  mov  bx,ax
  jc   @@1
  xor  bx,bx
@@1:
  lea  di,hIOResult
  mov  [di],bx
  push es
  les  di,handle
  mov  es:[di],ax
  pop  es
  xor  al,al
  cld
  mov  di,dx
  mov  cx,255
  repne scasb
  mov  bx,di
  sub  bx,dx
  mov  di,dx
  mov  [di-1],bl
 end;

procedure hWriteln(Handle:word;s:string);
 var erg:word;
 begin
  hWrite(Handle,s[1],ord(s[0]),erg);
  erg:=$0A0D;
  hwrite(handle,erg,2,erg);
 end;

procedure hReadln(Handle:word;var s:string);
 var i:byte;
     erg:word;
 begin
  hRead(Handle,s[1],255,erg);
  s[0]:=chr(erg);
  i:=pos(#13#10,s);
  if i>0 then
  begin
   hSeek(Handle,- erg + i + 1,sm_actual);
   s[0]:=chr(i-1);
  end;
 end;

procedure hTruncate(handle:word); assembler;
 asm
    mov  ah,$40
    mov  bx,Handle
    xor  cx,cx
    push bp
    push ds
    Int  $21
    pop  ds
    pop  bp
    jc   @@1
    xor  ax,ax
@@1:lea  di,hIOResult
    mov  [di],ax
 end;

function hFileSize(Handle:word):longint;
 var p:longint;
 begin
  p:=hSeek(handle,0,1);
  hFilesize:=hSeek(handle,0,2);
  p:=hSeek(Handle,p,0);
 end;

function hFilePos(Handle:word):longint;
 begin
  hFilePos:=hSeek(Handle,0,1);
 end;

procedure hSeekeof(Handle:word);
 var s:longint;
 begin
  s:=hSeek(Handle,0,2);
 end;


function hEOF(Handle:word):boolean; assembler;
 asm
    mov  ax,$4406
    mov  bx,Handle
    push bp
    push ds
    Int $21
    pop  ds
    pop  bp
    mov  bx,ax
    jc   @@1
    xor  bx,bx
@@1:lea  di,hIOResult
    mov  [di],bx
    cmp  al,$FF
    jne  @@2
    xor  al,al
    jmp  @@3
@@2:mov  al,1
@@3:
 end;

procedure _OpenCall_; near; assembler;
 asm
    push bp
    push ds
    push es
    pop  ds
    mov  bl,[si]
    xor  bh,bh
    inc  si
    mov  [si+bx],bh
    mov  dx,si
    Int  $21
    pop  ds
    pop  bp
    mov  bx,ax
    jc   @@1
    xor  ax,ax
@@1:lea  di,hIOResult
    mov  [di],ax
 end;


procedure hRewrite(var Handle:word;s:string;attr:word); assembler;
  asm
   mov  ah,$3C
   mov  cx,attr
   les  si,s
   call [_opencall_]
   les  di,Handle
   mov  es:[di],bx
 end;

 procedure hCreate(var Handle:word;s:string;attr:word); assembler;
  asm
    mov  ah,$5B
    mov  cx,attr
    les  si,s
    call [_OpenCall_]
    les  di,Handle
    mov  es:[di],bx
 end;

procedure hOpen(var Handle:word;s:string;mode:byte); assembler;
 asm
    mov  ah,$3D
    mov  al,Mode
    les  si,s
    call [_OpenCall_]
    les  di,Handle
    mov  es:[di],bx
 end;

procedure hClose(Handle:word); assembler;
 asm
  mov  ah,$3E;
  mov  bx,Handle;
  push bp
  push ds
  Int  $21
  pop  ds
  pop  bp
  jc   @@1
  xor  ax,ax
@@1:
  lea  di,hIOResult
  mov  [di],ax
 end;

procedure _readwrite_; near; assembler;
 asm
  push ds
  push bp
  push es
  pop  ds
  int  $21
  pop  bp
  pop  ds
  mov  bx,ax
  jc   @@1
  xor  ax,ax
  @@1:
  lea  di,hIOResult
  mov  [di],ax
 end;

procedure hWrite(Handle:word;var puffer;Anzahl:word;var ergebnis:word); assembler;
 asm
  mov  ah,$40;
  mov  bx,Handle;
  mov  cx,Anzahl;
  les  dx,puffer
  call [_readwrite_]
  les  di,ergebnis
  mov  es:[di],bx
 end;

procedure hRead(Handle:word;var puffer;Anzahl:word;var ergebnis:word); assembler;
 asm
  mov  ah,$3F;
  mov  bx,Handle;
  mov  cx,Anzahl;
  les  dx,puffer
  call [_readwrite_]
  les  di,ergebnis
  mov  es:[di],bx
 end;

function hSeek(Handle:word;anzahl:longint;modus:byte):longint; assembler;
 asm
     mov  ah,$42
     mov  al,modus
     mov  bx,handle
     les  dx,anzahl
     mov  cx,es
     push ds
     push bp
     int  $21
     pop  bp
     pop  ds
     mov  bx,ax
     jc   @@1
@@1: xor  ax,ax
     lea  di,hIOResult
     mov  [di],ax
     mov  ax,bx
 end;

END.