{***************************************************************************}
{                                                                           }
{          Copyright (C) Christian Baumgarten, Hamburg 1993.                }
{                                                                           }
{***************************************************************************}
unit heap;
interface

 procedure XGetMem(var p:pointer;size:longint);
 procedure XFreeMem(p:pointer;size:longint);

 function ValPtr(l:longint):pointer;
 function PtrVal(p:pointer):longint;

 implementation

 uses codes;

 type PtrRec = Record
       Ofs,Seg:word;
      end;

      pFreeRec = ^tFreeRec;
      tFreeRec = Object
       next:pFreeRec;
       Low,High:word;
       Function HoleSize:Longint;
       Function Alloc(Last:pFreeRec;Size:Longint;Var aNext:pFreeRec):pointer;
      end;

 var FreePtr:pFreeRec absolute FreeList;

function ValPtr(l:longint):pointer; assembler;
 asm
  mov dx,l.word[2]
  mov ax,l.word[0]
  shl dx,12
  mov bx,ax
  and ax,$0F
  shr bx,4
  or  dx,bx
 end;

function PtrVal(p:pointer):longint; assembler;
 asm
  les  bx,p
  mov  dx,es
  mov  ax,es
  shl  ax,4
  shr  dx,12
  add  ax,bx
  adc  dx,0
 end;

function SubPtr(p1,p2:pointer):longint;
 begin
  SubPtr:=PtrVal(p1)-PtrVal(p2);
 end;

procedure IncPtr(var p:pointer;n:longint);
 begin
  p:=ValPtr(PtrVal(p)+n);
 end;

procedure DecPtr(var p:pointer;n:longint);
 begin
  p:=ValPtr(PtrVal(p)-n);
 end;

function CleanPtr(p:pointer):pointer; assembler;
 asm
  mov ax,p.word[0] { Offset nach ax }
  mov dx,p.word[2] { Segment nach dx }
  cmp ax,$0010
  jb  @exit
  mov bx,ax
  and ax,$000F
  shr bx,4
  add dx,bx
  @exit:
 end;

Function tFreeRec.HoleSize:Longint; assembler;
 asm
      les  di,self
      mov  dx,es
      cmp  dx,heapptr.word[2]
      jne  @@1
      cmp  di,heapptr.word[0]
      jne  @@1
      les  di,heapend
      push es
      push di
      les  di,heapptr
      push es
      push di
      call subptr
      jmp  @@2
@@1:  les  di,self
      mov  dx,es:[di].&high
      mov  ax,dx
      shr  dx,12
      shl  ax,4
      add  ax,es:[di].&low
@@2:
 end;

Function tFreeRec.Alloc(Last:pFreeRec;Size:Longint;Var aNext:pFreeRec):pointer;
 var diff:longint;
     p:pFreeRec;
 begin
  diff:=holesize - size;
  if diff>=0 then
  begin
   if @self=heapptr then
   begin
    incptr(heapptr,size);
    if @self=freeptr then freeptr:=heapptr else
         if last<>nil then last^.next:=heapptr;
   end else
   begin
    p:=next;
    if diff>=8 then
    begin
     if size and $7<>0 then size:=(size or $7) + 1;
     p:=@self;
     incptr(pointer(p),size);
     p^.next:=next;
     p^.Low:=diff and 8;
     p^.high:=diff shr 4;
    end;
    if @self=freeptr then freeptr:=p else last^.next:=p;
   end;
   Alloc:=@self;
   Next:=nil;
  end else
  begin
   Alloc:=nil;
   if @self=heapptr then anext:=nil else anext:=next;
  end;
 end;

 procedure XGetMem(var p:pointer;size:longint);
  var f1:pFreeRec;
  begin
   f1:=freeptr;
   p:=nil;
   while (p=nil) and (f1<>nil) do p:=f1^.alloc(nil,size,f1);
  end;

 procedure XFreeMem(p:pointer;size:longint);
  var i,j:word;
  begin
   if p<>nil then
   begin
    for i:=1 to Size Div $8000 do
    begin
     freemem(p,$8000);
     incptr(p,$8000);
    end;
    if size and $7FFF>0 then freemem(p,size and $7FFF);
   end;
  end;


end.