{***************************************************************************}
{                                                                           }
{          Copyright (C) Christian Baumgarten, Hamburg 1993.                }
{                                                                           }
{***************************************************************************}
UNIT HERCULES;

INTERFACE
Type HGCMODE = (HALF,FULL);
	       { Half = Modus mit einer Graphikseite.
		 Full = Modus mit zwei Graphikseiten }
procedure HGCInitGraph(Mode:HgcMode);
procedure HGCCloseGraph;
procedure HGCShowPage(Page:Byte);

procedure HGCPutPixel(x,y:Integer;page,color:byte);
 function HGCGetPixel(x,y:Integer;page:byte):Byte;
procedure HGCClrDev(page:byte);
 function HGCIsGraphMode:Boolean;
procedure HGCLine(x1,y1,x2,y2:integer;page,color:byte);


IMPLEMENTATION

type  CRTRegs=array[0..11] of byte;

const
      TextRegs:CRTRegs=($61,$50,$52,$0F,$19,$06,$19,$19,$02,$0D,$0B,$0C);
      GrafRegs:CRTRegs=($35,$2D,$2E,$07,$5B,$02,$57,$57,$02,$03,$00,$00);

      ModeReg  = $03B8;
      ConfigReg= $03BF;
      IndexReg = $03B4;
      DataReg  = $03B5;

procedure HGCInit(Cfg,Mode1,Mode2:Byte;Var CRT6845:CRTRegs); assembler;
 asm
  mov dx,configreg      { Konfigurationsregister setzen }
  mov al,cfg
  out dx,al
  mov dx,modereg        { Modusregister setzen          }
  mov al,mode1
  out dx,al
  les si,crt6845        { CRT-Registerwerte setzen:     }
  mov cx,12             { 12 Stck an der Zahl..        }
  cld
  mov dx,IndexReg
  xor ah,ah             { AH = Index des jeweiligen Registers }
@@1:mov al,ah
    out dx,al
    seges lodsb         { Registerwert laden..          }
    inc dx              { Datenregister adressieren     }
    out dx,al           { Wert schreiben..              }
    dec dx              { Indexregister adressieren     }
    inc ah              { Nchster Index..              }
   loop @@1
  mov dx,modereg        { Modusregister auf endgltigen Wert setzen }
  mov al,mode2
  out dx,al
  mov es,seg0040        { Wert des Modusregisters im    }
  mov es:[$65],al       { Bios-Datenbereich anpassen    }
 end;

 procedure HGCInitGraph(Mode:HgcMode);
  begin
   case mode of
    Half:HGCInit(1,2,$0A,GrafRegs);
    Full:HGCInit(3,$82,$8A,GrafRegs);
    else exit;
   end;
   Mem[Seg0040:$49]:=6;  	{ Information fr den Maustreiber }
  end;

 procedure HGCCloseGraph;
  begin
   Mem[Seg0040:$49]:=7;		{ Bildschirmmodus 7 		}
   HGCInit(1,0,8,TextRegs);	{ HGC in den Textmodus schalten }
  end;

 function HGCIsGraphMode:Boolean;
  begin
   HGCIsGraphMode:=Mem[Seg0040:$65] and 2<>0;
  end;

procedure HGCClrDev(page:byte); assembler;
 asm
  mov  es,segB000       { Selektor 0. Seite }
  cmp  page,0
  je   @@1
  mov  es,segB800       { Selektor 1. Seite }
@@1:
  xor  di,di
  mov  cx,4000H         { 32 KB in Worten   }
  cld
  xor  ax,ax
  rep  stosw
 end;

procedure HGCShowPage(page:Byte); assembler;
 { Seitenumschaltung ber das MSB des Modusregisters: }
 { MSB = 1 => 1. Seite aktivieren                     }
 asm
  mov dx,modereg
  mov es,seg0040
  mov di,$65
  mov al,es:[di]	{ AL = Derzeitiger Wert des Modusregisters 	}
  cmp page,0		{ aus dem Biosdatenbereich.			}
  jne @@1
  and al,$7F            { Seite 0: MSB lschen.				}
  jmp @@2
@@1:
  or  al,$80		{ Seite 1: MSB setzen.				}
@@2:
  out dx,al		{ Neuen Wert in das Modusregister schreiben.	}
  mov es:[di],al	{ .. und im Biosdatenbereich mitprotokollieren.	}
 end;

{ Zeilenoffset (Hercules) berechnen:        }
{ = ((y and 3) shl 13) + (y shr 2) * 90 + x }
{ input:  ax = y  (Zeilen)                  }
{         bx = x  (Spalten)                 }
{ output: di = offs(x,y)                    }
procedure _gethgcoffs; near; assembler;
 asm
   push ax
   shr  ax,2
   mov  dx,90
   mul  dx
   pop  dx
   and  dx,3
   mov  cl,13
   shl  dx,cl
   add  ax,dx
   mov  cl,3
   shr  bx,cl
   add  ax,bx
   mov  di,ax
 end;

procedure _gethgcdelta; near; assembler;
 asm
  cmp di,$6000       { Letzter Block ?         }
  jae @@1
  add di,$2000       { Nein: Nchster Block, d.h. 2000H addieren }
  ret
@@1:
  sub di,$6000 - 90  { Ja: ($6000-90) abziehen: eine Zeile weiter, drei Blcke zurck }
 end;

{ Input: BX    = X                                }
{        DL    = Farbe                            }
{        ES:DI = Zeiger auf das Bildspeicherzeile }
procedure _hgcputpixel; near; assembler;
 asm
   mov  al,$80
   mov  cx,bx
   shr  bx,3	{ X / 8 = Offset auf Byte 		}
   and  cl,7    { X MOD 8 = Byteoffset des Bits 	}
   shr  al,cl
   test dl,1    { Farbe = 1 ?				}
   jnz  @@1
   not  al      { Nein: Bit lschen.			}
   and  es:[di+bx],al
   jmp  @@2
@@1:or  es:[di+bx],al	{ Ja: Bit Setzen.		}
@@2:
 end;

procedure HGCPutPixel(x,y:Integer;page,color:byte); assembler;
 asm
  mov  es,SegB000
  cmp  page,1
  jb   @seite0
  mov  es,SegB800     { ES = Segmentadresse Bildschirm  }
  @seite0:
  mov  ax,y
  xor  bx,bx
  call _gethgcoffs    { DI = Offs(0,y)			}
  mov  bx,x	      { BX = X, DL = Farbe		}
  mov  dl,color
  call _hgcputpixel
 end;

function HGCGetPixel(x,y:Integer;page:byte):Byte; assembler;
 asm
  mov  es,SegB000
  cmp  page,1
  jb   @seite0
  mov  es,SegB800
  @seite0:
  mov  ax,y
  mov  bx,x
  push bx
  call _gethgcoffs
  pop  cx
  and  cx,7
  mov  al,$80
  shr  al,cl
  and  al,es:[di]
  je   @ende
  mov  al,1
  @ende:
 end;

procedure HGCLine(x1,y1,x2,y2:integer;page,color:byte); assembler;
 var xx,d_x,d_y,r:integer;
 asm
    mov  xx,1
    mov  es,SegB000
    cmp  page,1
    jb   @@Page0
    mov  es,SegB800
@@Page0:
    mov  bx,y2
    cmp  bx,y1
    jae  @@1
    xchg bx,x1
    mov  x2,bx
    mov  ax,y1
    xchg ax,y2
    mov  y1,ax
@@1:mov  bx,x2
    sub  bx,x1
    jnb  @@2
    neg  xx
    neg  bx
@@2:mov  d_x,bx
    mov  ax,y2
    sub  ax,y1
    mov  d_y,ax
     mov  ax,y1
     xor  bx,bx
     call _gethgcoffs
     mov  bx,x1
     mov  dl,color
     call _hgcputpixel
    xor  cx,cx
    mov  r,cx
    mov  bx,d_x
    cmp  bx,d_y
    jbe  @@3
@@5:mov  bx,x1
    cmp  bx,x2
    je   @@4
    mov  ax,xx
    add  x1,ax
    mov  dx,d_y
    add  r,dx
    mov  ax,r
    shl  ax,1
    cmp  ax,d_x
    jb   @@6
    inc  y1
    call _gethgcdelta
    mov  ax,d_x
    sub  r,ax
@@6:mov  bx,x1
    mov  dl,color
    call _hgcputpixel
    jmp  @@5
@@3:mov  bx,y1
    cmp  bx,y2
    je   @@4
    inc  y1
    call _gethgcdelta
    mov  ax,d_x
    add  r,ax
    mov  ax,r
    shl  ax,1
    cmp  ax,d_y
    jbe  @@8
    mov  ax,xx
    add  x1,ax
    mov  ax,d_y
    sub  r,ax
@@8:mov  bx,x1
    mov  dl,color
    call _hgcputpixel
    jmp  @@3
@@4:
 end;

end.
