{************************************************************************}
{           Copyright (c) Christian Baumgarten, Hamburg 1993             }
{             Turbo-Pascal 7.0 Unit fr Keyboard-Funktionen              }
{************************************************************************}
UNIT KEYBOARD;
INTERFACE

function getkey(var scancode:byte):char;
procedure setkey(c:char;s:byte);
function keydown(var c:char;var scan:byte):boolean;
function shiftstate:word;
function shiftkeypressed:boolean;
function InsLocked:boolean;
function ScrollLocked:boolean;
function NumLocked:boolean;
function CapsLocked:boolean;

function ShiftRight:boolean;
function ShiftLeft:boolean;
function shift:boolean;

function Ctrl:boolean;
function CtrlRight:boolean;
function CtrlLeft:boolean;

function Alt:boolean;
function AltRight:boolean;
function AltLeft:boolean;

function Caps:boolean;
function Num:boolean;
function Scroll:boolean;

procedure NumOn;
procedure NumOFF;
procedure CapsON;
procedure CapsOFF;
procedure ScrollON;
procedure ScrollOFF;

IMPLEMENTATION

var Oldshiftstate:word;

function shiftstate:word; assembler;
 asm
  mov ah,12h
  int 16h
 end;

function getkey(var scancode:byte):char; assembler;
 asm
  xor ah,ah
  int 16h
  les di,scancode
  mov es:[di],ah
 end;

procedure setkey(c:char;s:byte); assembler;
 asm
  mov ah,5
  mov ch,&s
  mov cl,&c
  int 16h
 end;

function keydown(var c:char;var scan:byte):boolean; assembler;
  asm
     mov    ah,11h
     int    16h
     jz     @@No
     cld
     les    di,&c
     stosb
     xchg   al,ah
     les    di,&scan
     stosb
     mov    al,1
     jmp    @@yes
@@No:xor    al,al
@@Yes:
  end;

function InsLocked:boolean;
 begin
  Inslocked:=(shiftstate and $80)=$80;
 end;

function ScrollLocked:boolean;
 begin
  Scrolllocked:=(shiftstate and $10)=$10;
 end;

function NumLocked:boolean;
 begin
  Numlocked:=(shiftstate and $20)=$20;
 end;

function CapsLocked:boolean;
 begin
  capslocked:=(shiftstate and $40)=$40;
 end;

function ShiftRight:boolean;
 begin
  shiftright:=(shiftstate and 1)=1;
 end;

function ShiftLeft:boolean;
 begin
  shiftleft:=(shiftstate and 2)=2;
 end;

function shift:boolean;
 begin
  shift:=(shiftstate and 3)>0;
 end;

function Ctrl:boolean;
 begin
  ctrl:=(shiftstate and $104)>0;
 end;

function CtrlRight:boolean;
 begin
  ctrlRight:=(shiftstate and $104)=4;
 end;

function CtrlLeft:boolean;
 begin
  ctrlLeft:=(shiftstate and $104)=$104;
 end;

function Alt:boolean;
 begin
  alt:=(shiftstate and 8)=8;
 end;

function AltRight:boolean;
 begin
  altright:=(shiftstate and $208)=8;
 end;

function AltLeft:boolean;
 begin
  altleft:=(shiftstate and $208)=$208;
 end;

function Caps:boolean;
 begin
  caps:=(shiftstate and $4000)=$4000;
 end;

function Num:boolean;
 begin
  Num:=(shiftstate and $2000)=$2000;
 end;

function Scroll:boolean;
begin
 scroll:=(shiftstate and $1000)=$1000;
end;

function shiftkeypressed:boolean;
 begin
  if (shiftstate<>oldshiftstate) then
  begin
   oldshiftstate:=shiftstate;
   shiftkeypressed:=true;
  end else shiftkeypressed:=false;
 end;

procedure NumOn;
 begin
  Memw[Seg0040:$17]:=ShiftState or $20;
 end;

procedure NumOFF;
 begin
  Memw[Seg0040:$17]:=ShiftState and $FFDF;
 end;

procedure CapsON;
 begin
  Memw[Seg0040:$17]:=ShiftState or $40;
 end;

procedure CapsOFF;
 begin
  Memw[Seg0040:$17]:=ShiftState and $FFBF;
 end;

procedure ScrollON;
 begin
  Memw[Seg0040:$17]:=ShiftState or $10;
 end;

procedure ScrollOFF;
 begin
  Memw[Seg0040:$17]:=ShiftState and $FFEF;
 end;


BEGIN
 OldShiftstate:=Shiftstate;
END.