{***************************************************************************}
{                                                                           }
{          Copyright (C) Christian Baumgarten, Hamburg 1993.                }
{                                                                           }
{       Unit mit Dialogen zur Manipulation der EGA/VGA-Paletten		    }
{                                                                           }
{***************************************************************************}
unit palettes;
interface
uses dialogs,views,Drivers,vga,Objects,Commands;

{ Paletten-Standardbelegungen: }

const StdEgaPalette:tPaletteRegs =
       (Palette:($00,$01,$02,$03,$04,$05,$14,$07,$38,$39,$3A,$3B,$3C,$3D,$3E,$3F);OverScan:0);

      StdVGAColors: tRGB16Page =
       ((RED:$00;GREEN:$00;BLUE:$00), {Black      EGA  0}
        (RED:$00;GREEN:$00;BLUE:$2A), {Blue       EGA  1}
        (RED:$00;GREEN:$2A;BLUE:$00), {Green      EGA  2}
        (RED:$00;GREEN:$2A;BLUE:$2A), {Cyan       EGA  3}
        (RED:$2A;GREEN:$00;BLUE:$00), {Red        EGA  4}
        (RED:$2A;GREEN:$00;BLUE:$2A), {Magenta    EGA  5}
        (RED:$2A;GREEN:$15;BLUE:$00), {Brown      EGA 20}
        (RED:$2A;GREEN:$2A;BLUE:$2A), {Lt. Gray   EGA  7}
        (RED:$15;GREEN:$15;BLUE:$15), {Gray       EGA 56}
        (RED:$15;GREEN:$15;BLUE:$3F), {Lt Blue    EGA 57}
        (RED:$15;GREEN:$3F;BLUE:$15), {Lt Green   EGA 58}
        (RED:$15;GREEN:$3F;BLUE:$3F), {Lt Cyan    EGA 59}
        (RED:$3F;GREEN:$15;BLUE:$15), {Lt Red     EGA 60}
        (RED:$3F;GREEN:$15;BLUE:$3F), {Lt Magenta EGA 61}
        (RED:$3F;GREEN:$3F;BLUE:$15), {Yellow     EGA 62}
	(RED:$3F;GREEN:$3F;BLUE:$3F));{White      EGA 63}

type pPaletteView = ^tPaletteView;
     tPaletteView = object(tView)
      constructor init(var Bounds:tRect);
      procedure Draw; virtual;
     end;

     pColorBoxes = ^tColorBoxes;
     tColorBoxes = object(tCheckBoxes)
      constructor init(Bounds:tRect);
      procedure Press(item:integer); virtual;
      procedure MovedTo(item:integer); virtual;
     end;

     pColRadioButtons = ^tColRadioButtons;
     tColRadioButtons = Object(tRadioButtons)
      constructor init(Bounds:tRect);
      procedure Press(item:integer); virtual;
      procedure MovedTo(item:integer); virtual;
     end;

     pEGAPaletteDlg = ^tEGAPaletteDlg;
     tEGAPaletteDlg = object(tDialog)
      ThePalette:tPaletteRegs;
      Index:pRadioButtons;
      Color:pCheckBoxes;
      constructor init(aPalette:pPaletteRegs);
      constructor Load(var S:tStream);
      procedure   Store(var S:tStream);
      procedure   GetData(var Rec); virtual;
      procedure   SetData(var Rec); virtual;
      Function    DataSize:Word;    virtual;
      procedure   HandleEvent(var Event:tEvent); virtual;
     end;

     pVGAPaletteDlg = ^tVGAPaletteDlg;
     tVGAPaletteDlg = object(tDialog)
      ThePalette:tRGB16Page;
      Index:pRadioButtons;
      Red,Green,Blue:pScrollBar;
      constructor init(aPalette:pRGB16Page);
      constructor Load(var S:tStream);
      procedure   Store(var S:tStream);
      procedure   GetData(var Rec); virtual;
      procedure   SetData(var Rec); virtual;
      Function    DataSize:Word;    virtual;
      procedure   HandleEvent(var Event:tEvent); virtual;
     end;

     procedure ModifyEGAPalette(var EgaPalette:tPaletteRegs);
     procedure ModifyVGAPalette(var VgaPalette:tRGB16Page);
     procedure RegisterPalette;


const
 rPaletteView:tStreamRec = (
  objtype : srPaletteView;
  vmtLink : ofs(typeof(tPaletteView)^);
  load    : @tPaletteView.Load;
  store   : @tPaletteView.Store);

 rColorBoxes: tStreamRec = (
  objtype : srColorBoxes;
  vmtLink : ofs(typeof(tColorBoxes)^);
  load    : @tColorBoxes.Load;
  store   : @tColorBoxes.Store);

 rColRadioButtons: tStreamRec = (
  objtype : srColRadioButtons;
  vmtLink : ofs(typeof(tColRadioButtons)^);
  load    : @tColRadioButtons.Load;
  store   : @tColRadioButtons.Store);

 rEGAPaletteDlg: tStreamRec = (
  objtype : srEGAPaletteDlg;
  vmtLink : ofs(typeof(tEGAPaletteDlg)^);
  load    : @tEGAPaletteDlg.Load;
  store   : @tEGAPaletteDlg.Store);

 rVGAPaletteDlg: tStreamRec = (
  objtype : srVGAPaletteDlg;
  vmtLink : ofs(typeof(tVGAPaletteDlg)^);
  load    : @tVGAPaletteDlg.Load;
  store   : @tVGAPaletteDlg.Store);

implementation
uses App;

const egaIndex:integer=0;
      vgaIndex:integer=0;

 procedure RegisterPalette;
  begin
   RegisterType(rPaletteView);
   RegisterType(rColorBoxes);
   RegisterType(rColRadioButtons);
   RegisterType(rEgaPaletteDlg);
   RegisterType(rVgaPaletteDlg);
  end;

 constructor tColorBoxes.init(Bounds:tRect);
  begin
   Bounds.B.X:=Bounds.A.X + 21;
   Bounds.B.Y:=Bounds.A.Y + 6;
   inherited Init(Bounds,
     NewSItem('Primres Blau',
     NewSItem('Primres Grn',
     NewSItem('Primres Rot',
     NewSItem('Sekundres Blau',
     NewSItem('Sekundres Grn',
     NewSItem('Sekundres Rot',nil)))))));
  end;

 procedure tColorBoxes.Press(item:integer);
  begin
   Inherited Press(item);
   Message(Owner,evBroadCast,cmClusterChanged,@self);
  end;

 procedure tColorBoxes.MovedTo(item:integer);
  begin
   Press(item);
  end;

 constructor tColRadioButtons.init(Bounds:tRect);
  begin
    Bounds.B.X:=Bounds.A.X + 21;
    Bounds.B.Y:=Bounds.A.Y + 16;
    inherited Init(Bounds,
     NewSItem('0  (Schwarz) ',
     NewSItem('1  (Blau)',
     NewSItem('2  (Grn)',
     NewSItem('3  (Cyan)',
     NewSItem('4  (Rot)',
     NewSItem('5  (Magenta) ',
     NewSItem('6  (Braun)',
     NewSItem('7  (Hellgrau)',
     NewSItem('8  (Grau)',
     NewSItem('9  (HellBlau)',
     NewSItem('10 (Hellgrn)',
     NewSItem('11 (HellCyan)',
     NewSItem('12 (Hellrot)',
     NewSItem('13 (HellMagenta)',
     NewSItem('14 (Gelb)',
     NewSItem('15 (Wei)',nil)))))))))))))))));
  end;


 procedure tColRadioButtons.Press(item:integer);
  begin
   Inherited Press(item);
   Message(Owner,evBroadCast,cmClusterChanged,@self);
  end;

 procedure tColRadioButtons.MovedTo(item:integer);
  begin
   Press(item);
  end;
              
 constructor tPaletteView.init(var Bounds:tRect);
  begin
   Bounds.B.X:=Bounds.A.X+2;
   Bounds.B.Y:=Bounds.A.Y+16;
   tView.init(Bounds);
   options:=options and not ofselectable;
  end;

 procedure tPaletteView.Draw;
  var i:byte;
      buf:array[0..15,0..3] of byte;
  begin
   Fillchar(buf,sizeof(buf),219);
   for i:=0 to 15 do
   begin
    buf[i,1]:=i;
    buf[i,3]:=i;
   end;
   writebuf(0,0,2,16,buf);
  end;


  constructor tEGAPaletteDlg.init(aPalette:pPaletteRegs);
   var R:tRect;
       i:word;
   begin
    R.Assign(0,0,52,20);
    tDialog.Init(R,'EGA-Palette');
    ThePalette:=aPalette^;
    options:=options or ofcenterX or ofcenterY;
    R.Assign(3,2,5,18);
    insert(New(pPaletteView,Init(R)));
    R.Assign(5,2,26,18);
    Index:=New(pColRadioButtons,Init(R));
    Index^.SetData(egaIndex);
    Insert(Index);
    R.Assign(28,2,49,8);
    Color:=New(pColorBoxes,Init(R));
    i:=ThePalette.Palette[egaIndex];
    Color^.SetData(i);
    Insert(Color);
    R.assign(32,10,46,12);
    Insert(New(pButton,Init(R,'O~K~',cmOK,bfNormal)));
    R.assign(32,12,46,14);
    Insert(New(pButton,Init(R,'~C~ancel',cmCancel,bfNormal)));
    R.assign(32,15,46,17);
    Insert(New(pButton,Init(R,'~S~tandard',cmStandard,bfNormal)));
    SelectNext(False);
   end;

  constructor tEGAPaletteDlg.Load(var S:tStream);
   begin
    inherited Load(S);
    getsubviewptr(S,index);
    getsubviewptr(S,color);
    S.Read(ThePalette,sizeof(ThePalette));
   end;

  procedure tEGAPaletteDlg.Store(var S:tStream);
   begin
    inherited Store(S);
    putsubviewptr(S,index);
    putsubviewptr(S,color);
    S.Write(ThePalette,sizeof(ThePalette));
   end;

  procedure tEGAPaletteDlg.GetData(var Rec);
   begin
    move(thepalette,rec,datasize);
   end;

  procedure tEGAPaletteDlg.SetData(var Rec);
   begin
    move(rec,thepalette,datasize);
    Vga.SetAllPalette(thepalette);
   end;

  Function tEGAPaletteDlg.DataSize:Word;
   begin
    DataSize:=SizeOf(ThePalette);
   end;

  procedure tEGAPaletteDlg.HandleEvent(var Event:tEvent);
   var i:word;
   begin
    inherited handleevent(event);
    if (event.what=evCommand) and (event.command = cmStandard) then
    begin
     ThePalette:=StdEgaPalette;
     SetAllPalette(ThePalette);
     Index^.getdata(egaIndex);
     i:=ThePalette.Palette[egaIndex];
     Color^.setdata(i);
     Color^.draw;
    end else
    if (event.what=evBroadcast) and
       (event.command = cmClusterChanged) then
    begin
     if event.infoptr = Color then
     begin
      Index^.getdata(egaIndex);
      ThePalette.Palette[egaIndex]:=lo(Color^.Value);
      VGA.SetAllPalette(ThePalette);
      ClearEvent(Event);
     end else if event.infoptr=index then
     begin
      Index^.getdata(egaIndex);
      i:=ThePalette.Palette[egaIndex];
      Color^.setdata(i);
      Color^.draw;
     end else exit;
     clearEvent(event);
    end;
   end;

  procedure ModifyEGAPalette(var EgaPalette:tPaletteRegs);
   var pEGA:pEgaPaletteDlg;
   begin
    Vga.SetAllPalette(EgaPalette);
    pEga:=New(pEgaPaletteDlg,Init(@EgaPalette));
    if Desktop^.ExecView(pEga)=cmOK then EgaPalette:=pEga^.ThePalette;
    Vga.SetAllPalette(EgaPalette);
   end;


  constructor tVGAPaletteDlg.init(aPalette:pRGB16Page);
   var R:tRect;
       i:word;
   begin
    R.Assign(0,0,52,20);
    tDialog.Init(R,'VGA-Palette');
    ThePalette:=aPalette^;
    options:=options or ofcenterX or ofcenterY;
    R.Assign(3,2,5,18);
    insert(New(pPaletteView,Init(R)));
    R.Assign(5,2,26,18);
    Index:=New(pColRadioButtons,Init(R));
    Index^.SetData(vgaIndex);
    Insert(Index);

    R.Assign(28,3,49,4);
    Red:=New(pScrollBar,init(R));
    i:=ThePalette[vgaIndex].red;
    Red^.SetParams(i,0,63,16,1);
    Red^.Options:=Red^.Options or ofSelectable;
    Insert(Red);
    R.Assign(27,2,49,3);
    Insert(New(pLabel,Init(R,'Roter Anteil:',Red)));
    R.Assign(28,5,49,6);
    Green:=New(pScrollBar,init(R));
    i:=ThePalette[vgaIndex].Green;
    Green^.SetParams(i,0,63,16,1);
    Green^.Options:=Green^.Options or ofSelectable;
    Insert(Green);
    R.Assign(27,4,49,5);
    Insert(New(pLabel,Init(R,'Grner Anteil:',Green)));
    R.Assign(28,7,49,8);
    Blue:=New(pScrollBar,init(R));
    i:=ThePalette[vgaIndex].Blue;
    Blue^.SetParams(i,0,63,16,1);
    Blue^.Options:=Blue^.Options or ofSelectable;
    Insert(Blue);
    R.Assign(27,6,49,7);
    Insert(New(pLabel,Init(R,'Blauer Anteil:',Blue)));
    R.assign(32,10,46,12);
    Insert(New(pButton,Init(R,'O~K~',cmOK,bfNormal)));
    R.assign(32,12,46,14);
    Insert(New(pButton,Init(R,'~C~ancel',cmCancel,bfNormal)));
    R.assign(32,15,46,17);
    Insert(New(pButton,Init(R,'~S~tandard',cmStandard,bfNormal)));
    SelectNext(False);
   end;

  constructor tVGAPaletteDlg.Load(var S:tStream);
   begin
    inherited Load(S);
    getsubviewptr(S,index);
    getsubviewptr(S,red);
    getsubviewptr(S,green);
    getsubviewptr(S,blue);
    S.Read(ThePalette,sizeof(ThePalette));
   end;

  procedure   tVGAPaletteDlg.Store(var S:tStream);
   begin
    inherited Store(S);
    putsubviewptr(S,index);
    putsubviewptr(S,red);
    putsubviewptr(S,green);
    putsubviewptr(S,Blue);
    S.Write(ThePalette,sizeof(ThePalette));
   end;

  procedure tVGAPaletteDlg.GetData(var Rec);
   begin
    move(thepalette,rec,datasize);
   end;

  procedure   tVGAPaletteDlg.SetData(var Rec);
   begin
    move(rec,thepalette,Datasize);
    WaitVretrace;
    Vga.SetVga16Colors(thepalette);
   end;

  Function tVGAPaletteDlg.DataSize:Word;
   begin
    DataSize:=SizeOf(ThePalette);
   end;

  procedure tVGAPaletteDlg.HandleEvent(var Event:tEvent);
   var i:word;
   const locked:integer=0;
   begin
    inherited handleevent(event);
    if (event.what=evCommand) and (event.command = cmStandard) then
    begin
     ThePalette:=StdVgaColors;
     WaitVRetrace;
     SetVga16Colors(ThePalette);
     inc(locked);
      Index^.getdata(vgaIndex);
      Red^.SetValue(ThePalette[vgaIndex].Red);
      Green^.SetValue(ThePalette[vgaIndex].Green);
      Blue^.SetValue(ThePalette[vgaIndex].Blue);
     dec(locked);
    end else
    if (event.what=evBroadcast) then
    begin
     case event.command of
     cmClusterChanged:  begin
                         inc(locked);
                         Index^.getdata(vgaIndex);
                         Red^.SetValue(ThePalette[vgaIndex].Red);
                         Green^.SetValue(ThePalette[vgaIndex].Green);
                         Blue^.SetValue(ThePalette[vgaIndex].Blue);
                         dec(locked);
                        end;
     cmScrollBarChanged:if locked = 0 then
			begin
			  Index^.getdata(vgaIndex);
			  ThePalette[VgaIndex].Red:=Red^.Value;
			  ThePalette[VgaIndex].Green:=Green^.Value;
			  ThePalette[VgaIndex].Blue:=Blue^.Value;
			  WaitVRetrace;
			  Vga.SetRGBEntry(GetPaletteReg(vgaIndex),ThePalette[vgaIndex]);
			end;
      else exit;
     end;
     clearevent(event);
   end;
  end;

  procedure ModifyVGAPalette(var VgaPalette:tRGB16Page);
   var pVGA:pVgaPaletteDlg;
   begin
    WaitVRetrace;
    Vga.SetVGA16Colors(VgaPalette);
    pVga:=New(pVgaPaletteDlg,Init(@vgaPalette));
    if Desktop^.ExecView(pVga)=cmOK then VgaPalette:=pVga^.thePalette;
    WaitVRetrace;
    Vga.Setvga16Colors(VgaPalette);
   end;

end.