;******************************************************************;
;                                                                  ;
;         Copyright (c) 1993 by CHRISTIAN BAUMGARTEN 1993          ;
;                                                                  ;
;         QWORD CALCULATION ROUTINES FOR 8086/80386er CPUs         ;
;                                                                  ;
;******************************************************************;

        TITLE QWORDS

        LOCALS

AA      EQU  DWORD PTR [BP+14]
BB      EQU  DWORD PTR [BP+10]
CC      EQU  DWORD PTR [BP+6]

A_2     EQU  DWORD PTR [BP-4]
A_1     EQU  DWORD PTR [BP-8]

B_2     EQU  DWORD PTR [BP-12]
B_1     EQU  DWORD PTR [BP-16]

C_2     EQU  DWORD PTR [BP-20]
C_1     EQU  DWORD PTR [BP-24]

A4      EQU   WORD PTR [BP-2]
A3      EQU   WORD PTR [BP-4]
A2      EQU   WORD PTR [BP-6]
A1      EQU   WORD PTR [BP-8]

B4      EQU   WORD PTR [BP-10]
B3      EQU   WORD PTR [BP-12]
B2      EQU   WORD PTR [BP-14]
B1      EQU   WORD PTR [BP-16]

C4      EQU   WORD PTR [BP-18]
C3      EQU   WORD PTR [BP-20]
C2      EQU   WORD PTR [BP-22]
C1      EQU   WORD PTR [BP-24]

INIT    MACRO
         PUSH  BP
         MOV   BP,SP
         SUB   SP,24
        ENDM

EXIT    MACRO
         MOV   SP,BP
         POP   BP
        ENDM


DATA	SEGMENT	BYTE PUBLIC

        EXTRN   TEST8086:BYTE

DATA	ENDS

CODE	SEGMENT	BYTE PUBLIC

	ASSUME	CS:CODE,DS:DATA

;***************************************************************************;
;***************************************************************************;

     PUBLIC  QADD,QSUB,QMUL
     PUBLIC  QDIVMOD

QADD    PROC  FAR  ; PROCEDURE QADD(VAR A,B,C:QWORD);
         PUSH BP
         MOV  BP,SP
         CMP  TEST8086,2
         JB   @@86
         .386
         LES  DI,AA          ; EDX:EAX = A
         MOV  EAX,ES:[DI]
         MOV  EDX,ES:[DI+4]
         LES  DI,BB          ; B zu EDX:EAX addieren
         ADD  EAX,ES:[DI]
         ADC  EDX,ES:[DI+4]
         LES  DI,CC          ; EDX:EAX nach C schreiben
         MOV  DWORD PTR ES:[DI],EAX
         MOV  DWORD PTR ES:[DI+4],EDX
         .8086
@@EXIT:  POP  BP
         RET  12
@@86:    LES  DI,AA          ; DX:CX:BX:AX  = A
         MOV  AX,ES:[DI]
         MOV  BX,ES:[DI+2]
         MOV  CX,ES:[DI+4]
         MOV  DX,ES:[DI+6]
         LES  DI,BB          ; B zu DX:CX:BX:AX addieren
         ADD  AX,ES:[DI]
         ADC  BX,ES:[DI+2]
         ADC  CX,ES:[DI+4]
         ADC  DX,ES:[DI+6]
         LES  DI,CC          ; Ergebnis nach C schreiben
         MOV  ES:[DI],AX
         MOV  ES:[DI+2],BX
         MOV  ES:[DI+4],CX
         MOV  ES:[DI+6],DX
         JMP  @@EXIT
QADD    ENDP

QSUB    PROC  FAR  ; PROCEDURE QSUB(VAR A,B,C:QWORD);
         PUSH BP
         MOV  BP,SP
         CMP  TEST8086,2
         JB   @@86
         .386
         LES  DI,AA
         MOV  EAX,ES:[DI]
         MOV  EDX,ES:[DI+4]
         LES  DI,BB
         SUB  EAX,ES:[DI]
         SBB  EDX,ES:[DI+4]
         LES  DI,CC
         MOV  ES:[DI],EAX
         MOV  ES:[DI+4],EDX
         .8086
@@EXIT:  POP  BP
         RET  12
@@86:    LES  DI,AA
         MOV  AX,ES:[DI]
         MOV  BX,ES:[DI+2]
         MOV  CX,ES:[DI+4]
         MOV  DX,ES:[DI+6]
         LES  DI,BB
         SUB  AX,ES:[DI]
         SBB  BX,ES:[DI+2]
         SBB  CX,ES:[DI+4]
         SBB  DX,ES:[DI+6]
         LES  DI,CC
         MOV  ES:[DI],AX
         MOV  ES:[DI+2],BX
         MOV  ES:[DI+4],CX
         MOV  ES:[DI+6],DX
         JMP  @@EXIT
QSUB    ENDP

QMUL    PROC  FAR  ; PROCEDURE QMUL(VAR A,B,C:QWORD);
         PUSH  BP
         MOV   BP,SP
         CMP   TEST8086,2
         JB    @@86
         .386
         PUSH  DS                ; DS sichern
         LES   DI,AA
         LDS   SI,BB
         MOV   EAX,ES:[DI]       ; Lo-Doppelworte multiplizieren ...
         MUL   DWORD PTR [SI]
         MOV   EBX,EDX           ; ... und in EBX:ECX sichern.
         MOV   ECX,EAX
         MOV   EAX,ES:[DI+4]     ; Hi(A) * Lo(B) berechnen...
         MUL   DWORD PTR [SI]
         ADD   EBX,EAX           ; ...und Ergebnis zu EBX:ECX addieren.
         MOV   EAX,ES:[DI]
         MUL   DWORD PTR [SI+4]  ; Lo(A) * Hi(B) berechnen...
         ADD   EBX,EAX           ; ...und Ergebnis zu EBX:ECX addieren.
         POP   DS                ; DS restaurieren
         LES   DI,CC             ; Ergebnis nach C schreiben.
         MOV   ES:[DI],ECX
         MOV   ES:[DI+4],EBX
         .8086
@@EXIT:  POP   BP
         RET   12
@@86:    SUB   SP,8
         PUSH  DS
         LES   DI,[BP+10]
         LDS   SI,[BP+14]
         LODSW
         MOV   BX,AX
         MUL   WORD PTR ES:[DI+6]
         mov   a4,ax
         mov   ax,bx
         mul   word ptr es:[di+4]
         mov   a3,ax
         add   a4,dx
         mov   ax,bx
         mul   word ptr es:[di+2]
         mov   a2,ax
         add   a3,dx
         adc   a4,0
         mov   ax,bx
         mul   word ptr es:[di]
         mov   a1,ax
         add   a2,dx
         adc   a3,0
         adc   a4,0
         lodsw
         mov   bx,ax
         mul   word ptr es:[di+4]
         add   a4,ax
         mov   ax,bx
         mul   word ptr es:[di+2]
         add   a3,ax
         adc   a4,dx
         mov   ax,bx
         mul   word ptr es:[di]
         add   a2,ax
         adc   a3,dx
         adc   a4,0
         lodsw
         mov   bx,ax
         mul   word ptr es:[di+2]
         add   a4,ax
         mov   ax,bx
         mul   word ptr es:[di]
         add   a3,ax
         adc   a4,dx
         lodsw
         mul   word ptr es:[di]
         add   a4,ax
         lea   si,a1
         push  ss
         pop   ds
         les   di,[bp+6]
         mov   cx,4
         cld
         rep   movsw
         POP   DS
         MOV   SP,BP
         JMP   @@EXIT
QMUL    ENDP

QDIVMOD PROC  FAR  ; PROCEDURE QDIVMOD(VAR A,B,D,M:QWORD);
         PUSH  BP
         MOV   BP,SP
         CMP   TEST8086,2
         JB    @@86
         JMP   @@_386
@@86:    SUB   SP,16
          MOV   DI,SP
          MOV   AX,SS
          MOV   ES,AX
          MOV   DX,4
          CLD
          PUSH  DS
           LDS   SI,[BP+14]
           MOV   CX,DX
           REP   MOVSW
           LDS   SI,[BP+18]
           MOV   CX,DX
           REP   MOVSW
          POP   DS
          xor   ax,ax
          xor   bx,bx
          xor   cx,cx
          xor   dx,dx
          mov   si,a1
          cmp   si,b1
          jb    @@_3
          mov   si,041H
@@_1:     rcl   ax,1
          rcl   bx,1
          rcl   cx,1
          rcl   dx,1
          sub   ax,b1
          sbb   bx,b2
          sbb   cx,b3
          sbb   dx,b4
          jnb   @@_2
          add   ax,b1
          adc   bx,b2
          adc   cx,b3
          adc   dx,b4
@@_2:     cmc
          rcl   a1,1
          rcl   a2,1
          rcl   a3,1
          rcl   a4,1
          dec   si
          jnz   @@_1
          jmp   @@_4
@@_3:     xchg  ax,a1
          xchg  bx,a2
          xchg  cx,a3
          xchg  dx,a4
@@_4:     les   di,[bp+6]
          stosw
          mov   ax,bx
          stosw
          mov   ax,cx
          stosw
          mov   ax,dx
          stosw
          les   di,[bp+10]
          mov   dx,ds
          mov   si,ss
          mov   ds,si
          lea   si,a1
          mov   cx,4
          rep   movsw
          mov   ds,dx
          MOV   SP,BP
@@EXIT:   POP   BP
          RET   16
@@_386:
         .386
         les  di,[BP+18]
         mov  eax,es:[di]
         mov  edx,es:[di+4]
         les  di,[BP+14]
         mov  esi,es:[di]
         mov  edi,es:[di+4]
         xor  ecx,ecx
         xor  ebx,ebx
         push bp
         cmp  edx,edi
         jb   @@3
         mov  bp,041H
@@1:     rcl  ecx,1
         rcl  ebx,1
         sub  ecx,esi
         sbb  ebx,edi
         jnb  @@2
         add  ecx,esi
         adc  ebx,edi
@@2:     cmc
         rcl  eax,1
         rcl  edx,1
         dec  bp
         jnz  @@1
         jmp  @@4
@@3:     xor  eax,eax
         xor  edx,edx
         mov  ebx,edi
         mov  ecx,esi
@@4:     pop  bp
         les  di,[bp+10]
         mov  es:[di],eax
         mov  es:[di+4],edx
         les  di,[bp+6]
         mov  es:[di],ecx
         mov  es:[di+4],ebx
         .8086
         JMP  @@EXIT
QDIVMOD ENDP


CODE	ENDS
	END
