{***************************************************************************}
{                                                                           }
{          Copyright (C) Christian Baumgarten, Hamburg 1993.                }
{                                                                           }
{***************************************************************************}
UNIT QWORDS;
INTERFACE

TYPE DWORD = LONGINT;

     QWORD = RECORD
      LO,HI:DWORD;
     END;

function qstr(a:qword):string;
function qval(s:string;var a:qword):integer;

procedure Q_GGT(a,b:qword;var ggt:qword);
procedure Q_KGV(a,b:qword;var kgv:qword);

procedure qadd(var a,b,c:qword);
procedure qsub(var a,b,c:qword);
procedure qmul(var a,b,c:qword);
procedure qDivMod(var a,b,d,m:qword);

implementation

procedure qadd(var a,b,c:qword);                external;
procedure qsub(var a,b,c:qword);                external;
procedure qmul(var a,b,c:qword);                external;
procedure qDivMod(var a,b,d,m:qword);           external;
 {$L QWORDS.OBJ}

Procedure Q_GGT(a,b:qword;var ggt:qword);
 var d,m:qword;
 begin
  ggt:=a;
  repeat
   qdivmod(ggt,b,d,m);
   ggt:=b;
   b:=m;
  until (m.hi=0) and (m.lo=0);
 end;

procedure Q_KGV(a,b:qword;var kgv:qword);
 Var GGT,M:QWORD;
 begin
  Q_GGT(A,B,GGT);
  QDIVMOD(A,GGT,A,M);
  QMUL(A,B,KGV);
 end;

function qstr(a:qword):string;
 var s:string;
     i:byte;
     t,d,m:qword;
 begin
  s[0]:=#0;
  t.hi:=0;
  t.lo:=10;
  while not ((a.hi=0) and (a.lo=0)) do
  begin
   qdivmod(a,t,d,m);
   s:=chr(m.lo+48)+s;
   a:=d;
  end;
  if s[0]=#0 then qstr:='0' else qstr:=s;
 end;

function qval(s:string;var a:qword):integer;
 var i:byte;
     b,c,t:qword;
 begin
  t.hi:=0;
  t.lo:=10;
  qval:=0;
  a.lo:=0;
  a.hi:=0;
  i:=1;
  while (i<=ord(s[0])) and (s[i] in [' ','+']) do inc(i);
  while i<=length(s) do
  begin
   if s[i] in ['0'..'9'] then
   begin
    qmul(a,t,b);
    a:=b;
    b.hi:=0;
    b.lo:=ord(s[i])-48;
    qadd(a,b,c);
    a:=c;
    inc(i);
   end else
   begin
    qval:=i;
    exit;
   end;
  end;
 end;

end.