UNIT SYSINFO;
INTERFACE
USES DOS;

const Seg0000:word=0;
      SegC000:word=$C000;
      SegD000:word=$D000;
      SegF000:word=$F000;
type
     DosName=array[1..11] of char;

     DosExt=array[1..3] of char;

     DosPrename=array[1..8] of char;

     DosStr=string[12];

type PtrRec=Record
      case byte of
       0:(o,s:word);
       1:(p:pointer);
       2:(l:Longint);
      end;

Var EnvSeg:word;
    commandline:string[128];

type pMCB=^tMCB;
     tMCB=record { 16 Byte= 1 Paragraph }
      typ:char;
      PSPseg:word;
      size:word;
       mcbseg:word;
       res:byte;
      name:DosPreName;
     end;

     pDriverHead=^tDriverHead;
     tDriverHead=record { 18 Byte }
      next:pDriverHead;
      attr:word;
      strat:word;
      Inter:word;
      name:DosPreName;
     end;

MCBProc = Procedure(MCB:pMCB);
DriverProc = Procedure(Driver:pDriverHead);

const MCBtypes:Set Of Char = (.'M','Z','B','D','F','L','S','X'.);

procedure ForEachMCB(What:MCBProc);
procedure ForEachDriver(What:DriverProc);

{$IFDEF MSDOS}
type
 MCBFunc = Function(MCB:pMCB):Boolean;
 DriverFunc = Function(Driver:pDriverHead):Boolean;

 function FirstMCB:pMCB;
 function NulDevice:pDriverHead;
 function FirstDPB:pointer;
 function DCBAddress:pointer;

 function DOS_FreeMemSize:longint;
 function DOS_Allocate(size:longint):pointer;
procedure DOS_Dealloc(Segm:word);
procedure DOS_SetBlock(Segm:word;size:longint);
    {  Doserror=            }
    { =8 not enough memory  }
    { =7 MCBs destroyed     }
    { =9 no memory allocated under this address }

{$ENDIF}

procedure GetThisProg(var path:pathstr);
 function ROMTEXT:string;
 function ROMDATE:string;
 function GetDTA:pointer;
procedure SetDTA(p:pointer);

{$IFDEF DPMI }
  PROCEDURE __0000H; FAR;
  PROCEDURE __C000H; FAR;
  PROCEDURE __D000H; FAR;
  PROCEDURE __F000H; FAR;
{$ENDIF}

IMPLEMENTATION

{$IFDEF DPMI }
USES _DPMI,WINAPI;

  PROCEDURE __0000H; EXTERNAL 'KERNEL' INDEX 183;
  PROCEDURE __C000H; EXTERNAL 'KERNEL' INDEX 195;
  PROCEDURE __D000H; EXTERNAL 'KERNEL' INDEX 179;
  PROCEDURE __F000H; EXTERNAL 'KERNEL' INDEX 194;
{$ENDIF}

{$IFDEF MSDOS}

procedure Dos_Call; near; assembler;
 asm
  push ds
  int  $21
  pop  ds
  pushf
  push ax
  jc   @@1
  xor  ax,ax
@@1:
  mov  doserror,ax
  pop  ax
  popf
 end;

{ INPUT : DX:BX = Size(longint)       }
{ PUTPUT: BX = Anzahl der Paragraphen }
procedure CalcSize; near; assembler;
 asm
  add bx,15
  adc dx,0
  mov cl,4
  shl dl,cl
  shr bx,cl
  or  bh,dl
 end;

function DOS_FreeMemSize:longint; assembler;
 asm
  mov   ah,$48
  mov   bx,-1
  push  ds
  int   21h
  pop   ds
  mov   ax,bx
  mov   dx,bx
  mov   cl,12
  shr   dx,cl
  mov   cl,4
  shl   ax,cl
 end;

function DOS_Allocate(size:longint):pointer; assembler;
 asm
  mov  bx,size.word[0]
  mov  dx,size.word[2]
  call CalcSize
  mov  ah,$48
  call dos_call
  jnc  @@1
  xor  ax,ax
@@1:
  mov  dx,ax
  xor  ax,ax
 end;

procedure DOS_SetBlock(Segm:word;size:longint); assembler;
 asm
  mov  bx,size.word[0]
  mov  dx,size.word[2]
  call calcsize
  mov  ah,$4A
  mov  es,segm
  call dos_call
 end;

procedure DOS_Dealloc(Segm:word); assembler;
 asm
  mov  es,segm
  mov  ah,$49
  call dos_call
 end;

procedure ForEachMCB(What:MCBProc);
 var p,p1:pMCB;
 begin
  p:=FirstMCB;
  if (p<>nil) then
  repeat
   p1:=p;
   if p^.typ in mcbtypes then
   begin
    What(p);
    if (p^.pspseg=8) and (chr(Mem[ptrrec(p).s+1:0]) in mcbtypes) then
       inc(ptrrec(p).s) else inc(ptrrec(p).s,p^.size+1);
   end else exit;
  until (p1^.typ='Z');
 end;

Function FirstMCBThat(Fits:MCBFunc):pMCB;
 var p,p1:pMCB;
 begin
  p:=FirstMCB;
  FirstMCBThat:=nil;
  if (p<>nil) then
  repeat
   p1:=p;
   if p^.typ in mcbtypes then
   begin
    if Fits(p) then
    begin
     FirstMCBThat:=p;
     exit;
    end;
    if (p^.pspseg=8) and (chr(Mem[ptrrec(p).s+1:0]) in mcbtypes) then
       inc(ptrrec(p).s)
       else inc(ptrrec(p).s,p^.size+1);
   end else break;
  until (p1^.typ='Z');
 end;

procedure ForEachDriver(What:DriverProc);
 var p:pDriverHead;
 begin
  p:=NulDevice;
  while (ptrrec(p).o<>$FFFF) and (p<>nil) do
  begin
   what(p);
   p:=p^.next;
  end;
 end;

Function FirstDriverThat(Fits:DriverFunc):pDriverHead;
 var p:pDriverHead;
 begin
  p:=NulDevice;
  FirstDriverThat:=nil;
  while (ptrrec(p).o<>$FFFF) and (p<>nil) do
  begin
   if Fits(p) then
   begin
    FirstDriverThat:=p;
    exit;
   end;
   p:=p^.next;
  end;
 end;

function DCBAddress:pointer; assembler;
 asm
  mov  ah,$52
  call dos_call
  jnc  @@1
  xor  ax,ax
  mov  dx,ax
  jmp  @@2
@@1:
  mov  dx,es
  mov  ax,bx
@@2:
 end;

function FirstMCB:pMCB; assembler;
 asm
    mov  ah,$52
    call dos_call
    jc   @@1
    mov  dx,es
    dec  dx
    mov  es,dx
    mov  ax,es:[bx+12]
    mov  dx,es:[bx+14]
    jmp  @@2
@@1:xor  dx,dx
    xor  ax,ax
@@2:
 end;

function NulDevice:pDriverHead; assembler;
 asm
  mov  ah,$52
  call dos_call
  jc   @@1
  mov  ax,es:[bx+$22]
  mov  dx,es:[bx+$24]
  jmp  @@2
  @@1:
  xor  ax,ax
  xor  dx,dx
  @@2:
 end;

function FirstDPB:pointer; assembler;
 asm
  mov  ah,$52
  call dos_call
  jc   @@1
  mov  ax,es:[bx]
  mov  dx,es:[bx+2]
  jmp  @@2
  @@1:
  xor  ax,ax
  xor  dx,dx
  @@2:
 end;

{$ENDIF}

{$IFDEF DPMI}

procedure ForEachDriver(What:DriverProc);
 var pDRV:pDriverHead;
     pm,pr:Pointer;
     regs:tCallStructure;
 begin
  preparetCallStruct(regs);
  with Regs do
  begin
   _eax:=$5200;
   callRealMIntr($21,Regs);
   pm:=AllocPtr(Ptr(_es,_ebx+$22));
  end;
  pr:=pointer(pm^);
  if (pm<>nil) and (pr<>nil) then
  Repeat
   setptr(pm,pr);
   pDRV:=pm;
   What(pDRV);
   if (PtrRec(pDRV^.next).o=$FFFF) or
      (pDRV^.next=nil) then break;
   pr:=pDRV^.next;
  until (pr=nil);
  FreePtr(pm);
 end;

procedure ForEachMCB(What:MCBProc);
 var MCB:Array[0..1] of tMCB;
     pm,pr:Pointer;
     regs:tCallStructure;
 begin
  preparetCallStruct(regs);
  with Regs do
  begin
   _eax:=$5200;
   callRealMIntr($21,Regs);
   pm:=AllocPtr(Ptr(_es-1,_ebx+12));
  end;
  pr:=pointer(pm^);
  if (pm<>nil) then
  Repeat
   SetPtr(pm,pr);
   move(pm^,MCB,sizeof(MCB));
   if mcb[0].typ in mcbtypes then
   begin
    What(@MCB[0]);
    if (mcb[0].pspseg=8) and (mcb[1].typ in MCBTypes)
    then inc(ptrrec(pr).s)
    else inc(ptrRec(pr).s,mcb[0].size+1);
   end else break;
  until mcb[0].typ='Z';
  FreePtr(pm);
 end;

{$ENDIF}

function GetDTA:pointer; assembler;
{ DOS - Funktion 2FH : Get Disk Transfer Area }
{ Rckgabe in ES:BX                           }
 asm
  mov  ah,$2F
  push ds
  int  $21
  pop  ds
  mov  dx,es
  mov  ax,bx
 end;

procedure SetDTA(p:pointer); assembler;
 asm
  mov  ah,$1A
  push ds
  lds  dx,p
  int  $21
  pop  ds
 end;


 procedure GetThisProg(var path:pathstr); assembler;
 { Der String mit dem Pfad und Namen des laufenden Programms    }
 { befindet sich im Environment-Bereich nach zwei aufeinander - }
 { folgenden Nullbytes.                                         }
  asm
   lea  di,envseg
   mov  ax,[di]
   mov  es,ax
   mov  cx,4096   { Maximale Gre des Environment-Bereichs }
   xor  di,di
   xor  ax,ax
   cld
@@1:
   repne  scasb
   inc    di
   cmp    word ptr es:[di-2],0
   loopne @@1
   add   di,2
   mov   si,di
   xor   al,al
   mov   cx,79
   repne scasb
   mov  cx,di
   sub  cx,si
   dec  cx
   mov  al,cl
   mov  dx,ds
   push es
   pop  ds
   les  di,path
   stosb
   rep  movsb
   mov  ds,dx
  end;

function ROMTEXT:string; assembler;
 asm
  les  di,@result
  mov  bx,1
  mov  ax,SegF000
  push ds
  mov  ds,ax
  mov  si,$8001
  cld
  mov  cx,50
  @@restart:
  lodsb
  inc  si
  cmp  al,32
  jl   @@1
  cmp  al,122
  jg   @@1
  mov  es:[di+bx],al
  inc  bx
  loop @@restart
  @@1:
  dec  bx
  mov  es:[di],bl
  pop  ds
 end;

function ROMDATE:string; assembler;
 asm
  push ds
  les  di,@result
  mov  cx,8
  mov  al,cl
  cld
  stosb
  mov  ax,SegF000
  mov  ds,ax
  mov  si,$FFF5
  rep  movsb
  pop  ds
 end;


BEGIN
 Commandline:=string(ptr(prefixseg,$80)^);
 EnvSeg:=MemW[Prefixseg:$2C];

 {$IFDEF DPMI }
  Seg0000:=OFS(__0000H);
  SegC000:=OFS(__C000H);
  SegD000:=OFS(__D000H);
  SegF000:=OFS(__F000H);
 {$ENDIF}

END.