UNIT TBITMAPS;
INTERFACE
uses gdrivers,gviews,objects,tvgraph;

type
  PBitmap = ^TBitmap;
  TBitmap = record
    bmType: Integer;
    bmWidth: Integer;
    bmHeight: Integer;
    bmWidthBytes: Integer;
    bmPlanes: Byte;
    bmBitsPixel: Byte;
    bmBits: Pointer;
  end;

type
  TRGBTriple = record
    rgbtBlue: Byte;
    rgbtGreen: Byte;
    rgbtRed: Byte;
  end;

type
  TRGBQuad = record
    rgbBlue: Byte;
    rgbGreen: Byte;
    rgbRed: Byte;
    rgbReserved: Byte;
  end;

type
  PBitmapCoreHeader = ^TBitmapCoreHeader;
  TBitmapCoreHeader = record
    bcSize: Longint;              { used to get to color table }
    bcWidth: Word;
    bcHeight: Word;
    bcPlanes: Word;
    bcBitCount: Word;
  end;

type
  PBitmapInfoHeader = ^TBitmapInfoHeader;
  TBitmapInfoHeader = record
    biSize: Longint;
    biWidth: Longint;
    biHeight: Longint;
    biPlanes: Word;
    biBitCount: Word;
    biCompression: Longint;
    biSizeImage: Longint;
    biXPelsPerMeter: Longint;
    biYPelsPerMeter: Longint;
    biClrUsed: Longint;
    biClrImportant: Longint;
  end;

{ Constants for the biCompression field }

const
  bi_RGB  = 0;
  bi_RLE8 = 1;
  bi_RLE4 = 2;

type
  PBitmapInfo = ^TBitmapInfo;
  TBitmapInfo = record
    bmiHeader: TBitmapInfoHeader;
    bmiColors: array[0..0] of TRGBQuad;
  end;

type
  PBitmapCoreInfo = ^TBitmapCoreInfo;
  TBitmapCoreInfo = record
    bmciHeader: TBitmapCoreHeader;
    bmciColors: array[0..0] of TRGBTriple;
  end;

type
  PBitmapFileHeader = ^TBitmapFileHeader;
  TBitmapFileHeader = record
    bfType: Word;
    bfSize: Longint;
    bfReserved1: Word;
    bfReserved2: Word;
    bfOffBits: Longint;
  end;

{ Transformationstabellen fr 16-Farben-Bitmaps:    }
{ Zur Umrechnung der Standard-Windows-Farben in die }
{ Standardbelegung der EGA/VGA-Farben unter DOS	    }
{ und umgekehrt.				    }
const CDOS2WIN:Array[0..15] of byte
      = (0,7,1,9,2,10,3,11,4,12,5,13,6,14,8,15);
      CWIN2DOS:Array[0..15] of byte
      = (0,2,4,6,8,10,12,1,14,3,5,7,9,11,13,15);

Type

pColorTransformer = ^tColorTransformer;
tColorTransformer = Array[0..255] of byte;

pRGBTable = ^tRGBTable;
tRGBTable = Array[0..255] of tRGBQuad;

pBitImage = ^tBitImage;
tBitImage = object(tGraphImage)
 Constructor FileLoad(var F:File);
 Procedure FileStore(Var F:File);
end;

pGraphScroller = ^tGraphScroller;
tGraphScroller = object(tScroller)
  Image:pGraphImage;
  constructor init(var Bounds:tRect;AHScrollBar,AVScrollBar:PScrollbar;AImage:PGraphImage);
  procedure   HandleEvent(var Event:tEvent);			virtual;
  procedure   PaintBits(x_abs,y_abs,x_rel,y_rel,count:word);    virtual;
  destructor  done; virtual;
 end;

function BuildBmpInfo(Var Size:Word;Width,Height,BitsPP:word):pBitmapInfo;
function BuildBmpFileHeader(Width,Height,BitsPP:word):pBitmapFileHeader;
function LoadBitMap(FName:FNameStr):pBitImage;
function MakeDIBWindow(FName:FNameStr):pWindow;
function NewDIBWindow(aWidth,aHeight,aBitsPP:word):pWindow;

{ Sortiert einen Zeilenpuffer, der in jedem Nibble ein 16-Farbpixel enthlt, }
{ um in eine Folge von 4 Zeilen mit 1 Bit/Pixel, die die Farbkomponenten     }
{ (Ebenen) reprsentieren.                                                   }
{ Die Anzahl der Pixel wird dabei immer auf Vielfache von 8 aufgerundet      }
procedure Bits2Line(source,dest:pScanLine;Pixels:word);

{ Sortiert einen Zeilenpuffer, in dem vier Farbebenen nacheinander dargestellt }
{ sind, um in eine Darstellung, bei der je ein Nibble einen 16-farbigen Pixel  }
{ darstellt.                                                                   }
{ Die Anzahl der Pixel wird dabei immer auf Vielfache von 8 aufgerundet      }
procedure Line2Bits(source,dest:pScanLine;Pixels:word);

{ Sortiert einen Zeilenpuffer, der in jedem Nibble ein 16-Farbpixel enthlt, }
{ um in eine Folge von 8 Zeilen mit 1 Bit/Pixel, die die Farbkomponenten     }
{ (Ebenen) reprsentieren.                                                   }
{ Die Anzahl der Pixel wird dabei immer auf Vielfache von 8 aufgerundet      }
procedure Bits2Line8(source,dest:pScanLine;Pixels:word);

{ Sortiert einen Zeilenpuffer, in dem acht Farbebenen nacheinander dargestellt }
{ sind, um in eine Darstellung, bei der je ein Byte einen 256-farbigen Pixel   }
{ darstellt.                                                                   }
{ Die Anzahl der Pixel wird dabei immer auf Vielfache von 8 aufgerundet        }
procedure Line2Bits8(source,dest:pScanLine;Pixels:word);

{ Ersetzt in einer Scanzeile mit 4 Bits/Pixel alle Nibble durch die neuen }
{ Farben. Die Farbtabelle besteht aus einem Array[0..15] of Byte.	  }
{ Sie darf nur Werte von 0..15 enthalten.				  }
{ Schwarz (Index 0) wird durch ColTable[0] ersetzt u.s.w.		  }
procedure TransFormCol16(Line:pScanLine;Pixels:word;ColTable:Pointer);

Function Make8BitColTable(var RGBQ):pColorTransformer;
procedure TransFormCol256(Line:pScanLine;Pixels:word;ColTable:Pointer);
procedure Move256To16(source,Dest:pScanLine;Pixels:word);

IMPLEMENTATION
uses graphapp,dos,memory,gmsgbox,gcommand;

const VGAColors: Array[0..15] of tRGBTriple =
       ((rgbtBLUE:$00;rgbtGREEN:$00;rgbtRED:$00), {Black      EGA  0}
	(rgbtBLUE:$2A;rgbtGREEN:$00;rgbtRED:$00), {Blue       EGA  1}
	(rgbtBLUE:$00;rgbtGREEN:$2A;rgbtRED:$00), {GREEN      EGA  2}
	(rgbtBLUE:$2A;rgbtGREEN:$2A;rgbtRED:$00), {Cyan       EGA  3}
	(rgbtBLUE:$00;rgbtGREEN:$00;rgbtRED:$2A), {RED        EGA  4}
	(rgbtBLUE:$2A;rgbtGREEN:$00;rgbtRED:$2A), {Magenta    EGA  5}
	(rgbtBLUE:$00;rgbtGREEN:$15;rgbtRED:$2A), {Brown      EGA 20}
	(rgbtBLUE:$2A;rgbtGREEN:$2A;rgbtRED:$2A), {Lt. Gray   EGA  7}
	(rgbtBLUE:$15;rgbtGREEN:$15;rgbtRED:$15), {Gray       EGA 56}
	(rgbtBLUE:$3F;rgbtGREEN:$15;rgbtRED:$15), {Lt Blue    EGA 57}
	(rgbtBLUE:$15;rgbtGREEN:$3F;rgbtRED:$15), {Lt GREEN   EGA 58}
	(rgbtBLUE:$3F;rgbtGREEN:$3F;rgbtRED:$15), {Lt Cyan    EGA 59}
	(rgbtBLUE:$15;rgbtGREEN:$15;rgbtRED:$3F), {Lt RED     EGA 60}
	(rgbtBLUE:$3F;rgbtGREEN:$15;rgbtRED:$3F), {Lt Magenta EGA 61}
	(rgbtBLUE:$15;rgbtGREEN:$3F;rgbtRED:$3F), {Yellow     EGA 62}
	(rgbtBLUE:$3F;rgbtGREEN:$3F;rgbtRED:$3F));{White      EGA 63}

Function RGBDistance(A,B:tRGBTriple):word; assembler;
 asm
    push ds
    lds  si,A
    les  di,B
    xor  bx,bx
    xor  ah,ah
    mov  al,[si].tRGBTriple.rgbtRed
    sub  al,es:[di].tRGBTriple.rgbtRed
    jnb  @@1
    neg  al
@@1:mul  ax
    add  bx,ax
    xor  ah,ah
    mov  al,[si].tRGBTriple.rgbtBlue
    sub  al,es:[di].tRGBTriple.rgbtBlue
    jnb  @@2
    neg  al
@@2:mul  ax
    add  bx,ax
    xor  ah,ah
    mov  al,[si].tRGBTriple.rgbtGreen
    sub  al,es:[di].tRGBTriple.rgbtGreen
    jnb  @@3
    neg  al
@@3:mul  ax
    add  ax,bx
    pop  ds
 end;

Function Make8BitColTable(var RGBQ):pColorTransformer;
 var p:pColorTransformer;
     RGBQuads:tRGBTable absolute RGBQ;
     rgb:tRGBTriple;
     i,j,k,d,dd:word;
 begin
  new(p);
  for i:=0 to 255 do with RGBQuads[i] do
  begin
   rgb.rgbtRed:=rgbRed shr 2;
   rgb.rgbtBlue:=rgbBlue shr 2;
   rgb.rgbtGreen:=rgbGreen shr 2;
   d:=3 * 63 * 63;
   k:=0;
   for j:=0 to 15 do
   begin
    dd:=rgbdistance(rgb,vgacolors[j]);
    if dd<d then
    begin
     d:=dd;
     k:=j;
    end;
   end;
   p^[i]:=k;
  end;
  Make8BitColTable:=p;
 end;

 Constructor tBitImage.FileLoad(var F:File);
  var BitPtr,P:pScanLine;
      BmpInfo:pBitmapInfo;
      HeadSize,biType,i,aWidth,aBitsPP,aHeight,LineSize:word;
      LongSize:Longint;
      Colors:pColorTransFormer;
  begin
   Seek(F,0);
   BlockRead(F,biType,2);
   { 19778 = 'BM', die Dateimarke von Windows-Bitmap-Dateien }
   if biType<>19778 then
   begin
    MessageBox('Keine gltige Bitmapdatei !',nil,mfError+mfOKButton);
    fail;
   end;
   Seek(F,28); { DateiOffset vom tBitMapInfoHeader.BitCount }
   BlockRead(F,aBitsPP,sizeOf(aBitsPP));
   if aBitsPP>8 then
   begin
    MessageBox('Bitmap enthlt zu viele Farbebenen !',nil,mfError+mfOKButton);
    fail;
   end;
   HeadSize:=sizeof(tBitmapInfoHeader) + (1 shl aBitsPP) * SizeOf(tRGBQuad);
   GetMem(BmpInfo,HeadSize);
   Seek(F,SizeOf(tBitMapFileHeader));
   BlockRead(F,BmpInfo^,HeadSize);
   aWidth:=BmpInfo^.bmiHeader.biWidth;
   aHeight:=BmpInfo^.bmiHeader.biHeight;
   tCollection.init(aHeight,10);
   BitsPP:=aBitsPP;
   Width:=aWidth;
   BC:=Black;
   FC:=lightgray;
   if BitsPP=8 then Colors:=Make8BitColTable(BmpInfo^.bmiColors)
      else Colors:=nil;
   FreeMem(BmpInfo,HeadSize);
   LineSize:=ScanLineSize(width,bitsPP);
   LongSize:=(LineSize + 4) * (aHeight+charheight);
   if MemAvail< LongSize then
   begin
    MessageBox('Nicht genug Speicherplatz'+#13+'zum Laden der Datei !',nil,mfError+mfOKButton);
    fail;
   end;
   if BitsPP>1 then P:=NewScanLine(width,bitspp) else p:=nil;
   for i:=1 to aHeight do
   begin
     Case BitsPP of
     1: begin
	 BitPtr:=NewScanLine(width,bitspp);
	 BlockRead(F,BitPtr^,LineSize);
	end;
     4: begin
	 BitPtr:=NewScanLine(width,bitspp);
	 BlockRead(F,P^,LineSize);
	 TransFormCol16(P,Width,@CWin2Dos);
	 Bits2Line(P,BitPtr,Width);
	end;
     8: begin
	 BitPtr:=NewScanLine(width,4);
	 BlockRead(F,P^,LineSize);
	 TransFormCol256(P,Width,Colors);
	 Move256To16(P,BitPtr,Width);
	 Bits2Line(BitPtr,P,Width);
	 Move(P^,BitPtr^,ScanLineSize(width,4));
	end;
     end;
     AtInsert(0,BitPtr);
   end;
   DisposeLine(P,width,bitspp);
   if BitsPP=8 then
   begin
    dispose(colors);
    BitsPP:=4;
   end;
   if (BitsPP>1) and (GraphMaxPlanes=1) then Switch2Mono;
   if aHeight mod charheight<>0 then
   begin
    for i:=1 to (charheight-aHeight mod charheight) do
		 insert(newscanline(width,bitsPP));
   end;
  end;

 procedure tBitImage.FileStore(Var F:File);
  var pF:pBitMapFileHeader;
      pI:pBitMapInfo;
      i,Size:word;
      p1,p2:pScanLine;
  begin
   { Herstellen der entsprechenden Dateikpfe: }
   pF:=BuildBmpFileHeader(Width,Count,BitsPP);
   pI:=BuildBmpInfo(size,width,Count,BitsPP);
   Seek(F,0);
   BlockWrite(F,pF^,sizeof(tBitMapFileHeader));
   BlockWrite(F,pI^,Size);
   freemem(pI,size);
   Dispose(pF);
   Size:=ScanLineSize(width,bitsPP);
   { Die Zeilen werden von unten nach oben in der Bitmap-Datei gespeichert: }
   Case BitsPP of
    1: For i:=Count-1 downto 0 do
       begin
	p1:=at(i);
	BlockWrite(F,p1^,Size);
       end;
    4: begin
	P1:=NewScanLine(width,bitspp);
	For i:=Count-1 downto 0 do
	begin
	 p2:=at(i);
	 Line2Bits(p2,p1,width);
	 TransFormCol16(P1,Width,@CDos2Win);
	 BlockWrite(F,p1^,Size);
	end;
	DisposeLine(p1,width,bitspp);
       end;
   end;
  end;

function BuildBmpInfo(Var Size:Word;Width,Height,BitsPP:word):pBitmapInfo;
 var P:pBitMapInfo;
 begin
  Size:=sizeof(tBitmapInfoHeader) + (1 shl BitsPP) * SizeOf(tRGBQuad);
  getmem(p,size);
  Fillchar(p^,size,0);
  with p^.bmiHeader do
  begin
   biSize:=40;
   biWidth:=Width;
   biHeight:=Height;
   biPlanes:=1;
   biBitCount:=BitsPP;
  end;
  BuildBmpInfo:=P;
 end;

 constructor tGraphScroller.init(var Bounds:tRect;AHScrollBar,AVScrollBar:PScrollbar;AImage:PGraphImage);
  begin
   inherited init(Bounds,ahscrollbar,avscrollbar);
   setstate(sfgraphical,true);
   growmode:=gfgrowHiX or gfGrowHiY;
   Image:=aImage;
   setlimit(image^.width shr 3,image^.count div charheight);
  end;

 procedure tGraphScroller.PaintBits(x_abs,y_abs,x_rel,y_rel,count:word);
  var dx:integer;
  begin
   if y_rel+delta.y>=image^.count div charheight then
   FillRect(x_abs,y_abs,Count,1,image^.FC) else
   begin
    if x_rel+delta.x+count>image^.width shr 3 then
    begin
     dx:=image^.width shr 3-delta.x-x_rel;
     if dx<0 then dx:=0;
     FillRect(x_abs+dx,y_abs,count-dx,1,image^.fc);
    end;
    image^.putimage(x_rel+delta.x,y_rel+delta.y,count,1,x_abs,y_abs);
   end;
  end;

 procedure tGraphScroller.HandleEvent(var Event:tEvent);
  begin
   inherited Handleevent(event);
   if (event.what=evCommand) and (event.command=cmSwitch2Mono) then
   begin
    Image^.Switch2Mono;
    Owner^.ReDraw;
   end;
  end;

 destructor tGraphScroller.done;
  begin
   inherited done;
   dispose(image,done);
  end;

function BuildBmpFileHeader(Width,Height,BitsPP:word):pBitmapFileHeader;
 var p:pBitmapFileHeader;
     size:longint;
     Offs:word;
 begin
  New(p);
  fillchar(p^,sizeof(tBitMapFileHeader),0);
  Size:=ScanLineSize(width,bitsPP) * Height;
  offs:=sizeof(tBitMapFileHeader) + sizeof(tBitMapInfoHeader) +
        (1 shl BitsPP) * sizeof(tRGBQuad);
  p^.bfType:=19778;
  p^.bfSize:=Size+offs;
  p^.bfOffBits:=offs;
  BuildBmpFileHeader:=P;
 end;

function LoadBitMap(FName:FNameStr):pBitImage;
 var P:pBitImage;
     F:File;
     S:SearchRec;
     PS:pString;
 begin
  P:=NIL;
  PS:=@FName;
  FindFirst(Fname,$3F,S);
  if doserror=0 then
  begin
   {$I-}
   assign(F,Fname);
   reset(F,1);
   if ioresult=0 then
   begin
    p:=New(pBitImage,FileLoad(F));
    close(F);
   end else Messagebox('Fehler beim ffnen von %s',@PS,mfError+mfOKButton);
   {$I+}
  end;
  LoadBitMap:=P;
 end;

Function DIBWindow(FName:FNameStr;PI:PBITIMAGE):PWindow;
 var P:Pwindow;
     PS:PGraphScroller;
     PVS,PHS:pScrollbar;
     R:tRect;
 begin
  P:=NIL;
  if PI<>nil then
  begin
   R.Assign(1,1,1+PI^.width shr 3,PI^.count div charheight+1);
   R.Grow(1,1);
   if R.B.X-R.A.X<length(FName)+10 then R.B.X:=R.A.X+10+length(Fname);
   if desktop^.size.X<R.B.X then R.B.X:=desktop^.size.X;
   if desktop^.size.Y<R.B.Y then R.B.Y:=desktop^.size.Y;
   P:=New(PWindow,Init(R,FName,0));
   if p<>nil then
   begin
    PHS:=P^.StandardScrollBar(sbHorizontal);
    PVS:=P^.StandardScrollBar(sbVertical);
    P^.options:=p^.options and not ofBuffered;
    if p^.buffer<>nil then DisposeCache(p^.buffer);
    p^.getextent(R);
    R.grow(-1,-1);
    PS:=New(pGraphScroller,INIT(R,PHS,PVS,PI));
    P^.Insert(PS);
   end;
  end;
  DIBWindow:=P;
 end;


function MakeDIBWindow(FName:FNameStr):pWindow;
 var P:Pwindow;
     PI:PBitImage;
 begin
  P:=NIL;
  PI:=LoadBitMap(FName);
  if PI<>nil then P:=DIBWindow(FName,PI);
  MakeDIBWindow:=P;
 end;

function NewDIBWindow(aWidth,aHeight,aBitsPP:word):pWindow;
 var P:Pwindow;
     PI:PBitImage;
 begin
  P:=NIL;
  PI:=New(pBitImage,Init(aWidth,aHeight,aBitsPP));
  if PI<>nil then P:=DIBWindow('NONAME.BMP',PI) else
     MessageBox('Nicht gengend Speicher fr die Graphik frei',nil,mfError+mfOKButton);
  NewDIBWindow:=P;
 end;

procedure TransFormCol16(Line:pScanLine;Pixels:word;ColTable:Pointer); assembler;
 asm
    cld
    push ds
    mov  cx,pixels
    add  cx,7
    shr  cx,1
    and  cx,$FFFC
    les  di,line
    mov  si,di
    lds  bx,ColTable
@@1:seges lodsb
    mov  ah,al
    and  al,$0F
    shr  ah,4
    xlat
    xchg al,ah
    xlat
    shl  al,4
    or   al,ah
    stosb
    loop @@1
    pop  ds
 end;



procedure TransFormCol256(Line:pScanLine;Pixels:word;ColTable:Pointer); assembler;
 asm
    cld
    push ds
    les  di,line
    mov  si,di
    mov  cx,Pixels
    lds  bx,ColTable
@@1:seges lodsb
    xlat
    stosb
    loop @@1
    pop  ds
 end;

procedure Move256To16(source,Dest:pScanLine;Pixels:word); assembler;
 asm
    cld
    push ds
    mov  cx,Pixels
    shr  cx,1
    lds  si,source
    les  di,dest
@@1:lodsw
    shl  al,4
    and  ah,$0F
    or   al,ah
    stosb
    loop @@1
    pop  ds
 end;

procedure Bits2Line(source,dest:pScanLine;Pixels:word); assembler;
 asm
  push ds
  cld
  lds  si,source
  les  di,dest
  mov  dx,Pixels
  add  dx,7
  shr  dx,3       { DX = Anzahl der Bytes bei 1 bpp }
  mov  cl,1
@@3:push dx
    push si       { SI sichern, da die Nibbles 4-mal gelesen werden sollen }
@@2:
    mov  ch,4     { 4 Bytes werden untersucht  }
    xor ah,ah
@@1: lodsb
     shl al,cl    { Bit des Hi-Nibble => Carry }
     rcl ah,1     { Carry => AH                }
     shl al,4     { Bit im Lo-Nibble testen    }
     rcl ah,1     { Bit des Lo-Nibbles => AH   }
     dec ch
     jnz @@1
    mov al,ah
    stosb         { Ergebnis speichern }
    dec dx        { Nchste 8 Nibbles  }
    jnz @@2
   pop si
   pop dx
   inc cl
   cmp cl,4       { Alle Farbebenen bearbeitet ? }
   jbe @@3
  pop  ds
 end;


procedure Line2Bits(source,dest:pScanLine;Pixels:word); assembler;
 asm
   push ds
   cld
   les di,dest
    mov cx,pixels
    add cx,7
    shr cx,3
    mov dx,cx      { DX = Anzahl der Byte / Ebene }
    shl cx,1
    xor ax,ax
    push di
    rep stosw      { Ergebnispuffer lschen       }
    pop di
   lds  si,source
   mov  bx,$8008   { OR-Masken fr die Farbkomponenten; BH = Hi-Nibble }
   mov  cx,4
@@5:push cx
    push dx
    push di
@@4: lodsb
     mov  cx,4
@@3:  shl  al,1
      jnc  @@1
      or   es:[di],bh   { Farbbit im Hi-Nibble setzen }
@@1:  shl  al,1
      jnc  @@2
      or   es:[di],bl   { Farbbit im Lo-Nibble setzen }
@@2:  inc  di           { Nchstes Byte im Ergebnis   }
      loop @@3
     dec  dx            { 8 Bits bearbeitet: Nchstes Byte }
     jnz  @@4
    pop di
    pop dx
    pop cx
    shr bx,1            { OR-Maske fr nchste Farbkomponente }
    loop @@5
  pop  ds
 end;

procedure Bits2Line8(source,dest:pScanLine;Pixels:word); assembler;
 asm
  push ds
  cld
  lds  si,source
  les  di,dest
  mov  dx,Pixels
  add  dx,7
  shr  dx,3       { DX = Anzahl der Bytes bei 1 bpp }
  mov  cl,1
@@3:push dx
    push si       { SI sichern, da die Nibbles 4-mal gelesen werden sollen }
@@2:
    mov  ch,8     { 8 Bytes werden untersucht  }
    xor ah,ah
@@1: lodsb
     shl al,cl    { Bit des Hi-Nibble => Carry }
     rcl ah,1     { Carry => AH                }
     dec ch
     jnz @@1
    mov al,ah
    stosb         { Ergebnis speichern }
    dec dx        { Nchste 8 Byte     }
    jnz @@2
   pop si
   pop dx
   inc cl
   cmp cl,8       { Alle Farbebenen bearbeitet ? }
   jbe @@3
  pop  ds
 end;

procedure Line2Bits8(source,dest:pScanLine;Pixels:word); assembler;
 asm
   push ds
   cld
   les di,dest
    mov cx,pixels
    add cx,7
    shr cx,3
    mov dx,cx      { DX = Anzahl der Byte / Ebene }
    shl cx,2
    xor ax,ax
    push di
    rep stosw      { Ergebnispuffer lschen       }
    pop di
   lds  si,source
   mov  bl,$80     { OR-Masken fr die Farbkomponenten }
   mov  cx,8
@@5:push cx
    push dx
    push di
@@4: lodsb
     mov  cx,8
@@3:  shl  al,1
      jnc  @@1
      or   es:[di],bl   { Farbbit im Hi-Nibble setzen }
@@1:  inc  di           { Nchstes Byte im Ergebnis   }
      loop @@3
     dec  dx            { 8 Bits bearbeitet: Nchstes Byte }
     jnz  @@4
    pop di
    pop dx
    pop cx
    shr bl,1            { OR-Maske fr nchste Farbkomponente }
    loop @@5
  pop  ds
 end;



END.