{**************************************************************************}
{                     Turbo-Graphics-Vision-Demoprogramm                   }
{                                                                          }
{             Copyright (C) Christian Baumgarten, Hamburg 1993             }
{                                                                          }
{**************************************************************************}

program TGVDEMO;

uses objects,dos,gmenus,graphapp,histlist,
     gstddlgs,gdrivers,gdialogs,gviews,gMsgBox,gCommand,
     tvgraph,tbitmaps;

const hcnocontext = 0;
      cmWait  = 1100;
      cmBlack = 1101;
      cmArrow = 1102;

type pStdApplication=^tStdApplication;
     tStdApplication=object(tApplication)
      procedure initmenubar;    virtual;
      procedure initstatusline; virtual;
      procedure HandleEvent(var Event:tEvent); virtual;
      procedure OpenFile; virtual;
     end;

procedure tSTDApplication.OpenFile;
var
  D: PFileDialog;
  FileName: PathStr;
  P:pwindow;
begin
  D := PFileDialog(ValidView(New(PFileDialog, Init('*.bmp', 'Open a File',
    '~N~ame', fdOpenButton, 100))));
  if D <> nil then
  begin
    if Desktop^.ExecView(D) <> cmCancel then
    begin
      D^.GetFileName(FileName);
      {$V-}
      P:=MakeDIBWindow(FileName);
      {$V+}
      desktop^.insert(validview(P));
    end;
    Dispose(D, Done);
  end;
end;

procedure tSTDApplication.HandleEvent(var Event:tEvent);
 var l:longint;
     P:pWindow;
 begin
  tApplication.Handleevent(event);
  if event.what=evcommand then
  case event.command of
   cmOpen    : OpenFile;
   cmMemAvail: begin
		l:=memAvail;
		MessageBox('Freier Arbeitsspeicher: %d',@l,mfInformation+mfOkButton);
	       end;
   cmWait:  if graphplanes>0 then setMauscursor(idc_wait);
   cmArrow: if graphplanes>0 then setMauscursor(idc_Arrow);
   cmBlack: if graphplanes>0 then setMauscursor(idc_Black);
   else exit;
  end;
  clearevent(event);
 end;

procedure tSTDApplication.InitMenuBar;
var
  R: TRect;
begin
  GetExtent(R);
  R.B.Y := R.A.Y + 1;
  MenuBar := New(PMenuBar, Init(R, NewMenu(
    NewSubMenu('~D~atei',hcNocontext, NewMenu(
      StdFileMenuItems(nil)),
    NewSubMenu('~B~ipmap',hcNoContext,NewMenu(
       NewItem('~M~onochrom', '', kbNoKey, cmSwitch2Mono, hcNoContext,
       NewItem('~W~arten', '', kbNoKey, cmWait, hcNoContext,
       NewItem('~S~chwarz', '', kbNoKey, cmBlack, hcNoContext,
       NewItem('~P~feil', '', kbNoKey, cmArrow, hcNoContext,
       nil))))),
       nil)))));
end;

procedure tSTDApplication.InitStatusLine;
var
  R: TRect;
begin
  GetExtent(R);
  R.A.Y := R.B.Y - 1;
  StatusLine:=
  New(pStatusLine, Init(R,
    NewStatusDef(0, $FFFF,
      StdStatusKeys(nil),
    nil)));
end;

var A:tStdApplication;
begin
 A.init;
 A.run;
 A.done;
end.