{***************************************************************************}
{                                                                           }
{          Copyright (C) Christian Baumgarten, Hamburg 1993.                }
{                                                                           }
{          UNIT fr die Nutzung des Timers als Zeitmesser mit einer         }
{                    Genauigkeit von 1..2 sec.                             }
{                                                                           }
{***************************************************************************}

unit timer;
{$N+,E+}
interface
var timebias:extended;

 function GetSeconds:extended;
 procedure Synchronize;

implementation

uses dos;

 function biostime:longint; assembler;
  asm
   mov  es,seg0040
   mov  bx,$6C
   mov  ax,es:[bx]
   mov  dx,es:[bx+2]
  end;

 procedure StartTimer; assembler;
  asm
   in  al,61h
   or  al,1
   out 61h,al
  end;

  procedure StopTimer; assembler;
   asm
    in  al,61h
    and al,$FE
    out 61h,al
   end;

 procedure SetTimer(modus:byte;count:word); assembler;
   { Die Zhl-Frequenz der Timer betrgt 1193182 Hz,d.h. da
     das Zeitintervall des Timer-Taktes genau 65536/1193182 sec
     = 18.20651245 ms betrgt; (Adresse $40:$6C) }
   asm
    mov ah,$B0
    mov al,modus
    shl al,1
    and al,$F
    or  al,ah
    out 43h,al
    mov ax,count
    out 42h,al
    mov al,ah
    out 42h,al
   end;


 function TimerCount:word; assembler;
   asm
    mov  al,$80
    out  43h,al
    in   al,42h
    mov  ah,al
    in   al,42h
    xchg al,ah
   end;

 function GetSeconds:extended;
  var r:extended;
      t:word;
  begin
   r:=BiosTime+1;
   t:=timercount;
   r:=(r * 65536-t)/1193182;
   GetSeconds:=r;
  end;

procedure TimerInt; Interrupt;
 begin
  SetTimer(2,$FFFF);
  StartTimer;
 end;

procedure Synchronize;
 var p:pointer;
     l:longint;
     t:extended;
 begin
  l:=BiosTime;
  getintvec($1C,p);
  setintvec($1C,@TimerInt);
   repeat until BiosTime<>l;
  setintvec($1C,p);
  { Die Doppelschleife ist ntig, da der Fliekommaemulator
    von Turbo Pascal beim zweiten Durchlauf anders arbeitet
    als beim ersten (Falls ein 80x87 installiert ist) !
    Will man den Zeitbedarf einer Fliekommaoperationen
    abschtzen, so mu man dafr sorgen, da das entsprechende
    Codefragment mindestens zweimal durchlaufen wird ! }
  for l:=0 to 1 do
  begin
   t:=getseconds;
   timebias:=getseconds;
   timebias:=timebias-t;
  end;
 end;

end.