{*************************************************************************}
{                        Turbo Vision Graphik Unit                        }
{              Copyright (c) Christian Baumgarten, Hamburg 1993           }
{*************************************************************************}
UNIT TVGRAPH;
{$F+}
INTERFACE
Uses Objects;

const  { Konstanten fr verschiedene Graphikfonts: }

 Font8x8  = 8;
 Font8x12 = 12;
 Font8x14 = 14;
 Font8x16 = 16;

       { Konstanten fr EGA/VGA-GetFontPtr-Routinen }

 GetRom8x14   = 2;
 GetRom8x8    = 3;
 GetRom8x16   = 6;

       { Graphikkarten-Konstanten: }

  CGA           = 1;
  MCGA          = 2;
  EGA           = 3;
  EGA64         = 4;
  EGAMono       = 5;
  IBM8514       = 6;
  HercMono      = 7;
  ATT400        = 8;
  VGA           = 9;
  PC3270        = 10;

       { Farbkonstanten fr Text & EGA/VGA-Graphik: }

  Black        = 0;
  Blue         = 1;
  Green        = 2;
  Cyan         = 3;
  Red          = 4;
  Magenta      = 5;
  Brown        = 6;
  LightGray    = 7;
  Gray         = 8;
  LightBlue    = 9;
  LightGreen   = 10;
  LightCyan    = 11;
  LightMagenta = 12;
  LightRed     = 13;
  Yellow       = 14;
  White        = 15;

  { Portadressen der EGA/VGA-Karte: }

const _GCtrl_ = $03CE;
      _ACtrl_ = $03C0;
      _Sequ_  = $03C4;

  { Registerindices der EGA-VGA-Karte: }

      sq_mapmask   = 02;
      sq_memmode   = 04;

      gc_setreset  = 00;
      gc_sr_enable = 01;
      gc_colorcmp  = 02;
      gc_DataRot   = 03;
      gc_ReadSel   = 04;
      gc_Mode      = 05;
      gc_Miscell   = 06;
      gc_ColDont   = 07;
      gc_bitmask   = 08;

 { Konstanten fr verschiedene Mauscursor: }

      idc_arrow	   = 01;
      idc_black	   = 02;
      idc_wait	   = 03;

Type  tCursorMask = Array[0..63] of byte;

const CursorMasks : Array[1..3] of tCursorMask =
       (($ff,$3f,$ff,$1f,$ff,$0F,$ff,$07,
	 $ff,$03,$ff,$01,$ff,$00,$7f,$00,
	 $3f,$00,$1f,$00,$ff,$01,$ff,$10,
	 $ff,$30,$7f,$F8,$7f,$F8,$7f,$FC,
	 $00,$00,$00,$40,$00,$60,$00,$70,
	 $00,$78,$00,$7c,$00,$7E,$00,$7F,
	 $80,$7F,$00,$7C,$00,$6C,$00,$56,
	 $00,$06,$00,$03,$00,$03,$00,$00),
	($FF,$3f,$FF,$1f,$FF,$0f,$FF,$07,
	 $FF,$03,$FF,$01,$FF,$00,$7F,$00,
	 $3F,$00,$1F,$00,$0F,$00,$0F,$00,
	 $FF,$07,$FF,$0f,$FF,$1f,$FF,$3f,
	 $00,$C0,$00,$A0,$00,$90,$00,$88,
	 $00,$84,$00,$82,$00,$81,$80,$80,
	 $40,$80,$20,$80,$10,$80,$F0,$87,
	 $00,$88,$00,$90,$00,$A0,$00,$C0),
	($00,$00,$01,$80,$01,$80,$03,$C0,
	 $07,$E0,$0F,$F0,$1F,$F8,$3F,$FC,
	 $3F,$FC,$1F,$F8,$0F,$F0,$07,$E0,
	 $03,$C0,$01,$80,$01,$80,$00,$00,
	 $00,$00,$FC,$3F,$F8,$1F,$F0,$0B,
	 $60,$05,$80,$02,$00,$01,$80,$00,
	 $00,$01,$80,$00,$40,$03,$E0,$06,
	 $70,$0D,$B8,$1A,$5C,$35,$00,$00));


Var  { Zustzliche Variablen fr den Graphikmodus: }

  MouseGraphWhere:TPoint;
  LastGraphWhere:TPoint;
  DownGraphWhere:TPoint;

  GraphDriver,GraphMode:integer;
  GraphMaxX  : word;
  GraphMaxY  : Word;

  SaveScreenBuffer:Pointer;
  SaveScreenWidth:Byte;
  SaveScreenHeight:Byte;

  CursorVis:Boolean;
  CursorOn:boolean;
  CursorPos:word;
  CursorForm:word;
  CursorFlag:byte;

  CharHeight : word;

Const
  GraphPlanes: Word = 0;
  GraphMaxPlanes: Word = 0;
  TheFont   : Pointer = nil;
  FontSize  : word = 0;
  GraphInit : Pointer = nil;
  GraphExit : Pointer = nil;
  SegC000 : word = $C000;

  { Die Unit TVGraph initialisieren:    }
  Procedure InitTVGraphics;
  { Die Unit TVGraph deinitialisieren:  }
  Procedure DoneTVGraphics;
  { Graphikmodus einschalten: 	        }
  procedure EnterGraph;
  { Graphikmodus ausschalten:	        }
  procedure LeaveGraph;
  { Textcursor invertieren:	        }
  { Sollte nie direkt aufgerufen werden }
  procedure InvCursor;
  { Setzen eines bestimmten Mauscursors:}
  Procedure SetMausCursor(Id:word);
  { Graphik-Bildschirm lschen:		}
  procedure ClearDevice;
  { Aktuelle Graphikkarte ermitteln:	}
  Function  DetectGraphCard:Integer;
  { Zeiger auf das Bildschirmbyte mit 	}
  { den Koordinaten (x,y) ermitteln:	}
  { Dabei ist x Textkoordinate und y 	}
  { Graphikkoordinate.			}
  Function  GetScreenPtr(x,y:word):pointer;

  { Diese Routinen sind die Ausgaberoutinen fr den Graphikmodus, }
  { und werden von 'writeview' aufgerufen:                        }
  { Die Koordinaten sind Textkoordinaten:                         }
  Procedure PaintChar(X,Y,Count,CharColor:Word);
  Procedure PaintStr(X,Y:word;Color:Byte;Var S:String);
  Procedure PaintBuf(X,Y,W:Word;Var Buf);

  { Rechteckigen Bildschirmbereich im Graphikmodus	}
  { mit der Farbe Color fllen. (Textkoordinaten)	}
  Procedure FillRect(X,Y,W,H:Word;Color:Byte);

  { Zeilentyp fr eine BitMap: }
type
  pScanLine = ^tScanLine;
  tScanLine = Array[0..0] of byte;

  { tGraphimage-Typ, der Vorlufer von tBitImage:	}
type
 pGraphImage = ^tGraphImage;
 tGraphImage = object(tCollection)
  Width:word;
  BitsPP:Word;
  FC,BC:Byte;
  Constructor init(aWidth,aHeight,aBitsPP:word);
  Procedure FreeItem(Item:Pointer); virtual;
{ BitMapAusschnitt (ix,iy,w,h) an die Bildschirmposition (sx,sy) kopieren.}
{ Die Koordinaten sind TextKoordinaten !                                    }
  Procedure PutImage(ix,iy,w,h,sx,sy:integer);
  Procedure PutPixel(x,y:integer;color:byte);
  Procedure Line(x1,y1,x2,y2:integer;color:byte);
  Function  GetPixel(x,y:integer):byte;
  Procedure Switch2Mono;				virtual;
 end;

{ Gre einer einzelen Graphikzeile in Byte berechnen:	      }
 Function ScanLineSize(width,bitsPP:word):word;
{ Einzelne Scanzeile fr tGraphimage auf dem Heap reservieren }
 Function NewScanLine(Width,BitsPP:word):pScanLine;
{ Einzelne Scanzeile fr tGraphimage auf dem Heap freigeben   }
 Procedure DisposeLine(TheLine:pScanLine;Width,BitsPP:word);

{$IFDEF DPMI }
  { Dieser Selektor wird unter DPMI fr die EGA/VGA-Romzeichenstze bentigt }
  PROCEDURE __C000H; FAR;
{$ENDIF}

IMPLEMENTATION

Uses gdrivers,dos;

const
 { Interne Variablen fr den Graphikmodus: }
 GraphScreen:Pointer = Nil;

 { Offset zweier Near-Routinen, die fr jede Karte anders lauten: }
 ScreenDelta:word = 0;
 ScreenOffs :word = 0;

 { Verzgerung des Cursor-Blinkens: }
 Int1CDelay = 3;

 { Timer-Interrupt-Nr.              }
 TimerIntNo = $1C;

var  SaveInt1C:pointer;
     int1CCount:word;
     OldCursorLines:word;
     OldVideoMode:Byte;
     SysFont : Byte;

Procedure SetMausCursor(Id:word);
 var p:pointer;
 begin
   p:=@CursorMasks[id];
   asm
    mov ax,9
    xor bx,bx
    xor cx,cx
    les dx,p
    int 33h
   end;
 end;

Function SetVideoMode(Mode:byte):Boolean; near; assembler;
 asm
  xor  ah,ah   { Set Video Mode }
  mov  al,mode
  push ax
  int  $10
  mov  ah,$0F  { Get Video Mode: berprfen, ob die Initialisierung OK ist. }
  int  10h
  pop  bx
  cmp  al,bl
  jne  @@No    { Hat nicht funktioniert }
  mov  al,1    { Hat funktioniert       }
  jmp  @@YES
@@No:
  xor  al,al
@@YES:
 end;

function GetVideomode:byte; assembler;
 asm
  mov ah,$0F
  int 10h
 end;

{ Laden eines Fonts aus dem Systemverzeichnis in den Arbeitsspeicher }
Function LoadFont(Font:Byte):Pointer;
 var Dir:DirStr;
     Name:NameStr;
     Ext:ExtStr;
     Path:PathStr;
     S:SearchRec;
     F:File;
     P:Pointer;
 begin
  LoadFont:=Nil;
  Path:=ParamStr(0);
  FSplit(Path,Dir,Name,Ext);
  Str(Font,Name);
  Name:='FONT8X'+Name;
  Ext:='.FNT';
  Path:=Dir+Name+Ext;
  FindFirst(Path,$3F,S);
  if Doserror = 0 then
  begin
   {$I-}
   assign(F,path);
   if ioresult<>0 then exit;
   reset(F,256);
   if ioresult<>0 then exit;
   if GraphMaxPlanes=1 then Font:=Font shl 1;
   FontSize:=Font;
   FontSize:=FontSize shl 8;
   GetMem(P,FontSize);
   BlockRead(F,P^,Font);
   close(F);
   {$I+}
   LoadFont:=P;
  end;
 end;

{ Erfragen der Adresse der EGA/VGA-Rom-Fonts: }
Function GetROMPtr(Font:Byte):Pointer; assembler;
  asm
   push bp
   mov  ax,1130h
   mov  bh,font
   int  10h
   mov  dx,es
   mov  ax,bp
   pop  bp
   {$IFDEF DPMI}
   mov  dx,segC000
   {$ENDIF}
   xor  bx,bx
   mov  Fontsize,bx
  end;

{ Hilfsroutine fr XLATFont: }
procedure _xlat_; near; assembler;
 asm
    mov  dx,256
@@2:push di
    push cx
@@1: movsb
     add  di,255
     loop @@1
    pop  cx
    pop  di
    inc  di
    dec  dx
    jnz  @@2
 end;

{ Transponiert die Font-Daten fr die monochromen Graphikkarten }
Procedure XLATFont(Var Source,Dest;Font:Byte); assembler;
 asm
  cld
  push ds
  lds  si,source
  les  di,dest
  mov  cl,font
  xor  ch,ch
  push di
  call _xlat_
  pop  di
  mov  ax,256
  mul  cx
  add  di,ax
  call _xlat_
  pop  ds
 end;

{ Auswahl des Font treffen: Je nach Karte und Font entweder }
{ aus dem Rom oder aus einer Datei laden:                   }
Function SelectFont(Font:Byte):Boolean;
 Var P:Pointer;
     OldSize:word;
 begin
  P:=NIL;
  OldSize:=FontSize;
  FontSize:=0;
  case Graphdriver of
   EGA: begin
         case Font of
          8 : P:=GetRomPtr(GetRom8x8);
	  12: P:=LoadFont(Font);
          14: P:=GetRomPtr(GetRom8x14);
          16: P:=LoadFont(Font);
         end;
        end;
   VGA: begin
         case Font of
          8 : P:=GetRomPtr(GetRom8x8);
	  12: P:=LoadFont(Font);
          14: P:=GetRomPtr(GetRom8x14);
          16: P:=GetRomPtr(GetRom8x16);
         end;
        end;
   else P:=LoadFont(Font);
  end;
  if (P<>Nil) then
  begin
   if (OldSize<>0) then FreeMem(TheFont,OldSize);
   TheFont:=P;
   if graphmaxplanes=1 then
   begin
    getmem(P,FontSize);
    XLATFont(TheFont^,P^,Font);
    MOVE(P^,TheFont^,FontSize);
    freeMem(P,FontSize);
   end;
  end else FontSize:=OldSize;
  SelectFont:=P<>nil;
 end;

{ Zeilenoffset (Hercules) berechnen:        }
{ = ((y and 3) shl 13) + (y shr 2) * 90 + x }
{ input:  ax = y  (Zeilen)                  }
{         bx = x  (Zeichen)                 }
{        (cx = plane)                       }
{ output: di = offs(x,y)                    }
procedure _gethgcoffs; near; assembler;
 asm
  push ax
  push cx
  push dx
   push ax
   shr  ax,2
   mov  dx,90
   mul  dx
   pop  dx
   and  dx,3
   mov  cl,13
   shl  dx,cl
   add  ax,dx
   add  ax,bx
   mov  di,ax
  pop  dx
  pop  cx
  pop  ax
 end;

procedure _gethgcdelta; near; assembler;
 asm
  add di,$2000       { Nchste Zeile: 2000H addieren 	}
  jns @@1	     { Letzter Block ?         		}
  sub di,$8000 - 90  { Ja: $8000 - 90 abziehen 		}
@@1:
 end;

{ Zeilenoffset (CGA) berechnen:             }
{ = ((y and 1) shl 13) + (y shr 1) * 80 + x }
{ input:  ax = y  (Zeilen)                  }
{         bx = x  (Zeichen)                 }
{        (cx = plane)                       }
{ output: di = offs(x,y)                    }
procedure _getcgaoffs; near; assembler;
 asm
  push ax
  push cx
  push dx
   push ax
   shr  ax,1
   mov  dx,80
   mul  dx
   pop  dx
   and  dx,1
   mov  cl,13
   shl  dx,cl
   add  ax,dx
   add  ax,bx
   mov  di,ax
  pop  dx
  pop  cx
  pop  ax
 end;

procedure _getcgadelta; near; assembler;
 asm
  cmp di,$2000       { Letzter Block ?         }
  jae @@1
  add di,$2000       { Nein: Nchster Block, d.h. 2000H addieren }
  ret
@@1:
  sub di,$2000 - 80  { Ja: ($2000-80) abziehen: eine Zeile weiter, einen Block zurck }
 end;

{ Zeilenoffset (VGA) berechnen       }
{ EGA/VGA : (Y * 80) + X             }
{ input:  ax = y                     }
{         bx = x                     }
{ output: di = offset(x,y)           }
procedure _getvgaoffs; near; assembler;
 asm
   push dx
   push ax
   mov  dx,80
   mul  dx
   add  ax,bx
   mov  di,ax
   pop  ax
   pop  dx
 end;

{ DI auf nchste Zeile setzen:  }
procedure _getvgadelta; near; assembler;
 asm
   add  di,80
 end;

 { Variablen und Konstanten fr die Herculeskarte: }

 type  CRTRegs = Array[0..11] of Byte;

 const HGCGraphRegs: CRTRegs
       =($35,$2D,$2E,$07,$5B,$02,$57,$57,$02,$03,$00,$00);
       HGCTextRegs: CRTRegs
       =($61,$50,$52,$0F,$19,$06,$19,$19,$02,$0D,$0B,$0C);

 { CRTC-Register-Adressen: }

      hgc_ModeReg  = $03B8;
      hgc_ConfigReg= $03BF;
      hgc_IndexReg = $03B4;
      hgc_DataReg  = $03B5;

procedure HGCInit(Cfg,Mode1,Mode2:Byte;Var CRT6845:CRTRegs); assembler;
 asm
  mov dx,hgc_configreg
  mov al,cfg
  out dx,al
  mov dx,hgc_modereg
  mov al,mode1
  out dx,al
  les si,crt6845
  mov cx,12
  cld
  mov dx,hgc_IndexReg
  xor ah,ah
@@1:mov al,ah
    out dx,al
    seges lodsb
    inc dx
    out dx,al
    dec dx
    inc ah
   loop @@1
  mov dx,hgc_modereg
  mov al,mode2
  out dx,al
  { Neuen Wert des Modusregisters im BIOS-Datenberich ablegen: }
  mov es,seg0040
  mov es:[$65],al   
 end;

 Function InitGraph:Boolean;
  var OK:Boolean;
  begin
   OK:=False;
   OldVideoMode:=GetVideoMode;
   SaveScreenBuffer:=ScreenBuffer;
   SaveScreenWidth:=ScreenWidth;
   SaveScreenHeight:=ScreenHeight;
   if graphdriver=HercMono then
   begin
     HGCInit(1,2,$0A,HGCGraphRegs);
     { Videomode=6, damit der Maustreiber die Herculeskarte erkennt }
     Mem[Seg0040:$49]:=6; 
     OK:=true;
   end else OK:=SetVideoMode(GraphMode);
   InitGraph:=OK;
   if not OK then exit;
   ScreenBuffer:=GraphScreen;
   GraphPlanes:=GraphMaxPlanes;
   ScreenHeight:=(GraphMaxY+1) div CharHeight;
   ScreenWidth:=(GraphMaxX+1) shr 3;
  end;

 Procedure CloseGraph;
  begin
   if GraphDriver=HercMono then
   begin
    Mem[Seg0040:$49]:=7;
    HGCInit(1,0,8,HGCTextRegs);
   end else setvideomode(oldvideomode);
   ScreenBuffer:=SaveScreenBuffer;
   ScreenWidth:=SaveScreenWidth;
   ScreenHeight:=SaveScreenHeight;
   GraphPlanes:=0;
  end;

 procedure ClearDevice; assembler;
  asm
   cld
   mov al,screenwidth
   mul byte ptr screenheight
   mul charheight
   add ax,$0FFF
   and ax,$F000
   mov cx,ax
   xor ax,ax
   les di,screenbuffer
   shr cx,1
   rep stosw
  end;

 Procedure InitTVGraphics;
  begin
   {$IFDEF DPMI}
   SegC000:=Ofs(__C000H);
   {$ENDIF}
   GraphPlanes:=0;
   GraphDriver:=DetectGraphCard;
   Case GraphDriver of
    CGA,MCGA,EGAMONO,EGA64,HercMono: GraphMaxPlanes:=1;
    EGA,VGA:GraphMaxPlanes:=4;
    else exit;
   end;
   case graphdriver of
    CGA: begin
           ScreenOffs:=Ofs(_GetCGAOffs);
           ScreenDelta:=Ofs(_getCGAdelta);
           GraphMode:=6;
           GraphMaxX:=639;
           GraphMaxY:=199;
           SysFont:=Font8x8;
           GraphScreen:=Ptr(SegB800,0);
         end;
    HercMono: begin
          ScreenOffs:=Ofs(_GetHGCOffs);
	  ScreenDelta:=Ofs(_getHGCdelta);
          GraphMode:=6;
          GraphMaxX:=719;
          GraphMaxY:=347;
          SysFont:=Font8x12;
          GraphScreen:=Ptr(SegB000,0);
         end;
    MCGA:begin
	   ScreenOffs:=Ofs(_GetVgaOffs);
           ScreenDelta:=Ofs(_getvgadelta);
           GraphMode:=$11;
           GraphMaxX:=639;
           GraphMaxY:=479;
           SysFont:=Font8x16;
           GraphScreen:=Ptr(SegA000,0);
         end;
    EGA64,
    EGAMONO: begin
           ScreenOffs:=Ofs(_GetVgaOffs);
	   ScreenDelta:=Ofs(_getvgadelta);
           GraphMode:=$F;
           GraphMaxX:=639;
           GraphMaxY:=349;
           SysFont:=Font8x14;
           GraphScreen:=Ptr(SegA000,0);
         end;
    EGA: begin
	   ScreenOffs:=Ofs(_GetVgaOffs);
           ScreenDelta:=Ofs(_getvgadelta);
           GraphMode:=$10;
           GraphMaxX:=639;
           GraphMaxY:=349;
           SysFont:=Font8x14;
           GraphScreen:=Ptr(SegA000,0);
         end;
    VGA: begin
           ScreenOffs:=Ofs(_GetVgaOffs);
           ScreenDelta:=Ofs(_getvgadelta);
	   GraphMode:=$12;
           GraphMaxX:=639;
           GraphMaxY:=479;
           SysFont:=Font8x16;
           GraphScreen:=Ptr(SegA000,0);
         end;
   end;
   CharHeight:=SysFont;
   SelectFont(SysFont);
  end;

 Procedure DoneTVGraphics;
  begin
   if GraphPlanes>0 then LeaveGraph;
   if FontSize>0 then FreeMem(TheFont,FontSize);
  end;

Function  GetScreenPtr(x,y:word):pointer; assembler;
 asm
   mov  ax,y
   mov  bx,x
   call word ptr screenOffs
   mov  ax,di
   mov  dx,ScreenBuffer.word[2]
 end;

 procedure InvCursor; assembler;
  asm
    mov  cursorflag,1
    mov  cx,cursorform
    mov  dl,ch          { DX = Startzeile }
    xor  ch,ch          { CX = Endzeile   }
    xor  dh,dh
    mov  ax,cursorpos
    mov  bx,ax
    xor  al,al
    xchg al,ah          { AX = Y - Pos }
    xor  bh,bh          { BX = X - Pos }
    push ax
    sub  ax,MouseWhere.y
    js   @@3
    je   @@4
    dec  ax
    je   @@4
    dec  ax
    jne  @@3
@@4:push bx
    sub  bx,MouseWhere.X
    js   @@2
    je   @@ee
    dec  bx
    je   @@ee
    dec  bx
    je   @@ee
@@2:pop  bx
@@3:pop  ax
    mul  charheight.byte[0]
    add  ax,dx
    sub  cx,dx
    js   @@exit
    inc  cx
    cmp  graphplanes,1
    je   @@1
    mov  dx,_GCtrl_    { DX = Indexport     }
    push ax
    mov  ax,0F00h   { Set/Reset-Register, in alle Ebenen $FF schreiben }
    out  dx,ax
    mov  ax,0F01h   { Enable-Set/Reset-Register, alle Ebenen zulassen }
    out  dx,ax
    mov  ax,1803h   { Data-Rotate-Register, Wert fr XOR-Verknpfung }
    out  dx,ax
    pop  ax
@@1:call word ptr screenoffs
    mov  es,screenbuffer.word[2]
@@r:not  byte ptr es:[di] { Bei Hercules die Inversion, bei EGA/VGA
                            in Folge ein Lese- und ein Schreibzugriff }
    call word ptr screendelta
    loop @@r
    xor  cursorvis,1
    jmp  @@exit
@@ee:pop bx
     pop ax
@@exit:
    mov  cursorflag,0
    cmp  graphplanes,1
    je   @@X
    mov  dx,_GCtrl_  { Indexregister }
    mov  ax,3        { Index Data-Rotate-Register, keinerlei Datenoperationen einstellen }
    out  dx,ax
    mov  ax,1        { Index Enable-Set/Reset-Register }
    out  dx,ax
@@X:
  end;

 procedure TimerInt; interrupt;
  begin
   asm
    cmp  cursorflag,1    { Wird gerade der Cursor gezeichnet ? }
    je   @@exit
    cmp  cursorOn,0      { Cursor eingeschaltet ? }
    je   @@1
    dec  int1ccount      { Mu der Cursor wieder umgeschaltet werden ? }
    jnz  @@exit
    mov  int1CCount,int1Cdelay
@@2:call invcursor
    jmp  @@exit
@@1:cmp  cursorvis,0     { Ist der Cursor ausgeschaltet, aber noch sichtbar ? }
    jne  @@2
@@exit:
    pushf
    call dword ptr SaveInt1C; { Alte Interruptroutine aufrufen }
   end;
  end;


procedure InitGraphCursor;
 begin
   CursorVis:=False;
   CursorOn:=False;
   Int1CCount:=Int1CDelay;
   asm
    mov  ah,3
    xor  bh,bh
    int  10h
    or   cl,cl
    je   @@1
    push cx
    inc  cl
    cmp  cl,charheight.byte[0]
    pop  cx
    je   @@1
    sub  ch,cl
    add  ch,charheight.byte[0]
    mov  cl,charheight.byte[0]
    dec  cl
    dec  ch
 @@1:
    mov  cursorform,cx
    mov  cursorpos,dx
   end;
   OldCursorLines:=CursorLines;
   CursorLines:=(charheight-1) + (charheight-2) shl 8;
   CursorFlag:=0;
   getintvec($1C,SaveInt1C);
   setintVec($1C,@TimerInt);
 end;

procedure ExitGraphCursor;
 begin
  setintvec($1C,saveint1C);
  if cursorvis then invcursor;
  CursorLines:=OldCursorLines;
 end;

procedure EnterGraph;
 begin
  if GraphMaxPlanes>0 then
  begin
   donevideo;
   doneEvents;
   If Not InitGraph then
   begin
    CloseGraph;
    initvideo;
    initevents;
    exit;
   end;
   if Buttoncount>0 then
   asm
    xor ax,ax
    int 33h
   end;
   InitEvents;
   InitGraphCursor;
   if GraphInit<>Nil then
   asm
    call dword ptr graphinit
   end;
  end;
 end;

procedure LeaveGraph;
 begin
  if GraphPlanes>0 then
  begin
   HideMouse;
   DoneEvents;
   ExitGraphCursor;
   CloseGraph;
   if Buttoncount>0 then
   asm
    xor ax,ax
    int 33h
   end;
   InitVideo;
   InitEvents;
   ShowMouse;
   if GraphExit<>nil then
   asm
    call dword ptr graphexit
   end;
  end;
 end;

procedure GetDisplayType; near; assembler;
 asm
     MOV     AX, $1A00    { Read Monitor Status: EGA/VGA-BIOS }
     INT     $10
     CMP     AL,$1A       { Wenn Funktion untersttzt wird, steht in AL 1Ah }
     JNE     @@2
     CMP     BL,$07       { BL = 'Active Display Mode' }
     JZ      @@1
     CMP     BL,$08
     JZ      @@1
     CMP     BL,$0B
     JB      @@2
     CMP     BL,$0C
     JA      @@2
@@1: STC
     JMP     @@3
@@2: CLC
@@3:
 end;

Function DetectGraphCard:Integer; assembler;
 const Card:integer = -1;
 asm
     CMP     CARD,-1
     JNE     @@EXIT
     MOV     AX, $1200   { Alternate Function Select: EGA/VGA-BIOS }
     MOV     BX, $FF10   { Get Ega/Vga Info                        }
     MOV     CL, $0F     { Rckgabe in CL = 'Feature Bits'         }
     INT     10H
     CMP     CL,$0C
     JAE     @@10
     CMP     BH,$01     { BH = 1 Monochrome Mode, 0 = Colormode }
     JA      @@10
     CMP     BL,$03     { BL = Speicher, 0: 64KB,1:128KB,2:196KB,3:256KB }
     JA      @@10
     CMP     BH,1
     JNE     @@1
     MOV     CARD,EGAMONO
     JMP     @@EXIT
@@1: CMP     CL,2
     JB      @@2
     OR      BL,BL
     JZ      @@2
     CALL    GETDISPLAYTYPE
     JC      @@3
     MOV     ES,SEGC000
     CMP     WORD PTR ES:[$39],345AH
     JNE     @@4
     CMP     WORD PTR ES:[$3B],3934H
     JE      @@3
@@4: MOV     CARD,EGA
     JMP     @@EXIT
@@3: MOV     CARD,VGA
     JMP     @@EXIT
@@2: MOV     CARD,EGA64
     JMP     @@EXIT
@@10:MOV     AH,$0F
     INT     10H
     CMP     AL,7
     JE      @@7
     CALL    GETDISPLAYTYPE
     JNC     @@C0
     CMP     BL,0BH
     JB      @@EXIT
     MOV     CARD,MCGA
     JMP     @@EXIT
@@7: MOV     DX, $03BA    { $3BA: Statusregister der HGC/MDA-Karte   }
     XOR     BL,BL        { Bei der HGC-Karte flippt Bit 7,da es die }
     IN      AL,DX        { vertikale Synchronisation anzeigt        }
     AND     AL,$80
     MOV     AH,AL
     MOV     CX, $8000
@@H1:IN      AL,DX
     AND     AL,$80
     CMP     AL,AH
     JZ      @@H2
     INC     BL
     CMP     BL,$0A
     JNB     @@H3
@@H2:LOOP    @@H1
     JMP     @@C0
@@H3:MOV     CARD,HERCMONO
     JMP     @@EXIT
@@C0:MOV     SI, $B800             { Die CGA-Karte beginnt bei B8000H }
     MOV     ES,SI
     XOR     SI,SI
     MOV     AX,WORD PTR ES:[SI]
     NOT     AX
     NOT     WORD PTR ES:[SI]
     NOP
     NOP
     CMP     AX,WORD PTR ES:[SI]
     JNZ     @@EXIT
     MOV     CARD,CGA
@@EXIT:
     MOV     AX,CARD
 end;

{ INPUT :  CX = Count                      }
{          DS:DX = @Thinfont               }
{          DS:BX = @ThickFont              }
{          SS:SI = Source (tDrawbuffer)    }
{          ES:DI = Destination (Videoram)  }
procedure MonoMoveBuff;  near; assembler;
const CharH = - 2;
      GraphDelta = -6;
 asm
     cld
     xchg bx,dx     { Standardfont ist dnn }
@@11:push cx
     push si
     push di
@@1: segss lodsw
      test ah,8     { Zeichen dick zeichnen ? }
      jz   @@12
      xchg bx,dx
      xlat          { Bitmuster dicker Font }
      xchg bx,dx
      jmp  @@13
@@12: xlat          { Bitmuster dnner Font }
@@13: and  ah,$77   { Zeichen invertiert ?  }
      cmp  ah,$70
      jne  @@15
      not  al
      jmp  @@14
@@15: or   ah,ah   { Zeichen schwarz ? }
      jnz  @@14
      xor  al,al
@@14: stosb
     loop @@1
     pop  di
     pop  si
     pop  cx
     dec  word ptr [bp].CharH
     jz   @@17
     add  bx,256    { Nchste BitTabelle }
     add  dx,256
     call word ptr [bp].graphdelta  { Nchste Bildschirmzeile }
     jmp  @@11
@@17:
 end;

{ INPUT :  CX = Count                      }
{          AH = Color                      }
{          DS:DX = @Thinfont               }
{          DS:BX = @ThickFont              }
{          SS:SI = Source (tDrawbuffer)    }
{          ES:DI = Destination (Videoram)  }
procedure MonoMoveStr;  near; assembler;
const CharH      = - 2;
      Graphfunc  = - 4;
      GraphDelta = - 6;
 asm
     cld
     test ah,8
     jnz  @@1
     xchg bx,dx
@@1: and  ah,$77
     cmp  ah,$70
     jnz  @@2
     mov  word ptr [bp].graphfunc,offset @@Inverted
     jmp  @@11
@@2: mov  word ptr [bp].graphfunc,offset @@Normal
     or   ah,ah
     jnz  @@11
     mov  word ptr [bp].graphfunc,offset @@Black
@@11:push cx
     push si
     push di
     call word ptr [bp].graphfunc
     pop  di
     pop  si
     pop  cx
     dec  word ptr [bp].CharH
     jz   @@17
     add  bx,256    { Nchste BitTabelle }
     call word ptr [bp].graphdelta  { Nchste Bildschirmzeile }
     jmp  @@11
@@Normal:
     segss lodsb
     xlat
     stosb
     loop  @@normal
     ret
@@Black:
     xor   al,al
     rep   stosb
     ret
@@Inverted:
     segss lodsb
     xlat
     not   al
     stosb
     loop  @@inverted
     ret
@@17:
 end;

{ INPUT :  CX = Count                      }
{          AH = Color                      }
{          AL = Zeichen                    }
{          DS:DX = @Thinfont               }
{          DS:BX = @ThickFont              }
{          ES:DI = Destination (Videoram)  }
procedure MonoMoveChr;  near; assembler;
const CharH      = - 2;
      Graphfunc  = - 4;
      GraphDelta = - 6;
 asm
     cld
     test ah,8
     jnz  @@1
     xchg bx,dx
@@1: and  ah,$77
     cmp  ah,$70
     jnz  @@2
     mov  word ptr [bp].graphfunc,offset @@Inverted
     jmp  @@11
@@2: mov  word ptr [bp].graphfunc,offset @@Normal
     or   ah,ah
     jnz  @@11
     mov  word ptr [bp].graphfunc,offset @@Black
@@11:push cx
     push di
     call word ptr [bp].graphfunc
     pop  di
     pop  cx
     dec  word ptr [bp].CharH
     jz   @@17
     add  bx,256    { Nchste BitTabelle }
     call word ptr [bp].graphdelta  { Nchste Bildschirmzeile }
     jmp  @@11
@@Normal:
     push  ax
     xlat
     rep   stosb
     pop   ax
     ret
@@Black:
     push  ax
     xor   al,al
     rep   stosb
     pop   ax
     ret
@@Inverted:
     push  ax
     xlat
     not   al
     rep   stosb
     pop   ax
     ret
@@17:
 end;

{ INPUT :  CX = Count                         }
{          DS:BX = @ThickFont                 }
{          SS:SI = Source (tDrawBuffer)       }
{          ES:DI = Destination (Videoram)     }
procedure EGAMoveBuff; near; assembler;
const CharH = - 2;
      Graphfunc = - 4;
 asm
   mov  ch,cl
   mov  cl,byte ptr [bp].charh
   push bp
   mov  bp,si
   mov  si,bx
   mov  dx,_GCtrl_         { DX = Indexport               }
   mov  ax,$0200+gc_mode   { Mode Register, Modus 2       }
   out  dx,ax
   mov  al,gc_bitmask      { Bit-Mask-Register }
   out  dx,al
   inc  dx                 { Datenport         }
@@1:push di
    push si
    push cx
    mov  ax,[bp]           { ASCII-Zeichen nach AL, Farbe nach AH }
    inc  bp
    inc  bp
    mov  bl,ah
    mov  bh,ah
    and  bl,$0F        { BL = Vordergrundfarbe                   }
    shr  bh,4          { BH = Hintergrundfarbe                   }
    mul  cl
    add  si,ax
    xor  ch,ch         { Innere Schleife: nur ber Zeichenzeilen }
@@2: lodsb             { Fontbyte laden }
     out  dx,al        { Bitmuster Vordergrund      }
     mov  es:[di],bl   { Vordergrundfarbe schreiben }
     not  al
     out  dx,al        { Bitmuster Hintergrund                }
     mov  al,bh        { Mit Lesezugriff Latch-Register laden }
     xchg al,es:[di]   { Hintergrundfarbe schreiben           }
@@X: add  di,80        { Nchste Zeile                        }
     loop @@2
    pop  cx
    pop  si
    pop  di
    inc  di            { Nchstes Bildschirmzeichen }
    dec  ch
    jnz  @@1
   pop  bp
   mov  al,$FF         { Alle Bits zulassen         }
   out  dx,al
   dec  dx             { Indexport                  }
   mov  ax,gc_mode     { Mode Register, Modus 0     }
   out  dx,ax
 end;

{ INPUT :  CX = Count                         }
{          AH = Color                         }
{          DS:BX = @ThickFont                 }
{          SS:SI = Source (Array[..] of Char) }
{          ES:DI = Destination (Videoram)     }
procedure EGAMoveStr;  near; assembler;
const CharH = - 2;
 asm
   mov  ch,cl
   mov  cl,byte ptr [bp].charh
   push bp
   mov  bp,si
   mov  si,bx
   mov  bl,ah
   mov  bh,ah
   and  bl,$0F
   shr  bh,4
   mov  dx,_GCtrl_         { DX = Indexport               }
   mov  ax,$0200+gc_mode   { Mode Register, Modus 2       }
   out  dx,ax
   mov  al,gc_bitmask      { Bit-Mask-Register            }
   out  dx,al
   inc  dx                 { DX = Datenport               }
@@1:push di
    push si
    push cx
    mov  al,[bp]    { Asciizeichen laden }
    inc  bp
    mul  cl            { Offset in den Font berechnen }
    add  si,ax
    xor  ch,ch         { Innere Schleife: nur ber Zeichenzeilen }
@@2: lodsb             { Fontbyte laden }
     out  dx,al
     mov  es:[di],bl    { Vordergrundfarbe schreiben }
     not  al
     out  dx,al
     mov  ah,bh
     xchg ah,es:[di]    { Lesezugriff, um die Latchregister zu laden; sonst }
                        { wird die bereits gesetzte Vordergrundfarbe berschrieben }
                        { Hintergrundfarbe schreiben }
@@X: add  di,80         { Nchste Zeile              }
     loop @@2
    pop  cx
    pop  si
    pop  di
    inc  di
    dec  ch
    jnz  @@1
   pop  bp
   mov  al,$FF         { Alle Bits zulassen     }
   out  dx,al
   dec  dx             { Indexport              }
   mov  ax,gc_mode     { Mode Register, Modus 0 }
   out  dx,ax
 end;

{ INPUT :  CX = Count                      }
{          AH = Color                      }
{          AL = Zeichen                    }
{          DS:BX = @ThickFont              }
{          ES:DI = Destination (Videoram)  }
procedure EGAMoveChr;  near; assembler;
const CharH      = - 2;
      Graphfunc  = - 4;
      GraphDelta = - 6;
 asm
   cld
   mov   si,bx
   mov   bl,ah
   mov   bh,bl
   and   bl,$0F       { BL = Vordergrundfarbe }
   shr   bh,4         { BH = Hintergrundfarbe }
   xor   ah,ah
   mul   word ptr [bp].charh
   add   si,ax
   mov   dx,_GCtrl_       { DX = Indexport d. Graphic-Controllers }
   mov   ax,$0200+gc_mode { Mode Register, Modus 2                }
   out   dx,ax
   mov   al,gc_bitmask
   out   dx,al        { Bitmasken-Register adressieren }
   inc   dx           { Datenregister einstellen       }
@@2: lodsb
     out   dx,al
     not   al
     mov   ah,al
     mov   al,bl
     push  di
     push  cx
      rep  stosb
     pop   cx
     pop   di
     mov   al,ah
     out   dx,al
     push  di
     push  cx
@@1:  mov  al,bh
      xchg al,es:[di]
      inc  di
      loop @@1
     pop   cx
     pop   di
     dec   word ptr [bp].charh
     jz    @@3
     call  word ptr [bp].graphdelta
     jmp   @@2
@@3:mov   al,$FF
    out   dx,al       { Alle Bits zulassen }
    dec   dx          { DX = Indexregister }
    mov   ax,gc_mode  { Schreibmodus 0 einstellen }
    out   dx,ax
 end;


Procedure PaintStr(X,Y:word;Color:Byte;Var S:String); assembler;
 var CharH:word;
     Graphfunc:word;
     GraphDelta:word;
  asm
    cmp   GraphPlanes,0
    je    @@Text
    cld
    mov   ax,screendelta
    mov   Graphdelta,ax
    mov   ax,Charheight
    mov   CharH,ax
    les   si,S
    seges lodsb
    mov   cl,al
    xor   ch,ch
    mov   ax,ss
    cmp   ax,S.word[2]     { Liegt der Puffer bereits auf dem Stack ? }
    je    @@1
    { Wenn nicht: Relevanten Bereich auf Stack kopieren }
    sub   sp,cx
    mov   di,sp
    mov   dx,ds
    mov   ds,S.word[2] { DS:SI = ^Buffer      }
    mov   es,ax        { ES:DI = Zeiger auf Stackbereich }
    push  di
    push  cx
    shr   cx,1
    jnc   @@10
    movsb
@@10:rep  movsw
    pop   cx
    pop   si         { SS:SI = ^Stack-Buffer   }
    mov   ds,dx
@@1:                 { CX = Count }
    mov   ax,y
    mul   charh
    mov   bx,x
    mov   es,screenbuffer.word[2]
    call  word ptr screenoffs { ES:DI = ^Videomem }
    mov   ah,byte ptr color
    push  ds
    cmp   graphplanes,1
    lds   bx,Thefont  { DS:BX = ^Thickfont }
    jne   @@EGAVGA
    call  monomovestr
    jmp   @@exit
@@EGAVGA:
    call  egamovestr
    jmp   @@exit
@@text:
    push  ds
    mov   ax,y
    mul   screenwidth
    add   ax,x
    shl   ax,1
    les   di,screenbuffer
    add   di,ax
    mov   ah,color
    lds   si,S
    lodsb
    mov   cl,al
    xor   ch,ch
@@T:lodsb
    stosw
    loop  @@T
@@exit:
    pop   ds
 end;

Procedure PaintChar(X,Y,Count,CharColor:Word); assembler;
 var CharH:word;
     Graphfunc:word;
     GraphDelta:word;
  asm
    cld
    cmp   graphplanes,0
    je    @@Text
    mov   ax,screendelta
    mov   Graphdelta,ax
    mov   ax,Charheight
    mov   CharH,ax
    mov   cx,count            { CX = Count }
    mul   y
    mov   bx,x
    mov   es,screenbuffer.word[2]
    call  word ptr screenoffs
    mov   ax,CharColor
    push  ds
    cmp   graphplanes,1
    jne   @@EGAVGA
    push  ax
    mov   ax,256
    mul   charH
    mov   dx,ax
    lds   bx,Thefont  { DS:BX = ^Thickfont }
    add   dx,bx       { DS:DX = ^Thinfont  }
    pop   ax
    call  MonoMovechr
    jmp   @@exit
@@EGAVGA:
    lds   bx,Thefont  { DS:BX = ^Thickfont }
    call  egamovechr
    jmp   @@exit
@@text:
    push  ds
    mov   ax,y
    mul   screenwidth
    add   ax,x
    shl   ax,1
    les   di,screenbuffer
    add   di,ax
    mov   cx,count
    mov   ax,CharColor
    rep   stosw
@@exit:
    pop   ds
  end;

 Procedure PaintBuf(X,Y,W:Word;Var Buf); assembler;
 var CharH:word;
     Graphfunc:word;
     GraphDelta:word;
  asm
    cld
    cmp   graphplanes,0
    je    @@Text
    mov   ax,screendelta
    mov   Graphdelta,ax
    mov   ax,Charheight
    mov   CharH,ax
    mov   cx,w
    mov   si,buf.word[0]
    mov   ax,ss
    cmp   ax,buf.word[2]   { Liegt der Puffer bereits auf dem Stack ? }
    je    @@1
    { Wenn nicht: Relevanten Bereich auf Stack kopieren }
    sub   sp,cx
    sub   sp,cx
    mov   di,sp
    mov   dx,ds
    mov   ds,buf.word[2]  { DS:SI = ^Buffer      }
    mov   es,ax    { ES:DI = Zeiger auf Stackbereich }
    push  di
    push  cx
    rep   movsw
    pop   cx
    pop   si         { SS:SI = ^Stack-Buffer   }
    mov   ds,dx
@@1:                 { CX = Count }
    mov   ax,y
    mul   charh
    mov   bx,x
    call  word ptr screenoffs
    mov   es,screenbuffer.word[2]  { ES:DI = ^Videomem }
    push  ds
    cmp   graphplanes,1
    lds   bx,Thefont  { DS:BX = ^Thickfont }
    jne   @@EGAVGA
    mov   ax,256
    mul   charh
    mov   dx,ax
    add   dx,bx       { DS:DX = ^Thinfont  }
    call  MonoMovebuff
    jmp   @@exit
@@Text:
    push  ds
    mov   ax,y
    mul   screenwidth
    add   ax,x
    shl   ax,1
    les   di,screenbuffer
    add   di,ax
    mov   cx,W
    lds   si,Buf
    rep   movsw
    jmp   @@exit
@@EGAVGA:
    call  egamovebuff
@@exit:
    pop   ds
 end;

 procedure _dostore_; near; assembler;
  asm
@@1:push di
    push cx
    shr  cx,1
    jnc  @@2
    stosb
@@2:rep  stosw
    pop  cx
    pop  di
    call word ptr screendelta
    dec  si
    jnz  @@1
  end;

 Procedure FillRect(X,Y,W,H:Word;Color:Byte); assembler;
  asm
   cld
   mov  ax,y
   mul  charheight
   mov  bx,x
   call word ptr screenoffs
   mov  es,screenbuffer.word[2]
   mov  ax,h
   mul  charheight
   mov  si,ax
   mov  cx,w
   mov  bl,color
   cmp  graphplanes,1
   je   @@Mono
   mov  dx,_gctrl_
   mov  al,gc_setreset
   mov  ah,bl
   out  dx,ax
   mov  ax,$0F00+gc_sr_enable
   out  dx,ax
   inc  dx
   call _dostore_
   xor  al,al
   out  dx,al
   jmp  @@exit
@@Mono:
   or   bl,bl
   jz   @@Black
   mov  ax,$FFFF
   jmp  @@White
@@Black:
   xor  ax,ax
@@White:
   call _dostore_
@@exit:
  end;

 constructor tGraphImage.init(aWidth,aHeight,aBitsPP:word);
  var i:integer;
      longsize:longint;
  begin
   i:=aHeight mod charheight;
   if i<>0 then aHeight:=aHeight + Charheight - i;
   inherited init(aHeight,10);
   Width:=aWidth;
   BitsPP:=aBitsPP;
   BC:=Black;
   FC:=lightgray;
   Longsize:=scanlinesize(aWidth,aBitsPP);
   Longsize:=(Longsize + 4) * aHeight;
   if MemAvail<LongSize then fail;
   for i:=1 to aHeight do insert(NewScanLine(Width,BitsPP));
  end;

 procedure tGraphImage.FreeItem(Item:Pointer);
  begin
   DisposeLine(pScanLine(Item),Width,BitsPP);
  end;

 Procedure tGraphImage.PutImage(ix,iy,w,h,sx,sy:integer); assembler;
  var list:pointer;
      scrDelta:word;
  asm
   { Koordinaten berprfen: }
   cld
   push ds
   les di,self
   mov ax,es:[di].width
   shr ax,3
   sub ax,ix
   jbe @@exit
   cmp ax,w
   jae @@101
   mov w,ax
@@101:
   mov ax,es:[di].count
   xor dx,dx
   div charheight
   sub ax,iy
   jbe @@exit
   cmp ax,h
   jae @@102
   mov h,ax
@@102:
   { Monochrom oder Farbkarte ? }
   cmp graphplanes,1
   je  @@monodraw
   { Farbkarte: 2 oder 16 Farben ? }
   cmp es:[di].bitsPP,1
   je  @@2cols
   cmp es:[di].bitsPP,4
   jne @@exit
   { 16-Farben-Darstellung: 4 Farb-Ebenen in den Bildspeicher schreiben. }
   mov  ax,h
   mul  charheight
   mov  cx,ax
   push cx                      { CX = Zeilen         }
   mov  ax,es:[di].width
   mul  es:[di].bitsPP
   add  ax,31
   mov  bx,ax
   shr  bx,5                    { BX = Anzahl der Byte/Farbe }
   push bx
   les  di,es:[di].items        { Zeiger auf die Scanzeilen laden }
   mov  ax,iy
   mul  charheight
   shl  ax,2
   add  di,ax
   mov  list.word[0],di
   mov  list.word[2],es         { List = ^Array of ^Scanzeilen           }
   mov  ax,sy                   { AX = Y, BX = X fr Bildspeicher-Offset }
   mul  charheight
   mov  bx,sx
   call word ptr screenoffs     { DI = Bildspeicheroffset                }
   mov  es,screenbuffer.word[2] { ES:DI = ^VideoRam }
   pop  bx                      { BX = Anzahl der Byte/Farbe }
   pop  cx                      { CX = Zeilen         }
   mov  dx,_gctrl_              { DX = Indexregister des EGA/VGA-Graphikcontrollers }
   mov  ax,gc_sr_enable         { Set/Reset-Register sperren }
   out  dx,ax
   mov  dx,_sequ_               { DX = Indexregister des Sequencers  }
   mov  al,sq_mapmask           { Map-Mask-Register adressieren      }
   out  dx,al
   inc  dx
@@24:mov  al,1                  { 1. Farbebene selektieren           }
     out  dx,al
     lds  si,list
     lds  si,[si]               { DS:SI = Zeiger auf Quelldaten      }
     add  list.word[0],4
     push cx                    { Anzahl der Scanzeilen sichern      }
     mov  cx,w                  { Zhler fr eine Scanzeile setzen   }
     add  si,ix                 { DS:SI = ^Bits }
@@14: push di
      push si
      push cx
      shr  cx,1                 { Daten in den Bildspeicher schreiben: }
      jnc  @@100
      movsb
@@100:rep  movsw
      pop  cx
      pop  si
      pop  di
      add  si,bx                { Offset auf nchste Farbe der Scanzeile setzen }
      shl  al,1                 { Maske fr nchste Farbebene setzen }
      cmp  al,$10               { Letzte Ebene bereits geschrieben ? }
      jae  @@34
      out  dx,al
      jmp  @@14
@@34:add  di,80                 { Bildspeicheroffset auf nchste Scanzeile }
     pop  cx                    { Zeilenzhler restaurieren                }
     loop @@24
     mov  al,$0F                { Alle Ebene wieder zulassen               }
     out  dx,al
   jmp @@exit                   { Fertig => EXIT                           }
@@2cols:  {**** 2-Farbige Darstellung auf EGA/VGA-Karte: ****}
   mov  ax,h
   mul  charheight
   mov  cx,ax
   push cx                      { CX = Zeilen         }
   mov  bl,es:[di].FC
   mov  bh,es:[di].BC           { BX = Farben         }
   push bx
   les  di,es:[di].items
   mov  ax,iy
   mul  charheight
   shl  ax,2
   add  di,ax                   { ES:DI = ^Scanzeilenliste }
   mov  list.word[0],di
   mov  list.word[2],es
   mov  ax,sy
   mul  charheight
   mov  bx,sx
   call word ptr screenoffs     { Bildspeicheroffset berechnen }
   mov  es,screenbuffer.word[2] { ES:DI = ^VideoRam }
   pop  bx                      { BX = Farben         }
   pop  cx                      { CX = Zeilen         }
   mov  dx,_gctrl_              { Schreibmodus 2 einstellen: }
   mov  ax,$0200+gc_mode
   out  dx,ax
   mov  al,gc_bitmask           { Bitmaskenregister adressieren }
   out  dx,al
   inc  dx
@@20:lds  si,list
     lds  si,[si]
     add  list.word[0],4
     push cx
     mov  cx,w
     add  si,ix                 { DS:SI = ^Quellzeile }
     push di
@@10: lodsb                     { Bitmuster laden.. }
      out dx,al
      mov es:[di],bl            { Vordergrundfarbe schreiben. }
      not al                    { Bitmuster invertieren..     }
      out dx,al                 { ..und in das BitMaskRegister schreiben. }
      mov ah,bh
      xchg ah,es:[di]           { Lesezugriff, um die Latchregister zu laden }
      inc di                    { & Hintergrundfarbe schreiben.              }
      loop @@10
     pop  di
     pop  cx
     add  di,80                 { Offset nchste Scanzeile      }
     loop @@20
   mov al,$FF                   { Alle Bits wieder zulassen     }
   out dx,al
   dec dx
   mov ax,gc_mode               { Schreibmodus 0 einstellen     }
   out dx,ax
   jmp @@exit                    { FERTIG }
@@monodraw:
   mov  ax,screendelta          { Offset der aktuellen Routine laden. }
   mov  Scrdelta,ax
   mov  ax,h
   mul  charheight
   mov  cx,ax
   push cx                      { CX = Zeilen         }
   les  di,es:[di].items
   mov  ax,iy
   mul  charheight
   shl  ax,2
   add  di,ax
   mov  list.word[0],di
   mov  list.word[2],es
   mov  ax,sy
   mul  charheight
   mov  bx,sx
   call word ptr screenoffs
   mov  es,screenbuffer.word[2] { ES:DI = ^VideoRam }
   pop  cx
@@21:lds  si,list
     lds  si,[si]
     add  list.word[0],4
     push cx
     mov  cx,w
     add  si,ix                  { DS:SI = ^Bits }
     push di
     push si
     shr  cx,1
     jnc  @@50
     movsb
@@50:rep  movsw
     pop  si
     pop  di
     pop  cx
     call Word ptr ScrDelta
     loop @@21
@@exit:
   pop  ds
  end;

Procedure PutScanLinePixel(p:pScanLine;X,Width:Integer;Color,BitsPP:byte); assembler;
 asm
    les  di,p
    mov  ax,X		{ Offset auf erstes Byte = X shr 3              }
    mov  cx,ax
    shr  ax,3
    add  di,ax
    and  cx,7
    mov  ah,$80 	{ Maske = 80H shr (X and 7)			}
    shr  ah,cl
    mov  al,ah
    not  al
    mov  cl,BitsPP      { CX = Zhler ber die Farbebenen               }
    xor  ch,ch
    mov  bl,color       { BL = Farbe					}
    mov  dx,width       { DX = Offset-Delta zur nchsten Farbkomponente }
    add  dx,31
    shr  dx,3
    and  dx,$FFFC
@@1:shr  bl,1           { Farbbit gesetzt ?				}
    jc   @@2
    and  es:[di],al	{ Nein: Bit lschen                             }
    jmp  @@3
@@2:or   es:[di],ah     { Ja: Bit setzen				}
@@3:add  di,dx
    loop @@1
 end;

Procedure tGraphImage.PutPixel(x,y:integer;color:byte);
 var p:pScanline;
 begin
  if (y<count) and (x<width) and (y>=0) and (x>=0) then
  begin
   p:=at(y);
   putscanlinepixel(p,x,width,color,BitsPP);
  end;
 end;

Function getscanlinepixel(p:pScanLine;X,Width:Integer;BitsPP:byte):byte; assembler;
 asm
    les  di,p
    mov  ax,X		{ Offset auf erstes Byte = X shr 3              }
    mov  cx,ax
    shr  ax,3
    add  di,ax
    and  cx,7           { CX = X And 7+1  				}
    inc  cx
    mov  bl,BitsPP      { BL = Zhler ber die Farbebenen               }
    mov  dx,width       { DX = Offset-Delta zur nchsten Farbkomponente }
    add  dx,31
    shr  dx,3
    and  dx,$FFFC
    xor  ax,ax
@@1:mov  bh,es:[di]
    shl  bh,cl
    rcl  al,1
    add  di,dx
    dec  bl
    jnz  @@1
 end;

Function tGraphImage.GetPixel(x,y:integer):byte;
 var p:pScanLine;
 begin
  if (x<0) or (x>width) or (y<0) or (y>=count) then
  getpixel:=0 else
  begin
   p:=at(y);
   getpixel:=getscanlinepixel(p,x,width,bitspp);
  end;
 end;

{ Bresenham-Algorithmus: }
Procedure tGraphImage.Line(x1,y1,x2,y2:integer;color:byte);
 var xx,dx,dy,r:integer;
 begin
  if y2<y1 then
  begin
   dx:=x2;
   x2:=x1;
   x1:=dx;
   dy:=y2;
   y2:=y1;
   y1:=dy;
  end;
  if x2>x1 then xx:=1 else xx:=-1;
  dy:=abs(y2-y1);
  dx:=abs(x2-x1);
  r:=0;
  putpixel(x1,y1,color);
  if dx>dy then while x1<>x2 do
  begin
   x1:=x1+xx;
   inc(r,dy);
   if r shl 1>=dx then
   begin
    inc(y1);
    dec(r,dx);
   end;
   putpixel(x1,y1,color);
  end else while y1<>y2 do
  begin
   inc(y1);
   inc(r,dx);
   if r shl 1>dy then
   begin
    x1:=x1+xx;
    dec(r,dy);
   end;
   putpixel(x1,y1,color);
  end;
 end;

Procedure tGraphImage.Switch2Mono;
 var p2,p1,p0:pScanLine;
     x,y:integer;
     c:byte;
 procedure XChangeLine(p:pScanLine;i:integer);
  var q:pScanline;
  begin
   if (y<count) and (y>=0) then
   begin
    q:=at(i);
    atput(i,p);
    disposeline(q,width,bitspp);
   end;
  end;
 begin
  if bitsPP=1 then exit;
  p1:=nil;
  p2:=nil;
  for y:=0 to count-1 do
  begin
   p0:=p1;
   p1:=p2;
   p2:=NewScanLine(Width,1);
   for x:=0 to width-1 do
   begin
    c:=getpixel(x,y);
    if (getpixel(x-1,y)>c) or (getpixel(x+1,y)>c)
	or (getpixel(x,y-1)>c) or (getpixel(x,y+1)>c) then
     PutScanLinePixel(p2,X,Width,1,1);
   end;
   if (p0<>nil) and (y>1) then XChangeLine(p0,y-2);
  end;
  if p1<>nil then XChangeLine(p1,count-2);
  if p2<>nil then XChangeLine(p2,count-1);
  BitsPP:=1;
 end;


Function ScanLineSize(width,bitsPP:word):word; assembler;
 asm
  mov ax,width
  mul bitsPP
  add ax,31
  shr ax,3
  and ax,$FFFC
 end;

Function NewScanLine(Width,BitsPP:word):pScanLine;
 var s:word;
     p:pScanLine;
 begin
  p:=nil;
  s:=ScanLineSize(width,bitsPP);
  if MaxAvail>s then
  begin
   Getmem(p,s);
   asm
    cld
    mov cx,s
    shr cx,1
    les di,p
    xor ax,ax
    rep stosw
   end;
  end;
  NewScanLine:=p;
 end;

Procedure DisposeLine(TheLine:pScanLine;Width,BitsPP:word);
 begin
  if TheLine<>nil then FreeMem(TheLine,ScanLineSize(width,bitsPP));
 end;

{$IFDEF DPMI }
  PROCEDURE __C000H; EXTERNAL 'KERNEL' INDEX 195;
{$ENDIF}

BEGIN
 InitTVGraphics;
END.