{***************************************************************************}
{  Demoprogramm fr die Datenkommunikation ber die serielle Schnittstelle  }
{  Das Programm ist fr die Schnittstelle COM1 ausgelegt, d.h. IRQ 4, Ports }
{  ab 3F8H u.s.w..                                                          }
{  Soll das Programm ber eine andere Schnittstelle betrieben werden, sind  }
{  die entsprechenden Konstanten anzupassen.				    }
{  Das Programm sollte auf beiden verbundenen Rechnern geladen sein.	    }
{                                                                           }
{     	   Copyright (C) Christian Baumgarten, Hamburg 1992/1993	    }
{***************************************************************************}
program UARTDEMO;

 uses dos,crt;

 const int_No  = $0C;
       mask_reg= $21;
       DR      = $3F8;
       MCR     = $3FC;
       MSR     = $3FE;
       LSR     = $3FD;
       IER     = $3F9;
       IR      = $3FA;

 var OldIntVec:pointer;
     RX,RY,SY,SX:byte;
     z:char;

 procedure ErrorMsg(s:string);
  begin
   gotoxy(1,24); textattr:=$71;
   write(' ',s,' : ');
   clreol;
  end;

 procedure E_O_I;
  begin
   Port[$20]:=$20;
  end;

  Function DataAvail:Boolean;
   begin
    Dataavail:=Port[LSR] and 1=1;
   end;

 procedure RS232_Int; interrupt;
  var data:char;
  begin
   sy:=wherey;
   sx:=wherex;
   window(1,1,80,25);
   window(41,3,80,24);
   gotoxy(rx,ry);
   TextAttr:=Blue shl 4+White;
   while Dataavail do
   begin
    data:=chr(Port[DR]);
    write(data);
    if data=#13 then write(#10);
   end;
   TextAttr:=Blue shl 4+Yellow;
   rx:=wherex;
   ry:=wherey;
   window(1,3,40,24);
   GotoXY(sx,sy);
   E_O_I;
  end;

  { Im Interruptcontroller Maskierungsbit fr IRQ 4 lschen: }
  procedure enable_int;
   begin
    Port[mask_reg]:=Port[mask_reg] and $EF;
   end;

  { Im Interruptcontroller Maskierungsbit fr IRQ 4 setzen:  }
  procedure disable_int;
   begin
    Port[Mask_reg]:=Port[Mask_reg] or $10;
   end;

  procedure Install_int;
   var i:byte;
   begin
    { Interupt maskieren: }
    disable_int;
    { Interruptvector setzen: }
    getintvec(int_No,oldintvec);
    setintvec(int_no,@RS232_int);
    { Empfangspuffer leeren: }
    i:=Port[DR];
    { Interupt aufrufen, wenn Daten empfangen werden: }
    Port[IER]:=Port[IER] or 1;
    { IEN, DTR und RTS setzen: }
    Port[MCR]:=Port[MCR] or $0B;
    { Evtl. noch anhngige Interruptanforderungen lschen: }
    E_O_I;
    { Interrupt zulassen: }
    enable_int;
    E_O_I;
   end;

  procedure UnInStall_int;
   begin
    disable_int;
    setintvec(int_No,oldintvec);
    E_O_I;
   end;

  procedure SendRS232(c:char);
   var m:byte;
   begin
    while (Port[MSR] and $30<>$30)
	  and (Port[LSR] and $40<>$40) and not keypressed do;
    while (Port[MSR] and $30=$30)
	  and (Port[LSR] and $40=$40) do Port[DR]:=ord(c);
   end;


 begin
  TextAttr:=blue shl 4+yellow;
  clrscr;
  writeln(' RS-232 Datenbertragung');
  gotoxy(1,24); write(' Abbruch: ESC drcken..');
  window(1,3,40,24);
  clrscr;
  TextAttr:=Blue shl 4+White;
  RX:=1;
  SX:=1;
  SY:=1;
  RY:=1;
  install_int;
  repeat
   z:=readkey;
   if (z<>#27) then
   begin
    write(z); if z=#13 then write(#10);
    SendRS232(z);
   end;
  until (z=#27);
  uninstall_int;
  clrscr;
 end.
