{***************************************************************************}
{                                                                           }
{          Copyright (C) Christian Baumgarten, Hamburg 1993.                }
{                                                                           }
{       Unit mit diversen Funktionen zur Nutzung der EGA/VGA-Karte          }
{                                                                           }
{***************************************************************************}
unit vga;
interface

type pVGAinfo = ^tVGAInfo;
     tVGAInfo = Record
      videofunc:pointer;
      mode:byte;
      Rows:word;
      Chars:word;
      start:word;
      cursorpos:array[0..7,0..1] of byte;
      cursorform:word;
      activepage:byte;
      portaddress:word;
      crtmode:byte;
      palette:byte;
      Lines:byte;
      charheight:word;
      actmonitor:byte;
      altmonitor:byte;
      maxcolor:word;
      sides:byte;
      scanlines:byte;
      primCharSet:byte;
      sekCharSet:byte;
      infobyte:byte;
      res1:array[1..30] of byte;
      memsize:byte;
      statusinfo:byte;
      res2:array[1..13] of byte;
     end;

     { EGA-Palettenregister: }
     pPaletteRegs = ^tPaletteRegs;
     tPaletteRegs = Record
      Palette:Array[0..15] of byte;
      Overscan:Byte;
     end;

     { Fr einzelnes DAC-Register: }
     pRGBTriple = ^tRGBTriple;
     tRGBTriple = Record
      Red,Green,Blue:Byte;
     end;

     { Fr alle VGA-DAC-Register: }
     pRGBPalette = ^tRGBPalette;
     tRGBPalette = Array[0..255] of tRGBTriple;

     { Fr die aktuell selektierten VGA-DAC-Register: }
     pRGB16Page = ^tRGB16Page;
     tRGB16Page = Array[0..15] of tRGBTriple;

     { Fr eine VGA-Farbseite:	}
     pRGB64Page = ^tRGB64Page;
     tRGB64Page = Array[0..63] of tRGBTriple;

const
{ Konstanten fr LoadTxtFont: }
      ROM8x8       = $12;
      ROM8x14      = $11;
      ROM8x16      = $14;
      TXT_USERFONT = $10;

{ Konstanten fr LoadGraphFont }
      GR_ROM8x8    = $23;
      GR_ROM8x14   = $22;
      GR_ROM8x16   = $24;
      GR_USERFONT  = $21;

{ Konstanten fr GetFontPtr    }
      GetInt1F     = 0; { 8er Hhe, ab Zeichen 128 }
      GetInt43     = 1; { 16er Hhe }
      GetRom8x14   = 2;
      GetRom8x8    = 3;
      GetRom8x16   = 6;

{ Farbseitenkonstanten: }
      Color4PageMode  = 0;
      Color16PageMode = 1;

{ Selektor fr EGAVGA-Rom-Fonts: }
      SegC000:word = $C000;

{ Palettenfunktionen: }

Function GetPaletteReg(Index:Byte):Byte;
procedure SetPaletteReg(index,entry:byte);
procedure GetAllPalette(var Palette:tPaletteRegs);
procedure SetAllPalette(var Palette:tPaletteRegs);

Procedure GetRGBEntry(Index:Byte;var RGB:tRGBTriple);
Procedure SetRGBEntry(Index:Byte;RGB:tRGBTriple);
Procedure GetRGBPalette(var RGBPalette:tRGBPalette);
Procedure SetRGBPalette(var RGBPalette:tRGBPalette);
Procedure GetRGB16Page(Index:Byte;var RGBPage:tRGB16Page);
Procedure SetRGB16Page(Index:Byte;var RGBPage:tRGB16Page);
Procedure GetVga16Colors(var RGBPage:tRGB16Page);
Procedure SetVga16Colors(var RGBPage:tRGB16Page);

Procedure SelectColorPage(Page:Byte);
Procedure SetColorPageMode(Mode:Byte);
Function  ColorPageMode:Byte;
Function  ColorPage:Byte;

{ Hilfsfunktionen: }

{ Die Funktion VFrequency gibt die Vertikal- 	}
{ Frequenz einer VGA-Karte recht genau wieder	}
Function VFrequency:Word;

{ Liefert eine Schtzung der Horizontalfrquenz: }
Function HFrequency:Word;

{ Warten auf den vertikalen Strahlrcklauf, etwa 	}
{ bei nderung von Palettenregistern zu empfehlen. 	}
Procedure WaitVRetrace;

{ Warten auf den horizontalen Strahlrcklauf	}
Procedure WaitHRetrace;

{ Fontfunktionen: }
{ Liefert einen Zeiger auf die Adresse eines EGA-VGA-ROM-Fonts: }
 Function GetFontPtr(Font:Byte):Pointer;

{ Ldt einen Font in den selektierten Speicherblock: }
procedure LoadTxtFont(typ,block,BytesPerChar:byte;font:pointer);

{ Seletiert einen Font-Block. Ist BlockA<>BlockB, so	}
{ wird mit mehreren Fonts gearbeitet.			}
procedure SelectFont(BlockA,BlockB:byte);

{ Biosfunktionen: }

 function Videomode:byte;
procedure BIOSWriteStr(x,y,color:byte;s:string);
procedure SetCursorForm(s,e:byte);
procedure SetVideoMode(Mode:byte);
function  TextLines:word;
function  TextRows:word;

function  GetMaxcolor:word;
function  GetMaxY:word;
function  GetMaxX:word;
procedure BIOSPutPixel(x,y:integer; color:byte);
procedure putpixel(x,y:integer; color:byte);
procedure Line(x1,y1,x2,y2:integer;color:byte);
procedure Rectangle(x1,y1,x2,y2:integer;color:byte);

{ Schreibt in beliebigen Textmodi den String S ab Position x,y auf den  }
{ Bildschirm. Wenn Color = 0, dann werden die Attribute belassen, wie   }
{ sie sind, sonst wird der String in der Farbe Color ausgegeben.        }
procedure WriteStr(x,y,color:byte;s:string);

{ berprft bei VGA-Karten, ob der aktuelle Videomodus ein     }
{ Graphikmodus ist.                                            }
function  isgraphmode:boolean;

{ Liefert einen Zeiger auf die VGA-Statustabelle zum aktuellen }
{ Videomodus.                                                  }
function  getvgainfo:pVgaInfo;

{ berprft das Interlaced-Bit auf VGA-Karten: }
function  interlaced:boolean;

{ Berechnet zur den Graphikkoordinaten (x,y) die Bildspeicheroffset }
function  getoffs(x,y:word):word;

{ Diese Prozeduren erwarten in Font ein Array[0..255,0..Charheight-1] of byte }
{ Sie verwenden jeweils Schreibmodus 0,2 bzw. 3.                              }
{ Schreibmodus 3 existiert nur auf VGA-Karten !                               }
{ Getesteter Zeitbedarf bei einem 30-Zeichen String, 16 Byte/Zeichen auf }
{ einem 80386er mit 25 Mhz:                                              }
{ Modus 0: 5.3  ms                                                       }
{ Modus 2: 3.85 ms                                                       }
{ Modus 3: 4.17 ms                                                       }
{ Das VGA-BIOS bentigte fr die Ausgabe eines gleichlangen Strings      }
{ 2.808 ms (Nur Vordergrundfarbe !)                                      }
{ Die Koordinaten entsprechen dem Textmodus.                             }
procedure PaintStr0(x,y,color:byte;var Font;charheight:word;S:string);
procedure PaintStr2(x,y,color:byte;var Font;charheight:word;S:string);
procedure PaintStr3(x,y,color:byte;var Font;charheight:word;S:string);

{ Diese Prozeduren erwarten in Font ein Array[0..Charheight-1,0..255] of byte }
{ Die Prozeduren arbeiten mit dem XLAT-Befehl                                 }
{ Sie verwenden jeweils Schreibmodus 0,2 bzw. 3.                              }
{ Schreibmodus 3 existiert nur auf VGA-Karten !                               }
{ Getesteter Zeitbedarf bei einem 30-Zeichen String, 16 Byte/Zeichen auf }
{ einem 80386er mit 25 Mhz:                                              }
{ Modus 0: 10.5 ms                                                       }
{ Modus 2: 4.1  ms                                                       }
{ Modus 3: 2.8  ms                                                       }
{ Das VGA-BIOS bentigte fr die Ausgabe eines gleichlangen Strings      }
{ 2.808 ms (Nur Vordergrundfarbe !)                                      }
{ Die Koordinaten entsprechen dem Textmodus.                             }
procedure XPaintStr0(x,y,color:byte;var Font;charheight:word;S:string);
procedure XPaintStr2(x,y,color:byte;var Font;charheight:word;S:string);
procedure XPaintStr3(x,y,color:byte;var Font;charheight:word;S:string);

{ Erwartet in S einen Buffer vom Format <ASCII,Attribut,ASCII,Attribut...> }
{ mit w Worten und gibt diesen im 640 x ??? - Modus als String an der      }
{ Textposition (x,y) aus. Benutzt Schreibmodus 2.                          }
procedure PaintBuf2(x,y,w:byte;var Font;charheight:word;Var S);
procedure PaintBuf3(x,y,w:byte;var Font;charheight:word;Var S);
procedure xPaintBuf2(x,y,w:byte;var Font;charheight:word;var S);

implementation

{$IFDEF DPMI }
  PROCEDURE __C000H; FAR; EXTERNAL 'KERNEL' INDEX 195;
{$ENDIF}

{ Konstanten der VGA-Register: }

const _GCtrl_ = $03CE;
      _ACtrl_ = $03C0;
      _Sequ_  = $03C4;

      sq_mapmask   = 02;
      sq_memmode   = 04;

      gc_setreset  = 00;
      gc_sr_enable = 01;
      gc_colorcmp  = 02;
      gc_DataRot   = 03;
      gc_ReadSel   = 04;
      gc_Mode      = 05;
      gc_Miscell   = 06;
      gc_ColDont   = 07;
      gc_bitmask   = 08;

{ Konstanten fr den Biosdatenbereich: }

      _textrows    = $4A;
      _videomode   = $49;
      _pageoffs    = $4E;
      _CurForm     = $60;
      _CRTCPort    = $63;
      _modectrl    = $65;
      _textlines   = $84;
      _charheight  = $85;

 Procedure GetVga16Colors(var RGBPage:tRGB16Page);
  var i:byte;
  begin
   for i:=0 to 15 do
    GetRGBEntry(GetPaletteReg(i),RGBPage[i]);
  end;

 Procedure SetVga16Colors(var RGBPage:tRGB16Page);
  var i:byte;
  begin
   for i:=0 to 15 do
    SetRGBEntry(GetPaletteReg(i),RGBPage[i]);
  end;

 Function GetPaletteReg(Index:Byte):Byte; assembler;
  asm
   mov ax,1007h
   mov bl,index
   int 10h
   mov al,bh
  end;

 procedure SetPaletteReg(index,entry:byte);            assembler;
  asm
   mov ax,1000h
   mov bh,entry
   mov bl,index
   int 10h
  end;

 procedure GetAllPalette(var Palette:tPaletteRegs);    assembler;
  asm
   mov ax,1009h
   les dx,palette
   int 10h
  end;

 procedure SetAllPalette(var Palette:tPaletteRegs);    assembler;
  asm
   mov ax,1002h
   les dx,palette
   int 10h
  end;


 Procedure GetRGBEntry(Index:Byte;var RGB:tRGBTriple); assembler;
  asm
   mov ax,1015h
   xor bh,bh
   mov bl,index
   int 10h
   les di,rgb
   mov es:[di].trgbtriple.red,dh
   mov es:[di].trgbtriple.green,ch
   mov es:[di].trgbtriple.blue,cl
  end;

 Procedure SetRGBEntry(Index:Byte;RGB:tRGBTriple);     assembler;
  asm
   mov  ax,1010h
   xor  bh,bh
   mov  bl,index
   les  di,rgb
   mov  dh,es:[di].trgbtriple.red
   mov  ch,es:[di].trgbtriple.green
   mov  cl,es:[di].trgbtriple.blue
   int  10h
  end;

 Procedure GetRGBPalette(var RGBPalette:tRGBPalette);  assembler;
  asm
   mov ax,1017h
   xor bx,bx
   mov cx,256
   les dx,rgbpalette
   int 10h
  end;

 Procedure SetRGBPalette(var RGBPalette:tRGBPalette); assembler;
  asm
   mov  ax,1012h
   xor  bx,bx
   mov  cx,256
   les  dx,rgbpalette
   int  10h
  end;

 Procedure GetRGB16Page(Index:Byte;var RGBPage:tRGB16Page); assembler;
  asm
   mov ax,1017h
   mov bl,index
   xor bh,bh
   mov cl,4
   shl bx,cl
   mov cx,16
   les dx,rgbpage
   int 10h
  end;

 Procedure SetRGB16Page(Index:Byte;var RGBPage:tRGB16Page); assembler;
  asm
   call waitvretrace
   mov ax,1012h
   mov bl,index
   xor bh,bh
   mov cl,4
   shl bx,cl
   mov cx,16
   les dx,rgbpage
   int 10h
  end;

 Procedure SelectColorPage(Page:Byte); assembler;
  asm
   mov ax,1013h
   mov bl,1
   mov bh,page
   int 10h
  end;

 Procedure SetColorPageMode(Mode:Byte); assembler;
  asm
   mov ax,1013h
   xor bl,bl
   mov bh,mode
   and bh,1
   int 10h
  end;

 Function  ColorPageMode:Byte; assembler;
  asm
   mov ax,101Ah
   int 10h
   mov al,bl
  end;

 Function  ColorPage:Byte; assembler;
  asm
   mov ax,101Ah
   int 10h
   mov al,bh
  end;

 Function GetFontPtr(Font:Byte):Pointer; assembler;
  asm
   push bp
   mov  ax,1130h
   mov  bh,font
   int  10h
   mov  dx,es
   mov  ax,bp
   pop  bp
   {$IFDEF DPMI}
   mov  dx,segC000
   {$ENDIF}
  end;


Procedure WaitVRetrace;
 var StateReg:word;
 begin
  StateReg:=MemW[Seg0040:_crtcport]+6;
  Repeat until Port[StateReg] and 8<>0;
 end;

Procedure WaitHRetrace;
 var StateReg:word;
 begin
  StateReg:=MemW[Seg0040:_crtcport]+6;
  Repeat until Port[StateReg] and 1<>0;
 end;


Function ReadTimer:word; near; assembler;
 asm
  xor  al,al
  out  43h,al
  in   al,40h
  mov  ah,al
  in   al,40h
  xchg al,ah
 end;

Function VFrequency:Word; assembler;
  asm
    mov  es,seg0040
    mov  dx,es:[_crtcport]
    add  dx,6
@@1:in   al,dx
    and  al,8
    jz   @@1
@@2:in   al,dx
    and  al,8
    jnz  @@2
    call ReadTimer
    mov  bx,ax
@@3:in   al,dx
    and  al,8
    jz   @@3
@@4:in   al,dx
    and  al,8
    jnz  @@4
    call ReadTimer
    sub  bx,ax
    shr  bx,1
    jnz  @@5
    mov  bx,$8000
@@5:
    mov  dx,$12
    mov  ax,$34DE
    div  bx
 end;

Function HFrequency:Word; assembler;
  asm
    mov  es,seg0040
    mov  dx,es:[_crtcport]
    add  dx,6
    mov  cx,250
@@1:in   al,dx
    and  al,1
    jz   @@1
@@2:in   al,dx
    and  al,1
    jnz  @@2
    call ReadTimer
    mov  bx,ax
@@3:in   al,dx
    and  al,1
    jz   @@3
@@4:in   al,dx
    and  al,1
    jnz  @@4
    loop @@3
    call ReadTimer
    sub  bx,ax
    shl  bx,1
    mov  dx,$12
    mov  ax,$34DE
    div  bx
 end;

procedure LoadTxtFont(typ,block,bytesPerChar:byte;font:pointer); assembler;
 asm
  mov  ah,11h
  mov  al,typ
  mov  bl,block
  and  bl,7
  mov  bh,BytesPerChar
  mov  cx,256
  xor  dx,dx
  push bp
  les  bp,font
  int  10h
  pop  bp
 end;

procedure SelectFont(BlockA,BlockB:byte); assembler;
 asm
  mov ax,1103h
  mov bh,blockB
  mov bl,blockA
  cmp bl,4
  jb  @@1
  and bl,3
  or  bl,10h
@@1:
  cmp bh,4
  jb  @@2
  and bh,3
  or  bh,10h
@@2:
  shl bh,2
  or  bl,bh
  int 10h
 end;

procedure WriteStr(x,y,color:byte;s:string); assembler;
 asm
   cld
   mov  es,Seg0040
   mov  di,es:[_pageoffs]    { Offset aktive Bildseite }
   mov  ax,es:[_textrows]    { Textspalten             }
   mul  y              { Berechnung des Bildoffset von (x,y): }
   add  al,x           { Offset = ( Spalten * Y + X ) * 2     }
   adc  ah,0
   shl  ax,1
   add  di,ax
   cmp  byte ptr es:[_videomode],7 { Monochrom-Modus ? }
   je   @@1
   mov  es,SegB800     { ES:DI = Zeiger auf Farb-Videoram }
   jmp  @@2
@@1:
   mov  es,SegB000     { Monochrom-Modus: Segment = B000H }
@@2:
   mov  ah,color
   push ds
   lds  si,s           { DS:SI = Zeiger auf String   }
   lodsb
   mov  cl,al
   xor  ch,ch          { CX = Anzahl der Zeichen     }
   or   ah,ah
   jz   @@4
@@3: lodsb             { Zeichen + Attribute schreiben }
     stosw
     loop @@3
   jmp  @@5
@@4: movsb             { Nur Zeichen schreiben        }
     inc  di
     loop @@4
@@5:
   pop  ds
 end;

function interlaced:boolean; assembler;
{ Interlace Mode Register, CRT-Controller }
{ Index 8, Port 3D4h/3D5h , Bit 0         }
{ Lesen nur auf VGA-Karten mglich !      }
 asm
  mov es,seg0040
  mov dx,es:[_crtcport]
  mov al,8
  out dx,al
  inc dx
  in  al,dx
  and al,1
 end;


function isgraphmode:boolean; assembler;
{ Graphic Controller Mode-Register, Bit 0 }
{ Index- /Datenport = $3CE/$3CF, Index 6  }
 asm
  mov dx,3CEh
  mov al,6
  out dx,al
  inc dx
  in  al,dx
  and al,1
 end;

procedure rectangle(x1,y1,x2,y2:integer;color:byte);
 var x,y:integer;
 begin
  for x:=x1 to x2 do
  begin
   putpixel(x,y1,color);
   putpixel(x,y2,color);
  end;
  for y:=y1 to y2 do
  begin
   putpixel(x1,y,color);
   putpixel(x2,y,color);
  end;
 end;

{ Zeilenoffset (VGA) berechnen       }
{ EGA/VGA : (Y * 80) + (X SHR 3)     }
{ input:  ax = y                     }
{         bx = x                     }
{ output: di = offset(x,y)           }
procedure _getvgaoffs; near; assembler;
 asm
   mov  dx,80
   mul  dx
   mov  cl,3
   shr  bx,cl
   add  ax,bx
   mov  di,ax
 end;

{ DI auf nchste Zeile setzen:  }
procedure _getvgadelta; near; assembler;
 asm
   add  di,80
 end;

function getoffs(x,y:word):word; assembler;
 asm
  mov  ax,y
  mov  bx,x
  call _getvgaoffs
 end;

{ Input: BX    = X                                }
{        DL    = Farbe                            }
{        ES:DI = Zeiger auf das Bildspeicherzeile }
procedure _putpixel; near; assembler;
 asm
  mov  cx,bx
  and  cx,7
  mov  al,$80
  shr  al,cl          { AL = 80h shr (x and 7) = BitMask }
  push ax
  mov  cl,3
  shr  bx,cl
  mov  cl,dl
  mov  dx,_gctrl_     { DX = Indexport                   }
  mov  al,gc_setreset { Index fr Set/Reset-Register     }
  out  dx,al
  inc  dx             { DX = Datenport                   }
  mov  al,cl
  out  dx,al          { Farbe ins Set/Reset-Register     }
  dec  dx             { DX = Indexport                   }
  mov  al,gc_sr_enable
  out  dx,al          { Index fr Set/Reset-Enable       }
  inc  dx             { DX = Datenport                   }
  mov  al,0Fh
  out  dx,al          { Fh = Alle Ebenen zulassen        }
  dec  dx             { DX = Indexport                   }
  mov  al,gc_bitmask
  out  dx,al          { BitMask-Register adressieren     }
  inc  dx             { DX = Datenport                   }
  pop  ax
  out  dx,al          { Bitmaske setzen                  }
  inc  byte ptr es:[di+bx]
                      { Lese- & Schreibzugriff auf die Speicheradresse }
  mov  al,$FF
  out  dx,al          { Wieder alle Bits zulassen        }
  dec  dx             { DX = Indexport                   }
  mov  al,gc_sr_enable
  out  dx,al
  inc  dx             { DX = Datenport                   }
  xor  al,al
  out  dx,al          { Allen Ebenen des Set/Reset sperren }
 end;


Procedure PutPixel(x,y:integer;color:byte); assembler;
 asm
  mov  es,segA000     { ES = SegA000 }
  mov  ax,y
  xor  bx,bx
  call _getvgaoffs
  mov  bx,x
  mov  dl,color
  call _putpixel
 end;


{ Line-Prozedur nach dem Bresenham-Algorithmus: }
procedure Line(x1,y1,x2,y2:integer;color:byte); assembler;
 var yy,d_x,d_y,r:integer;
 asm
    mov  es,seg0040
    mov  ax,es:[_textrows]
    mov  yy,ax
    mov  es,SegA000
    mov  bx,x2
    cmp  bx,x1
    jae  @@1
    xchg bx,x1
    mov  x2,bx
    mov  ax,y2
    xchg ax,y1
    mov  y2,ax
@@1:mov  bx,x2
    sub  bx,x1 { BX = DX }
    mov  d_x,bx
    mov  ax,y2
    sub  ax,y1 { AX = DY }
    jae  @@X
    neg  ax
    neg  yy
@@X:mov  d_y,ax
     mov  ax,y1
     xor  bx,bx
     call _getvgaoffs  { ES:DI = Zeiger auf Bildschirm }
     mov  bx,x1
     mov  dl,color
     call _putpixel
    xor  cx,cx
    mov  r,cx
    mov  bx,d_x
    cmp  bx,d_y
    jbe  @@3
@@5:mov  bx,x1
    cmp  bx,x2
    je   @@4
    inc  x1
    mov  dx,d_y
    add  r,dx
    mov  ax,r
    shl  ax,1
    cmp  ax,d_x
    jb   @@6
    inc  y1
    add  di,yy
    mov  ax,d_x
    sub  r,ax
@@6:mov  bx,x1
    mov  dl,color
    call _putpixel
    jmp  @@5
@@3:mov  bx,y1
    cmp  bx,y2
    je   @@4
    inc  y1
    add  di,yy
    mov  ax,d_x
    add  r,ax
    mov  ax,r
    shl  ax,1
    cmp  ax,d_y
    jbe  @@8
    inc  x1
    mov  ax,d_y
    sub  r,ax
@@8:mov  bx,x1
    mov  dl,color
    call _putpixel
    jmp  @@3
@@4:
 end;

procedure BIOSPutPixel(x,y:integer; color:byte); assembler;
{ BIOS-Funktion 0Ch, Intr 10h }
 asm
  mov ah,0Ch
  xor bh,bh
  mov cx,x
  mov dx,y
  mov al,color
  int 10h
 end;

function GetMaxY:word; assembler;
{ BIOS-Datenbereich:
  $40:$84 = Textzeilen - 1
  $40:$85 = Zeilen/Zeichen }
 asm
  mov es,seg0040
  mov al,es:[_textlines]
  inc al
  xor ah,ah
  mul word ptr ES:[_charheight]
  cmp ax,592
  jne @@1
  mov ax,600
@@1:
  cmp ax,344
  jne @@2
  mov ax,350
@@2:
 end;

function GetMaxX:word; assembler;
 asm
  call textrows
  mov  cl,3
  shl  ax,cl
 end;

function getvgainfo:pVgaInfo;
 var p:pVgaInfo;
     al:byte;
 begin
  new(p);
  asm
   mov  ax,1B00h
   xor  bx,bx
   les  di,p
   int  10h
   mov  &al,al
  end;
  if al<>$1B then
  begin
   dispose(p);
   p:=nil;
  end;
  getvgainfo:=p;
 end;

function getmaxcolor:word;
 var p:pVgaInfo;
 begin
  p:=getvgainfo;
  if p=nil then getmaxcolor:=0 else
  begin
   getmaxcolor:=p^.maxcolor;
   dispose(p);
  end;
 end;

function  TextLines:word; assembler;
{ BIOS-Datenbereich $40:$84 = Textzeilen - 1 (BYTE) }
 asm
  mov es,seg0040
  mov al,es:[_textlines]
  inc al
  xor ah,ah
 end;

function  TextRows:word; assembler;
{ BIOS-Datenbereich $40:$4A = Textspalten (WORD) }
 asm
  mov es,seg0040
  mov ax,es:[_textrows]
 end;

procedure SetVideoMode(Mode:byte); assembler;
 asm
  xor ah,ah
  mov al,mode
  int $10
 end;

procedure SetCursorForm(s,e:byte); assembler;
 asm
  mov al,1
  mov ch,s
  mov cl,e
  int 10h
 end;

procedure BIOSWriteStr(x,y,color:byte;s:string); assembler;
 asm
  mov  ax,1301h
  mov  dl,x
  mov  dh,y
  mov  bl,color
  xor  bh,bh
  les  si,s
  mov  cl,es:[si]
  xor  ch,ch
  inc  si
  push bp
  mov  bp,si
  int  10h
  pop  bp
 end;

function Videomode:byte; assembler;
 asm
  mov  ah,$0F
  int  10h
 end;

procedure xPaintStr0(x,y,color:byte;var Font;charheight:word;S:string);
 begin
  asm
   cld
   push  ds
   push  bp
   lea   si,s           { SS:SI = ^String  }
   segss lodsb
   mov   cl,al
   xor   ch,ch        { CX = Stringlnge }
   mov   es,seg0040
   mov   ax,es:[_textrows]     { Al = Bildschirm-Textspalten  }
   mov   dx,cs
   {$IFDEF DPMI}
   add   dx,selectorInc
   {$ENDIF}
   mov   es,dx
   mov   es:[offset @@X + 2],al
   mov   dx,charheight
   mul   y
   push  dx
   mul   dx
   pop   dx
   add   al,x
   adc   ah,0
   mov   di,ax
   mov   es,segA000   { ES:DI = ^Videomem }
   lds   bx,font      { DS:BX = ^Fontdata }
   mov   ch,dl        { CH = Charheight }
   mov   dl,color
   mov   dh,dl
   and   dl,$0F
   shr   dh,4
   mov   bp,dx        { Hi(BP) = HG-Farbe, Lo(BP) = VG-Farbe  }
   mov   dx,$3CE      { DX = Indexport d. Graphic-Controllers }
   mov   al,1         { Enable Set/Reset }
   out   dx,al
   mov   al,$0F       { Alle Ebenen fr Set/Reset-Register freigeben }
   inc   dx
   out   dx,al
   dec   dx
@@2:push  si
    push  di
    push  cx
@@1:xchg  cx,bp       { Farbe nach CX }
    mov   al,8        { Index BitMask }
    out   dx,al
    segss lodsb       { ASCII-Nr. laden }
    xlat              { Bitmuster laden }
    mov   ah,al       { Bitmuster in AH sichern }
    inc   dx
    out   dx,al       { Bitmuster in Bitmaskenregister laden }
    dec   dx
    xor   al,al       { Index Set-Reset-Reg. = 0 }
    out   dx,al
    mov   al,cl
    inc   dx
    out   dx,al       { Vordergrundfarbe setzen  }
    dec   dx
    inc   byte ptr es:[di]
    mov   al,8        { Index Bitmaske }
    out   dx,al
    mov   al,ah
    not   al
    inc   dx
    out   dx,al       { Bitmaske f. Hintergrund setzen }
    dec   dx
    xor   al,al       { Set-Reset adressieren }
    out   dx,al
    mov   al,ch
    inc   dx
    out   dx,al       { Hintergrundfarbe setzen }
    dec   dx
    inc   byte ptr es:[di]
    inc   di          { Nchstes Bildschirmbyte }
    xchg  bp,cx       { CX = Zhler             }
    dec   cl          { CL = 0 ?                }
    jnz   @@1
    pop   cx
    pop   di
    pop   si
    dec   ch          { Alle Zeilen bearbeitet ? }
    jz    @@3
    add   bx,256      { Nchste Scanzeile im Font }
@@X:add   di,80       { Nchste Scanzeile auf dem Bildschirm }
    jmp   @@2
@@3:mov   al,1
    out   dx,al
    xor   al,al
    inc   dx
    out   dx,al       { Alle Ebenen fr Set/Reset sperren }
    dec   dx
    mov   al,8
    out   dx,al
    mov   al,$FF
    inc   dx
    out   dx,al       { Alle Bits zulassen }
    dec   dx
   pop  bp
   pop  ds
  end;
 end;

procedure xPaintStr2(x,y,color:byte;var Font;charheight:word;S:string);
 begin
  asm
   cld
   push  ds
   push  bp
   lea   si,s           { SS:SI = ^String  }
   segss lodsb
   mov   cl,al
   xor   ch,ch          { CX = Stringlnge }
   mov  es,seg0040
   mov  ax,es:[_textrows]     { Al = Bildschirm-Textspalten  }
   mov  dx,cs
   {$IFDEF DPMI}
   add  dx,selectorInc
   {$ENDIF}
   mov  es,dx
   mov  es:[offset @@X + 2],al
   mov   dx,charheight
   mul   y
   push  dx
   mul   dx
   pop   dx
   add   al,x
   adc   ah,0
   mov   di,ax
   mov   es,segA000   { ES:DI = ^Videomem }
   lds   bx,font      { DS:BX = ^Fontdata }
   mov   ch,dl        { CH = Charheight }
   mov   dl,color
   mov   dh,dl
   and   dl,$0F
   shr   dh,4
   mov   bp,dx        { Hi(BP) = HG-Farbe, Lo(BP) = VG-Farbe  }
   mov   dx,$3CE      { DX = Indexport d. Graphic-Controllers }
   mov   al,5         { Mode Register }
   out   dx,al
   mov   al,2
   inc   dx
   out   dx,al        { Schreibmodus 2 einstellen }
   dec   dx
   mov   al,8
   out   dx,al        { Bitmasken-Register adressieren }
   inc   dx           { Datenregister einstellen       }
@@2:push  si
    push  di
    push  cx
@@1: xchg  cx,bp       { Farbe nach CX }
     segss lodsb       { ASCII-Nr. laden }
     xlat              { Bitmuster laden }
     out   dx,al       { Bitmuster in Bitmaskenregister laden }
     mov   es:[di],cl  { Vordergrundfarbe in Bildspeicher     }
     not   al
     out   dx,al       { Bitmaske f. Hintergrund setzen }
     mov   ah,es:[di]
     mov   es:[di],ch { Hintergrundfarbe in Bildspeicher }
     inc   di          { Nchstes Bildschirmbyte }
     xchg  bp,cx       { CX = Zhler             }
    dec   cl          { CL = 0 ?                }
    jnz   @@1
    pop   cx
    pop   di
    pop   si
    dec   ch          { Alle Zeilen bearbeitet ? }
    jz    @@3
    add   bx,256      { Nchste Scanzeile im Font }
@@X:add   di,80       { Nchste Scanzeile auf dem Bildschirm }
    jmp   @@2
@@3:mov   al,$FF
    out   dx,al       { Alle Bits zulassen }
    dec   dx          { DX = Indexregister }
    mov   al,5
    out   dx,al
    inc   dx
    xor   al,al
    out   dx,al       { Schreibmodus 0 einstellen }
   pop  bp
   pop  ds
  end;
 end;

procedure xPaintStr3(x,y,color:byte;var Font;charheight:word;S:string);
 begin
  asm
   cld
   push  ds
   lea   si,s           { SS:SI = ^String  }
   segss lodsb
   mov   cl,al
   xor   ch,ch          { CX = Stringlnge }
   mov  es,seg0040
   mov  ax,es:[_textrows]     { Al = Bildschirm-Textspalten  }
   mov  dx,cs
   {$IFDEF DPMI}
   add  dx,selectorInc
   {$ENDIF}
   mov  es,dx
   mov  es:[offset @@X + 2],al
   mov   dx,charheight
   mul   y
   push  dx
   mul   dx
   pop   dx
   add   al,x
   adc   ah,0
   mov   di,ax
   mov   es,segA000    { ES:DI = ^Videomem                      }
   lds   bx,font       { DS:BX = ^Fontdata                      }
   mov   ch,dl         { CH = Charheight                        }
   mov   dl,color
   mov   dh,dl
   and   dl,$0F
   shr   dh,4
   push  dx
   mov   dx,$3CE       { DX = Indexport d. Graphic-Controllers  }
   mov   al,5          { Mode Register                          }
   out   dx,al
   mov   al,3
   inc   dx
   out   dx,al         { Schreibmodus 3 einstellen              }
   dec   dx
   xor   al,al         { Index Set/Reset-Register               }
   out   dx,al
   inc   dx            { Datenregister adressieren              }
   pop   ax            { AH = HG-Farbe, AL = VG-Farbe           }
@@2:out   dx,al        { Vordergrundfarbe einstellen            }
      push  ax         { Farben sichern                         }
      push  cx         { Zhler sichern                         }
      push  si         { Stringoffset sichern                   }
      push  di         { VGA-Offset sichern                     }
      xor   ch,ch      { Nur Zeichenzhler                      }
@@11: segss lodsb      { ASCII-Nr. laden                        }
      xlat             { In Bitmaske bersetzen                 }
      stosb            { In Bildschirmspeicher schreiben        }
      loop  @@11
      pop   di         { Register restaurieren                   }
      pop   si
      pop   cx
      pop   ax
    xchg  al,ah
    out   dx,al        { Hintergrundfarbe einstellen             }
    xchg  al,ah
      push  ax         { Farben sichern                          }
      push  cx         { Zhler sichern                          }
      push  si         { Stringoffset sichern                    }
      push  di         { VGA-Offset sichern                      }
      xor   ch,ch      { Nur Zeichenzhler                       }
@@21: segss lodsb      { ASCII-Nr. laden                         }
      xlat             { In Bitmaske bersetzen                  }
      not   al         { Invertieren                             }
      mov   ah,es:[di] { Mit Lesezugriff die Latchregister laden }
      stosb            { In Bildschirmspeicher schreiben         }
      loop  @@21
      pop   di         { Register restaurieren                   }
      pop   si
      pop   cx
      pop   ax
    dec   ch
    jz    @@exit
    add   bx,256      { Nchste Zeile der Fontdaten              }
@@X:add   di,80       { Nchste Bildschirmzeile                  }
    jmp   @@2
@@exit:
    dec   dx          { DX = Indexregister                       }
    mov   al,5        { Index des Modusregister                  }
    out   dx,al
    inc   dx
    xor   al,al
    out   dx,al       { Schreibmodus 0 einstellen                }
    pop   ds
  end;
 end;

procedure PaintStr0(x,y,color:byte;var Font;charheight:word;S:string);
 begin
  asm
   cld
   push ds
   push bp
   mov  cx,charheight   { CL = Charheight              }
   mov  es,seg0040
   mov  ax,es:[_textrows]     { Al = Bildschirm-Textspalten  }
   mov  dx,cs
   {$IFDEF DPMI}
   add  dx,selectorInc
   {$ENDIF}
   mov  es,dx
   mov  es:[offset @@X + 2],al
   mov  es:[offset @@Y + 2],al
   mul  y
   mul  cx
   add  al,x
   adc  ah,0
   mov  es,segA000
   mov  di,ax           { ES:DI = Zeiger auf VGA-RAM   }
   mov  bl,color
   mov  bh,bl
   and  bl,$0F          { BL = Vordergrundfarbe        }
   shr  bh,4            { BH = Hintergrundfarbe        }
   lds  si,font         { DS:SI = Zeiger auf Fontdaten }
   lea  bp,s            { SS:BP = Zeiger auf String    }
   mov  ch,[bp]         { CH = Stringlnge             }
   mov  dx,$3CE         { DX = Indexport               }
   mov  al,1            { Enable Set/Reset             }
   out  dx,al
   mov  al,$0F          { Alle Ebenen zulassen         }
   inc  dx
   out  dx,al
   dec  dx
@@1:push si
    push cx
    inc  bp
    mov  al,[bp]
    mul  cl
    add  si,ax
    xor  al,al      { Set/Reset-Register          }
    out  dx,al
    mov  al,bl
    inc  dx
    out  dx,al      { Farbwert Vordergrund setzen }
    dec  dx
     { Bitmasken schreiben         }
     mov  al,8       { Bit-Mask-Register }
     out  dx,al
     inc  dx
     push cx
     push di
     push si
     xor  ch,ch
@@11: lodsb          { Fontbyte laden               }
      out  dx,al     { In Bitmaskregister schreiben }
      inc  byte ptr es:[di] { Speicherzugriff }
@@X:  add  di,80     { Nchste Zeile  }
      loop @@11
     pop  si
     pop  di
     pop  cx
     dec  dx
    xor  al,al
    out  dx,al
    mov  al,bh      { Farbwert Hintergrund setzen }
    inc  dx
    out  dx,al
    dec  dx
    { Inverse Bitmasken schreiben }
     mov  al,8       { Bit-Mask-Register }
     out  dx,al
     inc  dx
     push cx
     push di
     push si
     xor  ch,ch
@@21: lodsb          { Fontbyte laden               }
      not  al        { Fontbyte invertieren         }
      out  dx,al     { In Bitmaskregister schreiben }
      inc  byte ptr es:[di] { Speicherzugriff }
@@Y:  add  di,80     { Nchste Zeile  }
      loop @@21
     pop  si
     pop  di
     pop  cx
     dec  dx
    pop  cx
    pop  si
    inc  di
    dec  ch
    jz   @@exit
    jmp  @@1
@@exit:
   pop  bp
   pop  ds
  end;
 end;

procedure PaintStr2(x,y,color:byte;var Font;charheight:word;S:string); assembler;
 var Offs:word;
  asm
   cld
   mov  ax,ss
   mov  bx,s.word[0]
   mov  offs,bx
   cmp  ax,s.word[2]
   je   @@0
   mov  dx,ds
   lds  si,s
   mov  es,ax
   mov  cl,[si]
   xor  ch,ch
   inc  cx
   sub  sp,cx
   mov  di,sp
   mov  offs,di
   shr  cx,1
   jnc  @@00
   movsb
@@00:
   rep  movsw
   mov  ds,dx
@@0:
   push ds
   mov  bl,color
   mov  bh,bl
   and  bl,$0F          { BL = Vordergrundfarbe        }
   mov  cl,4
   shr  bh,cl           { BH = Hintergrundfarbe        }
   mov  es,seg0040
   mov  ax,es:[_textrows]     { AX = Bildschirm-Textspalten }
   mov  dx,cs
   {$IFDEF DPMI}
   add  dx,selectorinc
   {$ENDIF}
   mov  es,dx
   mov  es:[offset @@X+2],al
   mov  cx,charheight   { CL = Charheight              }
   mul  y
   mul  cx
   add  al,x
   adc  ah,0
   mov  di,ax
   mov  es,segA000      { ES:DI = Zeiger auf VGA-RAM   }
   mov  si,offs
   mov  ch,ss:[si]      { CH = Stringlnge             }
   lds  si,font         { DS:SI = Zeiger auf Fontdaten }

   mov  dx,$3CE         { DX = Indexport               }
   mov  al,5            { Mode Register                }
   out  dx,al
   mov  al,$02          { Schreibmodus 2 einstellen    }
   inc  dx
   out  dx,al
   dec  dx
   mov  al,8            { Bit-Mask-Register }
   out  dx,al
   inc  dx              { DX = Datenport         }
@@1:push di
    push si
    push cx
    inc  offs
     push bx
     mov  bx,offs
     mov  al,ss:[bx]    { Asciizeichen laden }
     pop  bx
    mul  cl            { Offset in den Font berechnen }
    add  si,ax
    xor  ch,ch         { Innere Schleife: nur ber Zeichenzeilen }
@@2: lodsb             { Fontbyte laden }
     out  dx,al
     mov  es:[di],bl    { Vordergrundfarbe schreiben }
     not  al
     out  dx,al
     mov  ah,es:[di]    { Lesezugriff, um die Latchregister zu laden; sonst }
                        { wird die bereits gesetzte Vordergrundfarbe berschrieben }
     mov  es:[di],bh    { Hintergrundfarbe schreiben }
@@X: add  di,80         { Nchste Zeile              }
     loop @@2
    pop  cx
    pop  si
    pop  di
    inc  di
    dec  ch
    jnz  @@1
   mov  al,$FF
   out  dx,al
   dec  dx             { Indexport      }
   mov  al,5           { Mode Register  }
   out  dx,al
   xor  al,al          { Schreibmodus 0 }
   inc  dx
   out  dx,al
   pop  ds
  end;

procedure PaintStr3(x,y,color:byte;var Font;charheight:word;S:string); assembler;
 var OFFS:word;
  asm
   cld
   mov  ax,ss
   mov  bx,s.word[0]
   mov  offs,bx
   cmp  ax,s.word[2]
   je   @@0
   mov  dx,ds
   lds  si,s
   mov  es,ax
   mov  cl,[si]
   xor  ch,ch
   inc  cx
   sub  sp,cx
   mov  di,sp
   mov  offs,di
   shr  cx,1
   jnc  @@00
   movsb
@@00:
   rep  movsw
   mov  ds,dx
@@0:
   push ds
   mov  bl,color
   mov  bh,bl
   and  bl,$0F          { BL = Vordergrundfarbe        }
   mov  cl,4
   shr  bh,cl           { BH = Hintergrundfarbe        }
   mov  es,seg0040
   mov  ax,es:[_textrows]     { AX = Bildschirm-Textspalten }
   mov  dx,cs
   {$IFDEF DPMI}
   add  dx,selectorinc
   {$ENDIF}
   mov  es,dx
   mov  es:[offset @@X+2],al
   mov  cx,charheight   { CL = Charheight              }
   mul  y
   mul  cx
   add  al,x
   adc  ah,0
   mov  di,ax
   mov  es,segA000      { ES:DI = Zeiger auf VGA-RAM   }
   mov  si,offs
   mov  ch,ss:[si]      { CH = Stringlnge             }
   lds  si,font         { DS:SI = Zeiger auf Fontdaten }
   mov  dx,$3CE         { DX = Indexport               }
   mov  al,5            { Mode Register                }
   out  dx,al
   mov  al,$03          { Schreibmodus 3 einstellen    }
   inc  dx
   out  dx,al
   dec  dx
   xor  al,al           { Set/Reset-Register          }
   out  dx,al
   inc  dx              { Datenregister adressieren   }
   push bp
   mov  bp,offs
@@1:push di
    push si
    push cx
    inc  bp
    mov  al,[bp]    { Ascii-Zeichen laden                    }
    mul  cl         { Mit Anzahl Byte/Zeichen multiplizieren }
    xor  ch,ch      { Schleifen nur ber die Bytes/Zeichen   }
    add  si,ax      { Zum Fontoffset addieren                }
@@10:
     mov  al,bl     { Farbwert Vordergrund setzen }
     out  dx,al
     lodsb           { Datenbyte laden             }
     mov  ah,al
     mov  es:[di],al { Bitmaske schreiben          }
     mov  al,bh      { Farbwert Hintergrund setzen }
     out  dx,al
     not  ah
     xchg ah,es:[di] { Lese- und Schreibzugriff    }
@@X: add  di,80      { Nchste Graphikzeile        }
     loop @@10
    pop  cx
    pop  si
    pop  di
    inc  di
    dec  ch
    jnz  @@1
   pop  bp
   dec  dx          { Indexregister setzen }
   mov  al,5        { Mode Register        }
   out  dx,al
   xor  al,al       { Schreibmodus 0       }
   inc  dx
   out  dx,al
   pop  ds
 end;

procedure PaintBuf3(x,y,w:byte;var Font;charheight:word;Var S); assembler;
 var LineWidth:word;
  asm
   cld
   mov  ax,ss
   mov  bx,s.word[0]
   cmp  ax,s.word[2]
   je   @@0
    mov  dx,ds
    mov  cl,w
    xor  ch,ch
    lds  si,s
    push ss
    pop  es
    sub  sp,cx
    sub  sp,cx
    mov  bx,sp
    mov  di,bx
    rep  movsw
    mov  ds,dx
@@0:                    { SS:BX = Zeiger auf Puffer    }
   push ds
   mov  es,seg0040
   mov  ax,es:[_textrows]     { AX = Bildschirm-Textspalten }
   mov  dx,cs
   {$IFDEF DPMI}
   add  dx,selectorInc
   {$ENDIF}
   mov  es,dx
   mov  es:[OFFSET @@X+2],al
   mov  cx,charheight   { CL = Charheight              }
   mul  y
   mul  cx
   add  al,x
   adc  ah,0
   mov  di,ax
   mov  es,segA000      { ES:DI = Zeiger auf VGA-RAM   }
   mov  ch,w            { CH = Pufferlnge             }
   lds  si,font         { DS:SI = Zeiger auf Fontdaten }
   mov  dx,$3CE         { DX = Indexport               }
   mov  al,5            { Mode Register                }
   out  dx,al
   mov  al,$03          { Schreibmodus 3 einstellen    }
   inc  dx
   out  dx,al
   dec  dx
   xor  al,al           { Set/Reset-Register          }
   out  dx,al
   inc  dx              { Datenregister adressieren   }
   push bp
   mov  bp,bx
@@1:push di
    push si
    push cx
    mov  ax,[bp] { Ascii-Zeichen laden                    }
    mov  bl,ah
    mov  bh,bl
    and  bl,$0F     { BL = Vordergrundfarbe        }
    shr  bh,4       { BH = Hintergrundfarbe        }
    mul  cl         { Mit Anzahl Byte/Zeichen multiplizieren }
    xor  ch,ch      { Schleifen nur ber die Bytes/Zeichen   }
    add  si,ax      { Zum Fontoffset addieren                }
@@10:
     mov  al,bl     { Farbwert Vordergrund setzen }
     out  dx,al
     lodsb           { Datenbyte laden             }
     mov  ah,al
     mov  es:[di],al { Bitmaske schreiben          }
     mov  al,bh      { Farbwert Hintergrund setzen }
     out  dx,al
     not  ah
     xchg ah,es:[di] { Lese- und Schreibzugriff }
@@X: add  di,80      { Nchste Zeile            }
     loop @@10
    pop  cx
    pop  si
    pop  di
    add  bp,2
    inc  di
    dec  ch
    jnz  @@1
   pop  bp
   dec  dx          { Indexregister setzen }
   mov  al,5        { Mode Register        }
   out  dx,al
   xor  al,al       { Schreibmodus 0       }
   inc  dx
   out  dx,al
   pop  ds
 end;

procedure PaintBuf2(x,y,w:byte;var Font;charheight:word;Var S); assembler;
 var LineWidth:word;
  asm
   { Implizit: PUSH BP
               MOV  BP,SP  }
   cld
   mov  bx,S.word[0]
   mov  ax,ss
   cmp  ax,S.word[2]    { Liegt S im Stacksegment ?    }
   je   @@0
   mov  dx,ds
   mov  si,bx
   mov  cl,w
   xor  ch,ch
   mov  bx,cx
   shl  bx,1
   sub  sp,bx
   mov  bx,sp
   mov  es,ax
   mov  ds,s.word[2]
   mov  di,bx
   rep  movsw
   mov  ds,dx
@@0:                    { SS:BX = Zeiger auf S         }
   push ds
   push bp
   mov  es,seg0040
   mov  ax,es:[_textrows]     { AX = Bildschirm-Textspalten }
   mov  dx,cs
   {$IFDEF DPMI}
   add  dx,selectorInc
   {$ENDIF}
   mov  es,dx
   mov  es:[OFFSET @@X+2],al
   mul  y
   mov  cx,charheight   { CL = Charheight              }
   mul  cx
   add  al,x
   adc  ah,0
   mov  es,segA000
   mov  di,ax           { ES:DI = Zeiger auf VGA-RAM   }
   lds  si,font         { DS:SI = Zeiger auf Fontdaten }
   mov  ch,w            { CH = Stringlnge             }
   mov  dx,$3CE         { DX = Indexport               }
   mov  al,5            { Mode Register                }
   out  dx,al
   mov  al,$02          { Schreibmodus 2 einstellen    }
   inc  dx
   out  dx,al
   dec  dx
   mov  al,8            { Bit-Mask-Register }
   out  dx,al
   inc  dx              { Datenport         }
   mov  bp,bx           { SS:BP = Zeiger auf String    }
@@1:push di
    push si
    push cx
    mov  ax,[bp]        { ASCII-Zeichen nach AL, Farbe nach AH }
    inc  bp
    inc  bp
    mov  bl,ah
    mov  bh,ah
    and  bl,$0F        { BL = Vordergrundfarbe                   }
    shr  bh,4          { BH = Hintergrundfarbe                   }
    mul  cl
    add  si,ax
    xor  ch,ch         { Innere Schleife: nur ber Zeichenzeilen }
@@2: lodsb             { Fontbyte laden }
     out  dx,al        { Bitmuster Vordergrund      }
     mov  es:[di],bl   { Vordergrundfarbe schreiben }
     not  al
     out  dx,al        { Bitmuster Hintergrund                }
     mov  al,es:[di]   { Mit Lesezugriff Latch-Register laden }
     mov  es:[di],bh   { Hintergrundfarbe schreiben           }
@@X: add  di,80        { Nchste Zeile                        }
     loop @@2
    pop  cx
    pop  si
    pop  di
    inc  di            { Nchstes Bildschirmzeichen }
    dec  ch
    jnz  @@1
   dec  dx             { Indexport      }
   mov  al,5           { Mode Register  }
   out  dx,al
   xor  al,al          { Schreibmodus 0 }
   inc  dx
   out  dx,al
   pop  bp
   pop  ds
 end;

procedure xPaintBuf2(x,y,w:byte;var Font;charheight:word;var S); assembler;
  asm
   cld
   mov  bx,S.word[0]
   mov  ax,ss
   cmp  ax,S.word[2]    { Liegt S im Stacksegment ?    }
   je   @@0
   mov  dx,ds
   mov  si,bx
   mov  cl,w
   xor  ch,ch
   mov  bx,cx
   shl  bx,1
   sub  sp,bx
   mov  bx,sp
   mov  es,ax
   mov  ds,S.word[2]
   mov  di,bx
   rep  movsw
   mov  ds,dx
@@0:                    { SS:BX = Zeiger auf S         }
   mov  si,bx           { SS:SI = Zeiger auf S         }
   push  ds
   mov   cl,w
   mov  es,seg0040
   mov  ax,es:[_textrows]     { AX = Bildschirm-Textspalten }
   mov  dx,cs
   {$IFDEF DPMI}
   add  dx,selectorInc
   {$ENDIF}
   mov  es,dx
   mov  es:[OFFSET @@X+2],al
   mul   y
   mul   charheight
   add   al,x
   adc   ah,0
   mov   di,ax
   mov   es,segA000            { ES:DI = ^Videomem }
   mov   ch,charheight.byte[0] { CH = Charheight }
   lds   bx,font               { DS:BX = ^Fontdata }
   mov   dx,$3CE      { DX = Indexport d. Graphic-Controllers }
   mov   al,5         { Mode Register }
   out   dx,al
   mov   al,2
   inc   dx
   out   dx,al        { Schreibmodus 2 einstellen }
   dec   dx
   mov   al,8
   out   dx,al        { Bitmasken-Register adressieren }
   inc   dx           { Datenregister einstellen       }
@@2:push  si
    push  di
    push  cx
    xor   ch,ch
@@1: segss lodsw       { ASCII-Nr. + Attribut laden }
     xlat              { Bitmuster laden }
     push  bx
     mov   bl,ah
     mov   bh,ah
     and   bl,$0F      { BL = Vordergrundfarbe }
     shr   bh,4        { BH = Hintergrundfarbe }
     out   dx,al       { Bitmuster in Bitmaskenregister laden }
     mov   es:[di],bl  { Vordergrundfarbe in Bildspeicher     }
     not   al
     out   dx,al       { Bitmaske f. Hintergrund setzen }
     xchg  bh,es:[di]  { Hintergrundfarbe in Bildspeicher }
     inc   di          { Nchstes Bildschirmbyte }
     pop   bx
    loop  @@1
    pop   cx
    pop   di
    pop   si
    dec   ch          { Alle Zeilen bearbeitet ? }
    jz    @@3
    add   bx,256      { Nchste Scanzeile im Font }
@@X:add   di,80       { Nchste Scanzeile auf dem Bildschirm }
    jmp   @@2
@@3:mov   al,$FF
    out   dx,al       { Alle Bits zulassen }
    dec   dx          { DX = Indexregister }
    mov   al,5
    out   dx,al
    inc   dx
    xor   al,al
    out   dx,al       { Schreibmodus 0 einstellen }
   pop  ds
   mov  sp,bp
 end;

begin
 {$IFDEF DPMI}
 SegC000:=Ofs(__C000H);
 {$ENDIF}
end.