{***************************************************************************}
{                                                                           }
{          Copyright (C) Christian Baumgarten, Hamburg 1993.                }
{                                                                           }
{  DPMI- und Realmode-Unit fr den Umgang mit Variablen von mehr als 64 KB  }
{                                                                           }
{***************************************************************************}

UNIT VMEM32;

INTERFACE

function SubPtr(p_hi,p_lo:pointer):Longint;
Function IncPtr(p:pointer;Offset:LongInt):pointer;
Function DecPtr(p:pointer;offset:Longint):pointer;
Function SameArea(p1,p2:pointer):boolean;

Function EqualAt(p1,p2:pointer;Count:Longint):pointer;
{ Vergleicht zwei Datenbereiche und liefert Zeiger auf das      }
{ erste Byte einer bereinstimmung relativ zu p1.               }
{ Wird innerhalb der von                                        }
{ Count gesetzten Grenzen keinerlei bereinstimmung gefunden,   }
{ so ist der Rckgabewert NIL.                                  }

Function UnEqualAt(p1,p2:pointer;Count:Longint):pointer;
{ Vergleicht zwei Datenbereiche und liefert Zeiger auf das      }
{ erste Byte einer Differenz relativ zu p1.                     }
{ Wird innerhalb der durch Count gesetzten Grenzen keinerlei    }
{ Differenz gefunden, so ist der Rckgabewert NIL, d.h. die     }
{ Datenbereiche sind ber Count Bytes identisch.                }

Procedure _MoveUp(p1,p2:pointer;Count:Longint);
{ Bewegt Count Bytes von p1^ nach p2^. berschneiden sich die   }
{ Bereiche, so mu die Addresse von p1 kleiner als die von p2   }
{ sein, damit keine berschneidungen auftreten.                 }

Procedure _MoveDn(p1,p2:pointer;Count:Longint);
{ Bewegt Count Bytes von p1^ nach p2^. berschneiden sich die   }
{ Bereiche, so mu die Addresse von p1 grsser als die von p2   }
{ sein, damit keine berschneidungen auftreten.                 }

Function FindByte(what:byte;where:pointer;Len:Longint):pointer;
{ Liefert Zeiger auf das erste Byte im Datenbereich mit dem Wert }
{ What. Ist kein solches Byte vorhanden, so ist das Ergebnis NIL }

Procedure FillByte(what:byte;where:pointer;Len:Longint);
{ Fllt einen Datenbereich der Lnge Len mit dem Byte What. }

Procedure FillWord(what:word;where:pointer;Len:Longint);
{ Fllt einen Datenbereich der Lnge Len mit dem Wort What. }

Function FindBuf(buf:pointer;buflen:Longint;Where:pointer;Len:Longint):Pointer;
{ Durchsucht den Datenbereich Where der Lnge Len nach Buf und liefert }
{ im Erfolgsfall einen Zeiger relativ zu where auf die                 }
{ gefundene Sequenz zurck, ansonsten NIL.                             }

Function FindStr(S:string;Where:pointer;Len:Longint):Pointer;
{ Entspricht FindBuf, nur fr Strings. }

Procedure InsertBuf(source,dest:pointer;count,pos,dmaxlen:longint;var dlen:Longint);
{ Von Source Count Bytes an die Position Pos in Dest transferieren, wobei }
{ dLen Bytes in dest belegt sind und maximal dmaxlen Bytes in Dest zur    }
{ Verfgung stehen.                                                       }

Procedure DeleteBuf(p:pointer;pos,count:longint;var dlen:longint);
{ Im Datenbereich p count Bytes ab Position pos lschen und }
{ nachfolgende Daten nach vorn schieben.                    }


IMPLEMENTATION

Function SameArea(p1,p2:pointer):boolean; assembler;
 asm
       mov  ax,p1.word[2]
       mov  bx,p2.word[2]
       cmp  ax,bx
       je   @@2
       ja   @@1
       xchg ax,bx
@@1:   sub ax,bx        { Differenz der Selektoren bilden }
       div selectorInc  { Durch SelectorInc teilen        }
       or  dx,dx        { Rest = 0 ?                      }
       je  @@2          { Wenn ja, so ist SameArea=TRUE   }
       xor al,al
       jmp @@3
@@2:   mov al,1
@@3:
 end;

Function IncPtr(p:pointer;Offset:LongInt):pointer; assembler;
 asm
  les bx,p
  add bx,&offset.word[0]
  mov ax,&offset.word[2]
  mul selectorinc
  mov dx,es
  add dx,ax
  mov ax,bx
 end;

function SubPtr(p_hi,p_lo:pointer):Longint; assembler;
 asm
  les bx,p_hi
  mov ax,es
  sub ax,p_lo.word[2]
  je  @@1
  xor dx,dx
  div selectorinc
@@1:
  mov dx,ax
  sub bx,p_lo.word[0]
  mov ax,bx
 end;

Function DecPtr(p:pointer;offset:Longint):pointer; assembler;
 asm
    les  bx,p
    mov  ax,&offset.word[2]
    sub  bx,&offset.word[0]
    adc  ax,0
    mul  selectorinc
    mov  dx,es
    sub  dx,ax
    mov  ax,bx
 end;


{ Input: CX = Count fr Stringoperation }
{        SI/DI = Offset auf Strings     }
{ Falls der Offset zu hoch ist, als da sauber CX-mal die Operation }
{ ausgefhrt werden kann, so wird CX entsprechend vermindert. Der   }
{ Rest des Zhlers steht dann in DX.                                }
procedure check_cx_up; near; assembler;
 asm
     xor dx,dx
     mov ax,cx
     add ax,di
     jnc @@1
     mov dx,ax
@@1: mov ax,cx
     add ax,si
     jnc @@2
     cmp ax,dx
     jbe @@2
     mov dx,ax
@@2: sub cx,dx
 end;

{ Input: CX = Count fr Stringoperation }
{        SI/DI = Offset auf Strings     }
{ Falls der Offset zu hoch ist, als da sauber CX-mal die Operation }
{ ausgefhrt werden kann, so wird CX entsprechend vermindert. Der   }
{ Rest des Zhlers steht dann in DX.                                }
procedure check_cx_dn; near; assembler;
 asm
     xor dx,dx
     cmp di,cx
     jae @@1
     mov dx,cx
     sub dx,di
@@1: cmp si,cx
     jae @@2
     mov ax,cx
     sub ax,si
     cmp ax,dx
     jbe @@2
     mov dx,ax
@@2: sub cx,dx
 end;

{ Input DS:SI,ES:DI = Pointer, die gecheckt werden: Ist SI oder DI gleich }
{ Null, so wird zu DS bzw. ES SelectorInc addiert                         }
{ SelectorInc muss in einer lokalen Variablen an der Addresse [BP-2] zur  }
{ Verfgung gestellt werden !!                                            }
procedure check_si_di_up; near; assembler;
 asm
     or  di,di
     jne @@1
     mov  ax,es
     add  ax,[bp-2]
     mov es,ax
@@1: or  si,si
     jne @@2
     mov ax,ds
     add ax,[bp-2]
     mov ds,ax
@@2:ret
 end;

{ Input DS:SI,ES:DI = Pointer, die gecheckt werden: Ist SI oder DI gleich }
{ Null, so wird zu DS bzw. ES SelectorInc subtrahiert                     }
{ SelectorInc muss in einer lokalen Variablen an der Addresse [BP-2] zur  }
{ Verfgung gestellt werden !!                                            }
procedure check_si_di_dn; near; assembler;
 asm
     cmp di,$FFFF
     jne @@1
     mov  ax,es
     sub  ax,[bp-2]
     mov es,ax
@@1: cmp si,$FFFF
     jne @@2
     mov ax,ds
     sub ax,[bp-2]
     mov ds,ax
@@2:ret
 end;

{ Ersatz fr den CPU-Befehl repne cmpsb bei Directionflag = 0 ! }
{ INPUT    BX:CX = Count                                        }
{          DS:SI = Source                                       }
{          ES:DI = Dest                                         }
{          [BP-2] = SelectorInc                                 }
Procedure repne_cmpsb; near; assembler;
 asm
@@0: call check_cx_up
     repne cmpsb
     pushf
     call check_si_di_up
     add  cx,dx
     popf
     pushf
     je   @@e
     jcxz @@5
     popf
     jmp  @@0
@@5: or   bx,bx
     je   @@e
     popf
     cmpsb
     pushf
     dec  bx
     mov  cx,$FFFF
     call check_si_di_up
     popf
     je   @@e1
     jmp  @@0
@@e: popf
@@e1:
 end;

{ Ersatz fr den CPU-Befehl repe cmpsb bei Directionflag = 0 ! }
{ INPUT    BX:CX = Count                                       }
{          DS:SI = Source                                      }
{          ES:DI = Dest                                        }
{          [BP-2] = SelectorInc                                }
Procedure repe_cmpsb; near; assembler;
 asm
@@0: call check_cx_up
     repe cmpsb
     pushf
     call check_si_di_up
     add  cx,dx
     popf
     pushf
     jne  @@e
     jcxz @@5
     popf
     jmp  @@0
@@5: or   bx,bx
     je   @@e
     popf
     cmpsb
     pushf
     dec  bx
     mov  cx,$FFFF
     call check_si_di_up
     popf
     jne  @@e1
     jmp  @@0
@@e: popf
@@e1:
 end;

{ Ersatz fr den CPU-Befehl rep movsw bei Directionflag = 0 ! }
{ INPUT    BX:CX = Count                                      }
{          DS:SI = Source                                     }
{          ES:DI = Dest                                       }
{          [BP-2] = SelectorInc                               }
Procedure rep_movsw_up; near; assembler;
 asm
@@0: call check_cx_up
     shr  cx,1
     jnc  @@1
     movsb
@@1: rep  movsw
     call check_si_di_up
     add  cx,dx
     jcxz @@5
     jmp  @@0
@@5: or   bx,bx
     je   @@e
     movsb
     dec  bx
     mov  cx,$FFFF
     call check_si_di_up
     jmp  @@0
@@e:
 end;

{ Ersatz fr den CPU-Befehl rep movsb bei Directionflag = 0 ! }
{ INPUT    BX:CX = Count                                      }
{          DS:SI = Source                                     }
{          ES:DI = Dest                                       }
{          [BP-2] = SelectorInc                               }
Procedure rep_movsb_up; near; assembler;
 asm
@@1: call check_cx_up
     rep  movsb
     call check_si_di_up
     add  cx,dx
     jcxz @@2
     jmp  @@1
@@2: or   bx,bx
     je   @@e
     movsb
     dec  bx
     mov  cx,$FFFF
     call check_si_di_up
     jmp  @@1
@@e:
 end;

{ Ersatz fr den CPU-Befehl rep movsw bei Directionflag = 1 ! }
{ INPUT    BX:CX = Count                                      }
{          DS:SI = Source                                     }
{          ES:DI = Dest                                       }
{          [BP-2] = SelectorInc                               }
Procedure rep_movsw_dn; near; assembler;
 asm
@@0: call check_cx_dn
     shr  cx,1
     jnc  @@1
     movsb
@@1: dec  si
     dec  di
     rep  movsw
     call check_si_di_dn
     add  cx,dx
     jcxz @@5
     jmp  @@0
@@5: or   bx,bx
     je   @@e
     movsb
     dec  bx
     mov  cx,$FFFF
     call check_si_di_dn
     jmp  @@0
@@e:
 end;


{ Ersatz fr Move(), wenn physikalische Adresse von Source>Dest }
Procedure _MoveDn(p1,p2:pointer;Count:Longint); assembler;
 var s_inc:word;
 asm
  mov  ax,selectorinc
  mov  s_inc,ax
  cld
  push ds
  lds  si,p1
  les  di,p2
  mov  cx,count.word[0]
  mov  bx,count.word[2]
  call rep_movsw_up
  pop  ds
 end;

{ Ersatz fr Move(), wenn physikalische Adresse von Source<Dest }
Procedure _MoveUp(p1,p2:pointer;Count:Longint); assembler;
 var s_inc:word;
 asm
  mov  cx,count.word[0]
  mov  bx,count.word[2]
  sub  cx,1
  sbb  bx,0
  jc   @@1
  les  di,p2
  push es
  push di
  push bx
  push cx
  les  di,p1
  push es
  push di
  push bx
  push cx
  call IncPtr
  mov  p1.word[0],ax
  mov  p1.word[2],dx
  call IncPtr
  mov  es,dx
  mov  di,ax
  mov  ax,selectorinc
  mov  s_inc,ax
  std
  push ds
  lds  si,p1
  mov  cx,count.word[0]
  mov  bx,count.word[2]
  call rep_movsw_dn
  pop  ds
  @@1:
 end;


Function EqualAt(p1,p2:pointer;Count:Longint):pointer; assembler;
 var s_inc:word;
 asm
  mov  ax,selectorinc
  mov  s_inc,ax
  cld
  push ds
  lds  si,p1
  les  di,p2
  mov  cx,count.word[0]
  mov  bx,count.word[2]
  call repne_cmpsb
  jne  @@2
  mov  dx,ds
  mov  ax,si
  sub  ax,1
  jnc  @@1
  sub  dx,s_inc
@@1:
  jmp  @@3
@@2:
  xor  ax,ax
  mov  dx,ax
@@3:
  pop  ds
 end;

Function UnEqualAt(p1,p2:pointer;Count:Longint):pointer; assembler;
 var s_inc:word;
 asm
  mov  ax,selectorinc
  mov  s_inc,ax
  cld
  push ds
  lds  si,p1
  les  di,p2
  mov  cx,count.word[0]
  mov  bx,count.word[2]
  call repe_cmpsb
  je   @@2
  mov  dx,ds
  mov  ax,si
  sub  ax,1
  jnc  @@1
  sub  dx,s_inc
@@1:
  jmp  @@3
@@2:
  xor  ax,ax
  mov  dx,ax
@@3:
  pop  ds
 end;

Procedure Check_DI_UP; near; assembler;
 asm
  or  di,di
  jne @@1
  mov si,es
  add si,selectorInc
  mov es,si
@@1:
 end;

Procedure Check_CX_1; near; assembler;
 asm
    mov  dx,di
    add  dx,cx
    jnc  @@1
    sub  cx,dx
    jmp  @@2
@@1:xor  dx,dx
@@2:
 end;

Function FindByte(what:byte;where:pointer;Len:Longint):pointer; assembler;
 asm
     cld
     les  di,where
     mov  al,what
     mov  bx,len.word[2]
     mov  cx,len.word[0]
@@0: call check_cx_1
@@1: repne scasb
     pushf
     call check_di_up
     add  cx,dx
     popf
     je   @@e
     jcxz @@5
     jmp  @@0
@@5: sub  cx,1
     sbb  bx,0
     jc   @@X
     call check_cx_1
     inc  dx
     jmp  @@1
@@E: mov  dx,es
     mov  ax,di
     sub  ax,1
     jnc  @@XX
     sub  dx,selectorInc
     jmp  @@XX
@@X: xor  ax,ax
     mov  dx,ax
@@XX:
 end;

Procedure FillByte(what:byte;where:pointer;Len:Longint); assembler;
 asm
     cld
     les  di,where
     mov  al,what
     mov  ah,al
     mov  bx,len.word[2]
     mov  cx,len.word[0]
@@0: call check_cx_1
@@1: shr  cx,1
     jnc  @@2
     stosb
@@2: rep  stosw
     call check_di_up
     add  cx,dx
     jcxz @@5
     jmp  @@0
@@5: sub  cx,1
     sbb  bx,0
     jc   @@X
     call check_cx_1
     inc  dx
     jmp  @@1
@@X:
 end;

Procedure FillWord(what:word;where:pointer;Len:Longint); assembler;
 asm
     cld
     les  di,where
     mov  ax,what
     mov  bx,len.word[2]
     mov  cx,len.word[0]
     and  cx,$FFFE
@@0: call check_cx_1
@@1: shr  cx,1
     adc  dx,0
     rep  stosw
     call check_di_up
     add  cx,dx
     jcxz @@5
     jmp  @@0
@@5: sub  cx,1
     sbb  bx,0
     jc   @@X
     call check_cx_1
     inc  dx
     jmp  @@1
@@X:
 end;

Function FindBuf(buf:pointer;buflen:Longint;Where:pointer;Len:Longint):Pointer;
 var b:byte;
     p1,p2:pointer;
 begin
  FindBuf:=nil;
  if (Buflen>0) and (Len>=buflen) then
  begin
   b:=byte(buf^);
   p1:=where;
   repeat
    p2:=nil;
    p1:=FindByte(b,p1,len);
    if (p1<>nil) and (SubPtr(p1,where)<=len-buflen) then
    begin
     p2:=UnequalAt(buf,p1,buflen);
     if p2<>nil then p1:=IncPtr(p1,1);
    end else p1:=nil;
   until (p2=nil);
   FindBuf:=p1;
  end;
 end;

Function FindStr(S:string;Where:pointer;Len:Longint):Pointer;
 begin
  FindStr:=FindBuf(@S[1],length(S),where,len);
 end;

Procedure InsertBuf(source,dest:pointer;count,pos,dmaxlen:longint;var dlen:Longint);
 var c:longint;
 begin
  if pos+count>dmaxlen then count:=dmaxlen-pos;
  if count>0 then
  begin
   if dlen>pos then
   begin
    c:=dlen-pos;
    if (c>dmaxlen-pos-count) then c:=dmaxlen-pos-count;
    if c>0 then _MoveUp(incptr(dest,pos),incptr(dest,pos+count),c);
    dlen:=pos+count+c;
   end;
   _MoveUp(source,incptr(dest,pos),count);
   if pos+count>dlen then dlen:=pos+count;
  end;
 end;

Procedure DeleteBuf(p:pointer;pos,count:longint;var dlen:longint);
 begin
  if dlen>pos+count then
  begin
   _MoveDn(incptr(p,pos+count),incptr(p,pos),dlen-pos-count);
  end else dlen:=pos;
 end;

END.