{***************************************************************************}
{                                                                           }
{          Copyright (C) Christian Baumgarten, Hamburg 1993.                }
{                                                                           }
{***************************************************************************}
UNIT _DPMI;
interface
const
     dpmi_int = $31;
{ Deskriptor-Management }

  dpmiAllocDescriptor    = $0000;
  dpmiFreeDescriptor     = $0001;
  dpmiSegment2Descriptor = $0002;
  dpmiGetHugePtrInc      = $0003;
  dpmiSetDescriptorBase  = $0007;
  dpmiSetDescriptorSize  = $0008;
  dpmiSetDescriptorAR    = $0009;
  dpmiGetDescriptor      = $000B;
  dpmiSetDescriptor      = $000C;

  { DOS-Speicherverwaltung }

  dpmiDOSAllocMem      = $0100;
  dpmiDOSFreeMem       = $0101;
  dpmiDOSResizeMem     = $0102;

  { Interrupt-Funtkionen }

  dpmiGetRealMInt        = $0200;
  dpmiSetRealMInt        = $0201;
  dpmiGetXHandler        = $0202;
  dpmiSetXHandler        = $0203;
  dpmiGetProMInt         = $0204;
  dpmiSetProMInt         = $0205;

  { Interrupt-Simulationsfunktionen }

  dpmiSimulateRealMInt      = $0300;

  { Umsetzungsfunktionen }

  dpmiCallRealMProc         = $0301;
  dpmiCallRealMIntr         = $0302;
  dmpiCreateRealMCallBack   = $0303;
  dpmiFreeRealMCallBack     = $0304;

  { Informationsfunktionen }

  dpmiGetVersion         = $0400;

  { Speicherverwaltung }

  GetFreeMemInfo        = $0500;
  AllocMemBlock         = $0501;
  FreeMemBlock          = $0502;
  ResizeMemBlock        = $0503;
  LockLinearRegion      = $0600;
  UnlockLinearRegion    = $0601;
  GetPageSize           = $0604;

{ Mapping-Funktionen }

  MapPhysicalAddress    = $0800;

TYPE
   DWord=Longint;

   TCallStructure = RECORD
    _EDI: DWord;
    _ESI: DWord;
    _EBP: DWord;
    _Reserved: DWord;
    _EBX: DWord;
    _EDX: DWord;
    _ECX: DWord;
    _EAX: DWord;
    _Flags: Word;
    _ES: Word;
    _DS: Word;
    _FS: Word;
    _GS: Word;
    _IP: Word;
    _CS: Word;
    _SP: Word;
    _SS: Word;
  END;

const _TCS_Size = SizeOF(TCallStructure);

 procedure PrepareTCallStruct(var regs:TCallStructure);

 procedure getRealMintvec(No:byte;var p:pointer);
 procedure getProMIntVec(No:byte;var p:pointer);

 procedure SetRealMintvec(No:byte;p:pointer);
 procedure SetProMIntVec(No:byte;p:pointer);

 procedure CallRealMProc(var Regs:TCallStructure);
 procedure CallRealMIntr(No:Byte;var Regs:TCallStructure);

 Procedure SetPtr(var PMPtr:pointer;RMPtr:Pointer);
 Function AllocPtr(RM_Ptr:pointer):pointer;
 Procedure FreePtr(var P:Pointer);

implementation

 USES WINAPI,CODES;

 type PtrRec = Record
       offs,segm:word;
      end;

 var Regs:TCallStructure absolute RealModeRegs;

 Procedure SetPtr(var PMPtr:pointer;RMPtr:Pointer);
  var l:longint;
  begin
   l:=PtrRec(RMPtr).segm;
   l:=l shl 4;
   SetSelectorBase(PtrRec(PMPtr).segm,l);
   SetSelectorLimit(PtrRec(PMPtr).segm,$FFF0);
   PtrRec(PMPtr).Offs:=PtrRec(RMPtr).offs;
  end;

 Function AllocPtr(RM_Ptr:pointer):pointer;
  var s,o:word;
      l:longint;
  begin
   AllocPtr:=NIL;
   s:=allocselector(0);
   if s<>0 then
   begin
    l:=PtrRec(RM_ptr).segm;
    l:=l shl 4;
    if setselectorbase(s,l)=0 then
    begin
     freeselector(s);
     exit;
    end;
    setselectorlimit(s,$FFF0);
    AllocPtr:=ptr(s,ptrrec(rm_ptr).offs);
   end;
  end;

 Procedure FreePtr(var P:Pointer);
  begin
   FreeSelector(PtrRec(P).segm);
   P:=nil;
  end;

 procedure PrepareTCallStruct(var regs:TCallStructure); assembler;
  asm
   xor  ax,ax
   les  di,regs
   push di
   cld
   mov  cx,_TCS_Size
   shr  cx,1
   rep  stosw
   pop  di
   pushf
   pop  ax
   mov  es:[di].Tcallstructure._flags,ax
  end;

 procedure getRealMintvec(No:byte;var p:pointer); assembler;
  asm
   mov ax,dpmiGetRealMint
   mov bl,No
   int dpmi_int
   les di,p
   cld
   mov ax,dx
   stosw
   mov ax,cx
   stosw
  end;

 procedure getProMIntVec(No:byte;var p:pointer); assembler;
  asm
   mov ax,dpmiGetProMint
   mov bl,No
   int dpmi_int
   les di,p
   cld
   mov ax,dx
   stosw
   mov ax,cx
   stosw
  end;

 procedure SetRealMintvec(No:byte;p:pointer); assembler;
  asm
   mov ax,dpmiSetRealMint
   mov bl,No
   les dx,p
   mov cx,es
   int dpmi_int
  end;

 procedure SetProMIntVec(No:byte;p:pointer); assembler;
  asm
   mov ax,dpmiSetProMint
   mov bl,No
   les dx,p
   mov cx,es
   int dpmi_int
  end;

 procedure CallRealMProc(var Regs:TCallStructure); assembler;
  asm
   les di,Regs
   xor cx,cx
   mov ax,dpmiCallRealMProc
   xor bx,bx
   int dpmi_int
  end;

 procedure CallRealMIntr(No:Byte;var Regs:TCallStructure); assembler;
  asm
   mov ax,dpmiGetrealMInt
   mov bl,No
   int dpmi_int
   les di,regs
   mov es:[di].Tcallstructure._ip,dx
   mov es:[di].TCallstructure._cs,cx
   mov ax,dpmiCallRealMIntr
   xor bx,bx
   mov cx,bx
   int dpmi_int
  end;

end.