{***********************************************************************}
{                                                                       }
{        Copyright (C) Christian Baumgarten, Hamburg 1993.              }
{                                                                       }
{     UNIT mit Routinen fr den Zugriff auf das Extended Memory (XMS)   }
{     einschlielich eines XMS-Streams.                                 }
{                                                                       }
{***********************************************************************}

UNIT _XMS_;
{$F+}
INTERFACE
USES OBJECTS;

type XMS_TranferRec=record
      size:longint;
      Source:word;
      SOffs:pointer;
      Dest:word;
      DOffs:pointer;
     end;

const
     XMS_Error:byte=0;

 procedure GetXMSAddr;
  function XMS_Installed:boolean;
  function XMS_Version:word;
  function XMS_MemSize:word;
  function XMS_MaxAvail:word;
  function XMS_ErrorMsg:string;

 { Ext. Memory reservieren Blockgrsse in Kbytes=[1024 Bytes] }
 procedure XMS_Allocate(var handle:word;BlockSize:word);

 { Ext. Memory freigeben }
 procedure XMS_DeAlloc(handle:word);

 { Ext. Memory-Blockgrsse verndern }
 procedure XMS_SetBlock(handle:word;size:word);

 { Block aus dem Dos-Bereich in das Ext. Memory verschieben }
 { (Size in Bytes: Gerade Anzahl erforderlich)              }
 procedure XMS_Push(handle:word;offs:longint;var puffer;size:longint);

 { Block aus dem Ext. Memory in den Dos-Bereich verschieben }
 { (Size in Bytes: Gerade Anzahl erforderlich)              }
 procedure XMS_Pop(handle:word;offs:longint;var puffer;size:longint);

 { Datenblock innerhalb des Extended Memory verschieben     }
 procedure XMS_Move(S_Handle:word;S_Offs:longint;D_Handle:Word;D_Offs:longint;Size:longint);

 { Block gegen Verschieben sperren und physikalische Addresse erhalten }
 function XMS_Lock(handle:word):longint;

 { Block fr Verschieben freigeben }
 procedure XMS_UnLock(handle:word);

 { Grsse des Handles und verbleibende Anzahl Handles erfragen }
 procedure XMS_GetHandleInfo(handle:word;var Size:word;var FreeHandles:byte);

type

{ TXMSStream }
{ Stream, der im Extended Memory liegt, ohne EMS-Speicher zu }
{ verbrauchen. Setzt voraus, da freier XMS - Speicher       }
{ verfgbar ist.                                             }

     pXMSStream=^tXMSStream;
     tXMSStream=object(tStream)
      Handle:word;
      KBytes:word;
      Size:longint;
      Position:Longint;
      constructor Init(MinKBytes,MaxKBytes:word);
      destructor done;                        virtual;
      function getpos:longint;                virtual;
      function getsize:longint;               virtual;
      procedure Read(var Buf; Count:word);    virtual;
      procedure Seek(pos:longint);            virtual;
      procedure Truncate;                     virtual;
      procedure Write(var Buf;count:word);    virtual;
     end;

IMPLEMENTATION

var Master:XMS_TranferRec;

    XMSAddr:pointer;

 function XMS_ErrorMsg:string;
  begin
   case XMS_Error of
        0: XMS_ErrorMsg:='Alles Bestens';
        1: XMS_ErrorMsg:='Kein Treiber installiert';
      $A0: XMS_ErrorMsg:='Extended Memory voll belegt';
      $A1: XMS_ErrorMsg:='Alle Ext.Memory Handles belgt';
      $A2: XMS_ErrorMsg:='Handle ungltig';
      $A3: XMS_ErrorMsg:='Quell Handle ungltig';
      $A4: XMS_ErrorMsg:='Quell Adresse ungltig';
      $A5: XMS_ErrorMsg:='Ziel Handle ungltig';
      $A6: XMS_ErrorMsg:='Ziel Adresse ungltig';
      $A7: XMS_ErrorMsg:='Blocklnge ungltig';
      $A8: XMS_ErrorMsg:='berlappung der Adressen';
      $AA: XMS_ErrorMsg:='Block nicht gesperrt';
      $AB: XMS_ErrorMsg:='Zugriffsversuch auf gesperrten Block';
      $AC: XMS_ErrorMsg:='Zuviele gesperrte Blcke';
      $AD: XMS_ErrorMsg:='Sperrung misslungen';
     else XMS_ErrorMsg:='Unbekannte Fehlerursache';
    end;
  end;

 procedure NulProc; assembler;
  asm
   lea bx,xms_error
   mov ax,1
   mov byte ptr [bx],al
  end;

 procedure XMS_GetHandleInfo(handle:word;var Size:word;var FreeHandles:byte); assembler;
  asm
   mov  DX,handle
   mov  ah,$0E
   call [xmsAddr]
   cmp  ax,1
   jne  @Error
   les  di,size
   mov  es:[di],dx
   les  di,freehandles
   mov  es:[di],bl
   xor  bl,bl
   @Error:
   mov  al,bl
   lea  bx,xms_error
   mov  [bx],al
  end;

 function XMS_Lock(handle:word):longint; assembler;
  asm
   mov  ah,$0C
   mov  dx,handle
   call [xmsAddr]
   cmp  ax,1
   jne  @Error
   mov  ax,bx
   xor  bl,bl
   @Error:
   lea  di,xms_error
   mov  [di],bl
  end;

 procedure XMS_UnLock(handle:word); assembler;
  asm
   mov  ah,$0D
   mov  dx,handle
   call [xmsaddr]
   cmp  ax,1
   jne  @Error
   xor  bl,bl
   @Error:
   lea  di,xms_error
   mov  [di],bl
  end;

 procedure XMS_SetBlock(handle:word;size:word); assembler;
  asm
   mov  ah,$0F
   mov  dx,handle
   mov  bx,size
   call [xmsaddr]
   cmp  ax,1
   jne  @Error
   xor  bl,bl
   @Error:
   lea  di,xms_error
   mov  [di],bl
  end;

 procedure XMS_Move(S_Handle:word;S_Offs:longint;D_Handle:Word;D_Offs:longint;Size:longint);
  begin
   Master.size:=size and $FFFFFFFE;
   Master.Source:=S_Handle;
   longint(Master.SOffs):=S_Offs;
   Master.Dest:=D_Handle;
   longint(Master.DOffs):=D_Offs;
   asm
    mov  ah,$0B
    lea  si,Master
    call [xmsaddr]
    cmp  ax,1
    jne  @Error
    xor  bl,bl
    @Error:
    lea  di,xms_error
    mov  [di],bl
   end;
  end;

 procedure XMS_Push(handle:word;offs:longint;var puffer;size:longint);
  begin
   Master.size:=size and $FFFFFFFE;
   Master.Source:=0;
   Master.SOffs:=@puffer;
   Master.Dest:=handle;
   longint(Master.DOffs):=offs;
   asm
    mov  ah,$0B
    lea  si,Master
    call [xmsaddr]
    cmp  ax,1
    jne  @Error
    xor  bl,bl
    @Error:
    lea  di,xms_error
    mov  [di],bl
   end;
  end;

 procedure XMS_Pop(handle:word;offs:longint;var puffer;size:longint);
  begin
   Master.size:=size and $FFFFFFFE;
   Master.Source:=handle;
   longint(Master.SOffs):=offs;
   Master.Dest:=0;
   Master.DOffs:=@puffer;
   asm
    mov  ah,$0B
    lea  si,Master
    call [xmsaddr]
    cmp  ax,1
    jne  @Error
    xor  bl,bl
    @Error:
    lea  di,xms_error
    mov  [di],bl
   end;
  end;

 procedure XMS_Allocate(var handle:word;BlockSize:word); assembler;
  asm
   mov  ah,9
   mov  dx,blocksize
   call [xmsaddr]
   cmp  ax,1
   jne  @Error
   xor  bl,bl
   @Error:
   lea  di,xms_error
   mov  [di],bl
   les  di,handle
   mov  es:[di],dx
  end;

 procedure XMS_DeAlloc(handle:word); assembler;
  asm
   mov  ah,$0A
   mov  dx,handle
   call [xmsaddr]
   cmp  ax,1
   jne  @Error
   xor  bl,bl
   @Error:
   lea  di,xms_error
   mov  [di],bl
  end;

 function XMS_MaxAvail:word; assembler;
  asm
   mov  ah,8
   call [xmsaddr]
   lea  di,xms_error
   mov  [di],bl
  end;

 function XMS_MemSize:word; assembler;
  asm
   mov  ah,8
   call [xmsaddr]
   lea  di,xms_error
   mov  [di],bl
   mov  ax,dx
  end;

 function XMS_Version:word; assembler;
   asm
    xor  ax,ax
    call [xmsaddr]
   end;

 procedure GetXMSAddr; assembler;
  asm
   mov  ax,$4300
   push ds
   int  2Fh
   pop  ds
   cmp  al,$80
   je   @@1
   push cs
   pop  es
   mov  bx,offset NulProc
   jmp  @@2
@@1:
   mov  ax,$4310
   push ds
   int  2Fh
   pop  ds
@@2:
   lea  di,xmsaddr
   mov  [di],bx
   mov  [di].word[2],es
  end;

 function XMS_Installed:boolean; assembler;
  asm
   mov  ax,$4300
   push ds
   int  2Fh
   pop  ds
   cmp  al,$80
   jne  @@1
   mov  al,1
   jmp  @@2
@@1:xor al,al
@@2:
  end;

 constructor tXMSStream.Init(MinKBytes,MaxKBytes:word);
   var Av,Al:word;
   begin
    status:=stInitError;
    KBytes:=0;
    Size:=0;
    Position:=0;
    if XMS_Installed then
    begin
     Av:=XMS_MaxAvail;
     al:=0;
     if Av>=MaxKBytes then Al:=MaxKBytes else
     if Av>=MinKbytes then al:=Av;
     if al>0 then
     begin
      XMS_Allocate(Handle,al);
      if xms_error=0 then
      begin
       KBytes:=al;
       status:=stOK;
      end;
     end;
    end;
    errorinfo:=xms_error;
    if status<>stOK then error(sterror,errorinfo);
   end;

  destructor tXMSStream.done;
   begin
    if KBytes>0 then xms_dealloc(handle);
   end;

 function tXMSStream.getpos:longint;
   begin
    getpos:=position;
   end;

 function tXMSStream.getsize:longint;
   begin
    getsize:=size;
   end;

 procedure tXMSStream.Read(var Buf; Count:word);
   var w:word;
       T:Array[0..65519] of byte absolute buf;
   begin
    if (Status=stOK) and (position+count<=size) then
    begin
     xms_pop(handle,position,buf,count and $FFFE);
     if count and 1>0 then
     begin
      xms_pop(handle,position+count-1,w,2);
      T[count-1]:=lo(w);
     end;
     inc(position,count);
     errorinfo:=xms_error;
     if errorinfo<>0 then status:=stReadError;
    end else status:=stReadError;
   end;

 procedure tXMSStream.Seek(pos:longint);
   begin
    if pos<=size then
    begin
     Position:=pos;
    end else status:=sterror;
   end;

 procedure tXMSStream.Truncate;
   begin
    if (status=stOK) and (position<size) then Size:=Position;
   end;

 procedure tXMSStream.Write(var Buf;count:word);
   var w:word;
       T:array[0..65519] of Byte absolute buf;
       newsize:word;
   begin
    if (status=stOK) and (position+count>LongMul(KBytes,1024)) then
    begin
     NewSize:=Longdiv(position+count,1024);
     if LongMul(NewSize,1024)<position+count then inc(NewSize);
     XMS_SetBlock(handle,NewSize);
     errorinfo:=xms_error;
     if errorinfo<>0 then status:=stWriteError else
      KBytes:=NewSize;
    end;
    if status=stOK then
    begin
     xms_push(handle,position,buf,count and $FFFE);
     if count and 1>0 then
     begin
      xms_pop(handle,position+count-1,w,2);
      w:=(w and $FF00) or T[count-1];
      xms_push(handle,position+count-1,w,2);
     end;
     inc(position,count);
     if position>size then size:=position;
     errorinfo:=xms_error;
     if errorinfo<>0 then status:=stWriteError;
    end else status:=stWriteError;
   end;


BEGIN
 GetXMSAddr;
END.