      PROGRAM TEST 
!                                                                       
!***********************************************************************
!                                                                       
!  Testprogram for the SUBROUTINE POLFIT.                               
!                                                                       
!  Test example: Numerische Mathematik fr Ingenieure;                  
!                G. Engeln-Mllges/F. Reutter, 4th ed. 1984;            
!                Example 6.3 (III), p. 213 - 215.                       
!                                                                       
![   I *  X(I)  *  Y(I)  *  W(I)  *                                     
![  -------------------------------                                     
![   0 *    .02 *  50.00 *   1.00 *                                     
![   1 *    .10 *  10.00 *   1.00 *                                     
![   2 *    .50 *   1.00 *   1.00 *                                     
![   3 *   1.00 *    .00 *   1.00 *                                     
![                                                                      
![  LEAST SQUARES ERROR:  .40389222434673E-13                           
![                                                                      
![  COEFFICIENTS:                                                       
![  -------------                                                       
![                                                                      
![   J *         C(J)         *                                         
![  ---------------------------                                         
![   0 *      15.250000000000 *                                         
![   1 *     -36.744994208175 *                                         
![   2 *      97.982953935049 *                                         
![   3 *    -991.850907029480 *                                         
![                                                                      
![  COEFFICIENTS FOR THE RECURSIVE FORMULA:                             
![  ---------------------------------------                             
![                                                                      
![   J *         B(J)         *         C(J)         *                  
![  --------------------------------------------------                  
![   1 *        .405000000000 *                      *                  
![   2 *        .613609961939 *        .151075000000 *                  
![   3 *        .505566972694 *        .063622095595 *                  
![                                                                      
![                                                                      
![  TABLE OF VALUES:                                                    
![  ----------------                                                    
![                                                                      
![    .00        62.981434240363                                        
![    .10         9.999999420825                                        
![    .20       -16.737755566946                                        
![    .30       -23.182936431163                                        
![    .40       -15.286648880037                                        
![    .50         1.000001378218                                        
![    .60        19.725908635392                                        
![    .70        34.939967183271                                        
![    .80        40.691071313645                                        
![    .90        31.028115318301                                        
![   1.00         -.000006510974                                        
![   1.10       -58.344399882390                                        
![   1.20      -149.956170504160                                        
![   1.30      -280.786424084496                                        
![   1.40      -456.786266331611                                        
![   1.50      -683.906802953716                                        
![   1.60      -968.099139659022                                        
![   1.70     -1315.314382155743                                        
![   1.80     -1731.503636152090                                        
![   1.90     -2222.618007356275                                        
![   2.00     -2794.608601476511                                        
!                                                                       
!***********************************************************************
!                                                                       
      PARAMETER (N = 3, NGR = 3) 
      IMPLICIT DOUBLEPRECISION (A - H, O - Z) 
      DIMENSION X (0:N), Y (0:N), W (0:N) 
      DIMENSION AST (0:NGR), BE (1:NGR), CE (2:NGR) 
      DATA X, Y, W / .02D0, .1D0, .5D0, 1.D0, 50.D0, 10.D0, 1.D0, 0.D0, &
      4 * 1.D0 /                                                        
      WRITE ( *, 900) 
      DO 10 I = 0, N 
         WRITE ( *, 910) I, X (I), Y (I), W (I) 
   10 END DO 
      CALL POLFIT (N, X, Y, W, NGR, AST, BE, CE, FE, IFE) 
      IF (IFE.NE.0) THEN 
         WRITE ( *, 990) IFE 
         STOP 
      ENDIF 
      WRITE ( *, 1000) FE 
                                                                        
      WRITE ( *, 1100) 
      WRITE ( *, 920) 
      DO 20 I = 0, NGR 
         WRITE ( *, 930) I, AST (I) 
   20 END DO 
      WRITE ( *, 1200) 
      WRITE ( *, 940) 
      WRITE ( *, 950) 1, BE (1) 
      DO 30 K = 2, NGR 
         WRITE ( *, 960) K, BE (K), CE (K) 
   30 END DO 
      WRITE ( *, 970) 
      DO 40 XX = 0., 2.05, .1 
         WRITE ( *, 980) XX, POEVAL (XX, NGR, AST, BE, CE) 
   40 END DO 
      STOP 
  900 FORMAT (1X,'C[',2X,' I *  X(I)  *  Y(I)  *  W(I)  *',T78,']*',/,  &
     &        1X,'C[',2X,31('-'),T78,']*')                              
  910 FORMAT (1X,'C[',3X,I1,' *',3(1X,F6.2,' *'),T78,']*') 
  920 FORMAT (1X,'C[',T78,']*',/,                                       &
     &        1X,'C[',2X,' J *         C(J)         *',T78,']*',/,      &
     &        1X,'C[',2X,27('-'),T78,']*')                              
  930 FORMAT (1X,'C[',3X,I1,' * ',F20.12,' *',T78,']*') 
  940 FORMAT (1X,'C[',T78,']*',/,                                       &
     &        1X,'C[',2X,' J *',9X,'B(J)',9X,'*',9X,'C(J)',9X,'*'       &
     &         ,T78,']*',/,                                             &
     &        1X,'C[',2X,50('-'),T78,']*')                              
  950 FORMAT (1X,'C[',3X,I1,' * ',F20.12,' *',22X,'*',T78,']*') 
  960 FORMAT (1X,'C[',3X,I1,' * ',F20.12,' * ',F20.12,' *',T78,']*') 
  970 FORMAT (1X,'C[',T78,']*',/,                                       &
     &        1X,'C[',T78,']*',/,                                       &
     &        1X,'C[',2X,'TABLE OF VALUES:',T78,']*',/,                 &
     &        1X,'C[',2X,'----------------',T78,']*',/,                 &
     &        1X,'C[',T78,']*')                                         
  980 FORMAT (1X,'C[',2X,F5.2,3X,F20.12,T78,']*') 
  990 FORMAT (1X,'C[',2X,'ERROR PARAMETER: ',I2,T78,']*') 
 1000 FORMAT (1X,'C[',T78,']*',/,                                       &
     &        1X,'C[',2X,'LEAST SQUARES ERROR: ',E20.14,T78,']*',/,     &
     &        1X,'C[',T78,']*')                                         
 1100 FORMAT (1X,'C[',2X,'COEFFICIENTS:',T78,']*',/,                    &
     &        1X,'C[',2X,'-------------',T78,']*')                      
 1200 FORMAT (1X,'C[',T78,']*',/,                                       &
     &        1X,'C[',2X,'COEFFICIENTS FOR THE RECURSIVE ',             &
     &        'FORMULA:',T78,']*',/,                                    &
     &        1X,'C[',2X,39('-'),T78,']*')                              
      END PROGRAM TEST                              
