      PROGRAM TEST 
!                                                                     90
!                                                ( Guido Dubois )       
!***********************************************************************
!                                                                       
!  Testprogram for the SUBROUTINES RALGIP and RLIORD, and for the       
!  FUNCTION RLIFCT.                                                     
!                                                                       
!                                                                       
!  The exact solution for the test data is  F(X) = 1/(1+X*X).           
!                                                                       
!  The given test data produces the following results:                  
!                                                                       
!                                                                       
![  DEGREE OF THE DENOMINATOR POLYNOMIAL, L =  3                        
![                                                                      
![  *  I  *         X(I)         *         A(I)         *               
![  *****************************************************               
![  *  0  *  .00000000000000E+00 *  .10000000000000E+01 *               
![  *  1  *  .50000000000000E+00 *  .80000000000000E+00 *               
![  *  2  *  .10000000000000E+01 *  .50000000000000E+00 *               
![  *  3  *  .15000000000000E+01 *  .30769230700000E+00 *               
![  *  4  *  .20000000000000E+01 *  .20000000000000E+00 *               
![  *  5  *  .25000000000000E+01 *  .13793103400000E+00 *               
![  *  6  *  .30000000000000E+01 *  .10000000000000E+00 *               
![                                                                      
![  *  I  *         X(I)         *         A(I)         *               
![  *****************************************************               
![  *  0  *  .15000000000000E+01 * -.66686778523337E+10 *               
![  *  1  *  .20000000000000E+01 *  .67021882510214E+08 *               
![  *  2  *  .25000000000000E+01 * -.10499999253975E+00 *               
![  *  3  *  .10000000000000E+01 * -.42000000000000E+00 *               
![  *  4  *  .50000000000000E+00 * -.47619047619048E+00 *               
![  *  5  *  .00000000000000E+00 * -.33333333333333E+01 *               
![  *  6  *  .30000000000000E+01 *  .10000000000000E+00 *               
![                                                                      
![  *          XW          *        F(XW)         *        ABSERR       
![  ********************************************************************
![  *  .00000000000000E+00 *  .10000000000000E+01 *  .00000000000000E+00
![  *  .10000000000000E+00 *  .99009900922596E+00 *  .67502958778221E-09
![  *  .20000000000000E+00 *  .96153846071911E+00 *  .81935236373454E-09
![  *  .30000000000000E+00 *  .91743119203140E+00 *  .62915317400325E-09
![  *  .40000000000000E+00 *  .86206896521168E+00 *  .30556612795607E-09
![  *  .50000000000000E+00 *  .80000000000000E+00 *  .00000000000000E+00
![  *  .60000000000000E+00 *  .73529411785208E+00 *  .20501911279780E-09
![  *  .70000000000000E+00 *  .67114093988361E+00 *  .28629665305147E-09
![  *  .80000000000000E+00 *  .60975609781915E+00 *  .25817281645857E-09
![  *  .90000000000000E+00 *  .55248618799693E+00 *  .15162515687450E-09
![  *  .10000000000000E+01 *  .50000000000000E+00 *  .00000000000000E+00
![  *  .11000000000000E+01 *  .45248868761444E+00 *  .16836287919375E-09
![  *  .12000000000000E+01 *  .40983606524116E+00 *  .33261088328018E-09
![  *  .13000000000000E+01 *  .37174721141677E+00 *  .47914200385080E-09
![  *  .14000000000000E+01 *  .33783783723762E+00 *  .60021804193511E-09
![  *  .15000000000000E+01 *  .30769230700000E+00 *  .69230771115869E-09
![  *  .16000000000000E+01 *  .28089887564997E+00 *  .75452072367810E-09
![  *  .17000000000000E+01 *  .25706940795328E+00 *  .78707812489753E-09
![  *  .18000000000000E+01 *  .23584905581488E+00 *  .78889367260970E-09
![  *  .19000000000000E+01 *  .21691973894973E+00 *  .74658670912164E-09
![  *  .20000000000000E+01 *  .20000000000000E+00 *  .27755575615629E-16
![  *  .21000000000000E+01 *  .18484288271119E+00 *  .83779219672842E-09
![  *  .22000000000000E+01 *  .17123287597737E+00 *  .73496173036425E-09
![  *  .23000000000000E+01 *  .15898251127041E+00 *  .65327385168068E-09
![  *  .24000000000000E+01 *  .14792899351273E+00 *  .57010965393012E-09
![  *  .25000000000000E+01 *  .13793103400000E+00 *  .48275861086466E-09
![  *  .26000000000000E+01 *  .12886597899011E+00 *  .39132869167346E-09
![  *  .27000000000000E+01 *  .12062726146462E+00 *  .29654080579977E-09
![  *  .28000000000000E+01 *  .11312217174648E+00 *  .19921896077246E-09
![  *  .29000000000000E+01 *  .10626992551091E+00 *  .10014214457676E-09
![  *  .30000000000000E+01 *  .10000000000000E+00 *  .00000000000000E+00
!                                                                       
!***********************************************************************
!                                                                       
      PARAMETER (N = 6) 
      IMPLICIT DOUBLEPRECISION (A - H, O - Z) 
      DIMENSION X (0:N), A (0:N), Z (0:N - 1) 
      INTEGER L1 (0:N) 
      DATA X / 0.D0, .5D0, 1.D0, 1.5D0, 2.D0, 2.5D0, 3.D0 / 
      DATA A / 1.D0, .8D0, .5D0, .307692307D0, .2D0, .137931034D0, .1D0 &
      /                                                                 
      DATA L / 3 / 
      WRITE ( *, 900) L 
      WRITE ( *, 910) 
      WRITE ( *, 920) (I, X (I), A (I), I = 0, N) 
      CALL RALGIP (X, A, N, L, L1, IFEHL, NANZ, Z) 
      IF (IFEHL.EQ.0) THEN 
         WRITE ( *, 910) 
         WRITE ( *, 920) (I, X (I), A (I), I = 0, N) 
         WRITE ( *, 930) 
         DO 10 XW = 0.D0, 3.05D0, .1D0 
            RAXW = RLIFCT (XW, X, A, L1, N) 
            WRITE ( *, 940) XW, RAXW, ABS (FKT (XW) - RAXW) 
   10    END DO 
      ELSE 
         WRITE ( * , * ) '*** ERROR *** IFEHL = ', IFEHL 
      ENDIF 
      STOP 
  900 FORMAT (1X,'C[',2X,'DEGREE OF THE DENOMINATOR POLYNOMIAL, L = '   &
     &        ,I2,T78,']*')                                             
  910 FORMAT (1X,'C[',T78,']*',/,                                       &
     &        1X,'C[',2X,'*  I  *',9X,'X(I)',9X,'*',9X,'A(I)',9X,'*'    &
     &        ,T78,']*',/,                                              &
     &        1X,'C[',2X,53('*'),T78,']*')                              
  920 FORMAT (1X,'C[',2X,'*  ',I1,'  * ',E20.14,' * ',E20.14,' *',      &
     &        T78,']*')                                                 
  930 FORMAT (1X,'C[',T78,']*',/,                                       &
     &        1X,'C[',2X,'*',10X,'XW',10X,'*',8X,'F(XW)',9X,'*',8X,     &
     &        'ABSERR',8X,'*',T78,']*',/,                               &
     &        1X,'C[',2X,70('*'),T78,']*')                              
  940 FORMAT (1X,'C[',2X,'* ',E20.14,' * ',E20.14,' * ',E20.14,' *',    &
     &        T78,']*')                                                 
      END PROGRAM TEST                              
!                                                                       
!                                                                       
      DOUBLEPRECISION FUNCTION FKT (X) 
      IMPLICIT DOUBLEPRECISION (A - H, O - Z) 
      FKT = 1.D0 / (1.D0 + X * X) 
      RETURN 
      END FUNCTION FKT                              
