!                                                                       
!*********************************************************************  
!              Test program for the subroutines                      *  
!              CFSPPA,CFSP1D,CFSP2D,PSPTAB.                          *  
!--------------------------------------------------------------------*  
!   required subroutines    :  CFSPPA,CFSP1D,CFSP2D,                 *  
!                              FDISY,FDISYP,FDISYS,PSPTAB            *  
!--------------------------------------------------------------------*  
!                                                                    *  
!   This test program computes a parametric cubic fitting spline for *  
!   given end point derivatives for the nodes:                       *  
!                                                                    *  
!          X            Y            WX          WY                  *  
!      -------------------------------------------------             *  
!         1.0          1.0           10          10                  *  
!         1.5          2.0           50          50                  *  
!         2.0          2.5          100         200                  *  
!         2.5          2.0           80          80                  *  
!         2.5          1.0          100         300                  *  
!         2.0          1.5          300         100                  *  
!         2.5          2.0          200         200                  *  
!         3.0          3.0          100         100                  *  
!         4.0          3.0           10          10                  *  
!                                                                    *  
!      where WX(I) is the weight for X(I), WY(I) = weight for Y(I).  *  
!                                                                    *  
!                                                                    *  
!   We use the following end point conditions                        *  
!   -  1st end point derivatives wrt parameter given:                *  
!         SX'(T(0)) = 0.1  , SY'(T(0)) =  1.0                        *  
!         SX'(T(N)) = 1.0  , SY'(T(N)) = -1.0                        *  
!   -  1nd end point derivatives wrt parameter given:                *  
!         SX''(T(0)) = 0.0 , SY''(T(0)) = 0.0                        *  
!         SX''(T(N)) = 0.0 , SY''(T(N)) = 0.0                        *  
!   -  1st end point derivative (DY/DX) given:                       *  
!         Y'(T(0)) = 1.5   , Y'(T(N)) = -0.6                         *  
!                                                                    *  
!   Subroutine CFSPPA computes the parameters T(I), I=0, .., N, .    *  
!   These, the spline coefficients and a table of values for points  *  
!   XW,YW on the curve are put out.                                  *  
!                                                                    *  
!  Results:                                                          *  
!                                                                    *  
![                                                                  ]*  
![ GIVEN:   N + 1 POINTS X(I),Y(I), I=0(1)N, (N= 8),                ]*  
![ ======   AND WEIGHTS WX(I) AND WY(I)                             ]*  
![                                                                  ]*  
![  I        X(I)         Y(I)          WX(I)         WY(I)         ]*  
![  ---------------------------------------------------------       ]*  
![  0       1.0000       1.0000       10.0000       10.0000         ]*  
![  1       1.5000       2.0000       50.0000       50.0000         ]*  
![  2       2.0000       2.5000      100.0000      200.0000         ]*  
![  3       2.5000       2.0000       80.0000       80.0000         ]*  
![  4       2.5000       1.0000      100.0000      300.0000         ]*  
![  5       2.0000       1.5000      300.0000      100.0000         ]*  
![  6       2.5000       2.0000      200.0000      200.0000         ]*  
![  7       3.0000       3.0000      100.0000      100.0000         ]*  
![  8       4.0000       3.0000       10.0000       10.0000         ]*  
![                                                                  ]*  
![                                                                  ]*  
![ TO FIND:   A) TABLE OF VALUES FOR THE PARAMETER T(I),I=0(1)N     ]*  
![ ========                                                         ]*  
![            B) COEFFICIENTS OF A PARAMETRIC, PERIODIC, CUBIC      ]*  
![               APPROXIMATING SPLINE WITH COMPONENT FUNCTIONS      ]*  
![               SX AND SY AT THE NODES X(I),Y(I).                  ]*  
![               END POINT CONDITIONS FOR SX AND SY:                ]*  
![               1. DERIVATIVE WRT PARAMETER.                       ]*  
![               FOR SX: DERIVATIVE AT  X(0) =     .1000            ]*  
![                       DERIVATIVE AT  X(N) =    1.0000            ]*  
![               FOR SY: DERIVATIVE AT  X(0) =    1.0000            ]*  
![                       DERIVATIVE AT  X(N) =   -1.0000            ]*  
![                                                                  ]*  
![            C) TABLE OF VALUES FOR SX(T),SY(T)                    ]*  
![                                                                  ]*  
![                                                                  ]*  
![ SOLUTION:                                                        ]*  
![ =========                                                        ]*  
![                                                                  ]*  
![ A) PARAMETER VALUES T:                                           ]*  
![    -------------------                                           ]*  
![                                                                  ]*  
![  I         T(I)                                                  ]*  
![ --------------------------                                       ]*  
![  0    .00000000000000E+00                                        ]*  
![  1    .11180339887499E+01                                        ]*  
![  2    .18251407699364E+01                                        ]*  
![  3    .25322475511230E+01                                        ]*  
![  4    .35322475511230E+01                                        ]*  
![  5    .42393543323095E+01                                        ]*  
![  6    .49464611134961E+01                                        ]*  
![  7    .60644951022460E+01                                        ]*  
![  8    .70644951022460E+01                                        ]*  
![                                                                  ]*  
![                                                                  ]*  
![ B) SPLINE COEFFICIENTS:                                          ]*  
![    --------------------                                          ]*  
![                                                                  ]*  
![  I      AX(I)          BX(I)          CX(I)          DX(I)       ]*  
![ --------------------------------------------------------------   ]*  
![  0  .10369891E+01  .10000000E+00  .34919890E+00 -.61648462E-01   ]*  
![  1  .14991348E+01  .64965075E+00  .14242367E+00 -.54438097E-01   ]*  
![  2  .20104723E+01  .76941109E+00  .26943029E-01 -.22897586E+00   ]*  
![  3  .24870444E+01  .46405049E+00 -.45878812E+00 -.56234343E-01   ]*  
![  4  .24360724E+01 -.62222878E+00 -.62749115E+00  .10092254E+01   ]*  
![  5  .20391597E+01  .42028217E-02  .15133992E+01 -.94876022E+00   ]*  
![  6  .24633938E+01  .72133219E+00 -.49922514E+00  .27144737E+00   ]*  
![  7  .30251955E+01  .62295849E+00  .41123702E+00 -.14847751E+00   ]*  
![                                                                  ]*  
![                                                                  ]*  
![  I      AY(I)          BY(I)          CY(I)          DY(I)       ]*  
![ --------------------------------------------------------------   ]*  
![  0  .10036214E+01  .10000000E+01 -.38207448E-01 -.60356219E-02   ]*  
![  1  .20654610E+01  .89193197E+00 -.58451539E-01 -.55154408E+00   ]*  
![  2  .24719261E+01 -.18047104E-01 -.12284532E+01  .38425225E+00   ]*  
![  3  .19807920E+01 -.11789639E+01 -.41333108E+00  .64035940E+00   ]*  
![  4  .10288564E+01 -.84547882E-01  .15077471E+01 -.80245914E+00   ]*  
![  5  .14392334E+01  .84403982E+00 -.19452579E+00  .21031761E+00   ]*  
![  6  .20131553E+01  .88441522E+00  .25162523E+00 -.22819186E+00   ]*  
![  7  .29975853E+01  .59134688E+00 -.51375352E+00 -.18794661E+00   ]*  
![                                                                  ]*  
![ COEFFICIENTS FOUND.                                              ]*  
![                                                                  ]*  
![                                                                  ]*  
![ TABLE OF VALUES FOR:                                             ]*  
![   STARTING VALUE = T(0) =    .00                                 ]*  
![   FINAL VALUE    = T(N) =   7.06                                 ]*  
![                                                                  ]*  
![                                                                  ]*  
![ C) TABLE OF VALUES:                                              ]*  
![    ----------------                                              ]*  
![                                                                  ]*  
![   I          SX(T(I))                SY(T(I))                    ]*  
![ ---------------------------------------------------              ]*  
![   0     .10369890772665E+01     .10036213731124E+01              ]*  
![   1     .11195657483817E+01     .13706803706123E+01              ]*  
![   2     .12799962595157E+01     .17252517353571E+01              ]*  
![   3     .14991347562255E+01     .20654610144645E+01              ]*  
![   4     .17442180921983E+01     .23491251088754E+01              ]*  
![   5     .20104722657763E+01     .24719261100930E+01              ]*  
![   6     .22757486443106E+01     .23289705552738E+01              ]*  
![   7     .24870443862159E+01     .19807919643038E+01              ]*  
![   8     .25886686728748E+01     .15655953337428E+01              ]*  
![   9     .25758435228818E+01     .12008494398023E+01              ]*  
![  10     .24360724155391E+01     .10288563707320E+01              ]*  
![  11     .21822468098471E+01     .11519685504380E+01              ]*  
![  12     .20391597123204E+01     .14392333952231E+01              ]*  
![  13     .21878908622679E+01     .17226256244766E+01              ]*  
![  14     .24633937723601E+01     .20131552838691E+01              ]*  
![  15     .26769319258150E+01     .23658939244864E+01              ]*  
![  16     .28360984821231E+01     .27176600593028E+01              ]*  
![  17     .30251954928537E+01     .29975852854290E+01              ]*  
![  18     .32730421581728E+01     .31306562022492E+01              ]*  
![  19     .35792798258307E+01     .31077937558839E+01              ]*  
![  20     .39109134933733E+01     .28872320324114E+01              ]*  
![                                                                  ]*  
![ TABLE FOUND.                                                     ]*  
![                                                                  ]*  
![                                                                  ]*  
![ TO FIND:   A) TABLE OF VALUES FOR THE PARAMETER T(I),I=0(1)N     ]*  
![ ========                                                         ]*  
![            B) COEFFICIENTS OF A PARAMETRIC, PERIODIC, CUBIC      ]*  
![               APPROXIMATING SPLINE WITH COMPONENT FUNCTIONS      ]*  
![               SX AND SY AT THE NODES X(I),Y(I).                  ]*  
![               END POINT CONDITIONS FOR SX AND SY:                ]*  
![               2. DERIVATIVE WRT PARAMETER.                       ]*  
![               FOR SX: DERIVATIVE AT  X(0) =     .0000            ]*  
![                       DERIVATIVE AT  X(N) =     .0000            ]*  
![               FOR SY: DERIVATIVE AT  X(0) =     .0000            ]*  
![                       DERIVATIVE AT  X(N) =     .0000            ]*  
![                                                                  ]*  
![            C) TABLE OF VALUES FOR SX(T),SY(T)                    ]*  
![                                                                  ]*  
![                                                                  ]*  
![ SOLUTION:                                                        ]*  
![ =========                                                        ]*  
![                                                                  ]*  
![ A) PARAMETER VALUES T:                                           ]*  
![    -------------------                                           ]*  
![                                                                  ]*  
![  I         T(I)                                                  ]*  
![ --------------------------                                       ]*  
![  0    .00000000000000E+00                                        ]*  
![  1    .11180339887499E+01                                        ]*  
![  2    .18251407699364E+01                                        ]*  
![  3    .25322475511230E+01                                        ]*  
![  4    .35322475511230E+01                                        ]*  
![  5    .42393543323095E+01                                        ]*  
![  6    .49464611134961E+01                                        ]*  
![  7    .60644951022460E+01                                        ]*  
![  8    .70644951022460E+01                                        ]*  
![                                                                  ]*  
![                                                                  ]*  
![ B) SPLINE COEFFICIENTS:                                          ]*  
![    --------------------                                          ]*  
![                                                                  ]*  
![  I      AX(I)          BX(I)          CX(I)          DX(I)       ]*  
![ --------------------------------------------------------------   ]*  
![  0  .96956868E+00  .42302019E+00  .00000000E+00  .50718874E-01   ]*  
![  1  .15134014E+01  .61321597E+00  .17011627E+00 -.60959514E-01   ]*  
![  2  .20105163E+01  .76235744E+00  .40801617E-01 -.23623067E+00   ]*  
![  3  .24864650E+01  .46571363E+00 -.46031931E+00 -.55764503E-01   ]*  
      PROGRAM TEST 
![  4  .24360949E+01 -.62221850E+00 -.62761282E+00  .10093213E+01   ]*  
![  5  .20391625E+01  .41848596E-02  .15134810E+01 -.94880277E+00   ]*  
![  6  .24634097E+01  .72136600E+00 -.49923365E+00  .27087504E+00   ]*  
![  7  .30244387E+01  .62082700E+00  .40930883E+00 -.13643628E+00   ]*  
![                                                                  ]*  
![                                                                  ]*  
![  I      AY(I)          BY(I)          CY(I)          DY(I)       ]*  
![ --------------------------------------------------------------   ]*  
![  0  .10109978E+01  .96465686E+00  .00000000E+00 -.18329611E-01   ]*  
![  1  .20639005E+01  .89592082E+00 -.61479383E-01 -.55083390E+00   ]*  
![  2  .24719233E+01 -.17275001E-01 -.12299745E+01  .38505549E+00   ]*  
![  3  .19808585E+01 -.11791384E+01 -.41314849E+00  .64027609E+00   ]*  
![  4  .10288476E+01 -.84607158E-01  .15076798E+01 -.80210469E+00   ]*  
![  5  .14392744E+01  .84441699E+00 -.19384122E+00  .20998910E+00   ]*  
![  6  .20136891E+01  .88526775E+00  .25161292E+00 -.24631419E+00   ]*  
![  7  .29737301E+01  .52421316E+00 -.57454997E+00  .19151666E+00   ]*  
![                                                                  ]*  
![ COEFFICIENTS FOUND.                                              ]*  
![                                                                  ]*  
![                                                                  ]*  
![ TABLE OF VALUES FOR:                                             ]*  
![   STARTING VALUE = T(0) =    .00                                 ]*  
![   FINAL VALUE    = T(N) =   7.06                                 ]*  
![                                                                  ]*  
![                                                                  ]*  
![ C) TABLE OF VALUES:                                              ]*  
![    ----------------                                              ]*  
![                                                                  ]*  
![   I          SX(T(I))                SY(T(I))                    ]*  
![ ---------------------------------------------------              ]*  
![   0     .96956867563894E+00     .10109977664259E+01              ]*  
![   1     .11298442433874E+01     .13695553963480E+01              ]*  
![   2     .13058713180611E+01     .17224204907774E+01              ]*  
![   3     .15134014065850E+01     .20639005142212E+01              ]*  
![   4     .17487764697749E+01     .23486277860944E+01              ]*  
![   5     .20105162694425E+01     .24719233184789E+01              ]*  
![   6     .22747105093722E+01     .23290860758348E+01              ]*  
![   7     .24864650373667E+01     .19808584550957E+01              ]*  
![   8     .25884909721268E+01     .15656208514437E+01              ]*  
![   9     .25758316145053E+01     .12008560466148E+01              ]*  
![  10     .24360948526790E+01     .10288476154703E+01              ]*  
![  11     .21822619086069E+01     .11519460849855E+01              ]*  
![  12     .20391624810125E+01     .14392743729353E+01              ]*  
![  13     .21878956172425E+01     .17228710042750E+01              ]*  
![  14     .24634096659932E+01     .20136890984986E+01              ]*  
![  15     .26769296126321E+01     .23658057222595E+01              ]*  
![  16     .28358978487548E+01     .27113182606686E+01              ]*  
![  17     .30244386787846E+01     .29737301494711E+01              ]*  
![  18     .32718065754437E+01     .30917221926902E+01              ]*  
![  19     .35798128178790E+01     .31245957218499E+01              ]*  
![  20     .39181382332023E+01     .31149099939800E+01              ]*  
![                                                                  ]*  
![ TABLE FOUND.                                                     ]*  
![                                                                  ]*  
![                                                                  ]*  
![ TO FIND:   A) TABLE OF VALUES FOR THE PARAMETER T(I),I=0(1)N     ]*  
![ ========                                                         ]*  
![            B) COEFFICIENTS OF A PARAMETRIC, PERIODIC, CUBIC      ]*  
![               APPROXIMATING SPLINE WITH COMPONENT FUNCTIONS      ]*  
![               SX AND SY AT THE NODES X(I),Y(I).                  ]*  
![               END POINT CONDITIONS FOR SX AND SY:                ]*  
![               1ST DERIVATIVE (DY/DX) GIVEN:                      ]*  
![               AT  X(0) :    1.5000                               ]*  
![               AT  X(N) :    -.6000                               ]*  
![                                                                  ]*  
![            C) TABLE OF VALUES FOR SX(T),SY(T)                    ]*  
![                                                                  ]*  
![                                                                  ]*  
![ SOLUTION:                                                        ]*  
![ =========                                                        ]*  
![                                                                  ]*  
![ A) PARAMETER VALUES T:                                           ]*  
![    -------------------                                           ]*  
![                                                                  ]*  
![  I         T(I)                                                  ]*  
![ --------------------------                                       ]*  
![  0    .00000000000000E+00                                        ]*  
![  1    .11180339887499E+01                                        ]*  
![  2    .18251407699364E+01                                        ]*  
![  3    .25322475511230E+01                                        ]*  
![  4    .35322475511230E+01                                        ]*  
![  5    .42393543323095E+01                                        ]*  
![  6    .49464611134961E+01                                        ]*  
![  7    .60644951022460E+01                                        ]*  
![  8    .70644951022460E+01                                        ]*  
![                                                                  ]*  
![                                                                  ]*  
![ B) SPLINE COEFFICIENTS:                                          ]*  
![    --------------------                                          ]*  
![                                                                  ]*  
![  I      AX(I)          BX(I)          CX(I)          DX(I)       ]*  
![ --------------------------------------------------------------   ]*  
![  0  .94208458E+00  .55470020E+00 -.14235180E+00  .96525696E-01   ]*  
![  1  .15192173E+01  .59836326E+00  .18140523E+00 -.63618209E-01   ]*  
![  2  .20105342E+01  .75948168E+00  .46450629E-01 -.23918767E+00   ]*  
![  3  .24862285E+01  .46639129E+00 -.46094304E+00 -.55567903E-01   ]*  
![  4  .24361089E+01 -.62219850E+00 -.62764675E+00  .10092844E+01   ]*  
![  5  .20391606E+01  .41015017E-02  .15133687E+01 -.94874670E+00   ]*  
![  6  .24633126E+01  .72120800E+00 -.49922697E+00  .27416796E+00   ]*  
![  7  .30287753E+01  .63303241E+00  .42036032E+00 -.20542005E+00   ]*  
![                                                                  ]*  
![                                                                  ]*  
![  I      AY(I)          BY(I)          CY(I)          DY(I)       ]*  
![ --------------------------------------------------------------   ]*  
![  0  .10386737E+01  .83205029E+00  .14335359E+00 -.64456193E-01   ]*  
![  1  .20580460E+01  .91088795E+00 -.72839049E-01 -.54817244E+00   ]*  
![  2  .24719132E+01 -.14380685E-01 -.12356884E+01  .38805263E+00   ]*  
![  3  .19810977E+01 -.11798290E+01 -.41250447E+00  .64008346E+00   ]*  
![  4  .10288476E+01 -.84587601E-01  .15077459E+01 -.80229829E+00   ]*  
![  5  .14392528E+01  .84423968E+00 -.19418577E+00  .21015431E+00   ]*  
![  6  .20134283E+01  .88485099E+00  .25161884E+00 -.23745663E+00   ]*  
![  7  .29853896E+01  .55702546E+00 -.54483490E+00  .60495304E-02   ]*  
![                                                                  ]*  
![ COEFFICIENTS FOUND.                                              ]*  
![                                                                  ]*  
![                                                                  ]*  
![ TABLE OF VALUES FOR:                                             ]*  
![   STARTING VALUE = T(0) =    .00                                 ]*  
![   FINAL VALUE    = T(N) =   7.06                                 ]*  
![                                                                  ]*  
![                                                                  ]*  
![ C) TABLE OF VALUES:                                              ]*  
![    ----------------                                              ]*  
![                                                                  ]*  
![   I          SX(T(I))                SY(T(I))                    ]*  
![ ---------------------------------------------------              ]*  
![   0     .94208458229803E+00     .10386737157558E+01              ]*  
![   1     .11340343072509E+01     .13653344674582E+01              ]*  
![   2     .13164193684982E+01     .17117978247160E+01              ]*  
![   3     .15192172685694E+01     .20580459501745E+01              ]*  
![   4     .17506347269722E+01     .23467625649727E+01              ]*  
![   5     .20105341675839E+01     .24719132477767E+01              ]*  
![   6     .22742871181741E+01     .23295175224950E+01              ]*  
![   7     .24862285176256E+01     .19810976876907E+01              ]*  
![   8     .25884183165917E+01     .15656943046188E+01              ]*  
![   9     .25758279063967E+01     .12008640307330E+01              ]*  
![  10     .24361088640815E+01     .10288476350375E+01              ]*  
![  11     .21822771205115E+01     .11519527308738E+01              ]*  
![  12     .20391606211687E+01     .14392528439225E+01              ]*  
![  13     .21878527322947E+01     .17227510195523E+01              ]*  
![  14     .24633125603329E+01     .20134283281326E+01              ]*  
![  15     .26769449958163E+01     .23658489296804E+01              ]*  
![  16     .28370502453423E+01     .27144179360970E+01              ]*  
![  17     .30287752802804E+01     .29853896305066E+01              ]*  
![  18     .32788846376663E+01     .31107516294048E+01              ]*  
![  19     .35767585014670E+01     .31163835452872E+01              ]*  
![  20     .38767479726723E+01     .30036297182440E+01              ]*  
![                                                                  ]*  
![ TABLE FOUND.                                                     ]*  
!                                                                    *  
!*********************************************************************  
!                                                                    *  
!   Author      :  Gnter Palm                                       *  
!   Date        :  5.22.1988                                         *  
!   Source code :  FORTRAN 77                                        *  
!                                                                    *  
!*********************************************************************  
!                                                                       
      PARAMETER (N = 8, MT = 15) 
      IMPLICIT DOUBLEPRECISION (A - H, O - Z) 
!                                                                       
      DIMENSION X (0:N), Y (0:N), T (0:N), WX (0:N), WY (0:N) 
      DIMENSION AX (0:N), BX (0:N), CX (0:N), DX (0:N) 
      DIMENSION AY (0:N), BY (0:N), CY (0:N), DY (0:N) 
      DIMENSION XW (0:N + MT + 2), YW (0:N + MT + 2) 
      DIMENSION ALPHA (1:2, 1:3), BETA (1:2, 1:3) 
      DIMENSION HILF (14 * N - 10) 
!                                                                       
      DATA X / 1.0D0, 1.5D0, 2.0D0, 2.5D0, 2.5D0, 2.0D0, 2.5D0, 3.0D0,  &
      4.0D0 /                                                           
      DATA Y / 1.0D0, 2.0D0, 2.5D0, 2.0D0, 1.0D0, 1.5D0, 2.0D0, 3.0D0,  &
      3.0D0 /                                                           
      DATA WX / 10.0D0, 50.0D0, 100.0D0, 80.0D0, 100.0D0, 300.0D0,      &
      200.0D0, 100.0D0, 10.0D0 /                                        
      DATA WY / 10.0D0, 50.0D0, 200.0D0, 80.0D0, 300.0D0, 100.0D0,      &
      200.0D0, 100.0D0, 10.0D0 /                                        
      DATA ALPHA (1, 1) / 0.1D0 /, ALPHA (2, 1) / 1.0D0 / 
      DATA BETA (1, 1) / 1.0D0 /, BETA (2, 1) / - 1.0D0 / 
      DATA ALPHA (1, 2) / 0.0D0 /, ALPHA (2, 2) / 0.0D0 / 
      DATA BETA (1, 2) / 0.0D0 /, BETA (2, 2) / 0.0D0 / 
      DATA ALPHA (1, 3) / 1.5D0 /, BETA (1, 3) / - 0.6D0 / 
      DATA IW / 2 /, JT / 1 / 
!                                                                       
      WRITE ( *, 2000) N 
      DO 100 I = 0, N, 1 
         WRITE ( *, 2100) I, X (I), Y (I), WX (I), WY (I) 
  100 END DO 
      DO 10 IAB = 1, 3 
         CALL CFSPPA (N, X, Y, WX, WY, T, JT, IAB, ALPHA (1, IAB),      &
         BETA (1, IAB), IW, AX, BX, CX, DX, AY, BY, CY, DY, HILF, IFEHL)
         IF (IFEHL.NE.0) THEN 
            WRITE ( *, 1100) IFEHL 
            STOP 
         ENDIF 
         WRITE ( *, 2200) 
         IF (IAB.LE.2) THEN 
            WRITE ( *, 2250) IAB, ALPHA (1, IAB), BETA (1, IAB),        &
            ALPHA (2, IAB), BETA (2, IAB)                               
         ELSE 
            WRITE ( *, 2260) ALPHA (1, IAB), BETA (1, IAB) 
         ENDIF 
         WRITE ( *, 2270) 
         DO 150 I = 0, N, 1 
            WRITE ( *, 2275) I, T (I) 
  150    END DO 
         WRITE ( *, 2280) 
         DO 200 I = 0, N - 1, 1 
            WRITE ( *, 2300) I, AX (I), BX (I), CX (I), DX (I) 
  200    END DO 
         WRITE ( *, 2290) 
         DO 250 I = 0, N - 1, 1 
            WRITE ( *, 2300) I, AY (I), BY (I), CY (I), DY (I) 
  250    END DO 
!                                                                       
         WRITE ( *, 1150) T (0), T (N) 
         TANF = T (0) 
         TEND = T (N) 
         CALL PSPTAB (N, MT, TANF, TEND, T, AX, BX, CX, DX, AY, BY, CY, &
         DY, NT, XW, YW, IFEHL)                                         
         IF (IFEHL.NE.0) THEN 
            WRITE ( *, 1400) 
            STOP 
         ENDIF 
         WRITE ( *, 2400) 
         DO 300 I = 0, NT, 1 
            WRITE ( *, 2500) I, XW (I), YW (I) 
  300    END DO 
         WRITE ( *, 2600) 
   10 END DO 
      STOP 
!                                                                       
! Format                                                                
!                                                                       
 1100 FORMAT(1X,'C[ ERROR WITH COMPUTING COEFFICIENTS.',T70,']*',/,     &
     &       1X,'C[ ERROR PARAMETER =',I4,T70,']*')                     
 1150 FORMAT(1X,'C[',T70,']*',/,                                        &
     &       1X,'C[ COEFFICIENTS FOUND.',                               &
     &          T70,']*',/,1X,'C[',T70,']*',/,1X,'C[',T70,']*',/,       &
     &       1X,'C[ TABLE OF VALUES FOR:',T70,']*',/,                   &
     &       1X,'C[   STARTING VALUE = T(0) = ',F6.2,T70,']*',/,        &
     &       1X,'C[   FINAL VALUE    = T(N) = ',F6.2,T70,']*',/,        &
     &       1X,'C[',T70,']*')                                          
 1400 FORMAT(1X,'C[ ERRONEOUS INPUT.',T70,']*',/,                       &
     &       1X,'C[ TANF EXCEEDS TEND.',T70,']*')                       
 2000 FORMAT(1X,'C[',T70,']*',/,                                        &
     &       1X,'C[ GIVEN:   N + 1 POINTS X(I),Y(I), I=0(1)N, (N=',     &
     &          I2,'),',T70,']*',/,                                     &
     &       1X,'C[ ======   AND WEIGHTS WX(I) AND WY(I)',T70,']*',/,   &
     &       1X,'C[',T70,']*',/,                                        &
     &       1X,'C[  I        X(I)         Y(I)          WX(I)',        &
     &          '         WY(I)',T70,']*',/,                            &
     &       1X,'C[',2X,57('-'),T70,']*')                               
 2100 FORMAT(1X,'C[',1X,I2,4X,F9.4,4X,F9.4,4X,F10.4,4X,F10.4,T70,']*') 
 2200 FORMAT(1X,'C[',T70,']*',/,1X,'C[',T70,']*',/,                     &
     &       1X,'C[ TO FIND:   A) TABLE OF VALUES FOR THE PARAMETER ',  &
     &          'T(I),I=0(1)N',T70,']*',/,1X,'C[ ========',T70,']*',/,  &
     &       1X,'C[',12X,'B) COEFFICIENTS OF A PARAMETRIC, ',           &
     &          'PERIODIC, CUBIC',T70,']*',/,                           &
     &       1X,'C[',15X,'APPROXIMATING SPLINE WITH COMPONENT ',        &
     &          'FUNCTIONS',T70,']*',/,                                 &
     &       1X,'C[',15X,'SX AND SY AT THE NODES X(I),Y(I).',           &
     &          T70,']*',/,                                             &
     &       1X,'C[',15X,'END POINT CONDITIONS FOR SX AND SY:',T70,']*')
 2250 FORMAT(1X,'C[',15X,I1,'. DERIVATIVE WRT PARAMETER.',T70,']*',/,   &
     &       1X,'C[',15X,'FOR SX: DERIVATIVE AT  X(0) = ',F9.4,         &
     &          T70,']*',/,                                             &
     &       1X,'C[',15X,'        DERIVATIVE AT  X(N) = ',F9.4,         &
     &          T70,']*',/,                                             &
     &       1X,'C[',15X,'FOR SY: DERIVATIVE AT  X(0) = ',F9.4,         &
     &          T70,']*',/,                                             &
     &       1X,'C[',15X,'        DERIVATIVE AT  X(N) = ',F9.4,         &
     &          T70,']*')                                               
 2260 FORMAT(1X,'C[',15X,'1ST DERIVATIVE (DY/DX) GIVEN:',T70,']*',/,    &
     &       1X,'C[',15X,'AT  X(0) : ',F9.4,T70,']*',/,                 &
     &       1X,'C[',15X,'AT  X(N) : ',F9.4,T70,']*')                   
 2270 FORMAT(1X,'C[',T70,']*',/,                                        &
     &       1X,'C[',12X,'C) TABLE OF VALUES FOR SX(T),SY(T)',          &
     &          T70,']*',/,1X,'C[',T70,']*',/,1X,'C[',T70,']*',/,       &
     &       1X,'C[ SOLUTION:',T70,']*',/,                              &
     &       1X,'C[',1X,'=========',T70,']*',/,1X,'C[',T70,']*',/,      &
     &       1X,'C[ A) PARAMETER VALUES T:',T70,']*',/,                 &
     &       1X,'C[    -------------------',T70,']*',/,                 &
     &       1X,'C[',T70,']*',/,                                        &
     &       1X,'C[  I         T(I)',T70,']*',/,                        &
     &       1X,'C[', 1X,26('-'),T70,']*')                              
 2275 FORMAT(1X,'C[',1X,I2,3X,E20.14,T70,']*') 
 2280 FORMAT(1X,'C[',T70,']*',/,1X,'C[',T70,']*',/,                     &
     &       1X,'C[ B) SPLINE COEFFICIENTS:',T70,']*',/,                &
     &       1X,'C[    --------------------',T70,']*',/,                &
     &       1X,'C[',T70,']*',/,                                        &
     &       1X,'C[  I',6X,'AX(I)',10X,'BX(I)',10X,'CX(I)',10X,'DX(I)', &
     &          T70,']*',/,                                             &
     &       1X,'C[',1X,62('-'),T70,']*')                               
 2290 FORMAT(1X,'C[',T70,']*',/,1X,'C[',T70,']*',/,                     &
     &       1X,'C[  I',6X,'AY(I)',10X,'BY(I)',10X,'CY(I)',10X,'DY(I)', &
     &          T70,']*',/,                                             &
     &       1X,'C[',1X,62('-'),T70,']*')                               
 2300 FORMAT(1X,'C[',1X,I2,4(1X,E14.8),T70,']*') 
 2400 FORMAT(1X,'C[',T70,']*',/,                                        &
     &       1X,'C[ C) TABLE OF VALUES:',T70,']*',/,                    &
     &       1X,'C[    ----------------',T70,']*',/,                    &
     &       1X,'C[',T70,']*',/,                                        &
     &       1X,'C[   I          SX(T(I))                SY(T(I))',     &
     &          T70,']*',/,1X,'C[',1X,51('-'),T70,']*')                 
 2500 FORMAT(1X,'C[',1X,I3,2(4X,E20.14),T70,']*') 
 2600 FORMAT(1X,'C[',T70,']*',/,                                        &
     &       1X,'C[ TABLE FOUND.',T70,']*')                             
      END PROGRAM TEST                              
