!                                                                       
!*********************************************************************  
!              Test program for the subroutines                      *  
!              CFSPNP,CFSP1D,CFSP2D,CFSP3D,SPTAB.                    *  
!--------------------------------------------------------------------*  
!   required subroutines    :  CFSPNP,CFSP1D,CFSP2D,CFSP3D,          *  
!                              FDISY,FDISYP,FDISYS,                  *  
!                              FDIAG,FDIAGP,FDIAGS,SPTAB             *  
!--------------------------------------------------------------------*  
!                                                                    *  
!   This test program computes a non parametric cubic fitting spline *  
!   with prescribed 1st, 2nd or 3rd end point derivative for the     *  
!   following nodes:                                                 *  
!                                                                    *  
!                X          Y          W                             *  
!              -----------------------------                         *  
!               1.00       4.00     1000.00                          *  
!               2.00       5.00      500.00                          *  
!               3.00       4.50      100.00                          *  
!               3.50       3.20       10.00                          *  
!               4.80       2.70        1.00                          *  
!               5.70       2.00      100.00                          *  
!               7.00       1.00       10.00                          *  
!               8.50       1.50      500.00                          *  
!               9.20       2.50     1000.00                          *  
!                                                                    *  
!               where W(I) = weight for Y(I).                        *  
!                                                                    *  
!   We use the following end point derivatives:                      *  
!     1st end point derivatives   ALPHA =  1.0 , BETA =  1.5         *  
!     2nd end point derivatives   ALPHA =  0.0 , BETA =  0.0         *  
!     3rd end point derivatives   ALPHA = -1.2 , BETA = -1.7         *  
!                                                                    *  
!   Results:                                                         *  
!                                                                    *  
![                                                                  ]*  
![ GIVEN:   N + 1 POINTS X(I),Y(I), I=0(1)N, (N= 8),                ]*  
![ ======   AND WEIGHTS W(I)                                        ]*  
![                                                                  ]*  
![  I        X(I)         Y(I)          W(I)                        ]*  
![ -------------------------------------------                      ]*  
![  0       1.0000       4.0000     1000.0000                       ]*  
![  1       2.0000       5.0000      500.0000                       ]*  
![  2       3.0000       4.5000      100.0000                       ]*  
![  3       3.5000       3.2000       10.0000                       ]*  
![  4       4.8000       2.7000        1.0000                       ]*  
![  5       5.7000       2.0000      100.0000                       ]*  
![  6       7.0000       1.0000       10.0000                       ]*  
![  7       8.5000       1.5000      500.0000                       ]*  
![  8       9.2000       2.5000     1000.0000                       ]*  
![                                                                  ]*  
![                                                                  ]*  
![ TO FIND:  A) COEFFICIENTS OF A NON PARAMETRIC, CUBIC,            ]*  
![ ========     APPROXIMATING SPLINE S(X) FOR THE NODES X(I),Y(I).  ]*  
![              END POINT CONDITIONS FOR S(X):                      ]*  
![              1. DERIVATIVE AT  X(0) =    1.0000                  ]*  
![              1. DERIVATIVE AT  X(N) =    1.5000                  ]*  
![                                                                  ]*  
![           B) TABLE OF VALUES FOR S(X)                            ]*  
![                                                                  ]*  
![                                                                  ]*  
![ SOLUTION:                                                        ]*  
![ =========                                                        ]*  
![                                                                  ]*  
![ A) SPLINE COEFFICIENTS:                                          ]*  
![    --------------------                                          ]*  
![                                                                  ]*  
![  I       A(I)           B(I)           C(I)           D(I)       ]*  
![ --------------------------------------------------------------   ]*  
![  0  .40033000E+01  .10000000E+01  .53821914E+00 -.54999889E+00   ]*  
![  1  .49915202E+01  .42644160E+00 -.11117775E+01  .15664760E+00   ]*  
![  2  .44628319E+01 -.13271707E+01 -.64183475E+00  .77611583E+00   ]*  
![  3  .37358024E+01 -.13869186E+01  .52233900E+00 -.11688810E+00   ]*  
![  4  .25587580E+01 -.62145983E+00  .66475405E-01 -.93347764E-01   ]*  
![  5  .19852387E+01 -.72863917E+00 -.18556356E+00  .15267402E+00   ]*  
![  6  .10598302E+01 -.43704712E+00  .40986514E+00  .52957040E-01   ]*  
![  7  .15051861E+01  .11500083E+01  .64817182E+00 -.37921691E+00   ]*  
![                                                                  ]*  
![ COEFFICIENTS FOUND.                                              ]*  
![                                                                  ]*  
![                                                                  ]*  
![ TABLE OF VALUES FOR:                                             ]*  
![   STARTING VALUE = XANF =    .00                                 ]*  
![   FINAL VALUE    = XEND =  10.00                                 ]*  
![                                                                  ]*  
![                                                                  ]*  
![                                                                  ]*  
![ B) TABLE OF VALUES FOR SPLINE:                                   ]*  
![    ---------------------------                                   ]*  
![                                                                  ]*  
![   I           XW(I)                   YW(I)                      ]*  
![ ---------------------------------------------------              ]*  
![   0     .00000000000000E+00     .40915180281272E+01              ]*  
![   1     .50000000000000E+00     .37066046404251E+01              ]*  
![   2     .10000000000000E+01     .40032999933580E+01              ]*  
![   3     .15000000000000E+01     .45691049171748E+01              ]*  
![   4     .20000000000000E+01     .49915202421246E+01              ]*  
![   5     .25000000000000E+01     .49463776096583E+01              ]*  
![   6     .30000000000000E+01     .44628319060341E+01              ]*  
![   7     .35000000000000E+01     .37358023578078E+01              ]*  
![   8     .41500000000000E+01     .30228931283073E+01              ]*  
![   9     .48000000000000E+01     .25587579837246E+01              ]*  
![  10     .52500000000000E+01     .22840560136341E+01              ]*  
![  11     .57000000000000E+01     .19852386926646E+01              ]*  
![  12     .63500000000000E+01     .14751507330194E+01              ]*  
![  13     .70000000000000E+01     .10598301910223E+01              ]*  
![  14     .75000000000000E+01     .95039254774380E+00              ]*  
![  15     .80000000000000E+01     .10856052532993E+01              ]*  
![  16     .85000000000000E+01     .15051860874126E+01              ]*  
![  17     .88500000000000E+01     .19708311206746E+01              ]*  
![  18     .92000000000000E+01     .24977246985315E+01              ]*  
![  19     .96000000000000E+01     .30497454246132E+01              ]*  
![  20     .10000000000000E+02     .34087280735345E+01              ]*  
![                                                                  ]*  
![ TABLE FOUND.                                                     ]*  
![                                                                  ]*  
![                                                                  ]*  
![ TO FIND:  A) COEFFICIENTS OF A NON PARAMETRIC, CUBIC,            ]*  
![ ========     APPROXIMATING SPLINE S(X) FOR THE NODES X(I),Y(I).  ]*  
![              END POINT CONDITIONS FOR S(X):                      ]*  
![              2. DERIVATIVE AT  X(0) =     .0000                  ]*  
![              2. DERIVATIVE AT  X(N) =     .0000                  ]*  
![                                                                  ]*  
![           B) TABLE OF VALUES FOR S(X)                            ]*  
![                                                                  ]*  
![                                                                  ]*  
![ SOLUTION:                                                        ]*  
![ =========                                                        ]*  
![                                                                  ]*  
![ A) SPLINE COEFFICIENTS:                                          ]*  
![    --------------------                                          ]*  
![                                                                  ]*  
![  I       A(I)           B(I)           C(I)           D(I)       ]*  
![ --------------------------------------------------------------   ]*  
![  0  .40019611E+01  .13196907E+01  .00000000E+00 -.32684423E+00   ]*  
![  1  .49948075E+01  .33915801E+00 -.98053268E+00  .10586202E+00   ]*  
![  2  .44592949E+01 -.13043213E+01 -.66294663E+00  .78428091E+00   ]*  
![  3  .37394327E+01 -.13790573E+01  .51347474E+00 -.11477354E+00   ]*  
![  4  .25622731E+01 -.62592479E+00  .65857930E-01 -.91819054E-01   ]*  
![  5  .19853496E+01 -.73050081E+00 -.18205351E+00  .15235418E+00   ]*  
![  6  .10627502E+01 -.43140424E+00  .41212780E+00  .47770434E-01   ]*  
![  7  .15041566E+01  .11274296E+01  .62709475E+00 -.29861655E+00   ]*  
![                                                                  ]*  
![ COEFFICIENTS FOUND.                                              ]*  
![                                                                  ]*  
![                                                                  ]*  
![ TABLE OF VALUES FOR:                                             ]*  
![   STARTING VALUE = XANF =    .00                                 ]*  
![   FINAL VALUE    = XEND =  10.00                                 ]*  
![                                                                  ]*  
![                                                                  ]*  
![                                                                  ]*  
![ B) TABLE OF VALUES FOR SPLINE:                                   ]*  
![    ---------------------------                                   ]*  
![                                                                  ]*  
![   I           XW(I)                   YW(I)                      ]*  
![ ---------------------------------------------------              ]*  
![   0     .00000000000000E+00     .30091146056611E+01              ]*  
![   1     .50000000000000E+00     .33829712503282E+01              ]*  
![   2     .10000000000000E+01     .40019610653629E+01              ]*  
![   3     .15000000000000E+01     .46209508803977E+01              ]*  
![   4     .20000000000000E+01     .49948075250648E+01              ]*  
![   5     .25000000000000E+01     .49324861095717E+01              ]*  
![   6     .30000000000000E+01     .44592948664254E+01              ]*  
![   7     .35000000000000E+01     .37394326703219E+01              ]*  
![   8     .41500000000000E+01     .30284688494312E+01              ]*  
![   9     .48000000000000E+01     .25622730799495E+01              ]*  
![  10     .52500000000000E+01     .22855761458790E+01              ]*  
![  11     .57000000000000E+01     .19853496058189E+01              ]*  
![  12     .63500000000000E+01     .14754467352508E+01              ]*  
![  13     .70000000000000E+01     .10627502494530E+01              ]*  
![  14     .75000000000000E+01     .95605138133102E+00              ]*  
![  15     .80000000000000E+01     .10912442376672E+01              ]*  
![  16     .85000000000000E+01     .15041566437775E+01              ]*  
![  17     .88500000000000E+01     .19627729187971E+01              ]*  
![  18     .92000000000000E+01     .24982083007138E+01              ]*  
![  19     .96000000000000E+01     .31056552032601E+01              ]*  
![  20     .10000000000000E+02     .35984333514877E+01              ]*  
![                                                                  ]*  
![ TABLE FOUND.                                                     ]*  
![                                                                  ]*  
![                                                                  ]*  
![ TO FIND:  A) COEFFICIENTS OF A NON PARAMETRIC, CUBIC,            ]*  
![ ========     APPROXIMATING SPLINE S(X) FOR THE NODES X(I),Y(I).  ]*  
![              END POINT CONDITIONS FOR S(X):                      ]*  
![              3. DERIVATIVE AT  X(0) =   -1.2000                  ]*  
![              3. DERIVATIVE AT  X(N) =   -1.7000                  ]*  
![                                                                  ]*  
![           B) TABLE OF VALUES FOR S(X)                            ]*  
![                                                                  ]*  
![                                                                  ]*  
![ SOLUTION:                                                        ]*  
![ =========                                                        ]*  
![                                                                  ]*  
![ A) SPLINE COEFFICIENTS:                                          ]*  
![    --------------------                                          ]*  
![                                                                  ]*  
![  I       A(I)           B(I)           C(I)           D(I)       ]*  
![ --------------------------------------------------------------   ]*  
![  0  .40012000E+01  .15014158E+01 -.30593996E+00 -.20000000E+00   ]*  
![  1  .49966758E+01  .28953588E+00 -.90593996E+00  .77013437E-01   ]*  
      PROGRAM TEST 
![  2  .44572852E+01 -.12913037E+01 -.67489965E+00  .78892689E+00   ]*  
![  3  .37415243E+01 -.13745082E+01  .50849069E+00 -.11361357E+00   ]*  
![  4  .25644039E+01 -.62845321E+00  .65397773E-01 -.91014211E-01   ]*  
![  5  .19854188E+01 -.73190175E+00 -.18034060E+00  .15200576E+00   ]*  
![  6  .10631276E+01 -.43011808E+00  .41248188E+00  .46793130E-01   ]*  
![  7  .15039615E+01  .11231812E+01  .62305097E+00 -.28333333E+00   ]*  
![                                                                  ]*  
![ COEFFICIENTS FOUND.                                              ]*  
![                                                                  ]*  
![                                                                  ]*  
![ TABLE OF VALUES FOR:                                             ]*  
![   STARTING VALUE = XANF =    .00                                 ]*  
![   FINAL VALUE    = XEND =  10.00                                 ]*  
![                                                                  ]*  
![                                                                  ]*  
![                                                                  ]*  
![ B) TABLE OF VALUES FOR SPLINE:                                   ]*  
![    ---------------------------                                   ]*  
![                                                                  ]*  
![   I           XW(I)                   YW(I)                      ]*  
![ ---------------------------------------------------              ]*  
![   0     .00000000000000E+00     .23938442390183E+01              ]*  
![   1     .50000000000000E+00     .31990071097881E+01              ]*  
![   2     .10000000000000E+01     .40012000000000E+01              ]*  
![   3     .15000000000000E+01     .46504229096541E+01              ]*  
![   4     .20000000000000E+01     .49966758387503E+01              ]*  
![   5     .25000000000000E+01     .49245854669730E+01              ]*  
![   6     .30000000000000E+01     .44572851927437E+01              ]*  
![   7     .35000000000000E+01     .37415242759521E+01              ]*  
![   8     .41500000000000E+01     .30317301280279E+01              ]*  
![   9     .48000000000000E+01     .25644038552894E+01              ]*  
![  10     .52500000000000E+01     .22865492892120E+01              ]*  
![  11     .57000000000000E+01     .19854188015079E+01              ]*  
![  12     .63500000000000E+01     .14752333438885E+01              ]*  
![  13     .70000000000000E+01     .10631275806071E+01              ]*  
![  14     .75000000000000E+01     .95703815431973E+00              ]*  
![  15     .80000000000000E+01     .10922845175196E+01              ]*  
![  16     .85000000000000E+01     .15039615175576E+01              ]*  
![  17     .88500000000000E+01     .19612507651525E+01              ]*  
![  18     .92000000000000E+01     .24983000000000E+01              ]*  
![  19     .96000000000000E+01     .31162358446249E+01              ]*  
![  20     .10000000000000E+02     .36343479991309E+01              ]*  
![                                                                  ]*  
![ TABLE FOUND.                                                     ]*  
!                                                                    *  
!*********************************************************************  
!                                                                    *  
!     Author     :  Gnter Palm                                      *  
!     Date       :  5.22.1988                                        *  
!     Sourcecode :  FORTRAN 77                                       *  
!                                                                    *  
!*********************************************************************  
!                                                                       
      PARAMETER (N = 8, MT = 15) 
      IMPLICIT DOUBLEPRECISION (A - H, O - Z) 
!                                                                       
      DIMENSION X (0:N), Y (0:N), W (0:N) 
      DIMENSION A (0:N), B (0:N), C (0:N), D (0:N) 
      DIMENSION XW (0:N + MT + 2), YW (0:N + MT + 2) 
      DIMENSION ALPHA (3), BETA (3) 
      DIMENSION HILF (14 * N - 10) 
!                                                                       
      DATA X / 1.0D0, 2.0D0, 3.0D0, 3.5D0, 4.8D0, 5.7D0, 7.0D0, 8.5D0,  &
      9.2D0 /                                                           
      DATA Y / 4.0D0, 5.0D0, 4.5D0, 3.2D0, 2.7D0, 2.0D0, 1.0D0, 1.5D0,  &
      2.5D0 /                                                           
      DATA W / 1000.0D0, 500.0D0, 100.0D0, 10.0D0, 1.0D0, 100.0D0,      &
      10.0D0, 500.0D0, 1000.0D0 /                                       
      DATA ALPHA / 1.0D0, 0.0D0, - 1.2D0 / 
      DATA BETA / 1.5D0, 0.0D0, - 1.7D0 / 
!                                                                       
      WRITE ( *, 2000) N 
      DO 100 I = 0, N, 1 
         WRITE ( *, 2100) I, X (I), Y (I), W (I) 
  100 END DO 
      DO 10 IAB = 1, 3 
         CALL CFSPNP (N, X, Y, W, IAB, ALPHA (IAB), BETA (IAB), A, B, C,&
         D, HILF, IFEHL)                                                
         IF (IFEHL.NE.0) THEN 
            WRITE ( *, 1100) IFEHL 
            STOP 
         ENDIF 
         WRITE ( *, 2200) IAB, ALPHA (IAB), IAB, BETA (IAB) 
         DO 200 I = 0, N - 1, 1 
            WRITE ( *, 2300) I, A (I), B (I), C (I), D (I) 
  200    END DO 
!                                                                       
         XANF = 0.D+00 
         XEND = 1.D+01 
         WRITE ( *, 1150) XANF, XEND 
         CALL SPTAB (N, MT, XANF, XEND, X, A, B, C, D, NT, XW, YW,      &
         IFEHL)                                                         
         IF (IFEHL.NE.0) THEN 
            WRITE ( *, 1400) 
            STOP 
         ENDIF 
         WRITE ( *, 2400) 
         DO 300 I = 0, NT, 1 
            WRITE ( *, 2500) I, XW (I), YW (I) 
  300    END DO 
         WRITE ( *, 2600) 
   10 END DO 
      STOP 
!                                                                       
! Format                                                                
!                                                                       
 1100 FORMAT(1X,'C[ ERROR WITH COMPUTING COEFFICIENTS.',T70,']*',/,     &
     &       1X,'C[ ERROR PARAMETER =',I4,T70,']*')                     
 1150 FORMAT(1X,'C[',T70,']*',/,                                        &
     &       1X,'C[ COEFFICIENTS FOUND.',                               &
     &          T70,']*',/,1X,'C[',T70,']*',/,1X,'C[',T70,']*',/,       &
     &       1X,'C[ TABLE OF VALUES FOR:',T70,']*',/,                   &
     &       1X,'C[   STARTING VALUE = XANF = ',F6.2,T70,']*',/,        &
     &       1X,'C[   FINAL VALUE    = XEND = ',F6.2,T70,']*',/,        &
     &       1X,'C[',T70,']*')                                          
 1400 FORMAT(1X,'C[ ERRONEOUS INPUT.',T70,']*',/,                       &
     &       1X,'C[ XANF EXCEEDS XEND.',T70,']*')                       
 2000 FORMAT(1X,'C[',T70,']*',/,                                        &
     &       1X,'C[ GIVEN:   N + 1 POINTS X(I),Y(I), I=0(1)N, (N=',I2,  &
     &          '),',T70,']*',/,                                        &
     &       1X,'C[ ======   AND WEIGHTS W(I)',T70,']*',/,              &
     &       1X,'C[',T70,']*',/,                                        &
     &       1X,'C[  I        X(I)         Y(I)          W(I)',         &
     &          T70,']*',/,                                             &
     &       1X,'C[',1X,43('-'),T70,']*')                               
 2100 FORMAT(1X,'C[',1X,I2,4X,F9.4,4X,F9.4,4X,F10.4,T70,']*') 
 2200 FORMAT(1X,'C[',T70,']*',/,1X,'C[',T70,']*',/,                     &
     &       1X,'C[ TO FIND:  A) COEFFICIENTS OF A NON PARAMETRIC, ',   &
     &          'CUBIC,',T70,']*',/,                                    &
     &       1X,'C[ ========     APPROXIMATING SPLINE S(X) FOR THE ',   &
     &          'NODES X(I),Y(I).',T70,']*',/,                          &
     &       1X,'C[',14X,'END POINT CONDITIONS FOR S(X):',T70,']*',/,   &
     &       1X,'C[',14X,I1,'. DERIVATIVE AT  X(0) = ',F9.4,T70,']*',/, &
     &       1X,'C[',14X,I1,'. DERIVATIVE AT  X(N) = ',F9.4,T70,']*',/, &
     &       1X,'C[',T70,']*',/,                                        &
     &       1X,'C[           B) TABLE OF VALUES FOR S(X)',T70,']*',/,  &
     &       1X,'C[',T70,']*',/,1X,'C[',T70,']*',/,                     &
     &       1X,'C[ SOLUTION:',T70,']*',/,                              &
     &       1X,'C[ =========',T70,']*',/,                              &
     &       1X,'C[',T70,']*',/,                                        &
     &       1X,'C[ A) SPLINE COEFFICIENTS:',T70,']*',/,                &
     &       1X,'C[    --------------------',T70,']*',/,                &
     &       1X,'C[',T70,']*',/,                                        &
     &       1X,'C[  I',7X,'A(I)',11X,'B(I)',11X,'C(I)',11X,'D(I)',T70, &
     &          ']*',/,1X,'C[',1X,62('-'),T70,']*')                     
 2300 FORMAT(1X,'C[',1X,I2,4(1X,E14.8),T70,']*') 
 2400 FORMAT(1X,'C[',T70,']*',/,1X,'C[',T70,']*',/,                     &
     &       1X,'C[ B) TABLE OF VALUES FOR SPLINE:',T70,']*',/,         &
     &       1X,'C[    ---------------------------',T70,']*',/,         &
     &       1X,'C[',T70,']*',/,                                        &
     &       1X,'C[   I           XW(I)                   YW(I)',       &
     &          T70,']*',/,                                             &
     &       1X,'C[',1X,51('-'),T70,']*')                               
 2500 FORMAT(1X,'C[',1X,I3,2(4X,E20.14),T70,']*') 
 2600 FORMAT(1X,'C[',T70,']*',/,                                        &
     &       1X,'C[ TABLE FOUND.',T70,']*')                             
      END PROGRAM TEST                              
