!                                                                       
!***********************************************************************
!   Test program for the subroutines BICSP3 and BSPVAL      85/03/29    
!                                                                       
!     ( Elmar Pohl )                                                    
!                                                                       
!                                                                       
!                                                                       
!     Test example for using BICSP3 and BSPVAL:                         
!     Compute a bicubic spline with given surface normal.               
!     Flchennormalen                                                   
!                                                                       
!     (The output is designed for M <= 10)                              
!                                                                       
![                                                                      
![ COMPUTE A BICUBIC SPLINE USING BICSP3                                
![ =====================================                                
![                                                                      
![ X COORDINATES OF THE NODES                                           
![ --------------------------                                           
![                                                                      
![    I     X(I)                                                        
![ -----------------                                                    
![    0    0.000D+00                                                    
![    1    1.000D+00                                                    
![    2    2.000D+00                                                    
![    3    3.400D+00                                                    
![    4    5.000D+00                                                    
![                                                                      
![ Y COORDINATES OF THE NODES                                           
![ --------------------------                                           
![                                                                      
![    I     Y(I)                                                        
![ -----------------                                                    
![    0   -1.500D+00                                                    
![    1    0.000D+00                                                    
![    2    1.000D+00                                                    
![    3    1.500D+00                                                    
![                                                                      
![ GIVEN FUNCTION VALUES A(I,K,0,0) = S( X(I),Y(K) )                    
![ -------------------------------------------------                    
![            0           1           2           3                     
![ ---------------------------------------------------------------------
![    0   0.000D+00   0.000D+00   0.000D+00   0.000D+00                 
![    1   7.074D-02   1.000D+00   5.403D-01   7.074D-02                 
![    2   2.829D-01   4.000D+00   2.161D+00   2.829D-01                 
![    3   8.177D-01   1.156D+01   6.246D+00   8.177D-01                 
![    4   1.768D+00   2.500D+01   1.351D+01   1.768D+00                 
![                                                                      
![ SURFACE NORMAL FN(I,J)                                               
![ ----------------------                                               
![            0           1           2           3                     
![ ---------------------------------------------------------------------
![    0   0.000D+00   0.000D+00   0.000D+00   0.000D+00                 
![    0   0.000D+00   0.000D+00   0.000D+00   0.000D+00                 
![    0   1.000D+00   1.000D+00   1.000D+00   1.000D+00                 
![                                                                      
![    1  -1.415D-01  -2.000D+00  -1.081D+00  -1.415D-01                 
![    1  -9.975D-01   0.000D+00   8.415D-01   9.975D-01                 
![    1   1.000D+00   1.000D+00   1.000D+00   1.000D+00                 
![                                                                      
![    2  -2.829D-01  -4.000D+00  -2.161D+00  -2.829D-01                 
![    2  -3.990D+00   0.000D+00   3.366D+00   3.990D+00                 
![    2   1.000D+00   1.000D+00   1.000D+00   1.000D+00                 
![                                                                      
![    3  -4.810D-01  -6.800D+00  -3.674D+00  -4.810D-01                 
![    3  -1.153D+01   0.000D+00   9.727D+00   1.153D+01                 
![    3   1.000D+00   1.000D+00   1.000D+00   1.000D+00                 
![                                                                      
![    4  -7.074D-01  -1.000D+01  -5.403D+00  -7.074D-01                 
![    4  -2.494D+01   0.000D+00   2.104D+01   2.494D+01                 
![    4   1.000D+00   1.000D+00   1.000D+00   1.000D+00                 
![                                                                      
![                                                                      
![ COEFFICIENT ARRAYS A(I,J,K,L)                                        
![ =============================                                        
![ ( I IS THE ROW INDEX AND J IS THE COLUMN INDEX )                     
![                                                                      
![ COEFFICIENTS OF (X-X(I)) **  0 * (Y-Y(J)) **  1  :  A(I,J,  0,  1) = 
![ ---------------------------------------------------------------------
![            0           1           2                                 
![ ---------------------------------------------------------------------
![    0   0.000D+00   0.000D+00   0.000D+00                             
![    1   9.975D-01   0.000D+00  -8.415D-01                             
![    2   3.990D+00   0.000D+00  -3.366D+00                             
![    3   1.153D+01   0.000D+00  -9.727D+00                             
![                                                                      
![ COEFFICIENTS OF (X-X(I)) **  0 * (Y-Y(J)) **  2  :  A(I,J,  0,  2) = 
![ ---------------------------------------------------------------------
![            0           1           2                                 
![ ---------------------------------------------------------------------
![    0   0.000D+00   0.000D+00   0.000D+00                             
![    1  -9.098D-02  -5.376D-01  -2.739D-01                             
![    2  -3.639D-01  -2.150D+00  -1.096D+00                             
![    3  -1.052D+00  -6.215D+00  -3.166D+00                             
![                                                                      
![ COEFFICIENTS OF (X-X(I)) **  0 * (Y-Y(J)) **  3  :  A(I,J,  0,  3) = 
![ ---------------------------------------------------------------------
![            0           1           2                                 
![ ---------------------------------------------------------------------
![    0   0.000D+00   0.000D+00   0.000D+00                             
![    1  -1.073D-01   7.792D-02   1.572D-01                             
![    2  -4.294D-01   3.117D-01   6.287D-01                             
![    3  -1.241D+00   9.008D-01   1.817D+00                             
![                                                                      
![ COEFFICIENTS OF (X-X(I)) **  1 * (Y-Y(J)) **  0  :  A(I,J,  1,  0) = 
![ ---------------------------------------------------------------------
![            0           1           2                                 
![ ---------------------------------------------------------------------
![    0   0.000D+00   0.000D+00   0.000D+00                             
![    1   1.415D-01   2.000D+00   1.081D+00                             
![    2   2.829D-01   4.000D+00   2.161D+00                             
![    3   4.810D-01   6.800D+00   3.674D+00                             
![                                                                      
![ COEFFICIENTS OF (X-X(I)) **  1 * (Y-Y(J)) **  1  :  A(I,J,  1,  1) = 
![ ---------------------------------------------------------------------
![            0           1           2                                 
![ ---------------------------------------------------------------------
![    0   4.987D-01  -1.575D-01   1.925D-01                             
![    1   1.871D+00   5.899D-02  -1.724D+00                             
![    2   3.987D+00   4.055D-02  -3.354D+00                             
![    3   6.970D+00   8.411D-03  -5.627D+00                             
![                                                                      
![ COEFFICIENTS OF (X-X(I)) **  1 * (Y-Y(J)) **  2  :  A(I,J,  1,  2) = 
![ ---------------------------------------------------------------------
![            0           1           2                                 
![ ---------------------------------------------------------------------
![    0  -5.600D-01   1.225D-01   2.275D-01                             
![    1  -5.596D-02  -1.152D+00  -6.311D-01                             
![    2  -3.872D-01  -2.244D+00  -1.150D+00                             
![    3  -8.735D-01  -3.767D+00  -1.868D+00                             
![                                                                      
![ COEFFICIENTS OF (X-X(I)) **  1 * (Y-Y(J)) **  3  :  A(I,J,  1,  3) = 
![ ---------------------------------------------------------------------
![            0           1           2                                 
![ ---------------------------------------------------------------------
![    0   1.517D-01   3.500D-02  -1.225D+00                             
![    1  -2.436D-01   1.737D-01   6.456D-01                             
![    2  -4.126D-01   3.645D-01   6.889D-01                             
![    3  -6.431D-01   6.331D-01   7.004D-01                             
![                                                                      
![ COEFFICIENTS OF (X-X(I)) **  2 * (Y-Y(J)) **  0  :  A(I,J,  2,  0) = 
![ ---------------------------------------------------------------------
![            0           1           2                                 
![ ---------------------------------------------------------------------
![    0   7.074D-02   1.000D+00   5.403D-01                             
![    1   7.074D-02   1.000D+00   5.403D-01                             
![    2   7.074D-02   1.000D+00   5.403D-01                             
![    3   7.074D-02   1.000D+00   5.403D-01                             
![                                                                      
![ COEFFICIENTS OF (X-X(I)) **  2 * (Y-Y(J)) **  1  :  A(I,J,  2,  1) = 
![ ---------------------------------------------------------------------
![            0           1           2                                 
![ ---------------------------------------------------------------------
![    0   1.240D-01   2.560D-01  -1.185D+00                             
![    1   1.248D+00  -1.585D-01  -7.714D-01                             
![    2   8.679D-01  -6.394D-02  -9.268D-01                             
![    3   1.263D+00  -2.300D-01  -7.884D-01                             
![                                                                      
![ COEFFICIENTS OF (X-X(I)) **  2 * (Y-Y(J)) **  2  :  A(I,J,  2,  2) = 
![ ---------------------------------------------------------------------
![            0           1           2                                 
![ ---------------------------------------------------------------------
![    0   9.030D-01  -7.058D-01  -6.456D-01                             
![    1  -3.196D-01  -2.906D-01  -5.273D-02                             
![    2   1.244D-01  -3.245D-01  -1.919D-01                             
![    3  -2.911D-01  -1.307D-01   4.390D-02                             
![                                                                      
![ COEFFICIENTS OF (X-X(I)) **  2 * (Y-Y(J)) **  3  :  A(I,J,  2,  3) = 
![ ---------------------------------------------------------------------
![            0           1           2                                 
![ ---------------------------------------------------------------------
![    0  -3.818D-01  -9.885D-03   2.276D+00                             
![    1  -6.635D-02  -1.052D-02  -5.655D-01                             
![    2  -1.933D-01  -7.130D-02   3.343D-01                             
![    3  -9.176D-02  -9.899D-02  -6.908D-01                             
![                                                                      
![ COEFFICIENTS OF (X-X(I)) **  3 * (Y-Y(J)) **  0  :  A(I,J,  3,  0) = 
![ ---------------------------------------------------------------------
![            0           1           2                                 
![ ---------------------------------------------------------------------
![    0   0.000D+00   0.000D+00   0.000D+00                             
![    1   0.000D+00   0.000D+00   0.000D+00                             
![    2  -1.721D-17   5.755D-16   3.724D-16                             
![    3   1.561D-17  -1.776D-15  -4.718D-16                             
![                                                                      
![ COEFFICIENTS OF (X-X(I)) **  3 * (Y-Y(J)) **  1  :  A(I,J,  3,  1) = 
![ ---------------------------------------------------------------------
![            0           1           2                                 
![ ---------------------------------------------------------------------
![    0   3.748D-01  -9.851D-02   1.513D-01                             
![    1  -1.268D-01   9.954D-02  -2.891D-02                             
![    2   9.396D-02   2.498D-02   5.465D-02                             
![    3  -2.387D-01   1.405D-01  -7.023D-02                             
![                                                                      
![ COEFFICIENTS OF (X-X(I)) **  3 * (Y-Y(J)) **  2  :  A(I,J,  3,  2) = 
![ ---------------------------------------------------------------------
![            0           1           2                                 
![ ---------------------------------------------------------------------
![    0  -4.340D-01   4.570D-02   1.442D-01                             
![    1   1.027D-01  -1.702D-01  -1.379D-01                             
      PROGRAM TEST 
![    2  -1.419D-01  -1.046D-01  -3.070D-02                             
![    3   2.246D-01  -2.107D-01  -1.965D-01                             
![                                                                      
![ COEFFICIENTS OF (X-X(I)) **  3 * (Y-Y(J)) **  3  :  A(I,J,  3,  3) = 
![ ---------------------------------------------------------------------
![            0           1           2                                 
![ ---------------------------------------------------------------------
![    0   1.228D-01   5.281D-02  -8.938D-01                             
![    1  -1.210D-02   7.064D-02   3.915D-01                             
![    2   5.286D-02   7.963D-02  -1.572D-01                             
![    3  -4.366D-02   7.024D-02   6.739D-01                             
![                                                                      
![ EXAMPLE FOR USE OF BSPVAL:                                           
![ ==========================                                           
![                                                                      
![ TABLE OF VALUES FOR S(X,Y) AT THE CENTERS (X,Y) OF THE RECTANGLES    
![ FOR THE MESH, I. E.,                                                 
![     X = ( X(I)+X(I-1) )/2 , I = 1(1)N                                
![     Y = ( Y(K)+Y(K-1) )/2 , K = 1(1)M                                
![            1           2           3                                 
![ ---------------------------------------------------------------------
![    1   2.003D-01   2.118D-01   8.551D-02                             
![    2   1.622D+00   1.971D+00   7.080D-01                             
![    3   5.259D+00   6.384D+00   2.295D+00                             
![    4   1.279D+01   1.542D+01   5.578D+00                             
!                                                                       
!***********************************************************************
!                                                                       
      IMPLICIT DOUBLEPRECISION (A - H, O - Z) 
!                                                                       
      PARAMETER (N = 4, M = 3, KDIM = 3, LDIM = 3) 
!                                                                       
      DIMENSION A (0:N, 0:M, 0:KDIM, 0:LDIM), X (0:N), Y (0:M) 
      DIMENSION FN (0:N, 0:M, 3), F (80), XMIT (N), YMIT (N), ZMIT (N,  &
      M)                                                                
                                                                        
!                                                                       
!     VariableS FOR FORMAT STATEMENTS	                                  
!                                                                       
      CHARACTER FO1555 * 50, FO1560 * 50 
                                                                        
!                                                                       
! initialize mesh points                                                
!                                                                       
      DATA (X (I), I = 0, N) / 0.0D0, 1.0D0, 2.0D0, 3.4D0, 5.0D0 / 
      DATA (Y (I), I = 0, M) / - 1.5D0, 0.0D0, 1.0D0, 1.5D0 / 
!                                                                       
! compute functional values at mesh points                              
!                                                                       
      DO 10 I = 0, N 
         DO 10 K = 0, M 
            A (I, K, 0, 0) = S (X (I), Y (K) ) 
   10 CONTINUE 
!                                                                       
! compute surface normal at mesh points                                 
!                                                                       
      DO 20 I = 0, N 
         DO 20 J = 0, M 
            FN (I, J, 1) = - DSDX (X (I), Y (J) ) 
            FN (I, J, 2) = - DSDY (X (I), Y (J) ) 
            FN (I, J, 3) = 1.D0 
   20 CONTINUE 
!                                                                       
      WRITE ( *, 1520) 
      WRITE ( *, 1530) (I, X (I), I = 0, N) 
      WRITE ( *, 1540) (I, Y (I), I = 0, M) 
      WRITE ( *, 1550) 
      WRITE (FO1555, 1555) M + 1 
      WRITE ( *, FO1555) (I, I = 0, M) 
      WRITE ( *, 1556) 
      DO 30 I = 0, N 
         WRITE (FO1560, 1560) M + 1 
         WRITE ( *, FO1560) I, (A (I, K, 0, 0), K = 0, M) 
   30 END DO 
      WRITE ( *, 1570) 
      WRITE (FO1555, 1555) M + 1 
      WRITE ( *, FO1555) (I, I = 0, M) 
      WRITE ( *, 1556) 
      DO 40 I = 0, N 
         DO 50 K = 1, 3 
            WRITE (FO1560, 1560) M + 1 
            WRITE ( *, FO1560) I, (FN (I, J, K), J = 0, M) 
   50    END DO 
         WRITE ( *, 1565) 
   40 END DO 
      CALL BICSP3 (N, M, A, X, Y, FN, F, IFEHL) 
      IF (IFEHL.NE.0) THEN 
         WRITE ( *, 1500) IFEHL 
         STOP 
      ENDIF 
      WRITE ( *, 1595) 
      DO 60 IX = 0, KDIM 
         DO 70 IY = 0, LDIM 
            IF (IX.EQ.0.AND.IY.EQ.0) GOTO 70 
            WRITE ( *, 1600) IX, IY, IX, IY 
            WRITE (FO1555, 1555) M 
            WRITE ( *, FO1555) (I, I = 0, M - 1) 
            WRITE ( *, 1556) 
            DO 80 I = 0, N - 1 
               WRITE (FO1560, 1560) M 
               WRITE ( *, FO1560) I, (A (I, K, IX, IY), K = 0, M - 1) 
   80       END DO 
   70    END DO 
   60 END DO 
!                                                                       
!                                                                       
!     spline coefficients have been found;                              
!     next use  BSPVAL:                                                 
!     ------------------------------------                              
!                                                                       
!                                                                       
      DO 85 I = 1, N 
         XMIT (I) = 0.5D0 * (X (I) + X (I - 1) ) 
   85 END DO 
      DO 90 K = 1, M 
         YMIT (K) = 0.5D0 * (Y (K) + Y (K - 1) ) 
   90 END DO 
      DO 100 I = 1, N 
         DO 100 K = 1, M 
            CALL BSPVAL (N, M, A, X, Y, XMIT (I), YMIT (K), ZMIT (I, K),&
            J)                                                          
            IF (J.NE.0) THEN 
               WRITE ( *, 1510) 
               STOP 
            ENDIF 
  100 CONTINUE 
      WRITE ( *, 1610) 
      WRITE (FO1555, 1555) M 
      WRITE ( *, FO1555) (I, I = 1, M) 
      WRITE ( *, 1556) 
      DO 110 I = 1, N 
         WRITE (FO1560, 1560) M 
         WRITE ( *, FO1560) I, (ZMIT (I, K), K = 1, M) 
  110 END DO 
 1500 FORMAT(1X, 'C[', T75, ']*', /,                                    &
     &       1X, 'C[ *** ERROR IN BICSP3 ***', T75, ']*')               
 1510 FORMAT(1X, 'C[', T75, ']*', /,                                    &
     &       1X, 'C[ *** ERROR IN BSPVAL ***', T75, ']*')               
 1520 FORMAT(1X, 'C[', T75, ']*', /,                                    &
     &       1X, 'C[ COMPUTE A BICUBIC SPLINE USING BICSP3',            &
     &           T75, ']*', /,                                          &
     &       1X, 'C[ ', 37('='), T75, ']*')                             
 1530 FORMAT(1X, 'C[', T75, ']*', /,                                    &
     &       1X, 'C[ X COORDINATES OF THE NODES', T75, ']*', /,         &
     &       1X, 'C[ ', 26('-'), T75, ']*', /,                          &
     &       1X, 'C[', T75, ']*', /,                                    &
     &       1X, 'C[    I', 5X, 'X(I)', T75, ']*', /,                   &
     &       1X, 'C[ ', 17('-'), T75, ']*', /,                          &
     &      (1X, 'C[ ', 1P, I4,3X,D10.3, T75, ']*'))                    
 1540 FORMAT(1X, 'C[', T75, ']*', /,                                    &
     &       1X, 'C[ Y COORDINATES OF THE NODES', T75, ']*', /,         &
     &       1X, 'C[ ', 26('-'), T75, ']*', /,                          &
     &       1X, 'C[', T75, ']*', /,                                    &
     &       1X, 'C[    I', 5X, 'Y(I)', T75, ']*', /,                   &
     &       1X, 'C[ ', 17('-'), T75, ']*', /,                          &
     &      (1X, 'C[ ', 1P, I4,3X,D10.3, T75, ']*'))                    
 1550 FORMAT(1X, 'C[', T75, ']*', /,                                    &
     &       1X, 'C[ GIVEN FUNCTION VALUES A(I,K,0,0) = S( X(I)',       &
     &           ',Y(K) )', T75, ']*', /,                               &
     &       1X, 'C[ ', 49('-'), T75, ']*')                             
 1555 FORMAT('(1X, ''C[ '',', I2, '(8X,I4), T75, '']*'')') 
 1556 FORMAT(1X, 'C[ ', 70('-'), T75, ']*') 
 1560 FORMAT('(1X, ''C[ '', I4, 1P, ', I2, '(2X,D10.3), T75, '']*'')') 
 1565 FORMAT(1X, 'C[', T75, ']*') 
 1570 FORMAT(1X, 'C[', T75, ']*', /,                                    &
     &       1X, 'C[ SURFACE NORMAL FN(I,J)', T75, ']*', /,             &
     &       1X, 'C[ ', 22('-'), T75, ']*')                             
 1595 FORMAT(1X, 'C[', T75, ']*', /,                                    &
     &       1X, 'C[ COEFFICIENT ARRAYS A(I,J,K,L)', T75, ']*', /,      &
     &       1X, 'C[ ', 29('='), T75, ']*', /,                          &
     &       1X, 'C[ ( I IS THE ROW INDEX AND J IS THE COLUMN ',        &
     &           'INDEX )', T75, ']*')                                  
 1600 FORMAT(1X, 'C[', T75, ']*', /,                                    &
     &       1X, 'C[ COEFFICIENTS OF (X-X(I)) **', I3,                  &
     &           ' * (Y-Y(J)) **', I3, '  :  A(I,J,', I3, ',', I3,      &
     &           ') = ', T75, ']*', /,                                  &
     &       1X, 'C[ ', 70('-'), T75, ']*')                             
 1610 FORMAT(1X, 'C[', T75, ']*', /,                                    &
     &       1X, 'C[ EXAMPLE FOR USE OF BSPVAL:',T75, ']*', /,          &
     &       1X, 'C[ ', 26('='), T75, ']*', /,                          &
     &       1X, 'C[', T75, ']*', /,                                    &
     &       1X, 'C[ TABLE OF VALUES FOR S(X,Y) AT THE CENTERS (X,Y) ', &
     &           'OF THE RECTANGLES', T75, ']*', /,                     &
     &       1X, 'C[ FOR THE MESH, I. E., ',T75, ']*', /,               &
     &       1X, 'C[     X = ( X(I)+X(I-1) )/2 , I = 1(1)N',T75, ']*',/,&
     &       1X, 'C[     Y = ( Y(K)+Y(K-1) )/2 , K = 1(1)M', T75, ']*') 
      END PROGRAM TEST                              
!                                                                       
      DOUBLEPRECISION FUNCTION S (X, Y) 
!                                                                       
!*****************************************************************      
!                                                                *      
!  compute functional values                                            
!                                                                *      
!*****************************************************************      
!                                                                       
      DOUBLEPRECISION X, Y 
      S = X * X * DCOS (Y) 
      RETURN 
      END FUNCTION S                                
!                                                                       
      DOUBLEPRECISION FUNCTION DSDX (X, Y) 
!                                                                       
!*****************************************************************      
!                                                                *      
!  compute partial derivative DS/DX                              *      
!                                                                *      
!*****************************************************************      
!                                                                       
      DOUBLEPRECISION X, Y 
      DSDX = 2.0D+00 * X * DCOS (Y) 
      RETURN 
      END FUNCTION DSDX                             
!                                                                       
      DOUBLEPRECISION FUNCTION DSDY (X, Y) 
!                                                                       
!*****************************************************************      
!                                                                *      
!  compute partial derivative DS/DY                              *      
!                                                                *      
!*****************************************************************      
!                                                                       
      DOUBLEPRECISION X, Y 
      DSDY = X * X * ( - DSIN (Y) ) 
      RETURN 
      END FUNCTION DSDY                             
