      PROGRAM TEST 
!***********************************************************************
!                                                                       
!  Test program for the subroutines  BSPLFL, DEBOOR and KNOTVO.         
!  Compute a uniform open B spline surface.                             
!                                                                       
!-----------------------------------------------------------------------
!                                                                       
!     The computed results are shown with the imdividual parameters on t
!     screen.                                                           
!     For IBM compatibel PCs and the MICROSOFT FORTRAN 5.0 Compiler the 
!     following results are achieved:                                   
!                                                                       
!     NU =  6                                                           
!     NV =  5                                                           
!     KU =  4 , KV =  3 : respective orders                             
!     M  =  3  DIMENSION of the DE BOOR POINTS ( M >= 2 )               
!     N  =  2  DIMENSION of the DE BOOR POINTS ( N >= 2 )               
!     KK  =  3                                                          
!     DP : 3 DIM. DOUBLE PRECISION ARRAY DP(0:N,1:M,1:KK) with N+1 DE BO
!          POINTS:                                                      
!                                                                       
!        DP(0,0,I),I=1,3 = [2,0,0]                                      
!        DP(1,0,I),I=1,3 = [2,0,2]                                      
!        DP(2,0,I),I=1,3 = [0,0,2]                                      
!        DP(3,0,I),I=1,3 = [0,0,0]                                      
!        DP(0,1,I),I=1,3 = [1,1,0]                                      
!        DP(1,1,I),I=1,3 = [1,1,1]                                      
!        DP(2,1,I),I=1,3 = [0,1,1]                                      
!        DP(3,1,I),I=1,3 = [0,1,0]                                      
!        DP(0,2,I),I=1,3 = [1,2,0]                                      
!        DP(1,2,I),I=1,3 = [1,2,1]                                      
!        DP(2,2,I),I=1,3 = [0,2,1]                                      
!        DP(3,2,I),I=1,3 = [0,2,0]                                      
!                                                                       
!                                                                       
!-----------------------------------------------------------------------
!                                                                       
!     Required subroutines: BSPLFL, DEBOOR, KNOTVO                      
!                                                                       
!-----------------------------------------------------------------------
!                                                                       
![                                                                      
![  WANTED TO FIND: B SPLINE SURFACE                                    
![  ===============                                                     
![                                                                      
![                                                                      
![  SOLUTION:                                                           
![  =========                                                           
![                                                                      
![                                                                      
![    1. U CURVE                                                        
![  1|  .20000000000000D+01 |  .00000000000000D+00 |  .00000000000000D+0
![  2|  .17919999942780D+01 |  .00000000000000D+00 |  .96000001072884D+0
![  3|  .12959999828339D+01 |  .00000000000000D+00 |  .14400000071526D+0
![  4|  .70399993133545D+00 |  .00000000000000D+00 |  .14399999713898D+0
![  5|  .20799997711182D+00 |  .00000000000000D+00 |  .95999995708465D+0
![  6|  .00000000000000D+00 |  .00000000000000D+00 |  .00000000000000D+0
![                                                                      
![    2. U CURVE                                                        
![  1|  .15625000000000D+01 |  .50000000000000D+00 |  .00000000000000D+0
![  2|  .13999999955297D+01 |  .50000000000000D+00 |  .75000000838190D+0
![  3|  .10124999865890D+01 |  .50000000000000D+00 |  .11250000055879D+0
![  4|  .54999994635582D+00 |  .50000000000000D+00 |  .11249999776483D+0
![  5|  .16249998211861D+00 |  .50000000000000D+00 |  .74999996647239D+0
![  6|  .00000000000000D+00 |  .50000000000000D+00 |  .00000000000000D+0
![                                                                      
![    3. U CURVE                                                        
![  1|  .12500000000000D+01 |  .10000000000000D+01 |  .00000000000000D+0
![  2|  .11199999964237D+01 |  .10000000000000D+01 |  .60000000670552D+0
![  3|  .80999998927116D+00 |  .10000000000000D+01 |  .90000000447035D+0
![  4|  .43999995708466D+00 |  .10000000000000D+01 |  .89999998211860D+0
![  5|  .12999998569489D+00 |  .10000000000000D+01 |  .59999997317791D+0
![  6|  .00000000000000D+00 |  .10000000000000D+01 |  .00000000000000D+0
![                                                                      
![    4. U CURVE                                                        
![  1|  .10625000000000D+01 |  .15000000000000D+01 |  .00000000000000D+0
![  2|  .95199999696016D+00 |  .15000000000000D+01 |  .51000000569969D+0
![  3|  .68849999088049D+00 |  .15000000000000D+01 |  .76500000379980D+0
![  4|  .37399996352196D+00 |  .15000000000000D+01 |  .76499998480081D+0
![  5|  .11049998784065D+00 |  .15000000000000D+01 |  .50999997720122D+0
![  6|  .00000000000000D+00 |  .15000000000000D+01 |  .00000000000000D+0
![                                                                      
![    5. U CURVE                                                        
![  1|  .10000000000000D+01 |  .20000000000000D+01 |  .00000000000000D+0
![  2|  .89599999713898D+00 |  .20000000000000D+01 |  .48000000536442D+0
![  3|  .64799999141693D+00 |  .20000000000000D+01 |  .72000000357628D+0
![  4|  .35199996566773D+00 |  .20000000000000D+01 |  .71999998569488D+0
![  5|  .10399998855591D+00 |  .20000000000000D+01 |  .47999997854233D+0
![  6|  .00000000000000D+00 |  .20000000000000D+01 |  .00000000000000D+0
!                                                                       
!***********************************************************************
!                                                                       
      PARAMETER (M = 3, N = 2, NU = 6, NV = 5, KU = 4, KV = 3, KK = 3) 
      IMPLICIT DOUBLEPRECISION (A - H, O - Z) 
      DIMENSION DP (0:M, 0:N, 1:KK), KVU (1:KU + M - 1), KVV (1:KV + N -&
      1), XP (1:NU, 1:NV, 1:M), X (1:KK), UPOL (0:M, 1:KK), DV (1:KV, 1:&
      KK), EV (1:KV, 1:KK), DU (1:KU, 1:KK), EU (1:KU, 1:KK), HILF (0:N,&
      1:KK)                                                             
      DATA (DP (0, 0, I), I = 1, 3) / 2, 0, 0 / 
      DATA (DP (1, 0, I), I = 1, 3) / 2, 0, 2 / 
      DATA (DP (2, 0, I), I = 1, 3) / 0, 0, 2 / 
      DATA (DP (3, 0, I), I = 1, 3) / 0, 0, 0 / 
      DATA (DP (0, 1, I), I = 1, 3) / 1, 1, 0 / 
      DATA (DP (1, 1, I), I = 1, 3) / 1, 1, 1 / 
      DATA (DP (2, 1, I), I = 1, 3) / 0, 1, 1 / 
      DATA (DP (3, 1, I), I = 1, 3) / 0, 1, 0 / 
      DATA (DP (0, 2, I), I = 1, 3) / 1, 2, 0 / 
      DATA (DP (1, 2, I), I = 1, 3) / 1, 2, 1 / 
      DATA (DP (2, 2, I), I = 1, 3) / 0, 2, 1 / 
      DATA (DP (3, 2, I), I = 1, 3) / 0, 2, 0 / 
      CALL BSPLFL (KK, NU, NV, M, N, KU, KV, KVU, KVV, DP, XP, UPOL, DV,&
      DU, EV, EU, HILF, X, IERR)                                        
      IF (IERR.EQ.0) THEN 
         WRITE ( *, 890) 
         DO 10 J = 1, NV 
            WRITE ( *, 910) J 
            DO 20 I = 1, NU 
               WRITE ( *, 900) I, (XP (I, J, MM), MM = 1, 3) 
   20       END DO 
   10    END DO 
      ELSE 
         WRITE ( *, 880) IERR 
      ENDIF 
      STOP 
  880 FORMAT(1X,'ERROR IERR =',I3) 
  890 FORMAT(1X,'C[',T76,']*',                                          &
     &    /,1X,'C[',2X,'WANTED TO FIND: B SPLINE SURFACE',T76,']*',     &
     &    /,1X,'C[',2X,'===============',T76,']*',                      &
     &    /,1X,'C[',T76,']*',                                           &
     &    /,1X,'C[',T76,']*',                                           &
     &    /,1X,'C[',2X,'SOLUTION:',T76,']*',                            &
     &    /,1X,'C[',2X,'=========',T76,']*',                            &
     &    /,1X,'C[',T76,']*')                                           
  900 FORMAT(1X,'C[',I3,'|',1X,2(D20.14,1X,'|',1X),D20.14,T76,']*') 
  910 FORMAT(1X,'C[',T76,']*',/,1X,'C[',2X,I3,'. U CURVE',T76,']*') 
      END PROGRAM TEST                              
