!                                                                       
!     Test program for the  SUBROUTINE RENN2D        8.2.92             
!                                                 (Volker Krger)       
!                                                                       
!*******************************************************************    
!                                                                  *    
!     Test results                                                 *    
!                                                                  *    
!                                                                  *    
![                                                                ]*    
![ TEST EXAMPLE:                                                  ]*    
![ =============                                                  ]*    
![                                                                ]*    
![ NODES WITHOUT ROUNDING OF CORNERS:                             ]*    
![                                                                ]*    
![  I      X(I)        Y(I)                                       ]*    
![ --------------------------                                     ]*    
![  0   -70.00000    70.00000                                     ]*    
![  1   -50.00000    70.00000                                     ]*    
![  2   -30.00000    70.00000                                     ]*    
![  3   -10.00000    80.00000                                     ]*    
![  4    20.00000    90.00000                                     ]*    
![  5    40.00000    90.00000                                     ]*    
![  6    60.00000    70.00000                                     ]*    
![  7    60.00000    50.00000                                     ]*    
![  8    60.00000    30.00000                                     ]*    
![  9    40.00000    30.00000                                     ]*    
![ 10    20.00000    30.00000                                     ]*    
![ 11      .00000    30.00000                                     ]*    
![ 12   -20.00000    20.00000                                     ]*    
![ 13   -20.00000   -10.00000                                     ]*    
![ 14      .00000   -30.00000                                     ]*    
![ 15    30.00000   -30.00000                                     ]*    
![ 16    60.00000   -30.00000                                     ]*    
![ 17    60.00000   -50.00000                                     ]*    
![ 18    60.00000   -70.00000                                     ]*    
![ 19    30.00000   -70.00000                                     ]*    
![ 20      .00000   -70.00000                                     ]*    
![ 21   -20.00000   -80.00000                                     ]*    
![ 22   -30.00000   -90.00000                                     ]*    
![ 23   -50.00000   -90.00000                                     ]*    
![ 24   -70.00000   -70.00000                                     ]*    
![ 25   -80.00000   -30.00000                                     ]*    
![ 26   -80.00000    20.00000                                     ]*    
![ 27   -70.00000    70.00000                                     ]*    
![                                                                ]*    
![ SPLINE COEFFICIENTS:                                           ]*    
![                                                                ]*    
![  I    TSUM(I)      XN(I)        B(I,1)      C(I,1)      D(I,1) ]*    
![ -------------------------------------------------------------- ]*    
![  0     .000000  -70.000000    1.000000     .000000     .000000 ]*    
![  1   20.000000  -50.000000    1.000000     .000000     .000000 ]*    
![  2   40.000000  -30.000000    1.000000    -.013747     .000357 ]*    
![  3   62.921874  -10.000000     .932683     .000647    -.000005 ]*    
![  4   94.553985   20.000000     .959366     .004102    -.000138 ]*    
![  5  114.842191   40.000000     .955423     .002089    -.000391 ]*    
![  6  145.232314   60.000000     .000000     .000000     .000000 ]*    
![  7  165.232314   60.000000     .000000     .000000     .000000 ]*    
![  8  185.232314   60.000000   -1.000000     .000000     .000000 ]*    
![  9  205.232314   40.000000   -1.000000     .000000     .000000 ]*    
![ 10  225.232314   20.000000   -1.000000     .000000     .000000 ]*    
![ 11  245.232314     .000000   -1.000000    -.000539     .000282 ]*    
![ 12  268.482596  -20.000000    -.568082     .022922    -.000154 ]*    
![ 13  299.899299  -20.000000     .416019     .005235     .000098 ]*    
![ 14  330.051972     .000000    1.000000     .000000     .000000 ]*    
![ 15  360.051972   30.000000    1.000000     .000000     .000000 ]*    
![ 16  390.051972   60.000000     .000000     .000000     .000000 ]*    
![ 17  410.051972   60.000000     .000000     .000000     .000000 ]*    
![ 18  430.051972   60.000000   -1.000000     .000000     .000000 ]*    
![ 19  460.051972   30.000000   -1.000000     .000000     .000000 ]*    
![ 20  490.051972     .000000   -1.000000     .009753    -.000189 ]*    
![ 21  512.890802  -20.000000    -.849855     .034735    -.001664 ]*    
![ 22  527.285784  -30.000000    -.884353    -.011531     .000383 ]*    
![ 23  548.156526  -50.000000    -.865468    -.000171     .000214 ]*    
![ 24  577.079929  -70.000000    -.338548     .000257     .000050 ]*    
![ 25  618.471786  -80.000000    -.058322     .001540    -.000007 ]*    
![ 26  668.492889  -80.000000     .039627    -.009654     .000196 ]*    
![     728.504696                                                 ]*    
![                                                                ]*    
![ SPLINE COEFFICIENTS:                                           ]*    
![                                                                ]*    
![  I    TSUM(I)      FN(I)        B(I,2)      C(I,2)      D(I,2) ]*    
![--------------------------------------------------------------  ]*    
![  0     .000000   70.000000     .000000     .000000     .000000 ]*    
![  1   20.000000   70.000000     .000000     .000000     .000000 ]*    
![  2   40.000000   70.000000     .000000     .041362    -.000974 ]*    
![  3   62.921874   80.000000     .360696    -.001744     .000011 ]*    
![  4   94.553985   90.000000     .282166    -.013263    -.000032 ]*    
![  5  114.842191   90.000000    -.295242    -.012630     .000023 ]*    
![  6  145.232314   70.000000   -1.000000     .000000     .000000 ]*    
![  7  165.232314   50.000000   -1.000000     .000000     .000000 ]*    
![  8  185.232314   30.000000     .000000     .000000     .000000 ]*    
![  9  205.232314   30.000000     .000000     .000000     .000000 ]*    
![ 10  225.232314   30.000000     .000000     .000000     .000000 ]*    
![ 11  245.232314   30.000000     .000000    -.020100     .000069 ]*    
![ 12  268.482596   20.000000    -.822972    -.009849     .000180 ]*    
![ 13  299.899299  -10.000000    -.909356    -.005676     .000459 ]*    
![ 14  330.051972  -30.000000     .000000     .000000     .000000 ]*    
![ 15  360.051972  -30.000000     .000000     .000000     .000000 ]*    
![ 16  390.051972  -30.000000   -1.000000     .000000     .000000 ]*    
![ 17  410.051972  -50.000000   -1.000000     .000000     .000000 ]*    
![ 18  430.051972  -70.000000     .000000     .000000     .000000 ]*    
![ 19  460.051972  -70.000000     .000000     .000000     .000000 ]*    
![ 20  490.051972  -70.000000     .000000    -.034438     .000668 ]*    
![ 21  512.890802  -80.000000    -.527017    -.039125     .001909 ]*    
![ 22  527.285784  -90.000000    -.466818     .020731     .000078 ]*    
![ 23  548.156526  -90.000000     .500964     .004549     .000070 ]*    
![ 24  577.079929  -70.000000     .940949     .000457     .000004 ]*    
![ 25  618.471786  -30.000000     .998298     .000058    -.000001 ]*    
![ 26  668.492889   20.000000     .999215     .008350    -.000185 ]*    
![     728.504696                                                 ]*    
![                                                                ]*    
![ SPLINE IS A CLOSED CURVE                                       ]*    
![                                                                ]*    
![                                                                ]*    
![ NODES AFTER ROUNDING OF CORNERS:                               ]*    
![                                                                ]*    
![                                                                ]*    
![  I      X(I)        Y(I)                                       ]*    
![ --------------------------                                     ]*    
![  0   -70.00000    70.00000                                     ]*    
![  1   -50.00000    70.00000                                     ]*    
![  2   -30.00000    70.00000                                     ]*    
![  3   -10.00000    80.00000                                     ]*    
![  4    20.00000    90.00000                                     ]*    
![  5    40.00000    90.00000                                     ]*    
![  6    60.00000    70.00000                                     ]*    
![  7    60.00000    50.00000                                     ]*    
![  8    60.00000    40.00000                                     ]*    
![  9    50.00000    30.00000                                     ]*    
![ 10    40.00000    30.00000                                     ]*    
![ 11    20.00000    30.00000                                     ]*    
![ 12      .00000    30.00000                                     ]*    
![ 13   -20.00000    20.00000                                     ]*    
![ 14   -20.00000   -10.00000                                     ]*    
![ 15      .00000   -30.00000                                     ]*    
![ 16    30.00000   -30.00000                                     ]*    
![ 17    50.00000   -30.00000                                     ]*    
![ 18    60.00000   -40.00000                                     ]*    
![ 19    60.00000   -50.00000                                     ]*    
![ 20    60.00000   -60.00000                                     ]*    
![ 21    50.00000   -70.00000                                     ]*    
![ 22    30.00000   -70.00000                                     ]*    
![ 23      .00000   -70.00000                                     ]*    
![ 24   -20.00000   -80.00000                                     ]*    
![ 25   -30.00000   -90.00000                                     ]*    
![ 26   -50.00000   -90.00000                                     ]*    
![ 27   -70.00000   -70.00000                                     ]*    
![ 28   -80.00000   -30.00000                                     ]*    
![ 29   -80.00000    20.00000                                     ]*    
![ 30   -70.00000    70.00000                                     ]*    
![                                                                ]*    
![ SPLINE COEFFICIENTS:                                           ]*    
![                                                                ]*    
![  I    TSUM(I)      XN(I)        B(I,1)      C(I,1)      D(I,1) ]*    
![ -------------------------------------------------------------- ]*    
![  0     .000000  -70.000000    1.000000     .000000     .000000 ]*    
![  1   20.000000  -50.000000    1.000000     .000000     .000000 ]*    
![  2   40.000000  -30.000000    1.000000    -.013747     .000357 ]*    
![  3   62.921874  -10.000000     .932683     .000647    -.000005 ]*    
![  4   94.553985   20.000000     .959366     .004102    -.000138 ]*    
![  5  114.842191   40.000000     .955423     .002089    -.000391 ]*    
![  6  145.232314   60.000000     .000000     .000000     .000000 ]*    
![  7  165.232314   60.000000     .000000     .000000     .000000 ]*    
![  8  175.232314   60.000000     .000000    -.058333     .001124 ]*    
![  9  190.904547   50.000000   -1.000000     .000000     .000000 ]*    
![ 10  200.904547   40.000000   -1.000000     .000000     .000000 ]*    
![ 11  220.904547   20.000000   -1.000000     .000000     .000000 ]*    
![ 12  240.904547     .000000   -1.000000    -.000539     .000282 ]*    
![ 13  264.154828  -20.000000    -.568082     .022922    -.000154 ]*    
![ 14  295.571532  -20.000000     .416019     .005235     .000098 ]*    
![ 15  325.724204     .000000    1.000000     .000000     .000000 ]*    
![ 16  355.724204   30.000000    1.000000     .000000     .000000 ]*    
![ 17  375.724204   50.000000    1.000000    -.005474    -.001124 ]*    
![ 18  391.396437   60.000000     .000000     .000000     .000000 ]*    
![ 19  401.396437   60.000000     .000000     .000000     .000000 ]*    
![ 20  411.396437   60.000000     .000000    -.058333     .001124 ]*    
![ 21  427.068669   50.000000   -1.000000     .000000     .000000 ]*    
![ 22  447.068669   30.000000   -1.000000     .000000     .000000 ]*    
![ 23  477.068669     .000000   -1.000000     .009753    -.000189 ]*    
![ 24  499.907500  -20.000000    -.849855     .034735    -.001664 ]*    
![ 25  514.302482  -30.000000    -.884353    -.011531     .000383 ]*    
![ 26  535.173224  -50.000000    -.865468    -.000171     .000214 ]*    
![ 27  564.096626  -70.000000    -.338548     .000257     .000050 ]*    
![ 28  605.488483  -80.000000    -.058322     .001540    -.000007 ]*    
![ 29  655.509587  -80.000000     .039627    -.009654     .000196 ]*    
![     715.521394                                                 ]*    
![                                                                ]*    
![ SPLINE COEFFICIENTS:                                           ]*    
![                                                                ]*    
![  I    TSUM(I)      FN(I)        B(I,2)      C(I,2)      D(I,2) ]*    
![--------------------------------------------------------------  ]*    
![  0     .000000   70.000000     .000000     .000000     .000000 ]*    
![  1   20.000000   70.000000     .000000     .000000     .000000 ]*    
![  2   40.000000   70.000000     .000000     .041362    -.000974 ]*    
![  3   62.921874   80.000000     .360696    -.001744     .000011 ]*    
![  4   94.553985   90.000000     .282166    -.013263    -.000032 ]*    
![  5  114.842191   90.000000    -.295242    -.012630     .000023 ]*    
![  6  145.232314   70.000000   -1.000000     .000000     .000000 ]*    
![  7  165.232314   50.000000   -1.000000     .000000     .000000 ]*    
![  8  175.232314   40.000000   -1.000000     .005474     .001124 ]*    
      PROGRAM TEST 
![  9  190.904547   30.000000     .000000     .000000     .000000 ]*    
![ 10  200.904547   30.000000     .000000     .000000     .000000 ]*    
![ 11  220.904547   30.000000     .000000     .000000     .000000 ]*    
![ 12  240.904547   30.000000     .000000    -.020100     .000069 ]*    
![ 13  264.154828   20.000000    -.822972    -.009849     .000180 ]*    
![ 14  295.571532  -10.000000    -.909356    -.005676     .000459 ]*    
![ 15  325.724204  -30.000000     .000000     .000000     .000000 ]*    
![ 16  355.724204  -30.000000     .000000     .000000     .000000 ]*    
![ 17  375.724204  -30.000000     .000000    -.058333     .001124 ]*    
![ 18  391.396437  -40.000000   -1.000000     .000000     .000000 ]*    
![ 19  401.396437  -50.000000   -1.000000     .000000     .000000 ]*    
![ 20  411.396437  -60.000000   -1.000000     .005474     .001124 ]*    
![ 21  427.068669  -70.000000     .000000     .000000     .000000 ]*    
![ 22  447.068669  -70.000000     .000000     .000000     .000000 ]*    
![ 23  477.068669  -70.000000     .000000    -.034438     .000668 ]*    
![ 24  499.907500  -80.000000    -.527017    -.039125     .001909 ]*    
![ 25  514.302482  -90.000000    -.466818     .020731     .000078 ]*    
![ 26  535.173224  -90.000000     .500964     .004549     .000070 ]*    
![ 27  564.096626  -70.000000     .940949     .000457     .000004 ]*    
![ 28  605.488483  -30.000000     .998298     .000058    -.000001 ]*    
![ 29  655.509587   20.000000     .999215     .008350    -.000185 ]*    
![     715.521394                                                 ]*    
![                                                                ]*    
![ SPLINE IS A CLOSED CURVE                                       ]*    
!                                                                  *    
!                                                                  *    
!*******************************************************************    
!                                                                       
      PARAMETER (N = 27, NK = 41) 
      DOUBLEPRECISION XN (0:NK), FN (0:NK), B (0:NK - 1, 1:2), C (0:NK -&
      1, 1:2), D (0:NK - 1, 1:2), T (0:NK - 1), HELP ( - 2:NK + 1, 1:10)&
      , TSUM (0:NK), BETA                                               
!                                                                       
!     SET UP DATA; EXCHANGE IF DESIRED                                  
!                                                                       
      DATA (XN (I), I = 0, N) / - 70.0D+00, - 50.0D+00, - 30.0D+00,     &
      - 10.0D+00, 20.0D+00, 40.0D+00, 60.0D+00, 60.0D+00, 60.0D+00,     &
      40.0D+00, 20.0D+00, 0.0D+00, - 20.0D+00, - 20.0D+00, 0.0D+00,     &
      30.0D+00, 60.0D+00, 60.0D+00, 60.0D+00, 30.0D+00, 0.0D+00,        &
      - 20.0D+00, - 30.0D+00, - 50.0D+00, - 70.0D+00, - 80.0D+00,       &
      - 80.0D+00, - 70.0D+00 /                                          
      DATA (FN (I), I = 0, N) / 70.0D+00, 70.0D+00, 70.0D+00, 80.0D+00, &
      90.0D+00, 90.0D+00, 70.0D+00, 50.0D+00, 30.0D+00, 30.0D+00,       &
      30.0D+00, 30.0D+00, 20.0D+00, - 10.0D+00, - 30.0D+00, - 30.0D+00, &
      - 30.0D+00, - 50.0D+00, - 70.0D+00, - 70.0D+00, - 70.0D+00,       &
      - 80.0D+00, - 90.0D+00, - 90.0D+00, - 70.0D+00, - 30.0D+00,       &
      20.0D+00, 70.0D+00 /                                              
      NI = N 
!                                                                       
!     output of nodes                                                   
!                                                                       
      WRITE ( *, 2000) 
      WRITE ( *, 2005) 
      DO 10, I = 0, NI 
         WRITE ( *, 2010) I, XN (I), FN (I) 
   10 END DO 
!                                                                       
!     computations without rounding                                     
!                                                                       
      BETA = - 0.5D+00 
      CALL RENN2D (NI, XN, FN, NK, BETA, B, C, D, T, HELP, IMARK, IERR) 
!                                                                       
      IF (IERR.EQ.0) THEN 
         TSUM (0) = 0.0D+00 
         DO 15 I = 1, NI 
   15    TSUM (I) = TSUM (I - 1) + T (I - 1) 
         WRITE ( *, 2020) 
         DO 20, I = 0, NI - 1 
   20    WRITE ( *, 2030) I, TSUM (I), XN (I), B (I, 1), C (I, 1),      &
         D (I, 1)                                                       
         WRITE ( *, 2031) TSUM (NI) 
         WRITE ( *, 2025) 
         DO 25, I = 0, NI - 1 
   25    WRITE ( *, 2030) I, TSUM (I), FN (I), B (I, 2), C (I, 2),      &
         D (I, 2)                                                       
         WRITE ( *, 2031) TSUM (NI) 
         IF (IMARK.EQ.0) THEN 
            WRITE ( *, 2035) 
         ELSE 
            WRITE ( *, 2036) 
         ENDIF 
!                                                                       
! use for output as a table of values:                                  
!                                                                       
!         DO 28 TT=0.D0,TSUM(NI)+1.D0,2.D0                              
!            CALL PSPVAL(TT,NI,TSUM,XN,B(0,1),C(0,1),D(0,1),            
!     +                             FN,B(0,2),C(0,2),D(0,2),X,Y)        
!            WRITE(*,*)X,Y                                              
!   28    CONTINUE                                                      
!                                                                       
      ELSE 
         WRITE ( *, 2040) 
         IF (IERR.EQ. - 1) THEN 
            WRITE ( *, 2050) 
         ELSEIF (IERR.EQ. - 2) THEN 
            WRITE ( *, 2060) 
         ELSEIF (IERR.EQ. - 3) THEN 
            WRITE ( *, 2070) 
         ENDIF 
      ENDIF 
!                                                                       
!     computations with rounding of corners                             
!                                                                       
      BETA = 0.5D+00 
      CALL RENN2D (NI, XN, FN, NK, BETA, B, C, D, T, HELP, IMARK, IERR) 
!                                                                       
!     nodes after rounding                                              
!                                                                       
      WRITE ( *, 2090) 
      WRITE ( *, 2005) 
      DO 30, I = 0, NI 
         WRITE ( *, 2010) I, XN (I), FN (I) 
   30 END DO 
!                                                                       
!     output with rounding                                              
!                                                                       
      IF (IERR.EQ.0) THEN 
         TSUM (0) = 0.0D+00 
         DO 35 I = 1, NI 
   35    TSUM (I) = TSUM (I - 1) + T (I - 1) 
         WRITE ( *, 2020) 
         DO 40, I = 0, NI - 1 
   40    WRITE ( *, 2030) I, TSUM (I), XN (I), B (I, 1), C (I, 1),      &
         D (I, 1)                                                       
         WRITE ( *, 2031) TSUM (NI) 
         WRITE ( *, 2025) 
         DO 45, I = 0, NI - 1 
   45    WRITE ( *, 2030) I, TSUM (I), FN (I), B (I, 2), C (I, 2),      &
         D (I, 2)                                                       
         WRITE ( *, 2031) TSUM (NI) 
         IF (IMARK.EQ.0) THEN 
            WRITE ( *, 2035) 
         ELSE 
            WRITE ( *, 2036) 
         ENDIF 
!                                                                       
! for use with a desired table of values                                
!                                                                       
!         DO 47 TT=0.D0,TSUM(NI)+1.D0,2.D0                              
!            CALL PSPVAL(TT,NI,TSUM,XN,B(0,1),C(0,1),D(0,1),            
!     +                             FN,B(0,2),C(0,2),D(0,2),X,Y)        
!            WRITE(*,*)X,Y                                              
!   47    CONTINUE                                                      
!                                                                       
      ELSE 
         WRITE ( *, 2040) 
         IF (IERR.EQ. - 1) THEN 
            WRITE ( *, 2050) 
         ELSEIF (IERR.EQ. - 2) THEN 
            WRITE ( *, 2060) 
         ELSEIF (IERR.EQ. - 3) THEN 
            WRITE ( *, 2070) 
         ENDIF 
      ENDIF 
 2000 FORMAT (1X, 'C[', T68, ']*', /,                                   &
     &        1X, 'C[ TEST EXAMPLE:', T68, ']*', /,                     &
     &        1X, 'C[ ', 13('='), T68, ']*', /,                         &
     &        1X, 'C[', T68, ']*', /,                                   &
     &        1X, 'C[ NODES WITHOUT ROUNDING OF CORNERS:', T68, ']*')   
 2005 FORMAT (1X, 'C[', T68, ']*', /,                                   &
     &        1X, 'C[  I', 5X, ' X(I)', 7X, ' Y(I)', T68, ']*', /,      &
     &        1X, 'C[ ', 26('-'), T68, ']*')                            
 2010 FORMAT (1X, 'C[ ', I2, 3X, F9.5, 3X, F9.5, T68, ']*') 
 2020 FORMAT (1X, 'C[', T68, ']*', /,                                   &
     &        1X, 'C[ SPLINE COEFFICIENTS:', T68, ']*', /,              &
     &        1X, 'C[', T68, ']*', /,                                   &
     &        1X, 'C[  I', 4X, 'TSUM(I)', 6X, 'XN(I)', 8X, 'B(I,1)',    &
     &            5X, ' C(I,1)', 5X, ' D(I,1)', T68, ']*', /,           &
     &        1X, 'C[ ', 62('-'), T68, ']*')                            
 2025 FORMAT (1X, 'C[', T68, ']*', /,                                   &
     &        1X, 'C[ SPLINE COEFFICIENTS:', T68, ']*', /,              &
     &        1X, 'C[', T68, ']*', /,                                   &
     &        1X, 'C[  I', 4X, 'TSUM(I)', 6X, 'FN(I)', 8X, 'B(I,2)',    &
     &            5X, ' C(I,2)', 5X, ' D(I,2)', T68, ']*', /,           &
     &        1X, 'C[', 62('-'), T68, ']*')                             
 2030 FORMAT (1X, 'C[ ', I2, 1X, F11.6, 1X, F11.6, 1X, F11.6, 1X,       &
     &            F11.6, 1X, F11.6, T68, ']*')                          
 2031 FORMAT (1X, 'C[', 4X, F11.6, T68, ']*') 
 2035 FORMAT (1X, 'C[', T68, ']*', /,                                   &
     &        1X, 'C[ SPLINE IS NOT CLOSED', T68,']*')                  
 2036 FORMAT (1X, 'C[', T68, ']*', /,                                   &
     &        1X, 'C[ SPLINE IS A CLOSED CURVE', T68, ']*')             
 2040 FORMAT (1X, 'C[', T68, ']*', /,                                   &
     &        1X, 'C[ ERROR IN RENNER!', T68, ']*')                     
 2050 FORMAT (1X, 'C[ LESS THAN  4 STUETZSTELLEN!', T68, ']*') 
 2060 FORMAT (1X, 'C[ TWO ADJACENT NODES ARE IDENTICAL!',               &
     &            T68, ']*')                                            
 2070 FORMAT (1X, 'C[ NK TOO SMALL!', T68, ']*') 
 2090 FORMAT (1X, 'C[', T68, ']*', /,                                   &
     &        1X, 'C[', T68, ']*', /,                                   &
     &        1X, 'C[ NODES AFTER ROUNDING OF CORNERS:', T68, ']*', /,  &
     &        1X, 'C[', T68, ']*')                                      
      STOP 
      END PROGRAM TEST                              
