      PROGRAM TEST 
!                                                                       
!     Test program for the  SUBROUTINE RENN3D        5.4.93             
!                                                 (Andreas Sohn)        
!                                                                       
!*******************************************************************    
!                                                                  *    
!     Test results:                                                *    
!                                                                  *    
!                                                                  *    
![                                                                ]*    
![ TEST EXAMPLE:                                                  ]*    
![ =============                                                  ]*    
![                                                                ]*    
![ NODES WITHOUT ROUNDING OF CORNERS:                             ]*    
![                                                                ]*    
![  I      X(I)        Y(I)        Z(I)                           ]*    
![ --------------------------------------                         ]*    
![  0      .00000      .00000      .00000                         ]*    
![  1    10.00000      .00000      .00000                         ]*    
![  2    20.00000      .00000      .00000                         ]*    
![  3    20.00000    10.00000      .00000                         ]*    
![  4    20.00000    20.00000      .00000                         ]*    
![  5    20.00000    20.00000    10.00000                         ]*    
![  6    20.00000    20.00000    20.00000                         ]*    
![  7    20.00000    10.00000    20.00000                         ]*    
![  8    20.00000      .00000    20.00000                         ]*    
![  9    10.00000      .00000    20.00000                         ]*    
![ 10      .00000      .00000    20.00000                         ]*    
![ 11      .00000    10.00000    10.00000                         ]*    
![ 12      .00000      .00000      .00000                         ]*    
![                                                                ]*    
![ SPLINE COEFFICIENTS:                                           ]*    
![                                                                ]*    
![  I    TSUM(I)      XN(I)        B(I,1)      C(I,1)      D(I,1) ]*    
![ -------------------------------------------------------------- ]*    
![  0     .000000     .000000    1.000000     .000000     .000000 ]*    
![  1   10.000000   10.000000    1.000000     .000000     .000000 ]*    
![  2   20.000000   20.000000     .000000     .000000     .000000 ]*    
![  3   30.000000   20.000000     .000000     .000000     .000000 ]*    
![  4   40.000000   20.000000     .000000     .000000     .000000 ]*    
![  5   50.000000   20.000000     .000000     .000000     .000000 ]*    
![  6   60.000000   20.000000     .000000     .000000     .000000 ]*    
![  7   70.000000   20.000000     .000000     .000000     .000000 ]*    
![  8   80.000000   20.000000   -1.000000     .000000     .000000 ]*    
![  9   90.000000   10.000000   -1.000000     .000000     .000000 ]*    
![ 10  100.000000     .000000   -1.000000     .106419    -.002831 ]*    
![ 11  118.793563     .000000     .000000    -.053210     .002831 ]*    
![     137.587127                                                 ]*    
![                                                                ]*    
![ SPLINE COEFFICIENTS:                                           ]*    
![                                                                ]*    
![  I    TSUM(I)      YN(I)        B(I,2)      C(I,2)      D(I,2) ]*    
![--------------------------------------------------------------  ]*    
![  0     .000000     .000000     .000000     .000000     .000000 ]*    
![  1   10.000000     .000000     .000000     .000000     .000000 ]*    
![  2   20.000000     .000000    1.000000     .000000     .000000 ]*    
![  3   30.000000   10.000000    1.000000     .000000     .000000 ]*    
![  4   40.000000   20.000000     .000000     .000000     .000000 ]*    
![  5   50.000000   20.000000     .000000     .000000     .000000 ]*    
![  6   60.000000   20.000000   -1.000000     .000000     .000000 ]*    
![  7   70.000000   10.000000   -1.000000     .000000     .000000 ]*    
![  8   80.000000     .000000     .000000     .000000     .000000 ]*    
![  9   90.000000     .000000     .000000     .000000     .000000 ]*    
![ 10  100.000000     .000000     .000000     .084938    -.003013 ]*    
![ 11  118.793563   10.000000     .000000    -.084938     .003013 ]*    
![     137.587127                                                 ]*    
![                                                                ]*    
![ SPLINE COEFFICIENTS:                                           ]*    
![                                                                ]*    
![  I    TSUM(I)      ZN(I)        B(I,3)      C(I,3)      D(I,3) ]*    
![--------------------------------------------------------------  ]*    
![  0     .000000     .000000     .000000     .000000     .000000 ]*    
![  1   10.000000     .000000     .000000     .000000     .000000 ]*    
![  2   20.000000     .000000     .000000     .000000     .000000 ]*    
![  3   30.000000     .000000     .000000     .000000     .000000 ]*    
![  4   40.000000     .000000    1.000000     .000000     .000000 ]*    
![  5   50.000000   10.000000    1.000000     .000000     .000000 ]*    
![  6   60.000000   20.000000     .000000     .000000     .000000 ]*    
![  7   70.000000   20.000000     .000000     .000000     .000000 ]*    
![  8   80.000000   20.000000     .000000     .000000     .000000 ]*    
![  9   90.000000   20.000000     .000000     .000000     .000000 ]*    
![ 10  100.000000   20.000000     .000000    -.031728     .000182 ]*    
![ 11  118.793563   10.000000   -1.000000     .021481     .000182 ]*    
![     137.587127                                                 ]*    
![                                                                ]*    
![ SPLINE IS A CLOSED CURVE                                       ]*    
![                                                                ]*    
![                                                                ]*    
![ NODES AFTER ROUNDING OF CORNERS:                               ]*    
![                                                                ]*    
![                                                                ]*    
![  I      X(I)        Y(I)        Z(I)                           ]*    
![ --------------------------------------                         ]*    
![  0      .00000      .00000      .00000                         ]*    
![  1    10.00000      .00000      .00000                         ]*    
![  2    15.00000      .00000      .00000                         ]*    
![  3    20.00000     5.00000      .00000                         ]*    
![  4    20.00000    10.00000      .00000                         ]*    
![  5    20.00000    15.00000      .00000                         ]*    
![  6    20.00000    20.00000     5.00000                         ]*    
![  7    20.00000    20.00000    10.00000                         ]*    
![  8    20.00000    20.00000    15.00000                         ]*    
![  9    20.00000    15.00000    20.00000                         ]*    
![ 10    20.00000    10.00000    20.00000                         ]*    
![ 11    20.00000     5.00000    20.00000                         ]*    
![ 12    15.00000      .00000    20.00000                         ]*    
![ 13    10.00000      .00000    20.00000                         ]*    
![ 14      .00000      .00000    20.00000                         ]*    
![ 15      .00000    10.00000    10.00000                         ]*    
![ 16      .00000      .00000      .00000                         ]*    
![                                                                ]*    
![ SPLINE COEFFICIENTS:                                           ]*    
![                                                                ]*    
![  I    TSUM(I)      XN(I)        B(I,1)      C(I,1)      D(I,1) ]*    
![ -------------------------------------------------------------- ]*    
![  0     .000000     .000000    1.000000     .000000     .000000 ]*    
![  1   10.000000   10.000000    1.000000     .000000     .000000 ]*    
![  2   15.000000   15.000000    1.000000    -.010948    -.004497 ]*    
![  3   22.836116   20.000000     .000000     .000000     .000000 ]*    
![  4   27.836116   20.000000     .000000     .000000     .000000 ]*    
![  5   32.836116   20.000000     .000000     .000000     .000000 ]*    
![  6   40.672232   20.000000     .000000     .000000     .000000 ]*    
![  7   45.672232   20.000000     .000000     .000000     .000000 ]*    
![  8   50.672232   20.000000     .000000     .000000     .000000 ]*    
![  9   58.508349   20.000000     .000000     .000000     .000000 ]*    
![ 10   63.508349   20.000000     .000000     .000000     .000000 ]*    
![ 11   68.508349   20.000000     .000000    -.116667     .004497 ]*    
![ 12   76.344465   15.000000   -1.000000     .000000     .000000 ]*    
![ 13   81.344465   10.000000   -1.000000     .000000     .000000 ]*    
![ 14   91.344465     .000000   -1.000000     .106419    -.002831 ]*    
![ 15  110.138028     .000000     .000000    -.053210     .002831 ]*    
![     128.931592                                                 ]*    
![                                                                ]*    
![ SPLINE COEFFICIENTS:                                           ]*    
![                                                                ]*    
![  I    TSUM(I)      YN(I)        B(I,2)      C(I,2)      D(I,2) ]*    
![--------------------------------------------------------------  ]*    
![  0     .000000     .000000     .000000     .000000     .000000 ]*    
![  1   10.000000     .000000     .000000     .000000     .000000 ]*    
![  2   15.000000     .000000     .000000     .116667    -.004497 ]*    
![  3   22.836116    5.000000    1.000000     .000000     .000000 ]*    
![  4   27.836116   10.000000    1.000000     .000000     .000000 ]*    
![  5   32.836116   15.000000    1.000000    -.010948    -.004497 ]*    
![  6   40.672232   20.000000     .000000     .000000     .000000 ]*    
![  7   45.672232   20.000000     .000000     .000000     .000000 ]*    
![  8   50.672232   20.000000     .000000    -.116667     .004497 ]*    
![  9   58.508349   15.000000   -1.000000     .000000     .000000 ]*    
![ 10   63.508349   10.000000   -1.000000     .000000     .000000 ]*    
![ 11   68.508349    5.000000   -1.000000     .010948     .004497 ]*    
![ 12   76.344465     .000000     .000000     .000000     .000000 ]*    
![ 13   81.344465     .000000     .000000     .000000     .000000 ]*    
![ 14   91.344465     .000000     .000000     .084938    -.003013 ]*    
![ 15  110.138028   10.000000     .000000    -.084938     .003013 ]*    
![     128.931592                                                 ]*    
![                                                                ]*    
![ SPLINE COEFFICIENTS:                                           ]*    
![                                                                ]*    
![  I    TSUM(I)      ZN(I)        B(I,3)      C(I,3)      D(I,3) ]*    
![--------------------------------------------------------------  ]*    
![  0     .000000     .000000     .000000     .000000     .000000 ]*    
![  1   10.000000     .000000     .000000     .000000     .000000 ]*    
![  2   15.000000     .000000     .000000     .000000     .000000 ]*    
![  3   22.836116     .000000     .000000     .000000     .000000 ]*    
![  4   27.836116     .000000     .000000     .000000     .000000 ]*    
![  5   32.836116     .000000     .000000     .116667    -.004497 ]*    
![  6   40.672232    5.000000    1.000000     .000000     .000000 ]*    
![  7   45.672232   10.000000    1.000000     .000000     .000000 ]*    
![  8   50.672232   15.000000    1.000000    -.010948    -.004497 ]*    
![  9   58.508349   20.000000     .000000     .000000     .000000 ]*    
![ 10   63.508349   20.000000     .000000     .000000     .000000 ]*    
![ 11   68.508349   20.000000     .000000     .000000     .000000 ]*    
![ 12   76.344465   20.000000     .000000     .000000     .000000 ]*    
![ 13   81.344465   20.000000     .000000     .000000     .000000 ]*    
![ 14   91.344465   20.000000     .000000    -.031728     .000182 ]*    
![ 15  110.138028   10.000000   -1.000000     .021481     .000182 ]*    
![     128.931592                                                 ]*    
![                                                                ]*    
![ SPLINE IS A CLOSED CURVE                                       ]*    
!                                                                  *    
!*******************************************************************    
!                                                                       
      PARAMETER (N = 12, NK = 18) 
      DOUBLEPRECISION XN (0:NK), YN (0:NK), ZN (0:NK), B (0:NK - 1, 1:3)&
      , C (0:NK - 1, 1:3), D (0:NK - 1, 1:3), T (0:NK - 1), HELP ( - 2: &
      NK + 1, 1:14), TSUM (0:NK), BETA                                  
!                                                                       
!     INITIALIZE DATA; CHANGE IF DESIRED                                
!                                                                       
      DATA (XN (I), YN (I), ZN (I), I = 0, N) / 0.0D0, 0.0D0, 0.0D0,    &
      10.0D0, 0.0D0, 0.0D0, 20.0D0, 0.0D0, 0.0D0, 20.0D0, 10.0D0, 0.0D0,&
      20.0D0, 20.0D0, 0.0D0, 20.0D0, 20.0D0, 10.0D0, 20.0D0, 20.0D0,    &
      20.0D0, 20.0D0, 10.0D0, 20.0D0, 20.0D0, 0.0D0, 20.0D0, 10.0D0,    &
      0.0D0, 20.0D0, 0.0D0, 0.0D0, 20.0D0, 0.0D0, 10.0D0, 10.0D0, 0.0D0,&
      0.0D0, 0.0D0 /                                                    
!                                                                       
      NI = 12 
!                                                                       
!     output of nodes                                                   
!                                                                       
      WRITE ( *, 2000) 
      WRITE ( *, 2005) 
      DO 10, I = 0, NI 
         WRITE ( *, 2010) I, XN (I), YN (I), ZN (I) 
   10 END DO 
!                                                                       
!     computations with rounding of corners                             
!                                                                       
      BETA = - 0.5D+00 
      CALL RENN3D (NI, XN, YN, ZN, NK, BETA, B, C, D, T, HELP, IMARK,   &
      IERR)                                                             
!                                                                       
      IF (IERR.EQ.0) THEN 
         TSUM (0) = 0.0D+00 
         DO 15 I = 1, NI 
   15    TSUM (I) = TSUM (I - 1) + T (I - 1) 
         WRITE ( *, 2020) 
         DO 20, I = 0, NI - 1 
   20    WRITE ( *, 2030) I, TSUM (I), XN (I), B (I, 1), C (I, 1),      &
         D (I, 1)                                                       
         WRITE ( *, 2031) TSUM (NI) 
         WRITE ( *, 2025) 
         DO 25, I = 0, NI - 1 
   25    WRITE ( *, 2030) I, TSUM (I), YN (I), B (I, 2), C (I, 2),      &
         D (I, 2)                                                       
         WRITE ( *, 2031) TSUM (NI) 
         WRITE ( *, 2026) 
         DO 26, I = 0, NI - 1 
   26    WRITE ( *, 2030) I, TSUM (I), ZN (I), B (I, 3), C (I, 3),      &
         D (I, 3)                                                       
         WRITE ( *, 2031) TSUM (NI) 
         IF (IMARK.EQ.0) THEN 
            WRITE ( *, 2035) 
         ELSE 
            WRITE ( *, 2036) 
         ENDIF 
!                                                                       
! use if table of values is desired                                     
!                                                                       
!        OPEN(1, FILE='ORUNDUNG')                                       
!        REWIND(1)                                                      
!        DO 1111, I = 0, NI-1                                           
!           TSCH = T(I)/20.0D0                                          
!           DO 111, TT=0.0D0, T(I)+TSCH*0.5D0, TSCH                     
!              WRITE(1,'(1X,4(F10.5,2X))')                              
!    F             TT, ((D(I,1)*TT + C(I,1))*TT + B(I,1))*TT + XN(I)    
!    F               , ((D(I,2)*TT + C(I,2))*TT + B(I,2))*TT + YN(I)    
!    F               , ((D(I,3)*TT + C(I,3))*TT + B(I,3))*TT + ZN(I)    
! 111       CONTINUE                                                    
!1111    CONTINUE                                                       
!        CLOSE(1)                                                       
!                                                                       
      ELSE 
         WRITE ( *, 2040) 
         IF (IERR.EQ. - 1) THEN 
            WRITE ( *, 2050) 
         ELSEIF (IERR.EQ. - 2) THEN 
            WRITE ( *, 2060) 
         ELSEIF (IERR.EQ. - 3) THEN 
            WRITE ( *, 2070) 
         ENDIF 
      ENDIF 
!                                                                       
!     Compute coefficients with rounding                                
!                                                                       
      BETA = 0.5D+00 
      CALL RENN3D (NI, XN, YN, ZN, NK, BETA, B, C, D, T, HELP, IMARK,   &
      IERR)                                                             
!                                                                       
!     output of nodes                                                   
!                                                                       
      WRITE ( *, 2090) 
      WRITE ( *, 2005) 
      DO 30, I = 0, NI 
         WRITE ( *, 2010) I, XN (I), YN (I), ZN (I) 
   30 END DO 
!                                                                       
!     output of spline with rounding                                    
!                                                                       
      IF (IERR.EQ.0) THEN 
         TSUM (0) = 0.0D+00 
         DO 35 I = 1, NI 
   35    TSUM (I) = TSUM (I - 1) + T (I - 1) 
         WRITE ( *, 2020) 
         DO 40, I = 0, NI - 1 
   40    WRITE ( *, 2030) I, TSUM (I), XN (I), B (I, 1), C (I, 1),      &
         D (I, 1)                                                       
         WRITE ( *, 2031) TSUM (NI) 
         WRITE ( *, 2025) 
         DO 45, I = 0, NI - 1 
   45    WRITE ( *, 2030) I, TSUM (I), YN (I), B (I, 2), C (I, 2),      &
         D (I, 2)                                                       
         WRITE ( *, 2031) TSUM (NI) 
         WRITE ( *, 2026) 
         DO 46, I = 0, NI - 1 
   46    WRITE ( *, 2030) I, TSUM (I), ZN (I), B (I, 3), C (I, 3),      &
         D (I, 3)                                                       
         WRITE ( *, 2031) TSUM (NI) 
         IF (IMARK.EQ.0) THEN 
            WRITE ( *, 2035) 
         ELSE 
            WRITE ( *, 2036) 
         ENDIF 
!                                                                       
! use if creating a table of values                                     
!                                                                       
!        OPEN(2, FILE='RUNDUNG')                                        
!        REWIND(2)                                                      
!        DO 2222, I = 0, NI-1                                           
!           TSCH = T(I)/20.0D0                                          
!           DO 222, TT=0.0D0, T(I)+TSCH*0.5D0, TSCH                     
!              WRITE(2,'(1X,4(F10.5,2X))')                              
!    F             TT, ((D(I,1)*TT + C(I,1))*TT + B(I,1))*TT + XN(I)    
!    F               , ((D(I,2)*TT + C(I,2))*TT + B(I,2))*TT + YN(I)    
!    F               , ((D(I,3)*TT + C(I,3))*TT + B(I,3))*TT + ZN(I)    
! 222       CONTINUE                                                    
!2222    CONTINUE                                                       
!        CLOSE(2)                                                       
!                                                                       
      ELSE 
         WRITE ( *, 2040) 
         IF (IERR.EQ. - 1) THEN 
            WRITE ( *, 2050) 
         ELSEIF (IERR.EQ. - 2) THEN 
            WRITE ( *, 2060) 
         ELSEIF (IERR.EQ. - 3) THEN 
            WRITE ( *, 2070) 
         ENDIF 
      ENDIF 
                                                                        
 2000 FORMAT ( 1X,'C[', T68, ']*', /,                                   &
     &         1X,'C[ TEST EXAMPLE:', T68, ']*', /,                     &
     &         1X,'C[ ', 13('='), T68, ']*', /,                         &
     &         1X,'C[', T68, ']*', /,                                   &
     &         1X,'C[ NODES WITHOUT ROUNDING OF CORNERS:', T68, ']*')   
 2005 FORMAT ( 1X,'C[', T68, ']*', /,                                   &
     &         1X,'C[  I',5X,' X(I)',7X,' Y(I)',7X,' Z(I)',T68,']*',/,  &
     &         1X,'C[ ', 38('-'), T68, ']*')                            
 2010 FORMAT ( 1X,'C[ ', I2, 3X, F9.5, 3X, F9.5, 3X, F9.5, T68, ']*') 
 2020 FORMAT ( 1X,'C[', T68, ']*', /,                                   &
     &         1X,'C[ SPLINE COEFFICIENTS:', T68, ']*', /,              &
     &         1X,'C[', T68, ']*', /,                                   &
     &         1X,'C[  I', 4X, 'TSUM(I)', 6X, 'XN(I)', 8X, 'B(I,1)',    &
     &            5X, ' C(I,1)', 5X, ' D(I,1)', T68, ']*', /,           &
     &         1X,'C[ ', 62('-'), T68, ']*')                            
 2025 FORMAT ( 1X,'C[', T68, ']*', /,                                   &
     &         1X,'C[ SPLINE COEFFICIENTS:', T68, ']*', /,              &
     &         1X,'C[', T68, ']*', /,                                   &
     &         1X,'C[  I', 4X, 'TSUM(I)', 6X, 'YN(I)', 8X, 'B(I,2)',    &
     &            5X, ' C(I,2)', 5X, ' D(I,2)', T68, ']*', /,           &
     &         1X,'C[', 62('-'), T68, ']*')                             
 2026 FORMAT ( 1X,'C[', T68, ']*', /,                                   &
     &         1X,'C[ SPLINE COEFFICIENTS:', T68, ']*', /,              &
     &         1X,'C[', T68, ']*', /,                                   &
     &         1X,'C[  I', 4X, 'TSUM(I)', 6X, 'ZN(I)', 8X, 'B(I,3)',    &
     &            5X, ' C(I,3)', 5X, ' D(I,3)', T68, ']*', /,           &
     &         1X,'C[', 62('-'), T68, ']*')                             
 2030 FORMAT ( 1X,'C[ ', I2, 1X, F11.6, 1X, F11.6, 1X, F11.6, 1X,       &
     &            F11.6, 1X, F11.6, T68, ']*')                          
 2031 FORMAT ( 1X,'C[', 4X, F11.6, T68, ']*') 
 2035 FORMAT ( 1X,'C[', T68, ']*', /,                                   &
     &         1X,'C[ SPLINE IS NOT CLOSED', T68,']*')                  
 2036 FORMAT ( 1X,'C[', T68, ']*', /,                                   &
     &         1X,'C[ SPLINE IS A CLOSED CURVE', T68, ']*')             
 2040 FORMAT ( 1X,'C[', T68, ']*', /,                                   &
     &         1X,'C[ ERROR IN RENNER!', T68, ']*')                     
 2050 FORMAT ( 1X,'C[ LESS THAN  4 NODES!', T68, ']*') 
 2060 FORMAT ( 1X,'C[ TWO ADJACENT NODES ARE IDENTICAL!',               &
     &            T68, ']*')                                            
 2070 FORMAT ( 1X,'C[ NK TOO SMALL!', T68, ']*') 
 2090 FORMAT ( 1X,'C[', T68, ']*', /,                                   &
     &         1X,'C[', T68, ']*', /,                                   &
     &         1X,'C[ NODES AFTER ROUNDING OF CORNERS:', T68, ']*', /,  &
     &         1X,'C[', T68, ']*')                                      
      STOP 
      END PROGRAM TEST                              
