C[BA*)
C[LE*)
       SUBROUTINE FOURN (M, FRE, FIM, A, DELTAX)
C[IX{FOURN}*)
C
C*****************************************************************
C                                                                *
C  This program uses the fast Fourier transform (FFT) to compute *
C  approximate values of the Fourier transform                   *
C[BE*)
C                                                                *
C       F^(tj) = (INTEGRAL of) F(x) * EXP(-I*tj*x) dx            *
C                                                                *
C  ( I : imaginary unit; I**2 = -1 ) for j = -M/2 , ... , M/2 -1.*
C[BA*)
C  Here the nonperiodic function  F is known by its functional   *
C  values F(0), F(1), ... , F(M-1) at equidistant nodes with     *
C  uniform distance DELTAX. These nodes lie in the support of F. *
C[BE*)
C  The double precision vectors  FRE  and  FIM  contain the real *
C  and imaginary parts of the function values of F.              *
C                                                                *
C                                                                *
C  INPUT PARAMETERS:                                             *
C  =================                                             *
C  M        : Number of nodes; M must be even.                   *
C             If M is a power of two ( M = 2**ITAU  for a        *
C             positive integer ITAU ), we make use of the        *
C             subroutineso  FFT, which runs for all values of M. *
C             If M  is not a power of two, then we call on FFTB, * 
C             which limits the available size for its auxiliary  *
C             vectors F1RE, F1IM, GRE, GIM  to  1 <= M <= 1366.  *
C             For larger M, the dimension statement inside FFTB  *
C             must be amended as indicated there.                *
C  FRE, FIM : DOUBLE PRECISION vectors for the real and          *
C             imaginary parts for M functional values of F at the* 
C             nodes  x(j) = A + j * DELTAX , j = 0, 1, ... , M-1.*
C  A        : starting point of the functional values.           *
C  DELTAX   : uniform distance of the nodes.                     *
C                                                                *
C                                                                *
C  OUTPUT PARAMETERS:                                            *
C  ==================                                            *
C  FRE, FIM : DOUBLE PRECISION vectors for real and imaginary    *
C             parts of M complex numbers.                        *
C             FRE and FIM contain the values of the Fourier      *
C             transform  F^  as follows:                         * 
C               FRE(k+M) , FIM(k+M) : Real and imaginary parts of*
C                               F^(tk)  for  k = -M/2  to -1 ,   *  
C               FRE(k) , FIM(k) : Real and imaginary parts of    *
C                               F^(tk)  for  k = 0  to  M/2 -1.  *
C             Here tk = k / (M*DELTAX).                          *
C                                                                *
C----------------------------------------------------------------*
C                                                                *
C  Subroutines used : FFT bzw. FFTB                              *
C                                                                *
C*****************************************************************
C                                                                *
C  Author      : Klaus Niederdrenk                               *
C  Date        : 06.30.1994                                      *
C  Source code : FORTRAN 77                                      *
C                                                                *
C[BA*)
C*****************************************************************
C[BE*)
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      INTEGER M, ITAU
      DIMENSION FRE(0:M-1), FIM(0:M-1)
      LOGICAL POT2
C
C     complex multiplication: Real part
C
      CMLR(AR,AI,BR,BI)=AR*BR-AI*BI
C
C     complex multiplication: Imaginary part
C
      CMLI(AR,AI,BR,BI)=AR*BI+AI*BR
C
C     Determine whether M is a power of two
C
      ITAU=NINT(LOG(REAL(M))/LOG(2.0))
      IF(2**ITAU .EQ. M) THEN
        POT2=.TRUE.
      ELSE
        POT2=.FALSE.
      ENDIF
C
C*****************************************************************     
C     Determine discrete Fourier coeffizients                    *
C*****************************************************************
C
      IF( POT2 ) THEN
        CALL FFT(ITAU,FRE,FIM,0)
      ELSE
        CALL FFTB(M,FRE,FIM,0)
      ENDIF
C
C*****************************************************************
C     Transform to the nonperiodic case:                         *
C     Adjust values to those of the Fourier transform            *
C*****************************************************************
C
      X = DBLE(M)*DELTAX
      PI= 4.0D0*ATAN(1.0D0)
      FAKTOR=2.0D0*PI*A/X
      DO 10 K = -M/2+1, -1
        ARG=DBLE(K)*FAKTOR
        EKR=X*COS(ARG)
        EKI=X*SIN(ARG)
        H       =CMLR(FRE(K+M),FIM(K+M),EKR,-EKI)
        FIM(K+M)=CMLI(FRE(K+M),FIM(K+M),EKR,-EKI)
        FRE(K+M)=H
        H       =CMLR(FRE(-K),FIM(-K),EKR,EKI)
        FIM(-K) =CMLI(FRE(-K),FIM(-K),EKR,EKI)
        FRE(-K) =H
  10  CONTINUE
      FRE(0)    =X*FRE(0)
      FIM(0)    =X*FIM(0)
      ARG=DBLE(M/2)*FAKTOR
      EKR=X*COS(ARG)
      EKI=X*SIN(ARG)
      H         =CMLR(FRE(M/2),FIM(M/2),EKR,EKI)
      FIM(M/2)  =CMLI(FRE(M/2),FIM(M/2),EKR,EKI)
      FRE(M/2)  =H
      RETURN
      END
