C[BA*)
C[KA{F 8}
C[  {Linear and Nonlinear Approximation}
C[  {Linear and Nonlinear Approximation}*)
C[FE{F 8.1.3.1}
C[  {Normal Equations for Discrete Linear Least Squares}
C[  {Normal Equations for Discrete Linear Least Squares}*)
C[LE*)
      SUBROUTINE GADESM(M,X,F,W,LDA,N,C,A,B,Y,Z,IERR)
C[IX{GADESM}*)
C
C*****************************************************************
C                                                                *
C  SUBROUTINE GADESM determines the coefficients of a polynomial *
C  of degree N that approximates a function f at the given nodes *
C  in the discrete Gaussian least squares sense.                 *
C  The linear system of normal equations is solved using the     *
C  Cholesky method.                                              *
C[BE*)
C                                                                *
C                                                                *
C  INPUT PARAMETERS:                                             *
C  =================                                             *
C  M        : index of the last node.                            *
C  X        : (N+1)-vector X(0:M) containing the nodes.          *
C  F        : (N+1)-vector F(0:M) containing the function values *
C             at the nodes.                                      *
C  W        : (N+1)-vector W(0:M) containing the weights.        *
C  LDA      : leading dimension of auxiliary matrix A as defined *
C             in the calling program, LDA >= N+1.                *
C  N        : degree of the approximating polynomial,            *
C             2 <= N <= M.                                       *
C                                                                *
C                                                                *
C  OUPUT PARAMETERS:                                             *
C  =================                                             *
C  C        : (N+1)-vector C(0:N) containing coefficients of the *
C             approximating polynomial.                          *
C  IERR     : = 0, no error.                                     *
C             = 1, incorrect input parameter.                    *
C             = 2, error in SUBROUTINE CHOKY.                    *
C                                                                *
C                                                                *
C  HELP PARAMETER:                                               *
C  ===============                                               *
C  A        : 2-dim. array A(1:LDA,1:N+1).                       *
C  B        : (N+1)-vector B(1:N+1).                             *
C  Y        : (N+1)-vector Y(1:N+1).                             *
C  Z        : (N+1)-vector Z(1:N+1).                             *
C                                                                *
C----------------------------------------------------------------*
C                                                                *
C  subroutines required: CHOKY                                   *
C                                                                *
C*****************************************************************
C                                                                *
C  author   : Guido Dubois                                       *
C  date     : 05.30.87                                           *
C  source   : FORTRAN 77                                         *
C                                                                *
C[BA*)
C*****************************************************************
C[BE*)
C
C  declarations.
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      DIMENSION X(0:M),F(0:M),W(0:M),C(0:N),A(1:LDA,1:N+1),B(1:N+1),
     +     Y(1:N+1),Z(1:N+1)
C
C  testing the input parameter.
C
      IERR=1
      IF(N .LT. 2 .OR. N+1 .GT. LDA .OR. M .LT. N) RETURN
      IERR=0
C
C  compute the first column of the system matrix for the normal equations
C  and the right-hand side.
C
      A(1,1)=0.0D0
      B(1)=0.0D0
      DO 10 I=0,M
         A(1,1)=A(1,1)+W(I)
         B(1)=B(1)+W(I)*F(I)
   10 CONTINUE
      DO 20 J=1,N
         J1=J+1
         A(J1,1)=0.0D0
         B(J1)=0.0D0
         DO 30 I=0,M
            DUMMY=W(I)*X(I)**J
            A(J1,1)=A(J1,1)+DUMMY
            B(J1)=B(J1)+DUMMY*F(I)
   30    CONTINUE
   20 CONTINUE
C
C  compute the last row.
C
      DO 40 K=1,N
         K1=K+1
         L=K+N
         A(J1,K1)=0.0D0
         DO 50 I=0,M
            A(J1,K1)=A(J1,K1)+W(I)*X(I)**L
   50    CONTINUE
   40 CONTINUE
C
C  complete the matrix.
C
      DO 60 K=1,N
         DO 70 I=1,N
            A(I,K+1)=A(I+1,K)
   70    CONTINUE
   60 CONTINUE
C
C  solve the system of normal equations. (The system matrix is
C  positive definite, or MARK = 1 after CHOKY).
C
      CALL CHOKY(N+1,A,LDA,B,Y,Z,MARK)
      IF(MARK .EQ. 1) THEN
         DO 80 J=0,N
            C(J)=Y(J+1)
   80    CONTINUE
      ELSE
         IERR=2
      END IF
      RETURN
      END
