      PROGRAM TEST
C
C******************************************************************
C                                                                 *
C  Test function:  F(X) = SIN(X),  ITAU = 2.                      *
C                                                                 *
C  Test results computed on a PC:                                 *
C                                                                 *
C[   NODES:                                                      ]*
C[   ======                                                      ]*
C[   *    X    *         F(X)         *                          ]*
C[   **********************************                          ]*
C[   *  .00000 *  .00000000000000E+00 *                          ]*
C[   * 1.57080 *  .10000000000000E+01 *                          ]*
C[   * 3.14159 *  .12246063538224E-15 *                          ]*
C[   * 4.71239 * -.10000000000000E+01 *                          ]*
C[                                                               ]*
C[   FOURIER COEFFICIENTS:                                       ]*
C[   =====================                                       ]*
C[   *  K *         A(K)         *         B(K)         *        ]*
C[   ****************************************************        ]*
C[   *  0 *  .30615158845559E-16 *                      *        ]*
C[   *  1 * -.61230317691119E-16 *  .10000000000000E+01 *        ]*
C[   *  2 *  .30615158845559E-16 *                      *        ]*
C[                                                               ]*
C[   TABLE OF VALUES:                                            ]*
C[   ================                                            ]*
C[   *    X    *        FFT(X)        *   ABS(F(X)-FFT(X))   *   ]*
C[   *********************************************************   ]*
C[   *  .00000 *  .00000000000000E+00 *  .00000000000000E+00 *   ]*
C[   *  .17453 *  .17364817766693E+00 *  .00000000000000E+00 *   ]*
C[   *  .34907 *  .34202014332567E+00 *  .00000000000000E+00 *   ]*
C[   *  .52360 *  .50000000000000E+00 *  .00000000000000E+00 *   ]*
C[   *  .69813 *  .64278760968654E+00 *  .00000000000000E+00 *   ]*
C[   *  .87266 *  .76604444311898E+00 *  .00000000000000E+00 *   ]*
C[   * 1.04720 *  .86602540378444E+00 *  .00000000000000E+00 *   ]*
C[   * 1.22173 *  .93969262078591E+00 *  .00000000000000E+00 *   ]*
C[   * 1.39626 *  .98480775301221E+00 *  .00000000000000E+00 *   ]*
C[   * 1.57080 *  .10000000000000E+01 *  .00000000000000E+00 *   ]*
C[   * 1.74533 *  .98480775301221E+00 *  .11102230246252E-15 *   ]*
C[   * 1.91986 *  .93969262078591E+00 *  .00000000000000E+00 *   ]*
C[   * 2.09440 *  .86602540378444E+00 *  .11102230246252E-15 *   ]*
C[   * 2.26893 *  .76604444311898E+00 *  .00000000000000E+00 *   ]*
C[   * 2.44346 *  .64278760968654E+00 *  .11102230246252E-15 *   ]*
C[   * 2.61799 *  .50000000000000E+00 *  .00000000000000E+00 *   ]*
C[   * 2.79253 *  .34202014332567E+00 *  .11102230246252E-15 *   ]*
C[   * 2.96706 *  .17364817766693E+00 *  .11102230246252E-15 *   ]*
C[   * 3.14159 *  .15771889003147E-14 *  .12246063538224E-15 *   ]*
C[   * 3.31613 * -.17364817766693E+00 *  .11102230246252E-15 *   ]*
C[   * 3.49066 * -.34202014332567E+00 *  .11102230246252E-15 *   ]*
C[   * 3.66519 * -.50000000000000E+00 *  .11102230246252E-15 *   ]*
C[   * 3.83972 * -.64278760968654E+00 *  .11102230246252E-15 *   ]*
C[   * 4.01426 * -.76604444311898E+00 *  .00000000000000E+00 *   ]*
C[   * 4.18879 * -.86602540378444E+00 *  .00000000000000E+00 *   ]*
C[   * 4.36332 * -.93969262078591E+00 *  .00000000000000E+00 *   ]*
C[   * 4.53786 * -.98480775301221E+00 *  .00000000000000E+00 *   ]*
C[   * 4.71239 * -.10000000000000E+01 *  .00000000000000E+00 *   ]*
C[   * 4.88692 * -.98480775301221E+00 *  .00000000000000E+00 *   ]*
C[   * 5.06145 * -.93969262078591E+00 *  .00000000000000E+00 *   ]*
C[   * 5.23599 * -.86602540378444E+00 *  .00000000000000E+00 *   ]*
C[   * 5.41052 * -.76604444311898E+00 *  .00000000000000E+00 *   ]*
C[   * 5.58505 * -.64278760968654E+00 *  .11102230246252E-15 *   ]*
C[   * 5.75959 * -.50000000000000E+00 *  .00000000000000E+00 *   ]*
C[   * 5.93412 * -.34202014332567E+00 *  .00000000000000E+00 *   ]*
C[   * 6.10865 * -.17364817766693E+00 *  .00000000000000E+00 *   ]*
C[   * 6.28319 * -.46858133692651E-14 *  .00000000000000E+00 *   ]*
C                                                                 *
C******************************************************************
C
      PARAMETER (ITAU=2,M=2**ITAU)
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      DIMENSION F(0:M-1)
      DOUBLE PRECISION INTV
      PI=4.D0*DATAN(1.D0)
      PER=2.D0*PI
      OMEGA=2.D0*PI/PER
      INTV=PER/(M)
      WRITE(*,900)
      DO 10 I=0,M-1
         X=INTV*I
         F(I)=DSIN(X)
         WRITE(*,910)X,F(I)
   10 CONTINUE
      CALL RFFT(ITAU,F,0)
      WRITE(*,920)
      K=0
      WRITE(*,930)K,F(0)
      DO 20 K=1,M/2-1
         WRITE(*,940)K,F(2*K-1),F(2*K)
   20 CONTINUE
      WRITE(*,930)K,F(M-1)
      WRITE(*,950)
      INTV=PER/36.D0
      DO 30 X=0.D0,PER+0.5D0*INTV,INTV
         SUM=F(0)
         DO 40 K=1,M/2-1
            SUM=SUM+F(2*K-1)*DCOS(K*OMEGA*X)+F(2*K)*DSIN(K*OMEGA*X)
   40    CONTINUE
         SUM=SUM+F(M-1)*DCOS(M/2*OMEGA*X)
         FX=DSIN(X)
         WRITE(*,960)X,SUM,DABS(FX-SUM)
   30 CONTINUE
      STOP
  900 FORMAT(1X,'C[   NODES:',T67,']*',/,
     +       1X,'C[',3X,6('='),T67,']*',/,
     +       1X,'C[   *',4X,'X',4X,'*',9X,'F(X)',9X,'*',T67,']*',/,
     +       1X,'C[',3X,34('*'),T67,']*')
  910 FORMAT(1X,'C[   * ',F7.5,' * ',E20.14,' * ',T67,']*')
  920 FORMAT(1X,'C[',T67,']*',/,
     +       1X,'C[   FOURIER COEFFICIENTS:',T67,']*',/,
     +       1X,'C[',3X,21('='),T67,']*',/,
     +       1X,'C[   *  K *',9X,'A(K)',9X,'*',9X,'B(K)',
     +       9X,'*',T67,']*',/,1X,'C[',3X,52('*'),T67,']*')
  930 FORMAT(1X,'C[   * ',I2,' * ',E20.14,' *',22X,'*',T67,']*')
  940 FORMAT(1X,'C[   * ',I2,' * ',E20.14,' * ',E20.14,' *',T67,']*')
  950 FORMAT(1X,'C[',T67,']*',/,
     +       1X,'C[   TABLE OF VALUES:',T67,']*',/,
     +       1X,'C[',3X,16('='),T67,']*',/,
     +       1X,'C[   *',4X,'X',4X,'*',8X,'FFT(X)',8X,'*',
     +       3X,'ABS(F(X)-FFT(X))',3X,'*',T67,']*',/,
     +       1X,'C[',3X,57('*'),T67,']*')
  960 FORMAT(1X,'C[   * ',F7.5,' * ',E20.14,' * ',E20.14,' *',T67,']*')
      END
