      PROGRAM TEST 
!                                                                       
!*********************************************************************  
!              Test program for the subroutines                      *  
!              CFSPNP, CFSPPE, NCYFSY, SPTAB.                        *  
!--------------------------------------------------------------------*  
!   required subroutines    :  CFSPNP,CFSPPE,NCYFSY,NCYFSP,          *  
!                              NCYFSS,SPTAB                          *  
!--------------------------------------------------------------------*  
!                                                                    *  
!   The test program wcomputes a non parametric, periodic cubic      *  
!   fitting spline for the following nodes:                          *  
!                                                                    *  
!          I        X(I)         Y(I)          W(I)                  *  
!         -------------------------------------------                *  
!          0       0.0000       0.0000      100.0000                 *  
!          1       1.5000       2.0000       75.0000                 *  
!          2       2.5000       0.0000       50.0000                 *  
!          3       5.5000      -4.0000      100.0000                 *  
!          4       8.0000      -2.0000       50.0000                 *  
!          5      10.0000       0.0000       10.0000                 *  
!          6      12.0000       2.0000       50.0000                 *  
!          7      14.5000       4.0000      100.0000                 *  
!          8      17.5000       0.0000       50.0000                 *  
!          9      18.5000      -2.0000       75.0000                 *  
!         10      20.0000       0.0000      100.0000                 *  
!                                                                    *  
!               where W(I) = weight for Y(I).                        *  
!                                                                    *  
!   Results:                                                         *  
!                                                                    *  
![                                                                  ]*  
![ GIVEN:   N + 1 POINTS X(I),Y(I), I=0(1)N, (N=10),                ]*  
![ ======   AND WEIGHTS W(I)                                        ]*  
![                                                                  ]*  
![  I        X(I)         Y(I)          W(I)                        ]*  
![ -------------------------------------------                      ]*  
![  0        .0000        .0000      100.0000                       ]*  
![  1       1.5000       2.0000       75.0000                       ]*  
![  2       2.5000        .0000       50.0000                       ]*  
![  3       5.5000      -4.0000      100.0000                       ]*  
![  4       8.0000      -2.0000       50.0000                       ]*  
![  5      10.0000        .0000       10.0000                       ]*  
![  6      12.0000       2.0000       50.0000                       ]*  
![  7      14.5000       4.0000      100.0000                       ]*  
![  8      17.5000        .0000       50.0000                       ]*  
![  9      18.5000      -2.0000       75.0000                       ]*  
![ 10      20.0000        .0000      100.0000                       ]*  
![                                                                  ]*  
![                                                                  ]*  
![ TO FIND:  A) COEFFICIENTS OF A NON PARAMETRIC, PERIODIC, CUBIC   ]*  
![ ========     APPROXIMATING SPLINE S(X) FOR THE NODES X(I),Y(I).  ]*  
![                                                                  ]*  
![           B) TABLE OF VALUES FOR S(X)                            ]*  
![                                                                  ]*  
![                                                                  ]*  
![ SOLUTION:                                                        ]*  
![ =========                                                        ]*  
![                                                                  ]*  
![ A) SPLINE COEFFICIENTS:                                          ]*  
![    --------------------                                          ]*  
![                                                                  ]*  
![  I       A(I)           B(I)           C(I)           D(I)       ]*  
![ --------------------------------------------------------------   ]*  
![  0  .35236571E-18  .22250581E+01  .13230680E-16 -.42304850E+00   ]*  
![  1  .19097985E+01 -.63051924E+00 -.19037182E+01  .70447032E+00   ]*  
![  2  .80031329E-01 -.23245448E+01  .20969271E+00  .37542574E-01   ]*  
![  3 -.39927191E+01 -.52739027E-01  .54757588E+00 -.83805341E-01   ]*  
![  4 -.20116759E+01  .11137902E+01 -.80964182E-01  .13494030E-01   ]*  
![  5 -.20794287E-17  .95186184E+00 -.34582496E-17  .13494030E-01   ]*  
![  6  .20116759E+01  .11137902E+01  .80964182E-01 -.83805341E-01   ]*  
![  7  .39927191E+01 -.52739027E-01 -.54757588E+00  .37542574E-01   ]*  
![  8 -.80031329E-01 -.23245448E+01 -.20969271E+00  .70447032E+00   ]*  
![  9 -.19097985E+01 -.63051924E+00  .19037182E+01 -.42304850E+00   ]*  
![                                                                  ]*  
![ COEFFICIENTS FOUND.                                              ]*  
![                                                                  ]*  
![                                                                  ]*  
![ TABLE OF VALUES FOR:                                             ]*  
![   STARTING VALUE = XANF =    .00                                 ]*  
![   FINAL VALUE    = XEND =  20.00                                 ]*  
![                                                                  ]*  
![                                                                  ]*  
![                                                                  ]*  
![ B) TABLE OF VALUES FOR SPLINE:                                   ]*  
![    ---------------------------                                   ]*  
![                                                                  ]*  
![   I           XW(I)                   YW(I)                      ]*  
![ ---------------------------------------------------              ]*  
![   0     .00000000000000E+00     .35236570605779E-18              ]*  
![   1     .75000000000000E+00     .14903200022084E+01              ]*  
![   2     .15000000000000E+01     .19097984949648E+01              ]*  
![   3     .20000000000000E+01     .12066681034393E+01              ]*  
![   4     .25000000000000E+01     .80031328934795E-01              ]*  
![   5     .32500000000000E+01    -.15295868305261E+01              ]*  
![   6     .40000000000000E+01    -.28082710534049E+01              ]*  
![   7     .47500000000000E+01    -.36609916986180E+01              ]*  
![   8     .55000000000000E+01    -.39927191250816E+01              ]*  
![   9     .61250000000000E+01    -.38322444788108E+01              ]*  
![  10     .67500000000000E+01    -.33667379099330E+01              ]*  
![  11     .73750000000000E+01    -.27189611485029E+01              ]*  
![  12     .80000000000000E+01    -.20116759245756E+01              ]*  
![  13     .86666666666667E+01    -.13011349707178E+01              ]*  
![  14     .93333333333333E+01    -.63857279165910E+00              ]*  
![  15     .10000000000000E+02    -.20794287038935E-17              ]*  
![  16     .10666666666667E+02     .63857279165910E+00              ]*  
![  17     .11333333333333E+02     .13011349707178E+01              ]*  
![  18     .12000000000000E+02     .20116759245756E+01              ]*  
![  19     .12625000000000E+02     .27189611485029E+01              ]*  
![  20     .13250000000000E+02     .33667379099330E+01              ]*  
![  21     .13875000000000E+02     .38322444788108E+01              ]*  
![  22     .14500000000000E+02     .39927191250816E+01              ]*  
![  23     .15250000000000E+02     .36609916986180E+01              ]*  
![  24     .16000000000000E+02     .28082710534049E+01              ]*  
![  25     .16750000000000E+02     .15295868305261E+01              ]*  
![  26     .17500000000000E+02    -.80031328934795E-01              ]*  
![  27     .18000000000000E+02    -.12066681034393E+01              ]*  
![  28     .18500000000000E+02    -.19097984949648E+01              ]*  
![  29     .19250000000000E+02    -.14903200022084E+01              ]*  
![  30     .20000000000000E+02    -.83266726846887E-16              ]*  
![                                                                  ]*  
![ TABLE FOUND.                                                     ]*  
!                                                                    *  
!*********************************************************************  
!                                                                    *  
!   Author      :  Gnter Palm                                       *  
!   Date        :  5.22.1988                                         *  
!   Source code :  FORTRAN 77                                        *  
!                                                                    *  
!*********************************************************************  
!                                                                       
      IMPLICIT DOUBLEPRECISION (A - H, O - Z) 
      PARAMETER (N = 10, MT = 25) 
!                                                                       
      DIMENSION X (0:N), Y (0:N), W (0:N) 
      DIMENSION A (0:N), B (0:N), C (0:N), D (0:N) 
      DIMENSION XW (0:N + MT + 2), YW (0:N + MT + 2) 
      DIMENSION HILF (14 * N - 10) 
!                                                                       
      DATA X / 0.0D0, 1.5D0, 2.5D0, 5.5D0, 8.0D0, 10.0D0, 12.0D0,       &
      14.5D0, 17.5D0, 18.5D0, 20.0D0 /                                  
      DATA Y / 0.0D0, 2.0D0, 0.0D0, - 4.0D0, - 2.0D0, 0.0D0, 2.0D0,     &
      4.0D0, 0.0D0, - 2.0D0, 0.0D0 /                                    
      DATA W / 100.0D0, 75.0D0, 50.0D0, 100.0D0, 50.0D0, 10.0D0, 50.0D0,&
      100.0D0, 50.0D0, 75.0D0, 100.0D0 /                                
!                                                                       
      IAB = 4 
      CALL CFSPNP (N, X, Y, W, IAB, 0.0D0, 0.0D0, A, B, C, D, HILF,     &
      IFEHL)                                                            
      IF (IFEHL.NE.0) THEN 
         WRITE ( *, 1100) IFEHL 
         STOP 
      ENDIF 
      WRITE ( *, 2000) N 
      DO 100 I = 0, N, 1 
         WRITE ( *, 2100) I, X (I), Y (I), W (I) 
  100 END DO 
      WRITE ( *, 2200) 
      DO 200 I = 0, N - 1, 1 
         WRITE ( *, 2300) I, A (I), B (I), C (I), D (I) 
  200 END DO 
!                                                                       
      XANF = X (0) 
      XEND = X (N) 
      WRITE ( *, 1150) XANF, XEND 
      CALL SPTAB (N, MT, XANF, XEND, X, A, B, C, D, NT, XW, YW, IFEHL) 
      IF (IFEHL.NE.0) THEN 
         WRITE ( *, 1400) 
         STOP 
      ENDIF 
      WRITE ( *, 2400) 
      DO 300 I = 0, NT, 1 
         WRITE ( *, 2500) I, XW (I), YW (I) 
  300 END DO 
      WRITE ( *, 2600) 
      STOP 
!                                                                       
! Formatangaben                                                         
!                                                                       
 1100 FORMAT(1X,'C[ ERROR WITH COMPUTING COEFFICIENTS.',T70,']*',/,     &
     &       1X,'C[ ERROR PARAMETER =',I4,T70,']*')                     
 1150 FORMAT(1X,'C[',T70,']*',/,                                        &
     &       1X,'C[ COEFFICIENTS FOUND.',                               &
     &          T70,']*',/,1X,'C[',T70,']*',/,1X,'C[',T70,']*',/,       &
     &       1X,'C[ TABLE OF VALUES FOR:',T70,']*',/,                   &
     &       1X,'C[   STARTING VALUE = XANF = ',F6.2,T70,']*',/,        &
     &       1X,'C[   FINAL VALUE    = XEND = ',F6.2,T70,']*',/,        &
     &       1X,'C[',T70,']*')                                          
 1400 FORMAT(1X,'C[ ERRONEOUS INPUT.',T70,']*',/,                       &
     &       1X,'C[ XANF EXCEEDS XEND.',T70,']*')                       
 2000 FORMAT(1X,'C[',T70,']*',/,                                        &
     &       1X,'C[ GIVEN:   N + 1 POINTS X(I),Y(I), I=0(1)N, (N=',I2,  &
     &          '),',T70,']*',/,                                        &
     &       1X,'C[ ======   AND WEIGHTS W(I)',                         &
     &         T70,']*',/,1X,'C[',T70,']*',/,                           &
     &       1X,'C[  I        X(I)         Y(I)          W(I)',         &
     &          T70,']*',/,                                             &
     &       1X,'C[',1X,43('-'),T70,']*')                               
 2100 FORMAT(1X,'C[',1X,I2,4X,F9.4,4X,F9.4,4X,F10.4,T70,']*') 
 2200 FORMAT(1X,'C[',T70,']*',/,1X,'C[',T70,']*',/,                     &
     &       1X,'C[ TO FIND:  A) COEFFICIENTS OF A NON PARAMETRIC, ',   &
     &          'PERIODIC, CUBIC',T70,']*',/,                           &
     &       1X,'C[ ========     APPROXIMATING SPLINE S(X) FOR THE ',   &
     &          'NODES X(I),Y(I).',T70,']*',/,                          &
     &       1X,'C[',T70,']*',/,                                        &
     &       1X,'C[           B) TABLE OF VALUES FOR S(X)',T70,']*',/,  &
     &       1X,'C[',T70,']*',/,1X,'C[',T70,']*',/,                     &
     &       1X,'C[ SOLUTION:',T70,']*',/,                              &
     &       1X,'C[ =========',T70,']*',/,                              &
     &       1X,'C[',T70,']*',/,                                        &
     &       1X,'C[ A) SPLINE COEFFICIENTS:',T70,']*',/,                &
     &       1X,'C[    --------------------',T70,']*',/,                &
     &       1X,'C[',T70,']*',/,                                        &
     &       1X,'C[  I',7X,'A(I)',11X,'B(I)',11X,'C(I)',11X,'D(I)',T70, &
     &          ']*',/,1X,'C[',1X,62('-'),T70,']*')                     
 2300 FORMAT(1X,'C[',1X,I2,4(1X,E14.8),T70,']*') 
 2400 FORMAT(1X,'C[',T70,']*',/,1X,'C[',T70,']*',/,                     &
     &       1X,'C[ B) TABLE OF VALUES FOR SPLINE:',T70,']*',/,         &
     &       1X,'C[    ---------------------------',T70,']*',/,         &
     &       1X,'C[',T70,']*',/,                                        &
     &       1X,'C[   I           XW(I)                   YW(I)',       &
     &          T70,']*',/,                                             &
     &       1X,'C[',1X,51('-'),T70,']*')                               
 2500 FORMAT(1X,'C[',1X,I3,2(4X,E20.14),T70,']*') 
 2600 FORMAT(1X,'C[',T70,']*',/,                                        &
     &       1X,'C[ TABLE FOUND.',T70,']*')                             
      END PROGRAM TEST                              
