/* checkemx.c (emx+gcc) -- Copyright (c) 1996 by Eberhard Mattes */

/* This is sample code for
   1. checking the emx revision
   2. printing the full path name of the out-dated emx.dll. */

#define INCL_DOSMODULEMGR
#include <os2.h>
#include <stdio.h>
#include <stdlib.h>


static void check_emx (void)
{
  ULONG rc;
  HMODULE hmod;
  char name[CCHMAXPATH];
  char fail[9];

  if (_osmode == OS2_MODE)
    {
      if (_emx_rev < 41)
        {
          fputs ("This program requires emx.dll revision 41 (0.9b fix 02) "
                 "or later.\n", stderr);
          rc = DosLoadModule (fail, sizeof (fail), "emx", &hmod);
          if (rc == 0)
            {
              rc = DosQueryModuleName (hmod, sizeof (name), name);
              if (rc == 0)
                fprintf (stderr, "Please delete or update `%s'.\n", name);
              DosFreeModule (hmod);
            }
          exit (2);
        }
    }
  else
    {
      if (_emx_rev < 41)
        {
          fputs ("This program requires emx.exe revision 41 (0.9b fix 02) "
                 "or later\n", stderr);
          exit (2);
        }
    }
}


int main (void)
{
  check_emx ();

  puts ("This is a sample program for checking the emx revision.");
  return 0;
}
