      PROGRAM TEST
C                                         4.18.1993  ( Dubois Guido )
C*********************************************************************
C                                                                    *
C  Test program for the subroutines  PARMIT, PMTVAL and PMTAB.       *
C  Find the coefficients of a parametric Hermite spline for various  *
C  end point conditions:                                             *
C                                                                    *
C     1. Natural parametric Hermite spline                           *
C     2. Parametric Hermite spline for given end point curvature     *
C        radii                                                       *
C                                                                    *
C[  NODES:                                                          ]*
C[                                                                  ]*
C[   I      X(I)       Y(I)   XRICHT(I)  YRICHT(I)                  ]*
C[  ----------------------------------------------                  ]*
C[   1     1.0000     1.0000      .3162      .9487                  ]*
C[   2     1.5000     2.0000      .7071      .7071                  ]*
C[   3     2.0000     2.5000     1.0000      .0000                  ]*
C[   4     2.5000     2.0000      .7071     -.7071                  ]*
C[   5     2.5000     1.0000     -.8944     -.4472                  ]*
C[   6     2.0000     1.5000      .0000     1.0000                  ]*
C[   7     2.5000     2.0000      .7071      .7071                  ]*
C[   8     3.0000     3.0000      .5547      .8321                  ]*
C[   9     4.0000     3.0000      .7071     -.7071                  ]*
C[                                                                  ]*
C[                                                                  ]*
C[  END POINT CONDITION:  NATURAL PARAMETRIC SPLINE                 ]*
C[                    RB1(X) =   .000D+00     RB1(Y) =   .000D+00   ]*
C[                    RBN(X) =   .000D+00     RBN(X) =   .000D+00   ]*
C[                                                                  ]*
C[  COEFFICIENTS:                                                   ]*
C[                                                                  ]*
C[   I        T(I)          AX(I)          BX(I)          CX(I)     ]*
C[  --------------------------------------------------------------  ]*
C[   1    .000000D+00    .100000D+01    .316198D+00    .000000D+00  ]*
C[   2    .111803D+01    .150000D+01    .707107D+00   -.220662D+00  ]*
C[   3    .182514D+01    .200000D+01    .100000D+01   -.945891D-02  ]*
C[   4    .253225D+01    .250000D+01    .707107D+00    .163908D+00  ]*
C[   5    .353225D+01    .250000D+01   -.894427D+00   -.477708D+00  ]*
C[   6    .423935D+01    .200000D+01    .000000D+00    .164287D+01  ]*
C[   7    .494646D+01    .250000D+01    .707107D+00   -.605425D+00  ]*
C[   8    .606450D+01    .300000D+01    .554677D+00    .818099D+00  ]*
C[   9    .706450D+01                                               ]*
C[                                                                  ]*
C[   I                      DX(I)          EX(I)          FX(I)     ]*
C[  --------------------------------------------------------------  ]*
C[   1                  -.400148D+00    .904831D+00   -.405337D+00  ]*
C[   2                  -.142033D+01    .451286D+01   -.291735D+01  ]*
C[   3                  -.324279D+01    .591503D+01   -.302436D+01  ]*
C[   4                  -.163436D+01    .843005D+00   -.796551D-01  ]*
C[   5                   .941104D+00    .323693D+00   -.239535D+00  ]*
C[   6                   .658972D+00   -.372108D+01    .212614D+01  ]*
C[   7                   .764884D+00   -.736000D+00    .313266D+00  ]*
C[   8                   .138921D+01   -.315854D+01    .139655D+01  ]*
C[                                                                  ]*
C[   I        T(I)          AY(I)          BY(I)          CY(I)     ]*
C[  --------------------------------------------------------------  ]*
C[   1    .000000D+00    .100000D+01    .948693D+00    .000000D+00  ]*
C[   2    .111803D+01    .200000D+01    .707107D+00    .319506D+00  ]*
C[   3    .182514D+01    .250000D+01    .000000D+00   -.192226D+01  ]*
C[   4    .253225D+01    .200000D+01   -.707107D+00    .146911D+00  ]*
C[   5    .353225D+01    .100000D+01   -.447214D+00    .209417D+01  ]*
C[   6    .423935D+01    .150000D+01    .100000D+01   -.690561D+00  ]*
C[   7    .494646D+01    .200000D+01    .707107D+00    .292290D+00  ]*
C[   8    .606450D+01    .300000D+01    .832066D+00   -.492901D+00  ]*
C[   9    .706450D+01                                               ]*
C[                                                                  ]*
C[   I                      DY(I)          EY(I)          FY(I)     ]*
C[  --------------------------------------------------------------  ]*
C[   1                   .624723D+00   -.113882D+01    .484084D+00  ]*
C[   2                   .158281D+01   -.439391D+01    .214460D+01  ]*
C[   3                  -.122043D+00    .387877D+01   -.263277D+01  ]*
C[   4                  -.231507D+01    .246505D+01   -.589783D+00  ]*
C[   5                   .164730D+01   -.499305D+01    .246073D+01  ]*
C[   6                  -.171557D+00    .131489D+01   -.734797D+00  ]*
C[   7                  -.126465D+00    .105497D+00   -.824475D-01  ]*
C[   8                  -.685264D+00    .228075D+00    .118024D+00  ]*
C[                                                                  ]*
C[  FUNCTION VALUES AND DERIVATIVES AT THE NODES:                   ]*
C[                                                                  ]*
C[      T0         SX             SX(1)          SX(2)              ]*
C[                 SX(3)          SX(4)          SX(5)              ]*
C[                 SY             SY(1)          SY(2)              ]*
C[                 SY(3)          SY(4)          SY(5)              ]*
C[  -----------------------------------------------------           ]*
C[     .0000    .100000D+01    .316198D+00    .000000D+00           ]*
C[             -.240089D+01    .217160D+02   -.486405D+02           ]*
C[              .100000D+01    .948693D+00    .948693D+00           ]*
C[              .374834D+01   -.273317D+02    .580901D+02           ]*
C[    1.1180    .150000D+01    .707107D+00   -.441323D+00           ]*
C[             -.852201D+01    .108309D+03   -.350082D+03           ]*
C[              .200000D+01    .707107D+00    .707107D+00           ]*
C[              .949687D+01   -.105454D+03    .257352D+03           ]*
C[    1.8251    .200000D+01    .100000D+01   -.189178D-01           ]*
C[             -.194567D+02    .141961D+03   -.362923D+03           ]*
C[              .250000D+01    .000000D+00    .000000D+00           ]*
C[             -.732259D+00    .930905D+02   -.315933D+03           ]*
C[    2.5322    .250000D+01    .707107D+00    .327817D+00           ]*
C[             -.980619D+01    .202321D+02   -.955861D+01           ]*
C[              .200000D+01   -.707107D+00   -.707107D+00           ]*
C[             -.138904D+02    .591612D+02   -.707739D+02           ]*
C[    3.5322    .250000D+01   -.894427D+00   -.955416D+00           ]*
C[              .564662D+01    .776863D+01   -.287442D+02           ]*
C[              .100000D+01   -.447214D+00   -.447214D+00           ]*
C[              .988379D+01   -.119833D+03    .295287D+03           ]*
C[    4.2394    .200000D+01    .000000D+00    .328574D+01           ]*
C[              .395383D+01   -.893059D+02    .255137D+03           ]*
C[              .150000D+01    .100000D+01    .100000D+01           ]*
C[             -.102934D+01    .315574D+02   -.881757D+02           ]*
C[    4.9465    .250000D+01    .707107D+00   -.121085D+01           ]*
C[              .458931D+01   -.176640D+02    .375919D+02           ]*
C[              .200000D+01    .707107D+00    .707107D+00           ]*
C[             -.758790D+00    .253192D+01   -.989370D+01           ]*
C[    6.0645    .300000D+01    .554677D+00    .163620D+01           ]*
C[              .833529D+01   -.758050D+02    .167586D+03           ]*
C[              .300000D+01    .832066D+00    .832066D+00           ]*
C[             -.411158D+01    .547379D+01    .141629D+02           ]*
C[    7.0645    .400000D+01    .707107D+00   -.888178D-15           ]*
C[              .163233D+02    .917810D+02    .167586D+03           ]*
C[              .300000D+01   -.707107D+00   -.707107D+00           ]*
C[              .844367D+01    .196367D+02    .141629D+02           ]*
C[                                                                  ]*
C[  TABLE OF VALUES:                                                ]*
C[                                                                  ]*
C[    I       XTAB             YTAB                                 ]*
C[  -------------------------------------                           ]*
C[    1    .10000000D+01    .10000000D+01                           ]*
C[    2    .10853611D+01    .12757889D+01                           ]*
C[    3    .11754095D+01    .15606638D+01                           ]*
C[    4    .13141194D+01    .18086264D+01                           ]*
C[    5    .15000000D+01    .20000000D+01                           ]*
C[    6    .15086511D+01    .20087380D+01                           ]*
C[    7    .16805143D+01    .22484241D+01                           ]*
C[    8    .18757151D+01    .24687711D+01                           ]*
C[    9    .20000000D+01    .25000000D+01                           ]*
C[   10    .21440826D+01    .24565144D+01                           ]*
C[   11    .23312520D+01    .22236248D+01                           ]*
C[   12    .25000000D+01    .20000000D+01                           ]*
C[   13    .25077750D+01    .19922572D+01                           ]*
C[   14    .26864394D+01    .17635454D+01                           ]*
C[   15    .27370690D+01    .14328109D+01                           ]*
C[   16    .26143644D+01    .11001864D+01                           ]*
C[   17    .25000000D+01    .10000000D+01                           ]*
C[   18    .23668600D+01    .98141379D+00                           ]*
C[   19    .21138926D+01    .11846334D+01                           ]*
C[   20    .20000007D+01    .14993424D+01                           ]*
C[   21    .20000000D+01    .15000000D+01                           ]*
C[   22    .21256217D+01    .17301901D+01                           ]*
C[   23    .23860778D+01    .19049869D+01                           ]*
C[   24    .25000000D+01    .20000000D+01                           ]*
C[   25    .25889474D+01    .21043936D+01                           ]*
C[   26    .27291563D+01    .23436919D+01                           ]*
C[   27    .28384048D+01    .26113060D+01                           ]*
C[   28    .29388152D+01    .28846121D+01                           ]*
C[   29    .30000000D+01    .30000000D+01                           ]*
C[   30    .31067422D+01    .31129771D+01                           ]*
C[   31    .34188947D+01    .32222605D+01                           ]*
C[   32    .37606661D+01    .31730641D+01                           ]*
C[   33    .40000000D+01    .30000000D+01                           ]*
C[                                                                  ]*
C[                                                                  ]*
C[  END POINT CONDITION:  CURVATURE RADII                           ]*
C[                    RB1(X) =   .500D+00     RB1(Y) =   .500D+00   ]*
C[                    RBN(X) =  -.500D+00     RBN(X) =  -.500D+00   ]*
C[                                                                  ]*
C[  COEFFICIENTS:                                                   ]*
C[                                                                  ]*
C[   I        T(I)          AX(I)          BX(I)          CX(I)     ]*
C[  --------------------------------------------------------------  ]*
C[   1    .000000D+00    .100000D+01    .316198D+00    .500000D+00  ]*
C[   2    .111803D+01    .150000D+01    .707107D+00   -.153733D+00  ]*
C[   3    .182514D+01    .200000D+01    .100000D+01    .208878D-02  ]*
C[   4    .253225D+01    .250000D+01    .707107D+00    .166266D+00  ]*
C[   5    .353225D+01    .250000D+01   -.894427D+00   -.476967D+00  ]*
C[   6    .423935D+01    .200000D+01    .000000D+00    .164500D+01  ]*
C[   7    .494646D+01    .250000D+01    .707107D+00   -.593384D+00  ]*
C[   8    .606450D+01    .300000D+01    .554677D+00    .907971D+00  ]*
C[   9    .706450D+01                                               ]*
C[                                                                  ]*
C[   I                      DX(I)          EX(I)          FX(I)     ]*
C[  --------------------------------------------------------------  ]*
C[   1                  -.168193D+01    .199775D+01   -.715218D+00  ]*
C[   2                  -.168796D+01    .486824D+01   -.307399D+01  ]*
C[   3                  -.328845D+01    .597489D+01   -.305036D+01  ]*
C[   4                  -.164069D+01    .848593D+00   -.812708D-01  ]*
C[   5                   .940971D+00    .319620D+00   -.235606D+00  ]*
C[   6                   .666962D+00   -.375646D+01    .215417D+01  ]*
C[   7                   .812958D+00   -.850896D+00    .368957D+00  ]*
C[   8                   .161960D+01   -.388892D+01    .180668D+01  ]*
C[                                                                  ]*
C[   I        T(I)          AY(I)          BY(I)          CY(I)     ]*
C[  --------------------------------------------------------------  ]*
C[   1    .000000D+00    .100000D+01    .948693D+00    .466274D+01  ]*
C[   2    .111803D+01    .200000D+01    .707107D+00    .943623D+00  ]*
C[   3    .182514D+01    .250000D+01    .000000D+00   -.181471D+01  ]*
C[   4    .253225D+01    .200000D+01   -.707107D+00    .168117D+00  ]*
C[   5    .353225D+01    .100000D+01   -.447214D+00    .209565D+01  ]*
C[   6    .423935D+01    .150000D+01    .100000D+01   -.697971D+00  ]*
C[   7    .494646D+01    .200000D+01    .707107D+00    .246346D+00  ]*
C[   8    .606450D+01    .300000D+01    .832066D+00   -.836947D+00  ]*
C[   9    .706450D+01                                               ]*
C[                                                                  ]*
C[   I                      DY(I)          EY(I)          FY(I)     ]*
C[  --------------------------------------------------------------  ]*
C[   1                  -.113285D+02    .905316D+01   -.240572D+01  ]*
C[   2                  -.912986D+00   -.107942D+01    .683538D+00  ]*
C[   3                  -.548366D+00    .443927D+01   -.287700D+01  ]*
C[   4                  -.237721D+01    .252570D+01   -.609508D+00  ]*
C[   5                   .163054D+01   -.495452D+01    .243558D+01  ]*
C[   6                  -.205091D+00    .145421D+01   -.843786D+00  ]*
C[   7                  -.310908D+00    .545704D+00   -.295752D+00  ]*
C[   8                  -.156734D+01    .302437D+01   -.145214D+01  ]*
C[                                                                  ]*
C[  FUNCTION VALUES AND DERIVATIVES AT THE NODES:                   ]*
C[                                                                  ]*
C[      T0         SX             SX(1)          SX(2)              ]*
C[                 SX(3)          SX(4)          SX(5)              ]*
C[                 SY             SY(1)          SY(2)              ]*
C[                 SY(3)          SY(4)          SY(5)              ]*
C[  -----------------------------------------------------           ]*
C[     .0000    .100000D+01    .316198D+00    .100000D+01           ]*
C[             -.100916D+02    .479459D+02   -.858261D+02           ]*
C[              .100000D+01    .948693D+00    .948693D+00           ]*
C[             -.679709D+02    .217276D+03   -.288686D+03           ]*
C[    1.1180    .150000D+01    .707107D+00   -.307466D+00           ]*
C[             -.101278D+02    .116838D+03   -.368879D+03           ]*
C[              .200000D+01    .707107D+00    .707107D+00           ]*
C[             -.547791D+01   -.259062D+02    .820246D+02           ]*
C[    1.8251    .200000D+01    .100000D+01    .417756D-02           ]*
C[             -.197307D+02    .143397D+03   -.366043D+03           ]*
C[              .250000D+01    .000000D+00    .000000D+00           ]*
C[             -.329019D+01    .106543D+03   -.345240D+03           ]*
C[    2.5322    .250000D+01    .707107D+00    .332531D+00           ]*
C[             -.984417D+01    .203662D+02   -.975250D+01           ]*
C[              .200000D+01   -.707107D+00   -.707107D+00           ]*
C[             -.142632D+02    .606169D+02   -.731409D+02           ]*
C[    3.5322    .250000D+01   -.894427D+00   -.953933D+00           ]*
C[              .564583D+01    .767088D+01   -.282727D+02           ]*
C[              .100000D+01   -.447214D+00   -.447214D+00           ]*
C[              .978322D+01   -.118909D+03    .292269D+03           ]*
C[    4.2394    .200000D+01    .000000D+00    .329000D+01           ]*
C[              .400177D+01   -.901550D+02    .258501D+03           ]*
C[              .150000D+01    .100000D+01    .100000D+01           ]*
C[             -.123055D+01    .349009D+02   -.101254D+03           ]*
C[    4.9465    .250000D+01    .707107D+00   -.118677D+01           ]*
C[              .487775D+01   -.204215D+02    .442748D+02           ]*
C[              .200000D+01    .707107D+00    .707107D+00           ]*
C[             -.186545D+01    .130969D+02   -.354902D+02           ]*
C[    6.0645    .300000D+01    .554677D+00    .181594D+01           ]*
C[              .971758D+01   -.933341D+02    .216801D+03           ]*
C[              .300000D+01    .832066D+00    .832066D+00           ]*
C[             -.940405D+01    .725848D+02   -.174257D+03           ]*
C[    7.0645    .400000D+01    .707107D+00    .100000D+01           ]*
C[              .247841D+02    .123467D+03    .216801D+03           ]*
C[              .300000D+01   -.707107D+00   -.707107D+00           ]*
C[             -.239479D+02   -.101672D+03   -.174257D+03           ]*
C[                                                                  ]*
C[  TABLE OF VALUES:                                                ]*
C[                                                                  ]*
C[    I       XTAB             YTAB                                 ]*
C[  -------------------------------------                           ]*
C[    1    .10000000D+01    .10000000D+01                           ]*
C[    2    .11027746D+01    .14381776D+01                           ]*
C[    3    .11973639D+01    .17653985D+01                           ]*
C[    4    .13213285D+01    .18758531D+01                           ]*
C[    5    .15000000D+01    .20000000D+01                           ]*
C[    6    .15086607D+01    .20088277D+01                           ]*
C[    7    .16818097D+01    .22605021D+01                           ]*
C[    8    .18759584D+01    .24710390D+01                           ]*
C[    9    .20000000D+01    .25000000D+01                           ]*
C[   10    .21442199D+01    .24577911D+01                           ]*
C[   11    .23314168D+01    .22251463D+01                           ]*
C[   12    .25000000D+01    .20000000D+01                           ]*
C[   13    .25077753D+01    .19922597D+01                           ]*
C[   14    .26865204D+01    .17642083D+01                           ]*
C[   15    .27371541D+01    .14333978D+01                           ]*
C[   16    .26143787D+01    .11002492D+01                           ]*
C[   17    .25000000D+01    .10000000D+01                           ]*
C[   18    .23668730D+01    .98141001D+00                           ]*
C[   19    .21139380D+01    .11845225D+01                           ]*
C[   20    .20000007D+01    .14993424D+01                           ]*
C[   21    .20000000D+01    .15000000D+01                           ]*
C[   22    .21257965D+01    .17295357D+01                           ]*
C[   23    .23862079D+01    .19044922D+01                           ]*
C[   24    .25000000D+01    .20000000D+01                           ]*
C[   25    .25892741D+01    .21031451D+01                           ]*
C[   26    .27320206D+01    .23327333D+01                           ]*
C[   27    .28425502D+01    .25954406D+01                           ]*
C[   28    .29398861D+01    .28805124D+01                           ]*
C[   29    .30000000D+01    .30000000D+01                           ]*
C[   30    .31092799D+01    .31032617D+01                           ]*
C[   31    .34350935D+01    .31602456D+01                           ]*
C[   32    .37764524D+01    .31126276D+01                           ]*
C[   33    .40000000D+01    .30000000D+01                           ]*
C                                                                    *
C  THE RESULTS ARE DISPLAYED ON SCREEN; they may be sent to a file.  *
C                                                                    *
C*********************************************************************
C
      INTEGER N,INTV,NTAB
      PARAMETER (N=9,INTV=25,NTAB=INTV+N)
C
      DOUBLE PRECISION X(1:N),Y(1:N),XRICHT(1:N),YRICHT(1:N),T(1:N),
     &                 XT(1:N),YT(1:N),RB1(1:2),RBN(1:2),
     &                 SUP(1:N),DXT(1:N),AINF(1:N),PRC(1:N),
     &                 AR1(1:N),AR2(1:N),AR3(1:N),H(1:N),
     &                 AX(1:N),BX(1:N),CX(1:N),DX(1:N),EX(1:N),FX(1:N),
     &                 AY(1:N),BY(1:N),CY(1:N),DY(1:N),EY(1:N),FY(1:N),
     &                 SX,SY,AUSG(1:5,1:2),
     &                 DELT,XTAB(1:NTAB),YTAB(1:NTAB)
      INTEGER IERR,MORS,I,J,LENTAB,MARG
C
C     initialize data; change if desired
C
      DATA X /1.0D0, 1.5D0, 2.0D0, 2.5D0,
     &        2.5D0, 2.0D0, 2.5D0, 3.0D0, 4.0D0/
      DATA Y /1.0D0, 2.0D0, 2.5D0, 2.0D0,
     &        1.0D0, 1.5D0, 2.0D0, 3.0D0, 3.0D0/
      DATA XRICHT / 0.3162D0, 0.7071D0, 1.0000D0,  0.7071D0,
     &             -0.8944D0, 0.0000D0, 0.7071D0,  0.5547D0,  0.7071D0/
      DATA YRICHT / 0.9487D0, 0.7071D0, 0.0000D0, -0.7071D0,
     &             -0.4472D0, 1.0000D0, 0.7071D0,  0.8321D0, -0.7071D0/
C
C     output of test example
C
      WRITE(*,900)
      WRITE(*,910) (I,X(I),Y(I),XRICHT(I),YRICHT(I),I=1,N)
C
C     compute coefficients for various Hermite splines 
C
C     1. Natural parametric Hermite spline
C
C     2. Parametric Hermite-Spline with given end point curvature
C
      DO 10 MARG=2,5,3
         IF(MARG .EQ. 2) THEN
            RB1(1)=0.0D0
            RB1(2)=0.0D0
            RBN(1)=0.0D0
            RBN(2)=0.0D0
            WRITE(*,920) RB1,RBN
         ELSE IF(MARG .EQ. 5) THEN
            RB1(1)=0.5D0
            RB1(2)=0.5D0
            RBN(1)=-0.5D0
            RBN(2)=-0.5D0
            WRITE(*,930) RB1,RBN
         END IF
C
         CALL PARMIT(N,MARG,X,Y,XRICHT,YRICHT,1,RB1,RBN,
     &               AX,BX,CX,DX,EX,FX,AY,BY,CY,DY,EY,FY,
     &               T,MORS,XT,YT,SUP,DXT,AINF,PRC,AR1,AR2,AR3,H)
         IF(MORS .EQ. 0) THEN
C
C     print coefficients
C
            WRITE(*,940)
            DO 20 I=1,N-1
               WRITE(*,960) I,T(I),AX(I),BX(I),CX(I)
   20       CONTINUE
            WRITE(*,970) N,T(N)
            WRITE(*,950)
            DO 30 I=1,N-1
               WRITE(*,980) I,DX(I),EX(I),FX(I)
   30       CONTINUE
            WRITE(*,990)
            DO 40 I=1,N-1
               WRITE(*,960) I,T(I),AY(I),BY(I),CY(I)
   40       CONTINUE
            WRITE(*,970) N,T(N)
            WRITE(*,1000)
            DO 50 I=1,N-1
               WRITE(*,980) I,DY(I),EY(I),FY(I)
   50       CONTINUE
C
C     compute and print function values and derivatives at the nodes
C
            WRITE(*,1010)
            DO 60 I=1,N
               CALL PMTVAL(N,T(I),T,AX,BX,CX,DX,EX,FX,
     &                     AY,BY,CY,DY,EY,FY,SX,SY,AUSG)
               WRITE(*,1020) T(I),SX,AUSG(1,1),AUSG(2,1)
               WRITE(*,1030) (AUSG(J,1),J=3,5)
               WRITE(*,1030) SY,AUSG(1,2),AUSG(1,2)
               WRITE(*,1030) (AUSG(J,2),J=3,5)
   60       CONTINUE
C
C     compute and print 
C     T0 = T(1) (DELT) T(N)
C
            DELT=(T(N)-T(1))/INTV
C
            CALL PMTAB(N,NTAB,T(1),T(N),DELT,T,AX,BX,CX,DX,EX,FX,
     &                 AY,BY,CY,DY,EY,FY,XTAB,YTAB,LENTAB,IERR)
            IF(IERR .EQ. 0) THEN
               WRITE(*,1040)
               DO 70 I=1,LENTAB
                  WRITE(*,1050) I,XTAB(I),YTAB(I)
   70          CONTINUE
            ELSE
               WRITE(*,1060) IERR
            END IF
         ELSE
            WRITE(*,1070) MORS
         END IF
   10 CONTINUE
      STOP
  900 FORMAT(1X,'C[  NODES:',T70,']*',/,
     &       1X,'C[',T70,']*',/,
     &       1X,'C[   I',6X,'X(I)',7X,'Y(I)',3X,'XRICHT(I)',2X,
     &          'YRICHT(I)',T70,']*',/,
     &       1X,'C[  ',46('-'),T70,']*')
  910 FORMAT(1X,'C[  ',I2,3X,F8.4,3X,F8.4,3X,F8.4,3X,F8.4,T70,']*')
  920 FORMAT(1X,'C[',T70,']*',/,
     &       1X,'C[',T70,']*',/,
     &       1X,'C[  END POINT CONDITION:  NATURAL PARAMETRIC ',
     &          'SPLINE',T70,']*',/,
     &       1X,'C[',20X,'RB1(X) = ',D10.3,5X,
     &          'RB1(Y) = ',D10.3,T70,']*',/,
     &       1X,'C[',20X,'RBN(X) = ',D10.3,5X,
     &          'RBN(X) = ',D10.3,T70,']*',/,
     &       1X,'C[',T70,']*')
  930 FORMAT(1X,'C[',T70,']*',/,
     &       1X,'C[',T70,']*',/,
     &       1X,'C[  END POINT CONDITION:  CURVATURE RADII',T70,']*',/,
     &       1X,'C[',20X,'RB1(X) = ',D10.3,5X,
     &          'RB1(Y) = ',D10.3,T70,']*',/,
     &       1X,'C[',20X,'RBN(X) = ',D10.3,5X,
     &          'RBN(X) = ',D10.3,T70,']*',/,
     &       1X,'C[',T70,']*')
  940 FORMAT(1X,'C[  COEFFICIENTS:',T70,']*',/,
     &       1X,'C[',T70,']*',/,
     &       1X,'C[   I',8X,'T(I)',10X,'AX(I)',10X,'BX(I)',10X,
     &          'CX(I)',T70,']*',/,
     &       1X,'C[  ',62('-'),T70,']*')
  950 FORMAT(1X,'C[',T70,']*',/,
     &       1X,'C[   I',22X,'DX(I)',10X,'EX(I)',10X,'FX(I)',T70,']*',/,
     &       1X,'C[  ',62('-'),T70,']*')
  960 FORMAT(1X,'C[  ',I2,4(3X,D12.6),T70,']*')
  970 FORMAT(1X,'C[  ',I2,3X,D12.6,T70,']*')
  980 FORMAT(1X,'C[  ',I2,15X,3(3X,D12.6),T70,']*')
  990 FORMAT(1X,'C[',T70,']*',/,
     &       1X,'C[   I',8X,'T(I)',10X,'AY(I)',10X,'BY(I)',10X,
     &          'CY(I)',T70,']*',/,
     &       1X,'C[  ',62('-'),T70,']*')
 1000 FORMAT(1X,'C[',T70,']*',/,
     &       1X,'C[   I',22x,'DY(I)',10X,'EY(I)',10X,'FY(I)',T70,']*',/,
     &       1X,'C[  ',62('-'),T70,']*')
 1010 FORMAT(1X,'C[',T70,']*',/,
     &       1X,'C[  FUNCTION VALUES AND DERIVATIVES AT THE ',
     &          'NODES:',T70,']*',/,
     &       1X,'C[',T70,']*',/,
     &       1X,'C[',6X,'T0',9X,'SX',13X,'SX(1)',10X,'SX(2)',T70,']*',/,
     &       1X,'C[',17X,'SX(3)',10X,'SX(4)',10X,'SX(5)',T70,']*',/,
     &       1X,'C[',17X,'SY',13X,'SY(1)',10X,'SY(2)',T70,']*',/,
     &       1X,'C[',17X,'SY(3)',10X,'SY(4)',10X,'SY(5)',T70,']*',/,
     &       1X,'C[  ',53('-'),T70,']*')
 1020 FORMAT(1X,'C[  ',F8.4,3(3X,D12.6),T70,']*')
 1030 FORMAT(1X,'C[',10X,3(3X,D12.6),T70,']*')
 1040 FORMAT(1X,'C[',T70,']*',/,
     &       1X,'C[  TABLE OF VALUES:',T70,']*',/,
     &       1X,'C[',T70,']*',/,
     &       1X,'C[',4X,'I',7X,'XTAB',13X,'YTAB',T70,']*',/,
     &       1X,'C[  ',37('-'),T70,']*')
 1050 FORMAT(1X,'C[  ',I3,2(3X,D14.8),T70,']*')
 1060 FORMAT(1X,'C[',T70,']*',/,
     &       1X,'C[  ERROR IN SUBROUTINE PMTAB, IERR = ',I4,T70,']*')
 1070 FORMAT(1X,'C[',T70,']*',/,
     &       1X,'C[  ERROR IN SUBROUTINE PARMIT, MORS = ',I4,T70,']*')
      END
