C[BA*)
C[LE*)
C[LE*)
C[LE*)
C[FE{F 12.3.1}{B\'ezier Spline Curves}{B\'ezier Spline Curves}*)
C[LE*)
      SUBROUTINE CUBBEZ (B,D,M)
C[IX{CUBBEZ}*)
C
C*****************************************************************
C                                                                *
C     This subroutine determines BEZIER points of a curve by     *
C     the cubic BEZIER-method.                                   *
C[BE*)
C                                                                *
C                                                                *
C     INPUT PARAMETERS:                                          *
C     =================                                          *
C     M                  number of curve segments                *
C     D(J,K)             coordinates of the weight points        *
C                        J=1, ..., 3, K=0, ..., M                *
C                                                                *
C                                                                *
C     OUTPUT PARAMETER S                                         *
C     ==================                                         *
C     B(J,K)             coordinates of the BEZIER points        *
C                        J=1, ..., 3, K=0, ..., 3*M              *
C                                                                *
C----------------------------------------------------------------*
C                                                                *
C  subroutines required: none                                    *
C                                                                *
C*****************************************************************
C                                                                *
C  author   : Michael Radermacher                                *
C  date     : 04.30.1985                                         *
C  source   : FORTRAN 77                                         *
C                                                                *
C[BA*)
C*****************************************************************
C[BE*)
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      DOUBLE PRECISION B(3,0:3*M) , D(3,0:M)
C
C*****************************************************************
C     loop over the X- , Y- and Z-coordinates                    *
C*****************************************************************
C
      DO 20   K=1,3
         DO 10   J=1,M-1
            B(K,3*J-2)=(2.0D0*D(K,J-1)+D(K,J))/3.0D0
            B(K,3*J)  =(D(K,J-1)+4.0D0*D(K,J)+D(K,J+1))/6.0D0
   10       B(K,3*J+2)=(D(K,J)+2.0D0*D(K,J+1))/3.0D0
         B(K,2)=(D(K,0)+2.0D0*D(K,1))/3.0D0
         B(K,3*M-2)=(D(K,M)+2.0D0*D(K,M-1))/3.0D0
C
C*****************************************************************
C        the boundary points B(K,0) and B(K,3*M), K=1,...,3, are *
C        preset so that a natural cubic BEZIER spline will result*
C*****************************************************************
C
         B(K,0)=D(K,0)
   20    B(K,3*M)=D(K,M)
      RETURN
      END
