      PROGRAM TEST
C
C     Test program for the  SUBROUTINE RENN2D        8.2.92
C                                                 (Volker Krger)
C
C*******************************************************************
C                                                                  *
C     Test results                                                 *
C                                                                  *
C                                                                  *
C[                                                                ]*
C[ TEST EXAMPLE:                                                  ]*
C[ =============                                                  ]*
C[                                                                ]*
C[ NODES WITHOUT ROUNDING OF CORNERS:                             ]*
C[                                                                ]*
C[  I      X(I)        Y(I)                                       ]*
C[ --------------------------                                     ]*
C[  0   -70.00000    70.00000                                     ]*
C[  1   -50.00000    70.00000                                     ]*
C[  2   -30.00000    70.00000                                     ]*
C[  3   -10.00000    80.00000                                     ]*
C[  4    20.00000    90.00000                                     ]*
C[  5    40.00000    90.00000                                     ]*
C[  6    60.00000    70.00000                                     ]*
C[  7    60.00000    50.00000                                     ]*
C[  8    60.00000    30.00000                                     ]*
C[  9    40.00000    30.00000                                     ]*
C[ 10    20.00000    30.00000                                     ]*
C[ 11      .00000    30.00000                                     ]*
C[ 12   -20.00000    20.00000                                     ]*
C[ 13   -20.00000   -10.00000                                     ]*
C[ 14      .00000   -30.00000                                     ]*
C[ 15    30.00000   -30.00000                                     ]*
C[ 16    60.00000   -30.00000                                     ]*
C[ 17    60.00000   -50.00000                                     ]*
C[ 18    60.00000   -70.00000                                     ]*
C[ 19    30.00000   -70.00000                                     ]*
C[ 20      .00000   -70.00000                                     ]*
C[ 21   -20.00000   -80.00000                                     ]*
C[ 22   -30.00000   -90.00000                                     ]*
C[ 23   -50.00000   -90.00000                                     ]*
C[ 24   -70.00000   -70.00000                                     ]*
C[ 25   -80.00000   -30.00000                                     ]*
C[ 26   -80.00000    20.00000                                     ]*
C[ 27   -70.00000    70.00000                                     ]*
C[                                                                ]*
C[ SPLINE COEFFICIENTS:                                           ]*
C[                                                                ]*
C[  I    TSUM(I)      XN(I)        B(I,1)      C(I,1)      D(I,1) ]*
C[ -------------------------------------------------------------- ]*
C[  0     .000000  -70.000000    1.000000     .000000     .000000 ]*
C[  1   20.000000  -50.000000    1.000000     .000000     .000000 ]*
C[  2   40.000000  -30.000000    1.000000    -.013747     .000357 ]*
C[  3   62.921874  -10.000000     .932683     .000647    -.000005 ]*
C[  4   94.553985   20.000000     .959366     .004102    -.000138 ]*
C[  5  114.842191   40.000000     .955423     .002089    -.000391 ]*
C[  6  145.232314   60.000000     .000000     .000000     .000000 ]*
C[  7  165.232314   60.000000     .000000     .000000     .000000 ]*
C[  8  185.232314   60.000000   -1.000000     .000000     .000000 ]*
C[  9  205.232314   40.000000   -1.000000     .000000     .000000 ]*
C[ 10  225.232314   20.000000   -1.000000     .000000     .000000 ]*
C[ 11  245.232314     .000000   -1.000000    -.000539     .000282 ]*
C[ 12  268.482596  -20.000000    -.568082     .022922    -.000154 ]*
C[ 13  299.899299  -20.000000     .416019     .005235     .000098 ]*
C[ 14  330.051972     .000000    1.000000     .000000     .000000 ]*
C[ 15  360.051972   30.000000    1.000000     .000000     .000000 ]*
C[ 16  390.051972   60.000000     .000000     .000000     .000000 ]*
C[ 17  410.051972   60.000000     .000000     .000000     .000000 ]*
C[ 18  430.051972   60.000000   -1.000000     .000000     .000000 ]*
C[ 19  460.051972   30.000000   -1.000000     .000000     .000000 ]*
C[ 20  490.051972     .000000   -1.000000     .009753    -.000189 ]*
C[ 21  512.890802  -20.000000    -.849855     .034735    -.001664 ]*
C[ 22  527.285784  -30.000000    -.884353    -.011531     .000383 ]*
C[ 23  548.156526  -50.000000    -.865468    -.000171     .000214 ]*
C[ 24  577.079929  -70.000000    -.338548     .000257     .000050 ]*
C[ 25  618.471786  -80.000000    -.058322     .001540    -.000007 ]*
C[ 26  668.492889  -80.000000     .039627    -.009654     .000196 ]*
C[     728.504696                                                 ]*
C[                                                                ]*
C[ SPLINE COEFFICIENTS:                                           ]*
C[                                                                ]*
C[  I    TSUM(I)      FN(I)        B(I,2)      C(I,2)      D(I,2) ]*
C[--------------------------------------------------------------  ]*
C[  0     .000000   70.000000     .000000     .000000     .000000 ]*
C[  1   20.000000   70.000000     .000000     .000000     .000000 ]*
C[  2   40.000000   70.000000     .000000     .041362    -.000974 ]*
C[  3   62.921874   80.000000     .360696    -.001744     .000011 ]*
C[  4   94.553985   90.000000     .282166    -.013263    -.000032 ]*
C[  5  114.842191   90.000000    -.295242    -.012630     .000023 ]*
C[  6  145.232314   70.000000   -1.000000     .000000     .000000 ]*
C[  7  165.232314   50.000000   -1.000000     .000000     .000000 ]*
C[  8  185.232314   30.000000     .000000     .000000     .000000 ]*
C[  9  205.232314   30.000000     .000000     .000000     .000000 ]*
C[ 10  225.232314   30.000000     .000000     .000000     .000000 ]*
C[ 11  245.232314   30.000000     .000000    -.020100     .000069 ]*
C[ 12  268.482596   20.000000    -.822972    -.009849     .000180 ]*
C[ 13  299.899299  -10.000000    -.909356    -.005676     .000459 ]*
C[ 14  330.051972  -30.000000     .000000     .000000     .000000 ]*
C[ 15  360.051972  -30.000000     .000000     .000000     .000000 ]*
C[ 16  390.051972  -30.000000   -1.000000     .000000     .000000 ]*
C[ 17  410.051972  -50.000000   -1.000000     .000000     .000000 ]*
C[ 18  430.051972  -70.000000     .000000     .000000     .000000 ]*
C[ 19  460.051972  -70.000000     .000000     .000000     .000000 ]*
C[ 20  490.051972  -70.000000     .000000    -.034438     .000668 ]*
C[ 21  512.890802  -80.000000    -.527017    -.039125     .001909 ]*
C[ 22  527.285784  -90.000000    -.466818     .020731     .000078 ]*
C[ 23  548.156526  -90.000000     .500964     .004549     .000070 ]*
C[ 24  577.079929  -70.000000     .940949     .000457     .000004 ]*
C[ 25  618.471786  -30.000000     .998298     .000058    -.000001 ]*
C[ 26  668.492889   20.000000     .999215     .008350    -.000185 ]*
C[     728.504696                                                 ]*
C[                                                                ]*
C[ SPLINE IS A CLOSED CURVE                                       ]*
C[                                                                ]*
C[                                                                ]*
C[ NODES AFTER ROUNDING OF CORNERS:                               ]*
C[                                                                ]*
C[                                                                ]*
C[  I      X(I)        Y(I)                                       ]*
C[ --------------------------                                     ]*
C[  0   -70.00000    70.00000                                     ]*
C[  1   -50.00000    70.00000                                     ]*
C[  2   -30.00000    70.00000                                     ]*
C[  3   -10.00000    80.00000                                     ]*
C[  4    20.00000    90.00000                                     ]*
C[  5    40.00000    90.00000                                     ]*
C[  6    60.00000    70.00000                                     ]*
C[  7    60.00000    50.00000                                     ]*
C[  8    60.00000    40.00000                                     ]*
C[  9    50.00000    30.00000                                     ]*
C[ 10    40.00000    30.00000                                     ]*
C[ 11    20.00000    30.00000                                     ]*
C[ 12      .00000    30.00000                                     ]*
C[ 13   -20.00000    20.00000                                     ]*
C[ 14   -20.00000   -10.00000                                     ]*
C[ 15      .00000   -30.00000                                     ]*
C[ 16    30.00000   -30.00000                                     ]*
C[ 17    50.00000   -30.00000                                     ]*
C[ 18    60.00000   -40.00000                                     ]*
C[ 19    60.00000   -50.00000                                     ]*
C[ 20    60.00000   -60.00000                                     ]*
C[ 21    50.00000   -70.00000                                     ]*
C[ 22    30.00000   -70.00000                                     ]*
C[ 23      .00000   -70.00000                                     ]*
C[ 24   -20.00000   -80.00000                                     ]*
C[ 25   -30.00000   -90.00000                                     ]*
C[ 26   -50.00000   -90.00000                                     ]*
C[ 27   -70.00000   -70.00000                                     ]*
C[ 28   -80.00000   -30.00000                                     ]*
C[ 29   -80.00000    20.00000                                     ]*
C[ 30   -70.00000    70.00000                                     ]*
C[                                                                ]*
C[ SPLINE COEFFICIENTS:                                           ]*
C[                                                                ]*
C[  I    TSUM(I)      XN(I)        B(I,1)      C(I,1)      D(I,1) ]*
C[ -------------------------------------------------------------- ]*
C[  0     .000000  -70.000000    1.000000     .000000     .000000 ]*
C[  1   20.000000  -50.000000    1.000000     .000000     .000000 ]*
C[  2   40.000000  -30.000000    1.000000    -.013747     .000357 ]*
C[  3   62.921874  -10.000000     .932683     .000647    -.000005 ]*
C[  4   94.553985   20.000000     .959366     .004102    -.000138 ]*
C[  5  114.842191   40.000000     .955423     .002089    -.000391 ]*
C[  6  145.232314   60.000000     .000000     .000000     .000000 ]*
C[  7  165.232314   60.000000     .000000     .000000     .000000 ]*
C[  8  175.232314   60.000000     .000000    -.058333     .001124 ]*
C[  9  190.904547   50.000000   -1.000000     .000000     .000000 ]*
C[ 10  200.904547   40.000000   -1.000000     .000000     .000000 ]*
C[ 11  220.904547   20.000000   -1.000000     .000000     .000000 ]*
C[ 12  240.904547     .000000   -1.000000    -.000539     .000282 ]*
C[ 13  264.154828  -20.000000    -.568082     .022922    -.000154 ]*
C[ 14  295.571532  -20.000000     .416019     .005235     .000098 ]*
C[ 15  325.724204     .000000    1.000000     .000000     .000000 ]*
C[ 16  355.724204   30.000000    1.000000     .000000     .000000 ]*
C[ 17  375.724204   50.000000    1.000000    -.005474    -.001124 ]*
C[ 18  391.396437   60.000000     .000000     .000000     .000000 ]*
C[ 19  401.396437   60.000000     .000000     .000000     .000000 ]*
C[ 20  411.396437   60.000000     .000000    -.058333     .001124 ]*
C[ 21  427.068669   50.000000   -1.000000     .000000     .000000 ]*
C[ 22  447.068669   30.000000   -1.000000     .000000     .000000 ]*
C[ 23  477.068669     .000000   -1.000000     .009753    -.000189 ]*
C[ 24  499.907500  -20.000000    -.849855     .034735    -.001664 ]*
C[ 25  514.302482  -30.000000    -.884353    -.011531     .000383 ]*
C[ 26  535.173224  -50.000000    -.865468    -.000171     .000214 ]*
C[ 27  564.096626  -70.000000    -.338548     .000257     .000050 ]*
C[ 28  605.488483  -80.000000    -.058322     .001540    -.000007 ]*
C[ 29  655.509587  -80.000000     .039627    -.009654     .000196 ]*
C[     715.521394                                                 ]*
C[                                                                ]*
C[ SPLINE COEFFICIENTS:                                           ]*
C[                                                                ]*
C[  I    TSUM(I)      FN(I)        B(I,2)      C(I,2)      D(I,2) ]*
C[--------------------------------------------------------------  ]*
C[  0     .000000   70.000000     .000000     .000000     .000000 ]*
C[  1   20.000000   70.000000     .000000     .000000     .000000 ]*
C[  2   40.000000   70.000000     .000000     .041362    -.000974 ]*
C[  3   62.921874   80.000000     .360696    -.001744     .000011 ]*
C[  4   94.553985   90.000000     .282166    -.013263    -.000032 ]*
C[  5  114.842191   90.000000    -.295242    -.012630     .000023 ]*
C[  6  145.232314   70.000000   -1.000000     .000000     .000000 ]*
C[  7  165.232314   50.000000   -1.000000     .000000     .000000 ]*
C[  8  175.232314   40.000000   -1.000000     .005474     .001124 ]*
C[  9  190.904547   30.000000     .000000     .000000     .000000 ]*
C[ 10  200.904547   30.000000     .000000     .000000     .000000 ]*
C[ 11  220.904547   30.000000     .000000     .000000     .000000 ]*
C[ 12  240.904547   30.000000     .000000    -.020100     .000069 ]*
C[ 13  264.154828   20.000000    -.822972    -.009849     .000180 ]*
C[ 14  295.571532  -10.000000    -.909356    -.005676     .000459 ]*
C[ 15  325.724204  -30.000000     .000000     .000000     .000000 ]*
C[ 16  355.724204  -30.000000     .000000     .000000     .000000 ]*
C[ 17  375.724204  -30.000000     .000000    -.058333     .001124 ]*
C[ 18  391.396437  -40.000000   -1.000000     .000000     .000000 ]*
C[ 19  401.396437  -50.000000   -1.000000     .000000     .000000 ]*
C[ 20  411.396437  -60.000000   -1.000000     .005474     .001124 ]*
C[ 21  427.068669  -70.000000     .000000     .000000     .000000 ]*
C[ 22  447.068669  -70.000000     .000000     .000000     .000000 ]*
C[ 23  477.068669  -70.000000     .000000    -.034438     .000668 ]*
C[ 24  499.907500  -80.000000    -.527017    -.039125     .001909 ]*
C[ 25  514.302482  -90.000000    -.466818     .020731     .000078 ]*
C[ 26  535.173224  -90.000000     .500964     .004549     .000070 ]*
C[ 27  564.096626  -70.000000     .940949     .000457     .000004 ]*
C[ 28  605.488483  -30.000000     .998298     .000058    -.000001 ]*
C[ 29  655.509587   20.000000     .999215     .008350    -.000185 ]*
C[     715.521394                                                 ]*
C[                                                                ]*
C[ SPLINE IS A CLOSED CURVE                                       ]*
C                                                                  *
C                                                                  *
C*******************************************************************
C 
      PARAMETER (N=27, NK=41)
      DOUBLE PRECISION XN(0:NK), FN(0:NK), B(0:NK-1, 1:2),
     +  C(0:NK-1,1:2), D(0:NK-1,1:2), T(0:NK-1),
     +  HELP(-2:NK+1, 1:10), TSUM(0:NK), BETA
C
C     SET UP DATA; EXCHANGE IF DESIRED
C
      DATA (XN(I), I=0,N) / -70.0D+00,-50.0D+00,-30.0D+00,
     F                      -10.0D+00,20.0D+00,40.0D+00,60.0D+00,
     F                      60.0D+00,60.0D+00,40.0D+00,20.0D+00,
     F                      0.0D+00,-20.0D+00,-20.0D+00,0.0D+00,
     F                      30.0D+00,60.0D+00,60.0D+00,60.0D+00,
     F                      30.0D+00,0.0D+00,-20.0D+00,-30.0D+00,
     F                      -50.0D+00,-70.0D+00,-80.0D+00,
     F                      -80.0D+00,-70.0D+00/
      DATA (FN(I), I=0,N) / 70.0D+00,70.0D+00,70.0D+00,80.0D+00,
     F                      90.0D+00,90.0D+00,70.0D+00,50.0D+00,
     F                      30.0D+00,30.0D+00,30.0D+00,30.0D+00,
     F                      20.0D+00,-10.0D+00,-30.0D+00,
     F                      -30.0D+00,-30.0D+00,-50.0D+00,
     F                      -70.0D+00,-70.0D+00,-70.0D+00,
     F                      -80.0D+00,-90.0D+00,-90.0D+00,
     F                      -70.0D+00,-30.0D+00,20.0D+00,70.0D+00/
      NI = N
C
C     output of nodes
C
      WRITE(*,2000)
      WRITE(*,2005)
      DO 10, I = 0,NI
         WRITE(*,2010) I,XN(I),FN(I)
   10 CONTINUE
C
C     computations without rounding
C
      BETA = -0.5D+00
      CALL RENN2D(NI,XN,FN,NK,BETA,B,C,D,T,HELP,IMARK,IERR)
C
      IF (IERR .EQ. 0) THEN
         TSUM(0) = 0.0D+00
         DO 15 I = 1,NI
   15       TSUM(I) = TSUM(I-1) + T(I-1)
         WRITE(*,2020)
         DO 20,I = 0, NI-1
   20       WRITE(*,2030)I,TSUM(I),XN(I),B(I,1),C(I,1),D(I,1)
         WRITE(*,2031)TSUM(NI)
         WRITE(*,2025)
         DO 25,I = 0, NI-1
   25       WRITE(*,2030)I,TSUM(I),FN(I),B(I,2),C(I,2),D(I,2)
         WRITE(*,2031)TSUM(NI)
         IF (IMARK .EQ. 0) THEN
            WRITE(*,2035)
         ELSE
            WRITE(*,2036)
         ENDIF
C
C use for output as a table of values:
C  
C         DO 28 TT=0.D0,TSUM(NI)+1.D0,2.D0
C            CALL PSPVAL(TT,NI,TSUM,XN,B(0,1),C(0,1),D(0,1),
C     +                             FN,B(0,2),C(0,2),D(0,2),X,Y)
C            WRITE(*,*)X,Y
C   28    CONTINUE
C
      ELSE
         WRITE(*,2040)
         IF (IERR .EQ. -1) THEN
            WRITE(*,2050)
         ELSEIF (IERR .EQ. -2) THEN
            WRITE(*,2060)
         ELSEIF (IERR .EQ. -3) THEN
            WRITE(*,2070)
         ENDIF
      ENDIF
C
C     computations with rounding of corners
C
      BETA = 0.5D+00
      CALL RENN2D(NI,XN,FN,NK,BETA,B,C,D,T,HELP,IMARK,IERR)
C
C     nodes after rounding
C
      WRITE (*,2090)
      WRITE (*,2005)
      DO 30, I = 0,NI
         WRITE(*,2010) I,XN(I),FN(I)
   30 CONTINUE
C
C     output with rounding
C
      IF (IERR .EQ. 0) THEN
         TSUM(0) = 0.0D+00
         DO 35 I = 1,NI
   35       TSUM(I) = TSUM(I-1) + T(I-1)
         WRITE(*,2020)
         DO 40,I = 0, NI-1
   40       WRITE(*,2030)I,TSUM(I),XN(I),B(I,1),C(I,1),D(I,1)
         WRITE(*,2031)TSUM(NI)
         WRITE(*,2025)
         DO 45,I = 0, NI-1
   45       WRITE(*,2030)I,TSUM(I),FN(I),B(I,2),C(I,2),D(I,2)
         WRITE(*,2031)TSUM(NI)
         IF (IMARK .EQ. 0) THEN
            WRITE(*,2035)
         ELSE
            WRITE(*,2036)
         ENDIF
C
C for use with a desired table of values
C  
C         DO 47 TT=0.D0,TSUM(NI)+1.D0,2.D0
C            CALL PSPVAL(TT,NI,TSUM,XN,B(0,1),C(0,1),D(0,1),
C     +                             FN,B(0,2),C(0,2),D(0,2),X,Y)
C            WRITE(*,*)X,Y
C   47    CONTINUE
C
      ELSE
         WRITE(*,2040)
         IF (IERR .EQ. -1) THEN
            WRITE(*,2050)
         ELSEIF (IERR .EQ. -2) THEN
            WRITE(*,2060)
         ELSEIF (IERR .EQ. -3) THEN
            WRITE(*,2070)
         ENDIF
      ENDIF
 2000 FORMAT (1X, 'C[', T68, ']*', /,
     +        1X, 'C[ TEST EXAMPLE:', T68, ']*', /,
     +        1X, 'C[ ', 13('='), T68, ']*', /,
     +        1X, 'C[', T68, ']*', /,
     +        1X, 'C[ NODES WITHOUT ROUNDING OF CORNERS:', T68, ']*')
 2005 FORMAT (1X, 'C[', T68, ']*', /,
     +        1X, 'C[  I', 5X, ' X(I)', 7X, ' Y(I)', T68, ']*', /,
     +        1X, 'C[ ', 26('-'), T68, ']*')
 2010 FORMAT (1X, 'C[ ', I2, 3X, F9.5, 3X, F9.5, T68, ']*')
 2020 FORMAT (1X, 'C[', T68, ']*', /,
     +        1X, 'C[ SPLINE COEFFICIENTS:', T68, ']*', /,
     +        1X, 'C[', T68, ']*', /,
     +        1X, 'C[  I', 4X, 'TSUM(I)', 6X, 'XN(I)', 8X, 'B(I,1)',
     +            5X, ' C(I,1)', 5X, ' D(I,1)', T68, ']*', /,
     +        1X, 'C[ ', 62('-'), T68, ']*')
 2025 FORMAT (1X, 'C[', T68, ']*', /,
     +        1X, 'C[ SPLINE COEFFICIENTS:', T68, ']*', /,
     +        1X, 'C[', T68, ']*', /,
     +        1X, 'C[  I', 4X, 'TSUM(I)', 6X, 'FN(I)', 8X, 'B(I,2)',
     +            5X, ' C(I,2)', 5X, ' D(I,2)', T68, ']*', /,
     +        1X, 'C[', 62('-'), T68, ']*')
 2030 FORMAT (1X, 'C[ ', I2, 1X, F11.6, 1X, F11.6, 1X, F11.6, 1X,
     +            F11.6, 1X, F11.6, T68, ']*')
 2031 FORMAT (1X, 'C[', 4X, F11.6, T68, ']*')
 2035 FORMAT (1X, 'C[', T68, ']*', /,
     +        1X, 'C[ SPLINE IS NOT CLOSED', T68,']*')
 2036 FORMAT (1X, 'C[', T68, ']*', /,
     +        1X, 'C[ SPLINE IS A CLOSED CURVE', T68, ']*')
 2040 FORMAT (1X, 'C[', T68, ']*', /,
     +        1X, 'C[ ERROR IN RENNER!', T68, ']*')
 2050 FORMAT (1X, 'C[ LESS THAN  4 STUETZSTELLEN!', T68, ']*')
 2060 FORMAT (1X, 'C[ TWO ADJACENT NODES ARE IDENTICAL!',
     +            T68, ']*')
 2070 FORMAT (1X, 'C[ NK TOO SMALL!', T68, ']*')
 2090 FORMAT (1X, 'C[', T68, ']*', /,
     +        1X, 'C[', T68, ']*', /,
     +        1X, 'C[ NODES AFTER ROUNDING OF CORNERS:', T68, ']*', /,
     +        1X, 'C[', T68, ']*')
      STOP
      END
