C[BA*)
C[LE*)
      SUBROUTINE PSPANA (TV,N,T,AX,BX,CX,DX,AY,BY,CY,DY,
C[IX{PSPANA}*)
     +                   SX,SY,XDVT,YDVT,C1,C2,IERR)
C
C*****************************************************************
C                                                                *
C  A program to evaluate parametric cubic splines                *
C[BE*)
C  with component                                                *
C  functions SX(T), SY(T) given in the following form:           *
C                                                                *
C  SX := SX(T) = AX(I) + BX(I)(T-T(I)) + CX(I)(T-T(I))**2 +      *
C                                      + DX(I)(T-T(I))**3        *
C                                                                *
C  SY := SY(T) = AY(I) + BY(I)(T-T(I)) + CY(I)(T-T(I))**2 +      *
C                                      + DY(I)(T-T(I))**3        *
C                                                                *
C  for T in the interval [T(I),T(I+1)], I=0,1,...,N-1.           *
C                                                                *
C  This program determines the function value and that of the    *
C  1st, 2nd and 3rd derivative of the component functions SX(T)  *
C  and SY(T) at T=TV, as well as the 1st and 2nd derivative of   *
C  the curve K that is described in the plane by of the component*
C  functions SX and SY.                                          *
C                                                                *
C                                                                *
C  NOTE:  This evaluation routine is not well suited for making  *
C  =====  a table of values of SX(T) and SY(T).                  *
C                                                                *
C                                                                *
C  INPUT PARAMETERS:                                             *
C  =================                                             *
C  TV :  Location where the spline functions SX(T) and SY(T) are *
C        to be evaluated.                                        *
C  N  :  Index of the final node T(N)                            *
C  T  :  vector T(0:N) ; the nodes T(I), I=0,1,...,N.            *
C  AX :  ] N+1-vectors ..(0:N);                                  *
C  BX :  ] the components in positions 0 to N-1 contain the      *
C  CX :  ] spline coefficients for the component function SX(T)  *
C  DX :  ]                                                       *
C  AY :  ] N+1-vectors ..(0:N);                                  *
C  BY :  ] the components in positions 0 to N-1 contain the      *
C  CY :  ] spline coefficients for the component function SY(T)  *
C  DY :  ]                                                       *
C                                                                *
C                                                                *
C  OUTPUT PARAMETERS:                                            *
C  ==================                                            *
C  SX :  Function value of SX(T) at T=TV                         *
C  SY :  Function value of SY(T) at T=TV                         *
C  XDVT : ]  vectors ..(1:3);                                    *
C  YDVT : ]  the element in positin I contains the Ith derivative*
C            of the function SX(T) or SY(T), respectively, at    *
C            T=TV for I = 1, 2, 3.                               *
C  C1 :  1st derivative of the curve K at T=TV.                  *
C        It is obtained from the following equation:             *
C        C1 = YDVT(1)/XDVT(1)                                    *
C  C2 :  2nd derivative of the curve K at T=TV.                  *
C        It is obtained from the following equation:             *
C        C2 = (XDVT(1)*YDVT(2) - XDVT(2)*YDVT(1))/(XDVT(1)**3)   *
C                                                                *
C  IERR :  Error parameter                                       *
C          = 0 : Everything o.k.                                 *
C          = 1 : XDVT(1) = 0; values for C1 and C2 were not      *
C                determined                                      *
C          = 2 : The magnitude of the 1st derivative of SX(TV),  *
C                ABS(XDVT(1)), is positive but less than four    *
C                times the machine constant. The values of C1 and*
C                C2 can therefore not be determined accurately.  *
C                                                                *
C----------------------------------------------------------------*
C                                                                *
C  subroutines required: SPLFVD, MACHPD                          *
C                                                                *
C*****************************************************************
C                                                                *
C  author   : Guenter Palm                                       *
C  date     : 04.15.1988                                         *
C  source   : FORTRAN 77                                         *
C                                                                *
C[BA*)
C*****************************************************************
C[BE*)
C
C-----declarations------------------------------------------------
C
      IMPLICIT DOUBLE PRECISION (A-H, O-Z)
      DOUBLE PRECISION T(0:N), AX(0:N), BX(0:N), CX(0:N), DX(0:N),
     +                 AY(0:N), BY(0:N), CY(0:N), DY(0:N),
     +                 XDVT(3), YDVT(3)
      LOGICAL FLAG
      SAVE FMACHP,FLAG
C
C-----initializing------------------------------------------------
C
      DATA FLAG /.TRUE./
      IERR = 0
C
C-----determine the machine constant (only on 1st call)-----------
C
      IF (FLAG) THEN
        FMACHP = 1.0D0
   10   FMACHP = 0.5D0*FMACHP
        IF (MACHPD(1.0D0+FMACHP) .EQ. 1) GOTO 10
        FMACHP = 8.0D0*FMACHP
        FLAG = .FALSE.
      ENDIF
C
C-----determine the functional values and the derivatives----
C     of the component functions SX(T) and SY(T)
C
      CALL SPLFVD (TV,N,T,AX,BX,CX,DX,SX,XDVT(1),XDVT(2),XDVT(3))
      CALL SPLFVD (TV,N,T,AY,BY,CY,DY,SY,YDVT(1),YDVT(2),YDVT(3))
C
C-----determine the 1st and 2nd derivatives of the curve K--------
C
      IF (XDVT(1) .EQ. 0.0D0) THEN
        IERR = 1
      ELSE
        IF (DABS(XDVT(1)) .LE. FMACHP) IERR = 2
        C1 = YDVT(1)/XDVT(1)
        C2 = (XDVT(1)*YDVT(2) - XDVT(2)*YDVT(1))/(XDVT(1)**3)
      ENDIF
      RETURN
      END
