C[BA*)
C[LE*)
      SUBROUTINE RKF54 (M,COEFF,QG)
C[IX{RKF54}*)
C
C*****************************************************************
C                                                                *
C This subroutine determines the coefficients for the embedding  *
C formula RKF5(4) (method of Fehlberg).                          *
C[BE*)
C                                                                *
C                                                                *
C INPUT PARAMETERS:                                              *
C =================                                              *
C M       : Dimension of the matrix COEFF depending on the chosen*
C           embedding formula                                    *
C                                                                *
C                                                                *
C OUTPUT PARAMETERS:                                             *
C ==================                                             *
C COEFF   : 2-dimensional DOUBLE PRECISION array COEFF(1:16,1:M) *
C           with the coefficients for the embedding formula      *
C QG      : DOUBLE PRECISION value for the global error order    *
C                                                                *
C                                                                *
C----------------------------------------------------------------*
C                                                                *
C  required subroutines: none                                    *
C                                                                *
C*****************************************************************
C                                                                *
C  Author   : Volker Krger                                      *
C  Date     : 26.04.1993                                         *
C  Source   : FORTRAN 77                                         *
C  Sources  : E. Fehlberg :                                      *
C             Klassische Runge-Kutta-Formeln vierter und         *
C             niedrigerer Ordnung mit Schrittweiten-Kontrolle    *
C             und ihrer Anwendung auf Wrmeleitungsprobleme      *
C             page 61-71                                         *
C             Computing 6 1970                                   *
C                                                                *
C[BA*)
C*****************************************************************
C[BE*)
C
C Declarations
C
      DOUBLE PRECISION COEFF(16,M),QG
C
C Initialize QG
C
      QG=4.0D0
C
C Determine the matrix elements in COEFF
C
C         a - values (see scheme)
C
      COEFF(2,1)=1.0D0/4.0D0
      COEFF(3,1)=3.0D0/8.0D0
      COEFF(4,1)=12.0D0/13.0D0
      COEFF(5,1)=1.0D0
      COEFF(6,1)=1.0D0/2.0D0
C
C         b - values (see scheme)
C
      COEFF(2,2)=1.0D0/4.0D0
      COEFF(3,2)=3.0D0/32.0D0
      COEFF(4,2)=1932.0D0/2197.0D0
      COEFF(5,2)=439.0D0/216.0D0
      COEFF(6,2)=-8.0D0/27.0D0
      COEFF(3,3)=9.0D0/32.0D0
      COEFF(4,3)=-7200.0D0/2197.0D0
      COEFF(5,3)=-8.0D0
      COEFF(6,3)=2.0D0
      COEFF(4,4)=7296.0D0/2197.0D0
      COEFF(5,4)=3680.0D0/513.0D0
      COEFF(6,4)=-3544.0D0/2565.0D0
      COEFF(5,5)=-845.0D0/4104.0D0
      COEFF(6,5)=1859.0D0/4104.0D0
      COEFF(6,6)=-11.0D0/40.0D0
C
C         A tilde values (see scheme)
C
      COEFF(2,3)=16.0D0/135.0D0
      COEFF(2,5)=6656.0D0/12825.0D0
      COEFF(2,6)=28561.0D0/56430.0D0
      COEFF(3,4)=-9.0D0/50.0D0
      COEFF(3,5)=2.0D0/55.0D0
C
C          A - values (see scheme)
C
      COEFF(1,1)=25.0D0/216.0D0
      COEFF(1,3)=1408.0D0/2565.0D0
      COEFF(1,4)=2197.0D0/4104.0D0
      COEFF(1,5)=-1.0D0/5.0D0
      RETURN
      END
