      PROGRAM TEST 
!                                                                       
!     Test program for the SUBROUTINE AKIMA1        7.4.93              
!                                                  (Andreas Sohn)       
!                                                                       
!*****************************************************************      
!                                                                *      
!     Test results;                                              *      
!                                                                *      
![                                                              ]*      
![ TEST EXAMPLE:                                                ]*      
![ =============                                                ]*      
![                                                              ]*      
![ NODES WITHOUT ROUNDING OF CORNERS:                           ]*      
![                                                              ]*      
![  I      X(I)        Y(I)                                     ]*      
![ --------------------------                                   ]*      
![  0   -70.00000    30.00000                                   ]*      
![  1   -60.00000    40.00000                                   ]*      
![  2   -50.00000    60.00000                                   ]*      
![  3   -40.00000    70.00000                                   ]*      
![  4   -30.00000    70.00000                                   ]*      
![  5   -20.00000    70.00000                                   ]*      
![  6   -10.00000    70.00000                                   ]*      
![  7      .00000    50.00000                                   ]*      
![  8    10.00000    30.00000                                   ]*      
![  9    20.00000    10.00000                                   ]*      
![ 10    30.00000    30.00000                                   ]*      
![ 11    40.00000    50.00000                                   ]*      
![ 12    50.00000    70.00000                                   ]*      
![ 13    60.00000    70.00000                                   ]*      
![ 14    70.00000    60.00000                                   ]*      
![ 15    80.00000    35.00000                                   ]*      
![ 16    90.00000    10.00000                                   ]*      
![ 17   110.00000    30.00000                                   ]*      
![                                                              ]*      
![ AKIMA SPLINE COEFFICIENTS:                                   ]*      
![                                                              ]*      
![  I        FN(I)         B(I)          C(I)          D(I)     ]*      
![ ----------------------------------------------------------   ]*      
![  0     30.000000      1.000000       .000000       .000000   ]*      
![  1     40.000000      1.000000       .250000      -.015000   ]*      
![  2     60.000000      1.500000       .000000      -.005000   ]*      
![  3     70.000000       .000000       .000000       .000000   ]*      
![  4     70.000000       .000000       .000000       .000000   ]*      
![  5     70.000000       .000000       .000000       .000000   ]*      
![  6     70.000000     -2.000000       .000000       .000000   ]*      
![  7     50.000000     -2.000000       .000000       .000000   ]*      
![  8     30.000000     -2.000000       .000000       .000000   ]*      
![  9     10.000000      2.000000       .000000       .000000   ]*      
![ 10     30.000000      2.000000       .000000       .000000   ]*      
![ 11     50.000000      2.000000       .000000       .000000   ]*      
![ 12     70.000000      2.000000      -.342857       .014286   ]*      
![ 13     70.000000      -.571429       .064286      -.010714   ]*      
![ 14     60.000000     -2.500000       .000000       .000000   ]*      
![ 15     35.000000     -2.500000       .000000       .000000   ]*      
![ 16     10.000000      1.000000       .000000       .000000   ]*      
![                                                              ]*      
![                                                              ]*      
![ NODES AFTER ROUNDING OF CORNERS:                             ]*      
![                                                              ]*      
![  I      X(I)        Y(I)                                     ]*      
![ --------------------------                                   ]*      
![  0   -70.00000    30.00000                                   ]*      
![  1   -60.00000    40.00000                                   ]*      
![  2   -50.00000    60.00000                                   ]*      
![  3   -40.00000    70.00000                                   ]*      
![  4   -30.00000    70.00000                                   ]*      
![  5   -20.00000    70.00000                                   ]*      
![  6   -15.00000    70.00000                                   ]*      
![  7    -5.00000    60.00000                                   ]*      
![  8      .00000    50.00000                                   ]*      
![  9    10.00000    30.00000                                   ]*      
![ 10    15.00000    20.00000                                   ]*      
![ 11    25.00000    20.00000                                   ]*      
![ 12    30.00000    30.00000                                   ]*      
![ 13    40.00000    50.00000                                   ]*      
![ 14    50.00000    70.00000                                   ]*      
![ 15    60.00000    70.00000                                   ]*      
![ 16    70.00000    60.00000                                   ]*      
![ 17    80.00000    35.00000                                   ]*      
![ 18    85.00000    22.50000                                   ]*      
![ 19    95.00000    15.00000                                   ]*      
![ 20   110.00000    30.00000                                   ]*      
![                                                              ]*      
![ AKIMA SPLINE COEFFICIENTS:                                   ]*      
![                                                              ]*      
![  I        FN(I)         B(I)          C(I)          D(I)     ]*      
![ ----------------------------------------------------------   ]*      
![  0     30.000000      1.000000       .000000       .000000   ]*      
![  1     40.000000      1.000000       .250000      -.015000   ]*      
![  2     60.000000      1.500000       .000000      -.005000   ]*      
![  3     70.000000       .000000       .000000       .000000   ]*      
![  4     70.000000       .000000       .000000       .000000   ]*      
![  5     70.000000       .000000       .000000       .000000   ]*      
![  6     70.000000       .000000      -.100000       .000000   ]*      
![  7     60.000000     -2.000000       .000000       .000000   ]*      
![  8     50.000000     -2.000000       .000000       .000000   ]*      
![  9     30.000000     -2.000000       .000000       .000000   ]*      
![ 10     20.000000     -2.000000       .200000       .000000   ]*      
![ 11     20.000000      2.000000       .000000       .000000   ]*      
![ 12     30.000000      2.000000       .000000       .000000   ]*      
![ 13     50.000000      2.000000       .000000       .000000   ]*      
![ 14     70.000000      2.000000      -.342857       .014286   ]*      
![ 15     70.000000      -.571429       .064286      -.010714   ]*      
![ 16     60.000000     -2.500000       .000000       .000000   ]*      
![ 17     35.000000     -2.500000       .000000       .000000   ]*      
![ 18     22.500000     -2.500000       .175000       .000000   ]*      
![ 19     15.000000      1.000000       .000000       .000000   ]*      
!                                                                *      
!*****************************************************************      
!                                                                       
      PARAMETER (N = 17, NK = 26) 
      DOUBLEPRECISION XN (0:NK), FN (0:NK), B (0:NK - 1), C (0:NK - 1), &
      D (0:NK - 1), HELP ( - 2:NK + 1, 1:4), BETA                       
!                                                                       
! the declaration below must be 'uncommented', in case that output      
! in form of a table of values is desired                               
! see below!                                                            
!                                                                       
!     DOUBLE PRECISION X, XA, XE, XSCH, SPVAL                           
!                                                                       
      INTEGER NI, IERR, ISWTCH 
!                                                                       
!     initialize data, change if desired                                
!                                                                       
      DATA (XN (I), FN (I), I = 0, N) / - 70.0D0, 30.0D0, - 60.0D0,     &
      40.0D0, - 50.0D0, 60.0D0, - 40.0D0, 70.0D0, - 30.0D0, 70.0D0,     &
      - 20.0D0, 70.0D0, - 10.0D0, 70.0D0, 0.0D0, 50.0D0, 10.0D0, 30.0D0,&
      20.0D0, 10.0D0, 30.0D0, 30.0D0, 40.0D0, 50.0D0, 50.0D0, 70.0D0,   &
      60.0D0, 70.0D0, 70.0D0, 60.0D0, 80.0D0, 35.0D0, 90.0D0, 10.0D0,   &
      110.0D0, 30.0D0 /                                                 
!                                                                       
      NI = 17 
      ISWTCH = 1 
!                                                                       
!     output of nodes                                                   
!                                                                       
      WRITE ( *, 2000) 
      WRITE ( *, 2005) 
      DO 10, I = 0, NI 
         WRITE ( *, 2010) I, XN (I), FN (I) 
   10 END DO 
!                                                                       
!     Compute Akima coefficients with rounding                          
!                                                                       
      BETA = - 0.5D+00 
      CALL AKIMA1 (NI, XN, FN, NK, BETA, B, C, D, ISWTCH, HELP, IERR) 
!                                                                       
!     output                                                            
!                                                                       
      IF (IERR.EQ.0) THEN 
         WRITE ( *, 2020) 
         DO 20, I = 0, NI - 1 
   20    WRITE ( *, 2030) I, FN (I), B (I), C (I), D (I) 
!                                                                       
! when table of values is desired, 'uncomment' these instructions       
! see above!                                                            
!                                                                       
!        OPEN(1, FILE='ORUNDUNG')                                       
!        REWIND(1)                                                      
!        XSCH = (XN(NI)-XN(0))/150.0D0                                  
!        XA = XN(0)  - 0.5D0*XSCH                                       
!        XE = XN(NI) + XSCH                                             
!        DO 111 X=XA, XE+0.5D0*XSCH, XSCH                               
!           WRITE(1,'(1X,2(F10.5,2X))') X, SPVAL(X,NI,XN,FN,B,C,D)      
! 111       CONTINUE                                                    
!        CLOSE(1)                                                       
!                                                                       
      ELSE 
         WRITE ( *, 2040) 
         IF (IERR.EQ. - 1) THEN 
            WRITE ( *, 2050) 
         ELSEIF (IERR.EQ. - 2) THEN 
            WRITE ( *, 2060) 
         ELSEIF (IERR.EQ. - 3) THEN 
            WRITE ( *, 2070) 
         ELSEIF (IERR.EQ. - 4) THEN 
            WRITE ( *, 2080) 
         ENDIF 
      ENDIF 
!                                                                       
!     compute coefficients with rounding of corners                     
!                                                                       
      BETA = 0.5D+00 
      CALL AKIMA1 (NI, XN, FN, NK, BETA, B, C, D, ISWTCH, HELP, IERR) 
!                                                                       
!     output with rounded corners                                       
!                                                                       
      WRITE ( *, 2090) 
      WRITE ( *, 2005) 
      DO 30, I = 0, NI 
         WRITE ( *, 2010) I, XN (I), FN (I) 
   30 END DO 
!                                                                       
!    output                                                             
!                                                                       
      IF (IERR.EQ.0) THEN 
         WRITE ( *, 2020) 
         DO 40, I = 0, NI - 1 
   40    WRITE ( *, 2030) I, FN (I), B (I), C (I), D (I) 
!                                                                       
! in case of desired table of values 'uncomment' these lines:           
!                                                                       
!        OPEN(2, FILE='RUNDUNG')                                        
!        REWIND(2)                                                      
!        XSCH = (XN(NI)-XN(0))/150.0D0                                  
!        XA = XN(0)  - 0.5D0*XSCH                                       
!        XE = XN(NI) + XSCH                                             
!        DO 222 X=XA, XE+0.5D0*XSCH, XSCH                               
!           WRITE(2,'(1X,2(F10.5,2X))') X, SPVAL(X,NI,XN,FN,B,C,D)      
! 222       CONTINUE                                                    
!        CLOSE(2)                                                       
!                                                                       
      ELSE 
         WRITE ( *, 2040) 
         IF (IERR.EQ. - 1) THEN 
            WRITE ( *, 2050) 
         ELSEIF (IERR.EQ. - 2) THEN 
            WRITE ( *, 2060) 
         ELSEIF (IERR.EQ. - 3) THEN 
            WRITE ( *, 2070) 
         ELSEIF (IERR.EQ. - 4) THEN 
            WRITE ( *, 2080) 
         ENDIF 
      ENDIF 
 2000 FORMAT ( 1X,'C[', T66, ']*', /,                                   &
     &         1X,'C[ TEST EXAMPLE:', T66, ']*', /,                     &
     &         1X,'C[ ', 13('='), T66, ']*', /,                         &
     &         1X,'C[', T66, ']*', /,                                   &
     &         1X,'C[ NODES WITHOUT ROUNDING OF CORNERS:', T66, ']*')   
 2005 FORMAT ( 1X,'C[', T66, ']*', /,                                   &
     &         1X,'C[  I', 5X, ' X(I)', 7X, ' Y(I)', T66, ']*', /,      &
     &         1X,'C[ ', 26('-'), T66, ']*')                            
 2010 FORMAT ( 1X,'C[ ', I2, 3X, F9.5, 3X, F9.5, T66, ']*') 
 2020 FORMAT ( 1X,'C[', T66, ']*', /,                                   &
     &         1X,'C[ AKIMA SPLINE COEFFICIENTS:', T66, ']*', /,        &
     &         1X,'C[', T66, ']*', /,                                   &
     &         1X,'C[  I', 7X, ' FN(I)', 8X, ' B(I)', 9X, ' C(I)', 9X,  &
     &            ' D(I)', T66, ']*', /,                                &
     &         1X,'C[ ', 58('-'), T66, ']*')                            
 2030 FORMAT ( 1X,'C[ ', I2, 4X, F10.6, 4X, F10.6, 4X, F10.6, 4X,       &
     &             F10.6, T66, ']*')                                    
 2040 FORMAT ( 1X,'C[', T66, ']*', /,                                   &
     &         1X,1X,'C[ ERROR IN AKIMA!', T66, ']*')                   
 2050 FORMAT ( 1X,'C[ LESS THAN  4 NODES!', T66, ']*') 
 2060 FORMAT ( 1X,'C[ NODES NOT MONOTONIC!',                            &
     &            T66, ']*')                                            
 2070 FORMAT ( 1X,'C[ FIRST AND LAST NODE DO NOT COINCIDE!',            &
     &            T66, ']*')                                            
 2080 FORMAT ( 1X,'C[ NK TOO SMALL!', T66, ']*') 
 2090 FORMAT ( 1X,'C[', T66, ']*', /,                                   &
     &         1X,'C[', T66, ']*', /,                                   &
     &         1X,'C[ NODES AFTER ROUNDING OF CORNERS:', T66, ']*')     
      STOP 
      END PROGRAM TEST                              
