# Disable warnings for macros redefined here that were given
# on the command line.
__.SILENT := $(.SILENT)
.SILENT   := yes

# Configuration parameters for DMAKE startup.mk file
# Set these to NON-NULL if you wish to turn the parameter on.
_HAVE_RCS	:= yes		# yes => RCS  is installed.
_HAVE_SCCS	:= 		# yes => SCCS is installed.

# Applicable suffix definitions
A := .lib	# Libraries
E := .exe	# Executables
O := .obj	# Objects
S := .asm	# Assembler sources

# See if these are defined
.IMPORT .IGNORE : COMSPEC TMPDIR SHELL

# Recipe execution configurations
SHELL      := $(COMSPEC)
SHELLFLAGS := /c
SHELLMETAS := *"?<>|%][

# Group recipes always with Bourne shell
GROUPSHELL  := $(SHELL)
GROUPFLAGS  :=
GROUPSUFFIX := cmd

# Standard C-language command names and flags
# optimize:
   CC      := bcc		# C-compiler and flags
   CFLAGS   =

   AS       = $(CC)		# Assembler and flags
   ASFLAGS  =

   LD       = $(CC)		# Loader and flags
   LDFLAGS  =
   LDLIBS   =

   RC       = brcc		# Ressource compiler

# Definition of $(MAKE) macro for recursive makes.
   MAKE	   = $(MAKECMD) $(MFLAGS)

# Language and Parser generation Tools and their flags
   YACC	  := bison		# standard yacc
   YFLAGS  = -y
   YTAB	  := y_tab		# yacc output files name stem.

   LEX	  := flex		# standard lex
   LFLAGS  =
   LEXYY  := lexyy		# lex output file

# Other Compilers, Tools and their flags
   CO	   := co		# check out for RCS
   COFLAGS := -q

   AR      := ar		# archiver
   ARFLAGS = u

   RM	   := erase		# remove a file command
   RMFLAGS  =

# Implicit generation rules for making inferences.
# We don't provide .yr or .ye rules here.  They're obsolete.
# Rules for making *$O
   %$O : %.cpp ; $(CC) -c -o$@ $(CFLAGS)  $<
   %$O : %.c   ; $(CC) -c -o$@ $(CFLAGS)  $<
   %$O : %$S   ; $(CC) -c -o$@ $(ASFLAGS) $<
   %.o : %.c   ; $(CC) -c -o $@ $(CFLAGS)  $<

# Ressource files
   %.res : %.rc ; $(RC) -r $< $@

# Executables
   %$E : %$O ;
	$(CC) -e$@ $(LDFLAGS) $< $(LDLIBS)

# lex and yacc rules
   %.c : %.y 
	$(YACC)  $(YFLAGS) $<
	mv $(YTAB).c $@
   %.cc : %.l
	$(LEX)   $(LFLAGS) $<
	mv $(LEXYY).c $@
   %.c : %.l
	$(LEX)   $(LFLAGS) $<
	mv $(LEXYY).c $@
   %.pc : %.py 
	$(YACC)  $(YFLAGS) $<
	mv $(YTAB).c $@

# RCS support
.IF $(_HAVE_RCS)
   % : $$(@:d)RCS.DIR/$$(@:f),v ; $(CO) $(COFLAGS) $@ $(@:d)RCS.DIR/$(@:f),v
   .NOINFER : $$(@:d)RCS.DIR/$$(@:f),v

   % : $$(@:d)RCS.DIR/$$(@:f) ; $(CO) $(COFLAGS) $@ $(@:d)RCS.DIR/$(@:f)
   .NOINFER : $$(@:d)RCS.DIR/$$(@:f)

   % : %,v ; $(CO) $(COFLAGS) $@ %,v
   .NOINFER : %,v
.END

# SCCS support
.IF $(_HAVE_SCCS)
   % : s.% ; get $@
   .NOINFER : s.%
.END

# Recipe to make archive files.
  %$A : ; $(AR) $(ARFLAGS) $@ $? $(AR) s $@

# DMAKE uses this recipe to remove intermediate targets
.REMOVE : ; $(RM) $(RMFLAGS) $<

# AUGMAKE extensions for SYSV compatibility
"@B" = $(@:b)
"@D" = $(@:d)
"@F" = $(@:f)
"*B" = $(*:b)
"*D" = $(*:d)
"*F" = $(*:f)
"<B" = $(<:b)
"<D" = $(<:d)
"<F" = $(<:f)
"?B" = $(?:b)
"?F" = $(?:f)
"?D" = $(?:d)

# Turn warnings back to previous setting.
.SILENT := $(__.SILENT)

# Local init file if any, gets parsed before user makefile
.INCLUDE .IGNORE: "_startup.mk"

##########################################################

# .IF $O == .obj
#   CFLAGS += -Zomf
#   LDFLAGS += -Zomf
# .END
