C[BA*)
C[LE*)
      SUBROUTINE CFSPTR (N,XN,FN,W,MS,PX,PY,A,B,C,D,PHIN,R,PHIR,
C[IX{CFSPTR}*)
     +                   AUXF,IERR)
C
C*****************************************************************
C                                                                *
C  CFSPTR computes the coefficients A(I), B(I), C(I), D(I) for   *
C  I=0, 1, ..., N-1 of a transformed parametric cubic fitting    *
C  spline for a closed smooth curve K.                           *
C[BE*)
C  The program initially uses the given points XN(I),FN(I) to    *
C  compute the transformed coordinates PHIN(I),R(I) for I=0,...,N*
C  which serve as nodes for computing a nonparametric periodic   *
C  fitting spline S(PHI).                                        *
C  S(PHI) is represented in the form:                            *
C                                                                *
C  S(PHI) = A(I) + B(I)(PHI-PHIN(I)) + C(I)(PHI-PHIN(I))**2 +    *
C                                    + D(I)(PHI-PHIN(I))**3      *
C                                                                *
C  for PHI in the interval [PHIN(I),PHIN(I+1)], I=0,1,...,N-1.   *
C                                                                *
C  Since the transformed nodes PHIN(I) must be ordered strictly  *
C  monotonically, we must shift the origin to a point P = (PX,PY)*
C  and rotate the plane by an angle PHIR depending on the        *
C  original location of the points XN(I),FN(I) in order to       *
C  compute PHIN(I).                                              *
C  In order to be able to achieve this strict momotonicity of the*
C  PHIN(I) the following conditions must be satisfied by the     *
C  original points:                                              *
C   - the new origin P must be situated on the surface F         *
C     generated by the points XN(I),FN(I) so that every polar    *
C     ray from P cuts the boundary curve of F only once.         *
C     (The coordinates (PX,PY) of P can be specified by the      *
C     user, refer to input parameter MS.)                        *
C   - the points XN(I),FN(I) must be ordered counterclockwise    *
C     on the boundary curve of F, beginning with XN(0),FN(0).    *
C     If periodicity of S(PHI) is desired, the end point         *
C     XN(N),FN(N) must be equal to the starting point XN(0),FN(0)*
C  The coordinates of PHIN(I),R(I) are computed as follows:      *
C         PHIN(0) = 0,                                           *
C         PHIN(I) = DATAN(Y'(I)/X'(I)) - PHIR , I=1, ..., N-1,   *
C         PHIN(N) = 2*PI,                                        *
C         R(I) = DSQRT(X'(I)**2 + Y'(I)**2), I=0, 1, ..., N,     *
C         where:  PHIR = DATAN(FN(0)/XN(0)),                     *
C                 X'(I) = XN(I) - PX,  Y'(I) = FN(I) - PY.       *
C                                                                *
C                                                                *
C  REMARK:  The curve K can be found using subroutine TSPANA.    *
C  =======  To find a table of values for K one can use the      *
C           subroutine TSPTAB.                                   *
C           Both subroutines use the values for PX, PY and       *
C           PHIR as computed in this program in order to         *
C           recompute the coordinates.                           *
C                                                                *
C                                                                *
C  ASSUMPTIONS:    1.         N > 5                              *
C  ============    2.     XN(0) = XN(N)                          *
C                  3.     FN(0) = FN(N)                          *
C                  4.      W(I) > 0.0   , I=0, 1, ..., N         *
C                  5.      W(0) = W(N)                           *
C                                                                *
C                                                                *
C  INPUT PARAMETERS:                                             *
C  =================                                             *
C  N  :  Index of the last node                                  *
C  XN :  vector XN(0:N); the nodes XN(I) , I = 0, 1, ..., N      *
C  FN :  vector FN(0:N); the data points FN(I) at XN(I)          *
C  W  :  vector W(0:N);  the weights W(I) of the data points     *
C                        FN(I)                                   *
C                                                                *
C  MS :  label for the shift or translation of the origin:       *
C        MS > 0 : the user specifies the coordinates PX,PY       *
C        MS = 0 : no translation, i.e., PX = PY = 0              *
C        MS < 0 : the translation coordinates PX,PY are computed *
C                 by CFSPTR as follows:                          *
C                    PX = (XMAX+XMIN)/2                          *
C                    PY = (YMAX+YMIN)/2                          *
C                    where : XMAX = MAX(XN(I)) ]                 *
C                            XMIN = MIN(XN(I)) ] for I=0, 1, ...,*
C                            YMAX = MAX(FN(I)) ]       N         *
C                            YMIN = MIN(FN(I)) ]                 *
C                 NOTE: This does not insure that P will satisfy *
C                       the conditions mentioned earlier, i.e.,  *
C                       IERR = -4 might occur.                   *
C                                                                *
C  PX : ]  coordinaten of P                                      *
C  PY : ]  (for MS > 0)                                          *
C                                                                *
C                                                                *
C  AUXILIARY VARIABLES:                                          *
C  ====================                                          *
C  AUXF :  vector AUXF(1:14*N-10)                                *
C                                                                *
C                                                                *
C  OUTPUT PARAMETERS:                                            *
C  ==================                                            *
C  A    :  Vector A(0:N) ]  The entries in positions 0 to N-1    *
C  B    :  Vector B(0:N) ]  contain the spline coefficients for  *
C  C    :  Vector C(0:N) ]  S(PHI). The entries in A(N), B(N),   *
C  D    :  Vector D(0:N) ]  C(N) and D(N) are auxiliary          *
C                        ]  variables.                           *
C                                                                *
C  PHIN :  vector PHIN(0:N)   PHIN(I) measures the polar angle of*
C                             the point (XN(I),FN(I)) from the   *
C                             center P=(PX,PY)                   *
C  R    :  vector R(0:N);  R(I) is the length of the vector      *
C                          joining P and PHIN(I)                 *
C  PX   : ] coordinates of the center P                          *
C  PY   : ]                                                      *
C  PHIR :  angle in radian measure of the rotation used          *
C  IERR :  error parameter                                       *
C          =  0 :  All is o.k.                                   *
C          = -1 :  N < 6                                         *
C          = -3 :  Inadmissable weight W                         *
C          = -4 :  The nodes PHIN(I)are not monotonically ordered*
C                  PHIN(I) >= PHIN(I+1) for some I=0,1,...,N-1   *
C          = -5 :  XN(0) not equal to XN(N)  or                  *
C                  FN(0) not equal to FN(N)  or                  *
C                   W(0) not equal to W(N)                       *
C          =  1 :  default in NCYFSY (system matrix is           *
C                  numerically singular)                         *
C                                                                *
C----------------------------------------------------------------*
C                                                                *
C  subroutines required: CFSPPE                                  *
C                                                                *
C*****************************************************************
C                                                                *
C  Author  : Gnter Palm                                         *
C  Date    : 04.18.1988                                          *
C  Source  : FORTRAN 77                                          *
C                                                                *
C[BA*)
C*****************************************************************
C[BE*)
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      DOUBLE PRECISION XN(0:N), FN(0:N), W(0:N), PHIN(0:N),
     +                 R(0:N), A(0:N), B(0:N), C(0:N), D(0:N),
     +                 AUXF(1:14*N-10)
C
C-----Checking the input
C
      IERR = -1
      IF (N .LT. 6) RETURN
      IF (XN(0) .NE. XN(N)) RETURN
      IF (FN(0) .NE. FN(N)) RETURN
      IF (W(0)  .NE. W(N))  RETURN
      DO 10 I=0,N,1
        IF (W(I) .LE. 0.0D0) THEN
          IERR = -3
          RETURN
        ENDIF
   10 CONTINUE
C
C-----Initializing
C
      PI  = 4.0D0*DATAN(1.0D0)
      PI2 = 2.0D0*PI
C
C-----Transformation of the coordinates
C
C     Translation of the origin to P = (PX,PY),
C     in case MS is not equal to 0, i.e., we subtract
C     PX and PY from X(I) and Y(I)
C
      IF (MS .EQ. 0) THEN
C
C       No shift
C
        PX = 0.0D0
        PY = 0.0D0
        DO 20 I=0,N,1
          B(I) = XN(I)
          C(I) = FN(I)
   20   CONTINUE
      ELSE
C
C       Shift the origin to (PX,PY)
C
        IF (MS .LT. 0) THEN
C
C         Compute PX and PY
C
          XMAX = XN(0)
          XMIN = XN(0)
          YMAX = FN(0)
          YMIN = FN(0)
          DO 30 I=1,N,1
            XMAX = DMAX1(XMAX,XN(I))
            XMIN = DMIN1(XMIN,XN(I))
            YMAX = DMAX1(YMAX,FN(I))
            YMIN = DMIN1(YMIN,FN(I))
   30     CONTINUE
          PX = (XMAX+XMIN)/2.0D0
          PY = (YMAX+YMIN)/2.0D0
        ENDIF
        DO 40 I=0,N,1
          B(I) = XN(I) - PX
          C(I) = FN(I) - PY
   40   CONTINUE
      ENDIF
C
C-----Compute the transformed nodes
C
C     1. Compute R(I); Stop if R(I)=0, for then the center
C        (PX,PY) is one of the nodes
C
      IERR = -4
      DO 50 I=0,N,1
        R(I) = DSQRT(B(I)*B(I) + C(I)*C(I))
        IF (R(I) .EQ. 0.0D0) RETURN
   50 CONTINUE
C
C     2. Compute the coordinates X', Y' after a rotation by ALPHA
C        using the equations
C
C           [ X']   [ COS(ALPHA)   -SIN(ALPHA) ] [ X ]
C           [   ] = [                          ] [   ]
C           [ Y']   [ SIN(ALPHA)    COS(ALPHA) ] [ Y ]
C
C        for ALPHA = -PHIR
C
      PHIR = DACOS(B(0)/R(0))
      IF (C(0) .LT. 0.0D0) PHIR = PI2 - PHIR
      CA = B(0)/R(0)
      SA = -C(0)/R(0)
      DO 60 I=0,N,1
        A(I) = B(I)*CA - C(I)*SA
        D(I) = B(I)*SA + C(I)*CA
   60 CONTINUE
C
C     3. Compute the angular coordinates PHIN(I); Stop if the
C        angles are not stictly monotonically increasing
C
      PHIN(0) = 0.0D0
      DO 70 I=1,N-1
        PHIN(I) = DACOS(A(I)/R(I))
        IF (D(I) .LT. 0.0D0) PHIN(I) = PI2 - PHIN(I)
        IF (PHIN(I) .LE. PHIN(I-1)) RETURN
   70 CONTINUE
      PHIN(N) = PI2
C
C-----Compute the spline coefficients
C
      CALL CFSPPE (N,PHIN,R,W,1,A,B,C,D,AUXF(1),AUXF(N+2),
     +             AUXF(2*N+3),AUXF(3*N+4),AUXF(4*N+5),
     +             AUXF(5*N+5),IERR)
      RETURN
      END
