      PROGRAM TEST
C
C                                                         91/06/15
C****************************************************************************
C                                                                           *
C  Test program for the subroutines  CURVP, DEBOOR and KNOTVO.              *
C  We compute a uniform open B-spline curve of order.                       *
C                                                                           *
C---------------------------------------------------------------------------*
C                                                                           *
C     The given parameters and the results are displayed on screen.         *
C                                                                           *
C---------------------------------------------------------------------------*
C                                                                           *
C     required subroutines    : CURVP, DEBOOR, KNOTVO                       *
C                                                                           *
C---------------------------------------------------------------------------*
C                                                                           *
C[ DESIRED NUMBER OF POINTS ON THE CURVE;                                  ]*
C[ WE COMPUTE MAXIMALLY NP+1 POINTS                                        ]*
C[ NP=  40                                                                 ]*
C[                                                                         ]*
C[ N  =  7  N+1 IS THE NUMBER OF DE BOOR POINTS                            ]*
C[                                                                         ]*
C[ M  =  2  DIMENSION FOR THE DE BOOR POINTS ( M >= 2 )                    ]*
C[                                                                         ]*
C[ K  =  4  ORDER OF THE B-SPLINE CURVE                                    ]*
C[         ( 3 <= K <= N+1 )                                               ]*
C[                                                                         ]*
C[ DP : 2-DIM. DOUBLE PRECISION ARRAY (0:N,1:M) WITH N+1 DE BOOR POINTS    ]*
C[                                                                         ]*
C[        I   |  X(I)  |  Y(I)  |                                          ]*
C[       ------------------------                                          ]*
C[        1   |    3.0 |   -1.0 |                                          ]*
C[        2   |     .0 |    5.0 |                                          ]*
C[        3   |    6.0 |    7.0 |                                          ]*
C[        4   |   15.0 |    4.0 |                                          ]*
C[        5   |   15.0 |   -2.0 |                                          ]*
C[        6   |    6.0 |   -2.0 |                                          ]*
C[        7   |    4.0 |    4.0 |                                          ]*
C[        8   |     .0 |     .0 |                                          ]*
C[                                                                         ]*
C[ DESIRED:  B-SPLINE CURVE                                                ]*
C[ ========                                                                ]*
C[                                                                         ]*
C[                                                                         ]*
C[ SOLUTION:  POINTS OF THE B-SPLINE CURVE                                 ]*
C[ ========                                                                ]*
C[                                                                         ]*
C[        I   |        XP(I)         |         YP(I)       |               ]*
C[      ----------------------------------------------------               ]*
C[        1   |    .300000000000D+01 |  -.100000000000D+01 |               ]*
C[        2   |    .214453125009D+01 |   .102343749997D+01 |               ]*
C[        3   |    .178125000070D+01 |   .262499999977D+01 |               ]*
C[        4   |    .183984375000D+01 |   .385156250000D+01 |               ]*
C[        5   |    .225000000559D+01 |   .474999999814D+01 |               ]*
C[        6   |    .294140624127D+01 |   .536718750291D+01 |               ]*
C[        7   |    .384375000000D+01 |   .575000000000D+01 |               ]*
C[        8   |    .488671871577D+01 |   .594531251141D+01 |               ]*
C[        9   |    .600000004470D+01 |   .599999998510D+01 |               ]*
C[       10   |    .712207031250D+01 |   .595410156244D+01 |               ]*
C[       11   |    .822656243853D+01 |   .582031252002D+01 |               ]*
C[       12   |    .929589850316D+01 |   .560449216561D+01 |               ]*
C[       13   |    .103125000000D+02 |   .531249999627D+01 |               ]*
C[       14   |    .112587891938D+02 |   .495019527455D+01 |               ]*
C[       15   |    .121171873771D+02 |   .452343754098D+01 |               ]*
C[       16   |    .128701171875D+02 |   .403808596032D+01 |               ]*
C[       17   |    .135000000894D+02 |   .349999994040D+01 |               ]*
C[       18   |    .139921874315D+02 |   .291699221032D+01 |               ]*
C[       19   |    .143437499993D+02 |   .230468754098D+01 |               ]*
C[       20   |    .145546875349D+02 |   .168066400709D+01 |               ]*
C[       21   |    .146249999721D+02 |   .106250000745D+01 |               ]*
C[       22   |    .145546875087D+02 |   .467773349956D+00 |               ]*
C[       23   |    .143437500056D+02 |  -.859374199063D-01 |               ]*
C[       24   |    .139921875328D+02 |  -.581054687034D+00 |               ]*
C[       25   |    .134999999553D+02 |  -.100000005960D+01 |               ]*
C[       26   |    .128720703125D+02 |  -.132714839187D+01 |               ]*
C[       27   |    .121328125615D+02 |  -.155468750000D+01 |               ]*
C[       28   |    .113115233718D+02 |  -.167675783578D+01 |               ]*
C[       29   |    .104375000000D+02 |  -.168749998510D+01 |               ]*
C[       30   |    .954003893118D+01 |  -.158105468750D+01 |               ]*
C[       31   |    .864843762293D+01 |  -.135156250373D+01 |               ]*
C[       32   |    .779199218750D+01 |  -.993164061569D+00 |               ]*
C[       33   |    .699999991059D+01 |  -.500000000000D+00 |               ]*
C[       34   |    .628906256845D+01 |   .116210937500D+00 |               ]*
C[       35   |    .562500000000D+01 |   .773437500000D+00 |               ]*
C[       36   |    .496093746508D+01 |   .137207031250D+01 |               ]*
C[       37   |    .425000002235D+01 |   .181250000000D+01 |               ]*
C[       38   |    .344531250000D+01 |   .199511718750D+01 |               ]*
C[       39   |    .249999999441D+01 |   .182031250000D+01 |               ]*
C[       40   |    .136718750140D+01 |   .118847656250D+01 |               ]*
C[       41   |    .000000000000D+00 |   .000000000000D+00 |               ]*
C                                                                           *
C****************************************************************************
C
      PARAMETER (N=7,K=4,M=2,NP=40)
      DOUBLE PRECISION DP(0:N,1:M),XP(1:NP+1,1:M),X(1:M)
      DOUBLE PRECISION D(1:K,1:M),E(1:K,1:M)
      INTEGER KV(1:N+K-1)
C
C     INITIALIZE TEST DATA; change if desired
C
      DATA (KV(J),J=1,N+K-1)/3,3,3,4,5,6,7,8,8,8/
      DATA ((DP(J,I),J=0,N),I=1,M)/3.D0,0.D0,6.D0,15.D0,15.D0,6.D0,4.D0,
     F                  0.D0,-1.D0,5.D0,7.D0,4.D0,-2.D0,-2.D0,4.D0,0.D0/
C
      NPI=MAX(NP,2*(N-K+2))
      CALL CURVP(NPI,N,M,K,KV,DP,X,XP,D,E,IERR,IX)
C
C     output of parameters
C
      WRITE(*,100)
      WRITE(*,200)
      WRITE(*,1600)'NP=',NPI
      WRITE(*,300)
      WRITE(*,1100)'N  =',N, '  N+1 IS THE NUMBER OF DE BOOR POINTS'
      WRITE(*,300)
      WRITE(*,1100)'M  =',M,
     +             '  DIMENSION FOR THE DE BOOR POINTS ( M >= 2 )'
      WRITE(*,300)
      WRITE(*,1100)'K  =',K, '  ORDER OF THE B-SPLINE CURVE'
      WRITE(*,400)
      WRITE(*,300)
      WRITE(*,500)
      WRITE(*,300)
      WRITE(*,1200)
      DO 10 I=0,N
         WRITE(*,1300)I+1,DP(I,1),DP(I,2)
 10   CONTINUE
      WRITE(*,300)
      WRITE(*,600)
      WRITE(*,300)
      WRITE(*,300)
      WRITE(*,800)
      WRITE(*,300)
      WRITE(*,900)
      WRITE(*,1000)
      DO 20 I=1,NP+1
         WRITE(*,1400)I,(XP(I,J),J=1,M)
  20  CONTINUE
      STOP
 100  FORMAT (1X, 'C[ DESIRED NUMBER OF POINTS ON THE ',
     +           'CURVE;', T77, ']*')
 200  FORMAT (1X, 'C[ WE COMPUTE MAXIMALLY NP+1 POINTS',T77,']*')
 300  FORMAT (1X, 'C[', T77, ']*')
 400  FORMAT (1X, 'C[         ( 3 <= K <= N+1 )', T77, ']*')
 500  FORMAT (1X, 'C[ DP : 2-DIM. DOUBLE PRECISION ARRAY (0:N,1:M) ',
     +            'WITH N+1 DE BOOR POINTS', T77, ']*')
 600  FORMAT (1X, 'C[ DESIRED:  B-SPLINE CURVE', T77, ']*',/,
     +        1X, 'C[ ========', T77, ']*')
 800  FORMAT (1X, 'C[ SOLUTION:  POINTS OF THE B-SPLINE CURVE',
     +            T77, ']*',/,
     +        1X, 'C[ ========', T77, ']*')
 900  FORMAT (1X, 'C[        I   |        XP(I)         |         ',
     +            'YP(I)       |', T77, ']*')
1000  FORMAT (1X, 'C[      ', 52('-'), T77, ']*')
1100  FORMAT(1X, 'C[ ', A, I3, A, T77, ']*')
1200  FORMAT(1X, 'C[        I   |  X(I)  |  Y(I)  |', T77, ']*', /,
     +       1X, 'C[       ------------------------', T77, ']*')
1300  FORMAT(1X, 'C[ ', 5X, I3, '   |', F07.1, ' |', F07.1, ' |',
     +           T77, ']*')
1400  FORMAT(1X, 'C[      ', I3, '   | ', D20.12, ' |', D20.12,
     +           ' |               ', T77, ']*')
1500  FORMAT(1X, 'C[ ', A, E12.2, A, T77, ']*')
1600  FORMAT(1X, 'C[ ', A, I4, T77, ']*')
      END
