      PROGRAM TEST
C
C     Test program for the  SUBROUTINE RENN3D        5.4.93
C                                                 (Andreas Sohn)
C
C*******************************************************************
C                                                                  *
C     Test results:                                                *
C                                                                  *
C                                                                  *
C[                                                                ]*
C[ TEST EXAMPLE:                                                  ]*
C[ =============                                                  ]*
C[                                                                ]*
C[ NODES WITHOUT ROUNDING OF CORNERS:                             ]*
C[                                                                ]*
C[  I      X(I)        Y(I)        Z(I)                           ]*
C[ --------------------------------------                         ]*
C[  0      .00000      .00000      .00000                         ]*
C[  1    10.00000      .00000      .00000                         ]*
C[  2    20.00000      .00000      .00000                         ]*
C[  3    20.00000    10.00000      .00000                         ]*
C[  4    20.00000    20.00000      .00000                         ]*
C[  5    20.00000    20.00000    10.00000                         ]*
C[  6    20.00000    20.00000    20.00000                         ]*
C[  7    20.00000    10.00000    20.00000                         ]*
C[  8    20.00000      .00000    20.00000                         ]*
C[  9    10.00000      .00000    20.00000                         ]*
C[ 10      .00000      .00000    20.00000                         ]*
C[ 11      .00000    10.00000    10.00000                         ]*
C[ 12      .00000      .00000      .00000                         ]*
C[                                                                ]*
C[ SPLINE COEFFICIENTS:                                           ]*
C[                                                                ]*
C[  I    TSUM(I)      XN(I)        B(I,1)      C(I,1)      D(I,1) ]*
C[ -------------------------------------------------------------- ]*
C[  0     .000000     .000000    1.000000     .000000     .000000 ]*
C[  1   10.000000   10.000000    1.000000     .000000     .000000 ]*
C[  2   20.000000   20.000000     .000000     .000000     .000000 ]*
C[  3   30.000000   20.000000     .000000     .000000     .000000 ]*
C[  4   40.000000   20.000000     .000000     .000000     .000000 ]*
C[  5   50.000000   20.000000     .000000     .000000     .000000 ]*
C[  6   60.000000   20.000000     .000000     .000000     .000000 ]*
C[  7   70.000000   20.000000     .000000     .000000     .000000 ]*
C[  8   80.000000   20.000000   -1.000000     .000000     .000000 ]*
C[  9   90.000000   10.000000   -1.000000     .000000     .000000 ]*
C[ 10  100.000000     .000000   -1.000000     .106419    -.002831 ]*
C[ 11  118.793563     .000000     .000000    -.053210     .002831 ]*
C[     137.587127                                                 ]*
C[                                                                ]*
C[ SPLINE COEFFICIENTS:                                           ]*
C[                                                                ]*
C[  I    TSUM(I)      YN(I)        B(I,2)      C(I,2)      D(I,2) ]*
C[--------------------------------------------------------------  ]*
C[  0     .000000     .000000     .000000     .000000     .000000 ]*
C[  1   10.000000     .000000     .000000     .000000     .000000 ]*
C[  2   20.000000     .000000    1.000000     .000000     .000000 ]*
C[  3   30.000000   10.000000    1.000000     .000000     .000000 ]*
C[  4   40.000000   20.000000     .000000     .000000     .000000 ]*
C[  5   50.000000   20.000000     .000000     .000000     .000000 ]*
C[  6   60.000000   20.000000   -1.000000     .000000     .000000 ]*
C[  7   70.000000   10.000000   -1.000000     .000000     .000000 ]*
C[  8   80.000000     .000000     .000000     .000000     .000000 ]*
C[  9   90.000000     .000000     .000000     .000000     .000000 ]*
C[ 10  100.000000     .000000     .000000     .084938    -.003013 ]*
C[ 11  118.793563   10.000000     .000000    -.084938     .003013 ]*
C[     137.587127                                                 ]*
C[                                                                ]*
C[ SPLINE COEFFICIENTS:                                           ]*
C[                                                                ]*
C[  I    TSUM(I)      ZN(I)        B(I,3)      C(I,3)      D(I,3) ]*
C[--------------------------------------------------------------  ]*
C[  0     .000000     .000000     .000000     .000000     .000000 ]*
C[  1   10.000000     .000000     .000000     .000000     .000000 ]*
C[  2   20.000000     .000000     .000000     .000000     .000000 ]*
C[  3   30.000000     .000000     .000000     .000000     .000000 ]*
C[  4   40.000000     .000000    1.000000     .000000     .000000 ]*
C[  5   50.000000   10.000000    1.000000     .000000     .000000 ]*
C[  6   60.000000   20.000000     .000000     .000000     .000000 ]*
C[  7   70.000000   20.000000     .000000     .000000     .000000 ]*
C[  8   80.000000   20.000000     .000000     .000000     .000000 ]*
C[  9   90.000000   20.000000     .000000     .000000     .000000 ]*
C[ 10  100.000000   20.000000     .000000    -.031728     .000182 ]*
C[ 11  118.793563   10.000000   -1.000000     .021481     .000182 ]*
C[     137.587127                                                 ]*
C[                                                                ]*
C[ SPLINE IS A CLOSED CURVE                                       ]*
C[                                                                ]*
C[                                                                ]*
C[ NODES AFTER ROUNDING OF CORNERS:                               ]*
C[                                                                ]*
C[                                                                ]*
C[  I      X(I)        Y(I)        Z(I)                           ]*
C[ --------------------------------------                         ]*
C[  0      .00000      .00000      .00000                         ]*
C[  1    10.00000      .00000      .00000                         ]*
C[  2    15.00000      .00000      .00000                         ]*
C[  3    20.00000     5.00000      .00000                         ]*
C[  4    20.00000    10.00000      .00000                         ]*
C[  5    20.00000    15.00000      .00000                         ]*
C[  6    20.00000    20.00000     5.00000                         ]*
C[  7    20.00000    20.00000    10.00000                         ]*
C[  8    20.00000    20.00000    15.00000                         ]*
C[  9    20.00000    15.00000    20.00000                         ]*
C[ 10    20.00000    10.00000    20.00000                         ]*
C[ 11    20.00000     5.00000    20.00000                         ]*
C[ 12    15.00000      .00000    20.00000                         ]*
C[ 13    10.00000      .00000    20.00000                         ]*
C[ 14      .00000      .00000    20.00000                         ]*
C[ 15      .00000    10.00000    10.00000                         ]*
C[ 16      .00000      .00000      .00000                         ]*
C[                                                                ]*
C[ SPLINE COEFFICIENTS:                                           ]*
C[                                                                ]*
C[  I    TSUM(I)      XN(I)        B(I,1)      C(I,1)      D(I,1) ]*
C[ -------------------------------------------------------------- ]*
C[  0     .000000     .000000    1.000000     .000000     .000000 ]*
C[  1   10.000000   10.000000    1.000000     .000000     .000000 ]*
C[  2   15.000000   15.000000    1.000000    -.010948    -.004497 ]*
C[  3   22.836116   20.000000     .000000     .000000     .000000 ]*
C[  4   27.836116   20.000000     .000000     .000000     .000000 ]*
C[  5   32.836116   20.000000     .000000     .000000     .000000 ]*
C[  6   40.672232   20.000000     .000000     .000000     .000000 ]*
C[  7   45.672232   20.000000     .000000     .000000     .000000 ]*
C[  8   50.672232   20.000000     .000000     .000000     .000000 ]*
C[  9   58.508349   20.000000     .000000     .000000     .000000 ]*
C[ 10   63.508349   20.000000     .000000     .000000     .000000 ]*
C[ 11   68.508349   20.000000     .000000    -.116667     .004497 ]*
C[ 12   76.344465   15.000000   -1.000000     .000000     .000000 ]*
C[ 13   81.344465   10.000000   -1.000000     .000000     .000000 ]*
C[ 14   91.344465     .000000   -1.000000     .106419    -.002831 ]*
C[ 15  110.138028     .000000     .000000    -.053210     .002831 ]*
C[     128.931592                                                 ]*
C[                                                                ]*
C[ SPLINE COEFFICIENTS:                                           ]*
C[                                                                ]*
C[  I    TSUM(I)      YN(I)        B(I,2)      C(I,2)      D(I,2) ]*
C[--------------------------------------------------------------  ]*
C[  0     .000000     .000000     .000000     .000000     .000000 ]*
C[  1   10.000000     .000000     .000000     .000000     .000000 ]*
C[  2   15.000000     .000000     .000000     .116667    -.004497 ]*
C[  3   22.836116    5.000000    1.000000     .000000     .000000 ]*
C[  4   27.836116   10.000000    1.000000     .000000     .000000 ]*
C[  5   32.836116   15.000000    1.000000    -.010948    -.004497 ]*
C[  6   40.672232   20.000000     .000000     .000000     .000000 ]*
C[  7   45.672232   20.000000     .000000     .000000     .000000 ]*
C[  8   50.672232   20.000000     .000000    -.116667     .004497 ]*
C[  9   58.508349   15.000000   -1.000000     .000000     .000000 ]*
C[ 10   63.508349   10.000000   -1.000000     .000000     .000000 ]*
C[ 11   68.508349    5.000000   -1.000000     .010948     .004497 ]*
C[ 12   76.344465     .000000     .000000     .000000     .000000 ]*
C[ 13   81.344465     .000000     .000000     .000000     .000000 ]*
C[ 14   91.344465     .000000     .000000     .084938    -.003013 ]*
C[ 15  110.138028   10.000000     .000000    -.084938     .003013 ]*
C[     128.931592                                                 ]*
C[                                                                ]*
C[ SPLINE COEFFICIENTS:                                           ]*
C[                                                                ]*
C[  I    TSUM(I)      ZN(I)        B(I,3)      C(I,3)      D(I,3) ]*
C[--------------------------------------------------------------  ]*
C[  0     .000000     .000000     .000000     .000000     .000000 ]*
C[  1   10.000000     .000000     .000000     .000000     .000000 ]*
C[  2   15.000000     .000000     .000000     .000000     .000000 ]*
C[  3   22.836116     .000000     .000000     .000000     .000000 ]*
C[  4   27.836116     .000000     .000000     .000000     .000000 ]*
C[  5   32.836116     .000000     .000000     .116667    -.004497 ]*
C[  6   40.672232    5.000000    1.000000     .000000     .000000 ]*
C[  7   45.672232   10.000000    1.000000     .000000     .000000 ]*
C[  8   50.672232   15.000000    1.000000    -.010948    -.004497 ]*
C[  9   58.508349   20.000000     .000000     .000000     .000000 ]*
C[ 10   63.508349   20.000000     .000000     .000000     .000000 ]*
C[ 11   68.508349   20.000000     .000000     .000000     .000000 ]*
C[ 12   76.344465   20.000000     .000000     .000000     .000000 ]*
C[ 13   81.344465   20.000000     .000000     .000000     .000000 ]*
C[ 14   91.344465   20.000000     .000000    -.031728     .000182 ]*
C[ 15  110.138028   10.000000   -1.000000     .021481     .000182 ]*
C[     128.931592                                                 ]*
C[                                                                ]*
C[ SPLINE IS A CLOSED CURVE                                       ]*
C                                                                  *
C*******************************************************************
C
      PARAMETER (N=12, NK=18)
      DOUBLE PRECISION XN(0:NK), YN(0:NK), ZN(0:NK), B(0:NK-1, 1:3),
     +  C(0:NK-1,1:3), D(0:NK-1,1:3), T(0:NK-1),
     +  HELP(-2:NK+1, 1:14), TSUM(0:NK), BETA
C
C     INITIALIZE DATA; CHANGE IF DESIRED
C
      DATA (XN(I),YN(I), ZN(I), I=0,N) 
     F           /  0.0D0 ,    0.0D0 ,    0.0D0 ,
     F             10.0D0 ,    0.0D0 ,    0.0D0 ,
     F             20.0D0 ,    0.0D0 ,    0.0D0 ,
     F             20.0D0 ,   10.0D0 ,    0.0D0 ,
     F             20.0D0 ,   20.0D0 ,    0.0D0 ,
     F             20.0D0 ,   20.0D0 ,   10.0D0 ,
     F             20.0D0 ,   20.0D0 ,   20.0D0 ,
     F             20.0D0 ,   10.0D0 ,   20.0D0 ,
     F             20.0D0 ,    0.0D0 ,   20.0D0 ,
     F             10.0D0 ,    0.0D0 ,   20.0D0 ,
     F              0.0D0 ,    0.0D0 ,   20.0D0 ,
     F              0.0D0 ,   10.0D0 ,   10.0D0 ,
     F              0.0D0 ,    0.0D0 ,    0.0D0 /
C
      NI = 12
C
C     output of nodes
C
      WRITE(*,2000)
      WRITE(*,2005)
      DO 10, I = 0,NI
         WRITE(*,2010) I,XN(I),YN(I),ZN(I)
   10 CONTINUE
C
C     computations with rounding of corners
C
      BETA = -0.5D+00
      CALL RENN3D(NI,XN,YN,ZN,NK,BETA,B,C,D,T,HELP,IMARK,IERR)
C
      IF (IERR .EQ. 0) THEN
         TSUM(0) = 0.0D+00
         DO 15 I = 1,NI
   15       TSUM(I) = TSUM(I-1) + T(I-1)
         WRITE(*,2020)
         DO 20,I = 0, NI-1
   20       WRITE(*,2030)I,TSUM(I),XN(I),B(I,1),C(I,1),D(I,1)
         WRITE(*,2031)TSUM(NI)
         WRITE(*,2025)
         DO 25,I = 0, NI-1
   25       WRITE(*,2030)I,TSUM(I),YN(I),B(I,2),C(I,2),D(I,2)
         WRITE(*,2031)TSUM(NI)
         WRITE(*,2026)
         DO 26,I = 0, NI-1
   26       WRITE(*,2030)I,TSUM(I),ZN(I),B(I,3),C(I,3),D(I,3)
         WRITE(*,2031)TSUM(NI)
         IF (IMARK .EQ. 0) THEN
            WRITE(*,2035)
         ELSE
            WRITE(*,2036)
         ENDIF
C
C use if table of values is desired
C  
C        OPEN(1, FILE='ORUNDUNG')
C        REWIND(1)
C        DO 1111, I = 0, NI-1
C           TSCH = T(I)/20.0D0
C           DO 111, TT=0.0D0, T(I)+TSCH*0.5D0, TSCH
C              WRITE(1,'(1X,4(F10.5,2X))')
C    F             TT, ((D(I,1)*TT + C(I,1))*TT + B(I,1))*TT + XN(I)
C    F               , ((D(I,2)*TT + C(I,2))*TT + B(I,2))*TT + YN(I)
C    F               , ((D(I,3)*TT + C(I,3))*TT + B(I,3))*TT + ZN(I)
C 111       CONTINUE
C1111    CONTINUE
C        CLOSE(1)
C
      ELSE
         WRITE(*,2040)
         IF (IERR .EQ. -1) THEN
            WRITE(*,2050)
         ELSEIF (IERR .EQ. -2) THEN
            WRITE(*,2060)
         ELSEIF (IERR .EQ. -3) THEN
            WRITE(*,2070)
         ENDIF
      ENDIF
C
C     Compute coefficients with rounding
C
      BETA = 0.5D+00
      CALL RENN3D(NI,XN,YN,ZN,NK,BETA,B,C,D,T,HELP,IMARK,IERR)
C
C     output of nodes
C
      WRITE (*,2090)
      WRITE (*,2005)
      DO 30, I = 0,NI
         WRITE(*,2010) I,XN(I),YN(I),ZN(I)
   30 CONTINUE
C
C     output of spline with rounding
C
      IF (IERR .EQ. 0) THEN
         TSUM(0) = 0.0D+00
         DO 35 I = 1,NI
   35       TSUM(I) = TSUM(I-1) + T(I-1)
         WRITE(*,2020)
         DO 40,I = 0, NI-1
   40       WRITE(*,2030)I,TSUM(I),XN(I),B(I,1),C(I,1),D(I,1)
         WRITE(*,2031)TSUM(NI)
         WRITE(*,2025)
         DO 45,I = 0, NI-1
   45       WRITE(*,2030)I,TSUM(I),YN(I),B(I,2),C(I,2),D(I,2)
         WRITE(*,2031)TSUM(NI)
         WRITE(*,2026)
         DO 46,I = 0, NI-1
   46       WRITE(*,2030)I,TSUM(I),ZN(I),B(I,3),C(I,3),D(I,3)
         WRITE(*,2031)TSUM(NI)
         IF (IMARK .EQ. 0) THEN
            WRITE(*,2035)
         ELSE
            WRITE(*,2036)
         ENDIF
C
C use if creating a table of values
C  
C        OPEN(2, FILE='RUNDUNG')
C        REWIND(2)
C        DO 2222, I = 0, NI-1
C           TSCH = T(I)/20.0D0
C           DO 222, TT=0.0D0, T(I)+TSCH*0.5D0, TSCH
C              WRITE(2,'(1X,4(F10.5,2X))')
C    F             TT, ((D(I,1)*TT + C(I,1))*TT + B(I,1))*TT + XN(I)
C    F               , ((D(I,2)*TT + C(I,2))*TT + B(I,2))*TT + YN(I)
C    F               , ((D(I,3)*TT + C(I,3))*TT + B(I,3))*TT + ZN(I)
C 222       CONTINUE
C2222    CONTINUE
C        CLOSE(2)
C
      ELSE
         WRITE(*,2040)
         IF (IERR .EQ. -1) THEN
            WRITE(*,2050)
         ELSEIF (IERR .EQ. -2) THEN
            WRITE(*,2060)
         ELSEIF (IERR .EQ. -3) THEN
            WRITE(*,2070)
         ENDIF
      ENDIF

 2000 FORMAT ( 1X,'C[', T68, ']*', /,
     +         1X,'C[ TEST EXAMPLE:', T68, ']*', /,
     +         1X,'C[ ', 13('='), T68, ']*', /,
     +         1X,'C[', T68, ']*', /,
     +         1X,'C[ NODES WITHOUT ROUNDING OF CORNERS:', T68, ']*')
 2005 FORMAT ( 1X,'C[', T68, ']*', /,
     +         1X,'C[  I',5X,' X(I)',7X,' Y(I)',7X,' Z(I)',T68,']*',/,
     +         1X,'C[ ', 38('-'), T68, ']*')
 2010 FORMAT ( 1X,'C[ ', I2, 3X, F9.5, 3X, F9.5, 3X, F9.5, T68, ']*')
 2020 FORMAT ( 1X,'C[', T68, ']*', /,
     +         1X,'C[ SPLINE COEFFICIENTS:', T68, ']*', /,
     +         1X,'C[', T68, ']*', /,
     +         1X,'C[  I', 4X, 'TSUM(I)', 6X, 'XN(I)', 8X, 'B(I,1)',
     +            5X, ' C(I,1)', 5X, ' D(I,1)', T68, ']*', /,
     +         1X,'C[ ', 62('-'), T68, ']*')
 2025 FORMAT ( 1X,'C[', T68, ']*', /,
     +         1X,'C[ SPLINE COEFFICIENTS:', T68, ']*', /,
     +         1X,'C[', T68, ']*', /,
     +         1X,'C[  I', 4X, 'TSUM(I)', 6X, 'YN(I)', 8X, 'B(I,2)',
     +            5X, ' C(I,2)', 5X, ' D(I,2)', T68, ']*', /,
     +         1X,'C[', 62('-'), T68, ']*')
 2026 FORMAT ( 1X,'C[', T68, ']*', /,
     +         1X,'C[ SPLINE COEFFICIENTS:', T68, ']*', /,
     +         1X,'C[', T68, ']*', /,
     +         1X,'C[  I', 4X, 'TSUM(I)', 6X, 'ZN(I)', 8X, 'B(I,3)',
     +            5X, ' C(I,3)', 5X, ' D(I,3)', T68, ']*', /,
     +         1X,'C[', 62('-'), T68, ']*')
 2030 FORMAT ( 1X,'C[ ', I2, 1X, F11.6, 1X, F11.6, 1X, F11.6, 1X,
     +            F11.6, 1X, F11.6, T68, ']*')
 2031 FORMAT ( 1X,'C[', 4X, F11.6, T68, ']*')
 2035 FORMAT ( 1X,'C[', T68, ']*', /,
     +         1X,'C[ SPLINE IS NOT CLOSED', T68,']*')
 2036 FORMAT ( 1X,'C[', T68, ']*', /,
     +         1X,'C[ SPLINE IS A CLOSED CURVE', T68, ']*')
 2040 FORMAT ( 1X,'C[', T68, ']*', /,
     +         1X,'C[ ERROR IN RENNER!', T68, ']*')
 2050 FORMAT ( 1X,'C[ LESS THAN  4 NODES!', T68, ']*')
 2060 FORMAT ( 1X,'C[ TWO ADJACENT NODES ARE IDENTICAL!',
     +            T68, ']*')
 2070 FORMAT ( 1X,'C[ NK TOO SMALL!', T68, ']*')
 2090 FORMAT ( 1X,'C[', T68, ']*', /,
     +         1X,'C[', T68, ']*', /,
     +         1X,'C[ NODES AFTER ROUNDING OF CORNERS:', T68, ']*', /,
     +         1X,'C[', T68, ']*')
      STOP
      END
