      PROGRAM TEST 
!***********************************************************************
!                                                                       
!  Test progrmm for the subroutine   SHPLOK.                            
!  Computes points on the surface which is generated via a local        
!  Shepard interpolation.                                               
!                                                                       
!-----------------------------------------------------------------------
!                                                                       
!     The results are displayed on the screen for the following paramete
!     For IBM compatible PCs and the MICROSOFT FORTRAN 5.0 Compiler the 
!     following results are computed:                                   
!                                                                       
!-----------------------------------------------------------------------
!                                                                       
!     Required subroutine:  SHPLOK                                      
!                                                                       
!-----------------------------------------------------------------------
!                                                                       
!   GIVEN:                                                              
!   ======                                                              
!    DMUE = 3      : Exponent                                           
!    N    = 11     : Index of final node                                
!    RR   = 1.3D0  : Radius                                             
!                                                                       
!            FX           |            FY         |           FZ        
!   ====================================================================
!   -.80000000000000D+00  |   .15000000000000D+01 |  .10535653752853D+01
!    .20000000000000D+00  |   .13000000000000D+01 |  .15066519173319D+01
!    .10000000000000D+01  |   .14000000000000D+01 |  .10198039027186D+01
!   -.12000000000000D+01  |   .30000000000000D+00 |  .15716233645502D+01
!   -.20000000000000D+00  |   .20000000000000D+00 |  .19798989873223D+01
!    .10000000000000D+01  |   .10000000000000D+01 |  .14142135623731D+01
!   -.80000000000000D+00  |  -.30000000000000D+00 |  .18083141320025D+01
!    .50000000000000D+00  |  -.40000000000000D+00 |  .18947295321496D+01
!    .15000000000000D+01  |  -.30000000000000D+00 |  .12884098726725D+01
!   -.11000000000000D+01  |  -.14000000000000D+01 |  .91104335791443D+00
!    .50000000000000D+00  |  -.17000000000000D+01 |  .92736184954957D+00
!    .13000000000000D+01  |  -.14000000000000D+01 |  .59160797830996D+00
!                                                                       
!                                                                       
![                                                                      
![  WANTED TO FIND: POINTS THAT LIE ON THE SURFACE GENERATED BY LOCAL   
![  ==============  SHEPARD INTERPOLATION                               
![                                                                      
![                                                                      
![  SOLUTION: POINTS ON THE INTERPOLATING SURFACE                       
![  ========                                                            
![                                                                      
![                                                                      
![           X           |          Y           |          Z            
![  =====================+======================+====================== 
![  -.20000000000000D+01 | -.20000000000000D+01 |  .91104335791443D+00  
![  -.20000000000000D+01 | -.15000000000000D+01 |  .91104335791443D+00  
![  -.20000000000000D+01 | -.10000000000000D+01 |  .18083085711203D+01  
![  -.20000000000000D+01 | -.50000000000000D+00 |  .11384020964843D+01  
![  -.20000000000000D+01 |  .00000000000000D+00 |  .18062496535501D+01  
![  -.20000000000000D+01 |  .50000000000000D+00 |  .15716233645502D+01  
![  -.20000000000000D+01 |  .10000000000000D+01 |  .10608628333816D+01  
![  -.20000000000000D+01 |  .15000000000000D+01 |  .10535653752853D+01  
![  -.20000000000000D+01 |  .20000000000000D+01 |  .10535653752853D+01  
![  -.15000000000000D+01 | -.20000000000000D+01 |  .91104335791443D+00  
![  -.15000000000000D+01 | -.15000000000000D+01 |  .18083141017122D+01  
![  -.15000000000000D+01 | -.10000000000000D+01 |  .15719981268057D+01  
![  -.15000000000000D+01 | -.50000000000000D+00 |  .11101925581107D+01  
![  -.15000000000000D+01 |  .00000000000000D+00 |  .19798122675951D+01  
![  -.15000000000000D+01 |  .50000000000000D+00 |  .19455881511099D+01  
![  -.15000000000000D+01 |  .10000000000000D+01 |  .12066299352840D+01  
![  -.15000000000000D+01 |  .15000000000000D+01 |  .15704390801140D+01  
![  -.15000000000000D+01 |  .20000000000000D+01 |  .10535653752853D+01  
![  -.10000000000000D+01 | -.20000000000000D+01 |  .91104335791443D+00  
![  -.10000000000000D+01 | -.15000000000000D+01 |  .18083097671647D+01  
![  -.10000000000000D+01 | -.10000000000000D+01 |  .15716908896080D+01  
![  -.10000000000000D+01 | -.50000000000000D+00 |  .17880134966360D+01  
![  -.10000000000000D+01 |  .00000000000000D+00 |  .19719045260876D+01  
![  -.10000000000000D+01 |  .50000000000000D+00 |  .12753208574191D+01  
![  -.10000000000000D+01 |  .10000000000000D+01 |  .17802815433097D+01  
![  -.10000000000000D+01 |  .15000000000000D+01 |  .15391337869611D+01  
![  -.10000000000000D+01 |  .20000000000000D+01 |  .15066518659742D+01  
![  -.50000000000000D+00 | -.20000000000000D+01 |  .92530295547279D+00  
![  -.50000000000000D+00 | -.15000000000000D+01 |  .17701548567182D+01  
![  -.50000000000000D+00 | -.10000000000000D+01 |  .15884211959133D+01  
![  -.50000000000000D+00 | -.50000000000000D+00 |  .13476945722186D+01  
![  -.50000000000000D+00 |  .00000000000000D+00 |  .18805412966065D+01  
![  -.50000000000000D+00 |  .50000000000000D+00 |  .18924522634074D+01  
![  -.50000000000000D+00 |  .10000000000000D+01 |  .18078996445226D+01  
![  -.50000000000000D+00 |  .15000000000000D+01 |  .15731941704258D+01  
![  -.50000000000000D+00 |  .20000000000000D+01 |  .14952369055267D+01  
![   .00000000000000D+00 | -.20000000000000D+01 |  .91105293566254D+00  
![   .00000000000000D+00 | -.15000000000000D+01 |  .71433494207928D+00  
![   .00000000000000D+00 | -.10000000000000D+01 |  .60377794218241D+00  
![   .00000000000000D+00 | -.50000000000000D+00 |  .92923043152975D+00  
![   .00000000000000D+00 |  .00000000000000D+00 |  .15137619736936D+01  
![   .00000000000000D+00 |  .50000000000000D+00 |  .10382408374616D+01  
![   .00000000000000D+00 |  .10000000000000D+01 |  .15716111628263D+01  
![   .00000000000000D+00 |  .15000000000000D+01 |  .19659702910887D+01  
![   .00000000000000D+00 |  .20000000000000D+01 |  .10266368191777D+01  
![   .50000000000000D+00 | -.20000000000000D+01 |  .59204331296902D+00  
![   .50000000000000D+00 | -.15000000000000D+01 |  .18316741840800D+01  
![   .50000000000000D+00 | -.10000000000000D+01 |  .19797937566681D+01  
![   .50000000000000D+00 | -.50000000000000D+00 |  .16945525393952D+01  
![   .50000000000000D+00 |  .00000000000000D+00 |  .16560458174202D+01  
![   .50000000000000D+00 |  .50000000000000D+00 |  .12883428161754D+01  
![   .50000000000000D+00 |  .10000000000000D+01 |  .10535693378470D+01  
![   .50000000000000D+00 |  .15000000000000D+01 |  .10537454531881D+01  
![   .50000000000000D+00 |  .20000000000000D+01 |  .10535685262532D+01  
![   .10000000000000D+01 | -.20000000000000D+01 |  .69850283513427D+00  
![   .10000000000000D+01 | -.15000000000000D+01 |  .13504018029383D+01  
![   .10000000000000D+01 | -.10000000000000D+01 |  .12530977866490D+01  
![   .10000000000000D+01 | -.50000000000000D+00 |  .19788209332109D+01  
![   .10000000000000D+01 |  .00000000000000D+00 |  .19502419827245D+01  
![   .10000000000000D+01 |  .50000000000000D+00 |  .18904317641754D+01  
![   .10000000000000D+01 |  .10000000000000D+01 |  .14142135623731D+01  
![   .10000000000000D+01 |  .15000000000000D+01 |  .15014935549423D+01  
![   .10000000000000D+01 |  .20000000000000D+01 |  .14718739973080D+01  
![   .15000000000000D+01 | -.20000000000000D+01 |  .92007780001373D+00  
![   .15000000000000D+01 | -.15000000000000D+01 |  .12587780710804D+01  
![   .15000000000000D+01 | -.10000000000000D+01 |  .12006134907053D+01  
![   .15000000000000D+01 | -.50000000000000D+00 |  .14992966245433D+01  
![   .15000000000000D+01 |  .00000000000000D+00 |  .15933828534551D+01  
![   .15000000000000D+01 |  .50000000000000D+00 |  .18933431878228D+01  
![   .15000000000000D+01 |  .10000000000000D+01 |  .14610489205025D+01  
![   .15000000000000D+01 |  .15000000000000D+01 |  .15066012480327D+01  
![   .15000000000000D+01 |  .20000000000000D+01 |  .14019002881686D+01  
![   .20000000000000D+01 | -.20000000000000D+01 |  .59160797830996D+00  
![   .20000000000000D+01 | -.15000000000000D+01 |  .12880729538318D+01  
![   .20000000000000D+01 | -.10000000000000D+01 |  .10221543992261D+01  
![   .20000000000000D+01 | -.50000000000000D+00 |  .59361631953948D+00  
![   .20000000000000D+01 |  .00000000000000D+00 |  .12884098726725D+01  
![   .20000000000000D+01 |  .50000000000000D+00 |  .10216009703111D+01  
![   .20000000000000D+01 |  .10000000000000D+01 |  .12884087859626D+01  
![   .20000000000000D+01 |  .15000000000000D+01 |  .13317961741912D+01  
![   .20000000000000D+01 |  .20000000000000D+01 |  .10198039027186D+01  
!                                                                       
!***********************************************************************
!                                                                       
      IMPLICIT DOUBLEPRECISION (A - H, O - Z) 
      PARAMETER (N = 11) 
      DIMENSION FX (0:N), FY (0:N), FZ (0:N), W (0:N), R (0:N), PPHI (0:&
      N)                                                                
      DATA FX / - .8D+00, .2D+00, .1D+01, - .12D+01, - .2D+00, .1D+01,  &
      - .8D+00, .5D+00, .15D+01, - .11D+01, .5D+00, .13D+01 /           
      DATA FY / .15D+01, .13D+01, .14D+01, .3D+00, .2D+00, .1D+01,      &
      - .3D+00, - .4D+00, - .3D+00, - .14D+01, - .17D+01, - .14D+01 /   
      DATA FZ / .10535653752853D+01, .15066519173319D+01,               &
      .10198039027186D+01, .15716233645502D+01, .19798989873223D+01,    &
      .14142135623731D+01, .18083141320025D+01, .18947295321496D+01,    &
      .12884098726725D+01, .91104335791443D+00, .92736184954957D+00,    &
      .59160797830996D+00 /                                             
      DMUE = 3.d0 
      RR = 1.4d0 
      WRITE ( *, 890) 
      WRITE ( *, 910) 
      DO 10 X = - 2.D0, 2.D0, 0.5D0 
         DO 20 Y = - 2.D0, 2.D0, 0.5D0 
            CALL SHPLOK (X, Y, FX, FY, FZ, PPHI, W, R, N, DMUE, RR, PHI) 
            WRITE ( *, 900) X, Y, PHI 
   20    END DO 
   10 END DO 
      STOP 
  890 FORMAT(1X,'C[',T76,']*',                                          &
     &    /,1X,'C[',2X,'WANTED TO FIND: POINTS THAT LIE ON THE SURFACE' &
     &    ,' GENERATED BY LOCAL',T76,']*',                              &
     &    /,1X,'C[',2X,'==============  SHEPARD INTERPOLATION',T76,']*',&
     &    /,1X,'C[',T76,']*',                                           &
     &    /,1X,'C[',T76,']*',                                           &
     &    /,1X,'C[',2X,                                                 &
     &    'SOLUTION: POINTS ON THE INTERPOLATING SURFACE ',T76,']*',    &
     &    /,1X,'C[',2X,'========',T76,']*',                             &
     &    /,1X,'C[',T76,']*')                                           
  900 FORMAT(1X,'C[',2X,2(D20.14,1X,'|',1X),D20.14,T76,']*') 
  910 FORMAT(1X,'C[',T76,']*',                                          &
     &    /,1X,'C[',11X,'X',11X,'|',10X,'Y',11X,'|',10X,'Z',T76,']*',   &
     &    /,1X,'C[',2X,21('='),'+',22('='),'+',22('='),T76,']*')        
      END PROGRAM TEST                              
