      PROGRAM TEST 
!                                                                       
!***********************************************************************
!                Test program for the subroutines                      *
!                      PSPANA und SPLFVD                               *
!----------------------------------------------------------------------*
!     required subroutines    :  ISPLPA, ISPLPE, CYTSY,  CYTSYP,       *
!                                CYTSYS, PSPANA, SPLFVD, MACHPD        *
!----------------------------------------------------------------------*
!                                                                      *
!     We compute a parametric, periodic, interpolating cubic spline.   *
!                                                                      *
!     The results are stored on  TAPE3.                                *
!                                                                      *
![  TEST PROGRAM MPPSPANA:                                            ]*
![  ======================                                            ]*
![                                                                    ]*
![  A: RESULTS AT THE NODES T(I), I=0(1)12:                           ]*
![  ---------------------------------------                           ]*
![                                                                    ]*
![  1) FUNCTION VALUES OF THE SPLINES SX AND SY:                      ]*
![                                                                    ]*
![   I          SX                 SY                                 ]*
![  ----------------------------------------                          ]*
![   0    .3200000000D+02    .1500000000D+01                          ]*
![   1    .2500000000D+02    .2500000000D+01                          ]*
![   2    .1600000000D+02    .3200000000D+01                          ]*
![   3    .5000000000D+01    .3000000000D+01                          ]*
![   4   -.6000000000D+01    .3100000000D+01                          ]*
![   5   -.1800000000D+02    .1800000000D+01                          ]*
![   6   -.1600000000D+02   -.7000000000D+00                          ]*
![   7   -.1300000000D+02   -.2200000000D+01                          ]*
![   8   -.6000000000D+01   -.3400000000D+01                          ]*
![   9    .4000000000D+01   -.3100000000D+01                          ]*
![  10    .2100000000D+02   -.2500000000D+01                          ]*
![  11    .3300000000D+02   -.1100000000D+01                          ]*
![  12    .3200000000D+02    .1500000000D+01                          ]*
![                                                                    ]*
![                                                                    ]*
![  2) 1ST AND 2ND DERIVATIVES OF THE SPLINES SX AND SY:              ]*
![                                                                    ]*
![   I      ABLX(1)        ABLY(1)        ABLX(2)        ABLY(2)      ]*
![  --------------------------------------------------------------    ]*
![   0   -.645071D+00    .758479D+00   -.166378D+00   -.292001D+00    ]*
![   1   -.109147D+01   -.603148D-01    .401166D-01    .604111D-01    ]*
![   2   -.989092D+00    .805893D-01   -.174339D-01   -.291934D-01    ]*
![   3   -.925418D+00   -.551250D-01    .290091D-01    .452211D-02    ]*
![   4   -.130860D+01    .112649D+00   -.986753D-01    .259810D-01    ]*
![   5    .230161D+00   -.705206D+00    .353643D+00   -.161497D+00    ]*
![   6    .847657D+00   -.673674D+00    .321034D-01    .181195D+00    ]*
![   7    .934128D+00   -.298167D+00    .194581D-01    .427136D-01    ]*
![   8    .101951D+01   -.622353D-01    .458688D-02    .237264D-01    ]*
![   9    .936679D+00    .957449D-01   -.211462D-01    .785547D-02    ]*
![  10    .130463D+01   -.152486D+00    .644074D-01   -.370410D-01    ]*
![  11   -.185340D-01    .876368D+00   -.283449D+00    .207362D+00    ]*
![  12   -.645071D+00    .758479D+00   -.166378D+00   -.292001D+00    ]*
![                                                                    ]*
![                                                                    ]*
![  3) 1ST AND 2ND DERIVATIVES OF THE CURVE K:                        ]*
![                                                                    ]*
![   I          C1                 C2            IFEHL                ]*
![  --------------------------------------------------                ]*
![   0   -.1175808116D+01   -.1171860022D+01       0                  ]*
![   1    .5526001719D-01    .4884889735D-01       0                  ]*
![   2   -.8147807259D-01   -.3129280322D-01       0                  ]*
![   3    .5956771518D-01    .3262619838D-02       0                  ]*
![   4   -.8608378273D-01    .1021162170D-01       0                  ]*
![   5   -.3063962891D+01    .1740568788D+02       0                  ]*
![   6   -.7947476545D+00    .2876864162D+00       0                  ]*
![   7   -.3191929932D+00    .5606772011D-01       0                  ]*
![   8   -.6104411467D-01    .2309620272D-01       0                  ]*
![   9    .1022173719D+00    .1141707069D-01       0                  ]*
![  10   -.1168810704D+00   -.1733959641D-01       0                  ]*
![  11   -.4728426728D+02   -.3841313692D+05       0                  ]*
![  12   -.1175808116D+01   -.1171860022D+01       0                  ]*
![                                                                    ]*
![                                                                    ]*
![  B: 1ST AND 2ND DERIVATIVES OF THE CURVE K IN A REGION WITH LARGE  ]*
![     SLOPE:                                                         ]*
![  ----------------------------------------------------------------  ]*
![                                                                    ]*
![   I          TW                 C1                 C2        IFEHL ]*
![  ----------------------------------------------------------------- ]*
![   1    .4949567000D+02    .1902829151D+05   -.6289828370D+13   0   ]*
![   2    .4949568000D+02    .2124123045D+05   -.8749346855D+13   0   ]*
![   3    .4949569000D+02    .2403661274D+05   -.1267808434D+14   0   ]*
![   4    .4949570000D+02    .2767923301D+05   -.1935945856D+14   0   ]*
![   5    .4949571000D+02    .3262306499D+05   -.3169586081D+14   0   ]*
![   6    .4949572000D+02    .3971694415D+05   -.5719432786D+14   0   ]*
![   7    .4949573000D+02    .5075316763D+05   -.1193471783D+15   0   ]*
![   8    .4949574000D+02    .7028267269D+05   -.3169309971D+15   0   ]*
![   9    .4949575000D+02    .1142421896D+06   -.1361120834D+16   0   ]*
![  10    .4949576000D+02    .3050239968D+06   -.2590695460D+17   0   ]*
![  11    .4949577000D+02   -.4552798749D+06    .8614834068D+17   0   ]*
![  12    .4949578000D+02   -.1303558061D+06    .2022087345D+16   0   ]*
![  13    .4949579000D+02   -.7606789463D+05    .4018002250D+15   0   ]*
![  14    .4949580000D+02   -.5370289987D+05    .1413827467D+15   0   ]*
![  15    .4949581000D+02   -.4150106909D+05    .6524966264D+14   0   ]*
![  16    .4949582000D+02   -.3381744137D+05    .3530367118D+14   0   ]*
![  17    .4949583000D+02   -.2853450191D+05    .2120829399D+14   0   ]*
![  18    .4949584000D+02   -.2467915484D+05    .1372090984D+14   0   ]*
![  19    .4949585000D+02   -.2174161781D+05    .9381339408D+13   0   ]*
![  20    .4949586000D+02   -.1942900972D+05    .6694813585D+13   0   ]*
![                                                                    ]*
![                                                                    ]*
![  MEANING OF PARAMETER IFEHL:                                       ]*
![  ---------------------------                                       ]*
![                                                                    ]*
![  IFEHL = 0 : ALL OK                                                ]*
![  IFEHL = 1 : DUE TO ABLX(I)=0 NO VALUES FOR C1 AND C2 WERE COMPUTED]*
![  IFEHL = 2 : DUE TO ABS(ABLX(I)) <= 4*MACHINE CONSTANT THE VALUES  ]*
![              FOR C1 AND C2 ARE NOT VERY GOOD                       ]*
!                                                                      *
!***********************************************************************
!                                                                      *
!     Author      :  Gnter Palm                                       *
!     Date        :  5.20.1988                                         *
!     Source code :  FORTRAN 77                                        *
!                                                                      *
!***********************************************************************
!                                                                       
      IMPLICIT DOUBLEPRECISION (A - H, O - Z) 
      PARAMETER (N = 12, MT = 100) 
!                                                                       
      DIMENSION X (0:N), Y (0:N), T (0:N) 
      DIMENSION BX (0:N), CX (0:N), DX (0:N) 
      DIMENSION BY (0:N), CY (0:N), DY (0:N) 
      DIMENSION ALPHA (2), BETA (2) 
      DIMENSION ABLX (3, 0:N), ABLY (3, 0:N) 
      DIMENSION HILF (1:5 * N + 1) 
      DIMENSION C1 (0:N), C2 (0:N) 
      INTEGER IFEHL (0:N) 
!                                                                       
      DATA X / 32.0D0, 25.0D0, 16.0D0, 5.0D0, - 6.0D0, - 18.0D0,        &
      - 16.0D0, - 13.0D0, - 6.0D0, 4.0D0, 21.0D0, 33.0D0, 32.0D0 /      
      DATA Y / 1.5D0, 2.5D0, 3.2D0, 3.0D0, 3.1D0, 1.8D0, - 0.7D0,       &
      - 2.2D0, - 3.4D0, - 3.1D0, - 2.5D0, - 1.1D0, 1.5D0 /              
      DATA JT / 1 / 
      DATA IR / 4 / 
!                                                                       
      CALL ISPLPA (N, X, Y, T, JT, IR, ALPHA, BETA, BX, CX, DX, BY, CY, &
      DY, HILF, MARKE)                                                  
      IF (MARKE.NE.0) THEN 
         WRITE ( *, 1000) MARKE 
         STOP 
      ENDIF 
      OPEN (3, FILE = 'TAPE3') 
      REWIND (3) 
!                                                                       
      WRITE (3, 2000) 
      DO 100 K = 0, N, 1 
         CALL PSPANA (T (K), N, T, X, BX, CX, DX, Y, BY, CY, DY, SX, SY,&
         ABLX (1, K), ABLY (1, K), C1 (K), C2 (K), IFEHL (K) )          
         WRITE (3, 2010) K, SX, SY 
         IF (IFEHL (K) .EQ.1) THEN 
            C1 (K) = 9.99D+09 
            C2 (K) = 9.99D+09 
         ENDIF 
  100 END DO 
      WRITE (3, 2020) 
      DO 110 K = 0, N, 1 
         WRITE (3, 2030) K, ABLX (1, K), ABLY (1, K), ABLX (2, K),      &
         ABLY (2, K)                                                    
  110 END DO 
      WRITE (3, 2040) 
      DO 120 K = 0, N, 1 
         WRITE (3, 2050) K, C1 (K), C2 (K), IFEHL (K) 
  120 END DO 
      WRITE (3, 2060) 
      TW = 49.49566D0 
      H = 0.00001D0 
      DO 130 K = 1, 20, 1 
         TW = TW + H 
         CALL PSPANA (TW, N, T, X, BX, CX, DX, Y, BY, CY, DY, SX, SY,   &
         ABLX (1, 0), ABLY (1, 0), C1 (0), C2 (0), MARKE)               
         IF (MARKE.EQ.1) THEN 
            C1 (0) = 9.99D+09 
            C2 (0) = 9.99D+09 
         ENDIF 
         WRITE (3, 2070) K, TW, C1 (0), C2 (0), MARKE 
  130 END DO 
      WRITE (3, 2080) 
!                                                                       
      WRITE ( * , * ) ' PROGRAM RAN SUCCESSFULLY.' 
      WRITE ( * , * ) ' RESULTS ON TAPE3.' 
      STOP 
!                                                                       
 1000 FORMAT(' ERROR WHEN COMPUTING COEFFICIENTS.',/,                   &
     &       ' ERROR PARAMETER =',I4)                                   
 2000 FORMAT('C[  TEST PROGRAM MPPSPANA:',T71,']*',/,                   &
     &       'C[  ',22('='),T71,']*',/,                                 &
     &       'C[',T71,']*',/,                                           &
     &       'C[  A: RESULTS AT THE NODES T(I), ',                      &
     &       'I=0(1)12:',T71,']*',/,                                    &
     &       'C[  ',39('-'),T71,']*',/,                                 &
     &       'C[',T71,']*',/,                                           &
     &       'C[  1) FUNCTION VALUES OF THE SPLINES SX AND SY:',        &
     &       T71,']*',/,                                                &
     &       'C[',T71,']*',/,                                           &
     &       'C[   I',10X,'SX',17X,'SY',T71,']*',/,                     &
     &       'C[  ',40('-'),T71,']*')                                   
 2010 FORMAT('C[  ',I2,2(3X,D16.10),T71,']*') 
 2020 FORMAT('C[',T71,']*',/,                                           &
     &       'C[',T71,']*',/,                                           &
     &       'C[  2) 1ST AND 2ND DERIVATIVES OF THE SPLINES SX ',       &
     &       'AND SY:',T71,']*',/,                                      &
     &       'C[',T71,']*',/,                                           &
     &       'C[   I',6X,'ABLX(1)',8X,'ABLY(1)',8X,'ABLX(2)',8X,        &
     &       'ABLY(2)',T71,']*',/,                                      &
     &       'C[  ',62('-'),T71,']*')                                   
 2030 FORMAT('C[  ',I2,4(3X,D12.6),T71,']*') 
 2040 FORMAT('C[',T71,']*',/,                                           &
     &       'C[',T71,']*',/,                                           &
     &       'C[  3) 1ST AND 2ND DERIVATIVES OF THE CURVE K:',          &
     &       T71,']*',/,                                                &
     &       'C[',T71,']*',/,                                           &
     &       'C[   I',10X,'C1',17X,'C2',12X,'IFEHL',T71,']*',/,         &
     &       'C[  ',50('-'),T71,']*')                                   
 2050 FORMAT('C[  ',I2,2(3X,D16.10),7X,I1,T71,']*') 
 2060 FORMAT('C[',T71,']*',/,                                           &
     &       'C[',T71,']*',/,                                           &
     &       'C[  B: 1ST AND 2ND DERIVATIVES OF THE CURVE K IN A ',     &
     &       'REGION WITH LARGE',T71,']*',/,                            &
     &       'C[',5X,'SLOPE:',T71,']*',/,                               &
     &       'C[  ',64('-'),T71,']*',/,                                 &
     &       'C[',T71,']*',/,                                           &
     &       'C[   I',10X,'TW',17X,'C1',17X,'C2',8X,'IFEHL',T71,']*',/, &
     &       'C[  ',65('-'),T71,']*')                                   
 2070 FORMAT('C[  ',I2,3(3X,D16.10),3X,I1,T71,']*') 
 2080 FORMAT('C[',T71,']*',/,                                           &
     &       'C[',T71,']*',/,                                           &
     &       'C[  MEANING OF PARAMETER IFEHL:',T71,']*',/,              &
     &       'C[  ',27('-'),T71,']*',/,                                 &
     &       'C[',T71,']*',/,                                           &
     &       'C[  IFEHL = 0 : ALL OK',T71,']*',/,                       &
     &       'C[  IFEHL = 1 : DUE TO ABLX(I)=0 NO VALUES FOR ',         &
     &          'C1 AND C2 WERE COMPUTED',T71,']*',/,                   &
     &       'C[  IFEHL = 2 : DUE TO ABS(ABLX(I)) <= ',                 &
     &          '4*MACHINE CONSTANT THE VALUES',T71,']*',/,             &
     &       'C[',14X,'FOR C1 AND C2 ARE NOT VERY GOOD',T71,']*')       
      END PROGRAM TEST                              
