!                                                                       
!***********************************************************************
!   Test program for the subroutines BICSP1 and BSPVAL       85/03/29   
!                                                                       
!     ( Elmar Pohl )                                                    
!                                                                       
!                                                                       
!                                                                       
!     Test example for applications of BICSP1 and BSPVAL:               
!     Compute a bicubic spline with given end point derivatives;        
!     followed by interpolation at the centers of the partition.        
!                                                                       
!     (The output is designed for M <= 10 )                             
!                                                                       
![                                                                      
![ COMPUTE A BICUBIC SPLINE USING BICSP1                                
![ =====================================                                
![                                                                      
![ X COORDINATES OF THE NODES                                           
![ --------------------------                                           
![                                                                      
![    I     X(I)                                                        
![ -----------------                                                    
![    0    0.000D+00                                                    
![    1    1.000D+00                                                    
![    2    2.000D+00                                                    
![    3    3.400D+00                                                    
![    4    5.000D+00                                                    
![                                                                      
![ Y COORDINATES OF THE NODES                                           
![ --------------------------                                           
![                                                                      
![    I     Y(I)                                                        
![ -----------------                                                    
![    0   -1.500D+00                                                    
![    1    0.000D+00                                                    
![    2    1.000D+00                                                    
![    3    1.500D+00                                                    
![                                                                      
![ GIVEN FUNCTION VALUES A(I,K,0,0) = S( X(I),Y(K) )                    
![ -------------------------------------------------                    
![            0           1           2           3                     
![ ---------------------------------------------------------------------
![    0   0.000D+00   0.000D+00   0.000D+00   0.000D+00                 
![    1   7.074D-02   1.000D+00   5.403D-01   7.074D-02                 
![    2   2.829D-01   4.000D+00   2.161D+00   2.829D-01                 
![    3   8.177D-01   1.156D+01   6.246D+00   8.177D-01                 
![    4   1.768D+00   2.500D+01   1.351D+01   1.768D+00                 
![                                                                      
![ GIVEN END POINT DERIVATIVES                                          
![ A(I,K,1,0) = P(I,K) = DS/DX( X(I),Y(K) ) , I=0,N                     
![ ------------------------------------------------                     
![            0           1           2           3                     
![ ---------------------------------------------------------------------
![    0   0.000D+00   0.000D+00   0.000D+00   0.000D+00                 
![    4   7.074D-01   1.000D+01   5.403D+00   7.074D-01                 
![                                                                      
![ GIVEN END POINT DERIVATIVES                                          
![ A(I,K,0,1) = Q(I,K) = DS/DY( X(I),Y(K) ) , K=0,M                     
![ ------------------------------------------------                     
![            0           1           2           3           4         
![ ---------------------------------------------------------------------
![    0   0.000D+00   9.975D-01   3.990D+00   1.153D+01   2.494D+01     
![    3   0.000D+00  -9.975D-01  -3.990D+00  -1.153D+01  -2.494D+01     
![                                                                      
![ GIVEN MIXED HIGHER DERIVATIVES                                       
![ ------------------------------                                       
![                                                                      
![ A(0,0,1,1) = D2S/DXDY( X(0),Y(0) ) =  0.000D+00                      
![ A(N,0,1,1) = D2S/DXDY( X(N),Y(0) ) =  9.975D+00                      
![ A(0,M,1,1) = D2S/DXDY( X(0),Y(M) ) =  0.000D+00                      
![ A(N,M,1,1) = D2S/DXDY( X(N),Y(M) ) = -9.975D+00                      
![                                                                      
![ COEFFICIENT ARRAYS A(I,J,K,L)                                        
![ =============================                                        
![ ( I IS THE ROW INDEX AND J IS THE COLUMN INDEX )                     
![                                                                      
![ COEFFICIENTS OF (X-X(I)) **  0 * (Y-Y(J)) **  1  :  A(I,J,  0,  1) = 
![ ---------------------------------------------------------------------
![            0           1           2                                 
![ ---------------------------------------------------------------------
![    0   0.000D+00   0.000D+00   0.000D+00                             
![    1   9.975D-01   9.918D-03  -8.381D-01                             
![    2   3.990D+00   3.967D-02  -3.353D+00                             
![    3   1.153D+01   1.147D-01  -9.689D+00                             
![                                                                      
![ COEFFICIENTS OF (X-X(I)) **  0 * (Y-Y(J)) **  2  :  A(I,J,  0,  2) = 
![ ---------------------------------------------------------------------
![            0           1           2                                 
![ ---------------------------------------------------------------------
![    0   0.000D+00   0.000D+00   0.000D+00                             
![    1  -9.759D-02  -5.608D-01  -2.873D-01                             
![    2  -3.904D-01  -2.243D+00  -1.149D+00                             
![    3  -1.128D+00  -6.483D+00  -3.321D+00                             
![                                                                      
![ COEFFICIENTS OF (X-X(I)) **  0 * (Y-Y(J)) **  3  :  A(I,J,  0,  3) = 
![ ---------------------------------------------------------------------
![            0           1           2                                 
![ ---------------------------------------------------------------------
![    0   0.000D+00   0.000D+00   0.000D+00                             
![    1  -1.029D-01   9.118D-02   1.705D-01                             
![    2  -4.117D-01   3.647D-01   6.821D-01                             
![    3  -1.190D+00   1.054D+00   1.971D+00                             
![                                                                      
![ COEFFICIENTS OF (X-X(I)) **  1 * (Y-Y(J)) **  0  :  A(I,J,  1,  0) = 
![ ---------------------------------------------------------------------
![            0           1           2                                 
![ ---------------------------------------------------------------------
![    0   0.000D+00   0.000D+00   0.000D+00                             
![    1   1.415D-01   2.000D+00   1.081D+00                             
![    2   2.829D-01   4.000D+00   2.161D+00                             
![    3   4.810D-01   6.800D+00   3.674D+00                             
![                                                                      
![ COEFFICIENTS OF (X-X(I)) **  1 * (Y-Y(J)) **  1  :  A(I,J,  1,  1) = 
![ ---------------------------------------------------------------------
![            0           1           2                                 
![ ---------------------------------------------------------------------
![    0   0.000D+00   0.000D+00   0.000D+00                             
![    1   1.995D+00   1.984D-02  -1.676D+00                             
![    2   3.990D+00   3.967D-02  -3.353D+00                             
![    3   6.783D+00   6.744D-02  -5.699D+00                             
![                                                                      
![ COEFFICIENTS OF (X-X(I)) **  1 * (Y-Y(J)) **  2  :  A(I,J,  1,  2) = 
![ ---------------------------------------------------------------------
![            0           1           2                                 
![ ---------------------------------------------------------------------
![    0   0.000D+00   0.000D+00   0.000D+00                             
![    1  -1.952D-01  -1.122D+00  -5.745D-01                             
![    2  -3.904D-01  -2.243D+00  -1.149D+00                             
![    3  -6.636D-01  -3.813D+00  -1.953D+00                             
![                                                                      
![ COEFFICIENTS OF (X-X(I)) **  1 * (Y-Y(J)) **  3  :  A(I,J,  1,  3) = 
![ ---------------------------------------------------------------------
![            0           1           2                                 
![ ---------------------------------------------------------------------
![    0   0.000D+00   0.000D+00   0.000D+00                             
![    1  -2.059D-01   1.824D-01   3.411D-01                             
![    2  -4.117D-01   3.647D-01   6.821D-01                             
![    3  -7.000D-01   6.200D-01   1.160D+00                             
![                                                                      
![ COEFFICIENTS OF (X-X(I)) **  2 * (Y-Y(J)) **  0  :  A(I,J,  2,  0) = 
![ ---------------------------------------------------------------------
![            0           1           2                                 
![ ---------------------------------------------------------------------
![    0   7.074D-02   1.000D+00   5.403D-01                             
![    1   7.074D-02   1.000D+00   5.403D-01                             
![    2   7.074D-02   1.000D+00   5.403D-01                             
![    3   7.074D-02   1.000D+00   5.403D-01                             
![                                                                      
![ COEFFICIENTS OF (X-X(I)) **  2 * (Y-Y(J)) **  1  :  A(I,J,  2,  1) = 
![ ---------------------------------------------------------------------
![            0           1           2                                 
![ ---------------------------------------------------------------------
![    0   9.975D-01   9.918D-03  -8.381D-01                             
![    1   9.975D-01   9.918D-03  -8.381D-01                             
![    2   9.975D-01   9.918D-03  -8.381D-01                             
![    3   9.975D-01   9.918D-03  -8.381D-01                             
![                                                                      
![ COEFFICIENTS OF (X-X(I)) **  2 * (Y-Y(J)) **  2  :  A(I,J,  2,  2) = 
![ ---------------------------------------------------------------------
![            0           1           2                                 
![ ---------------------------------------------------------------------
![    0  -9.759D-02  -5.608D-01  -2.873D-01                             
![    1  -9.759D-02  -5.608D-01  -2.873D-01                             
![    2  -9.759D-02  -5.608D-01  -2.873D-01                             
![    3  -9.759D-02  -5.608D-01  -2.873D-01                             
![                                                                      
![ COEFFICIENTS OF (X-X(I)) **  2 * (Y-Y(J)) **  3  :  A(I,J,  2,  3) = 
![ ---------------------------------------------------------------------
![            0           1           2                                 
![ ---------------------------------------------------------------------
![    0  -1.029D-01   9.118D-02   1.705D-01                             
![    1  -1.029D-01   9.118D-02   1.705D-01                             
![    2  -1.029D-01   9.118D-02   1.705D-01                             
![    3  -1.029D-01   9.118D-02   1.705D-01                             
![                                                                      
![ COEFFICIENTS OF (X-X(I)) **  3 * (Y-Y(J)) **  0  :  A(I,J,  3,  0) = 
![ ---------------------------------------------------------------------
![            0           1           2                                 
![ ---------------------------------------------------------------------
![    0  -2.776D-17   0.000D+00   0.000D+00                             
![    1   0.000D+00  -4.441D-16  -4.441D-16                             
![    2   9.975D-18   1.223D-16  -2.983D-16                             
![    3   1.561D-17  -1.776D-15  -4.718D-16                             
![                                                                      
![ COEFFICIENTS OF (X-X(I)) **  3 * (Y-Y(J)) **  1  :  A(I,J,  3,  1) = 
![ ---------------------------------------------------------------------
![            0           1           2                                 
![ ---------------------------------------------------------------------
![    0  -2.220D-16   1.214D-16  -2.220D-16                             
![    1  -4.441D-16  -3.816D-16   1.332D-15                             
![    2  -7.117D-16  -1.702D-16  -2.368D-16                             
![    3  -2.776D-17  -8.795D-16   2.942D-15                             
![                                                                      
![ COEFFICIENTS OF (X-X(I)) **  3 * (Y-Y(J)) **  2  :  A(I,J,  3,  2) = 
![ ---------------------------------------------------------------------
![            0           1           2                                 
![ ---------------------------------------------------------------------
![    0   3.608D-16   2.220D-16  -4.441D-16                             
![    1   5.551D-17   4.441D-16   1.332D-15                             
![    2  -3.358D-17  -4.611D-15   3.372D-15                             
      PROGRAM TEST 
![    3   1.037D-15   3.303D-15   3.386D-15                             
![                                                                      
![ COEFFICIENTS OF (X-X(I)) **  3 * (Y-Y(J)) **  3  :  A(I,J,  3,  3) = 
![ ---------------------------------------------------------------------
![            0           1           2                                 
![ ---------------------------------------------------------------------
![    0  -5.551D-17  -2.220D-16  -8.882D-16                             
![    1   0.000D+00   2.220D-16  -4.441D-15                             
![    2  -3.388D-18   4.964D-16  -7.663D-16                             
![    3   3.678D-16  -1.277D-15   6.994D-15                             
![                                                                      
![ EXAMPLE FOR USE OF BSPVAL:                                           
![ ==========================                                           
![                                                                      
![ TABLE OF VALUES FOR S(X,Y) AT THE CENTERS (X,Y) OF THE RECTANGLES    
![ FOR THE MESH, I. E.,                                                 
![     X = ( X(I)+X(I-1) )/2 , I = 1(1)N                                
![     Y = ( Y(K)+Y(K-1) )/2 , K = 1(1)M                                
![            1           2           3                                 
![ ---------------------------------------------------------------------
![    1   1.801D-01   2.190D-01   7.887D-02                             
![    2   1.621D+00   1.971D+00   7.098D-01                             
![    3   5.253D+00   6.387D+00   2.300D+00                             
![    4   1.271D+01   1.546D+01   5.565D+00                             
!                                                                       
!***********************************************************************
!                                                                       
      IMPLICIT DOUBLEPRECISION (A - H, O - Z) 
!                                                                       
      PARAMETER (N = 4, M = 3, KDIM = 3, LDIM = 3) 
!                                                                       
      DIMENSION A (0:N, 0:M, 0:KDIM, 0:LDIM), X (0:N), Y (0:M) 
      DIMENSION F (50), XMIT (N), YMIT (N), ZMIT (N, M) 
!                                                                       
!     Variables for format statements                                   
!                                                                       
      CHARACTER FO1555 * 50, FO1560 * 50 
!                                                                       
! initialize mesh                                                       
!                                                                       
      DATA (X (I), I = 0, N) / 0.0D0, 1.0D0, 2.0D0, 3.4D0, 5.0D0 / 
      DATA (Y (I), I = 0, M) / - 1.5D0, 0.0D0, 1.0D0, 1.5D0 / 
                                                                        
!                                                                       
! compute function on the mesh                                          
!                                                                       
      DO 10 I = 0, N 
         DO 10 K = 0, M 
            A (I, K, 0, 0) = S (X (I), Y (K) ) 
   10 CONTINUE 
!                                                                       
! initialize partial derivative DS/DX                                   
!                                                                       
      DO 20 K = 0, M 
         A (0, K, 1, 0) = DSDX (X (0), Y (K) ) 
         A (N, K, 1, 0) = DSDX (X (N), Y (K) ) 
   20 END DO 
!                                                                       
! initialize partial derivative DS/DY                                   
!                                                                       
      DO 30 K = 0, N 
         A (K, 0, 0, 1) = DSDY (X (K), Y (0) ) 
         A (K, M, 0, 1) = DSDY (X (K), Y (M) ) 
   30 END DO 
!                                                                       
! initialize partial derivative D2S/DXDY                                
!                                                                       
      A (0, 0, 1, 1) = D2SXY (X (0), Y (0) ) 
      A (N, 0, 1, 1) = D2SXY (X (N), Y (0) ) 
      A (0, M, 1, 1) = D2SXY (X (0), Y (M) ) 
      A (N, M, 1, 1) = D2SXY (X (N), Y (M) ) 
!                                                                       
      WRITE ( *, 1520) 
      WRITE ( *, 1530) (I, X (I), I = 0, N) 
      WRITE ( *, 1540) (I, Y (I), I = 0, M) 
      WRITE ( *, 1550) 
      WRITE (FO1555, 1555) M + 1 
      WRITE ( *, FO1555) (I, I = 0, M) 
      WRITE ( *, 1556) 
      DO 40 I = 0, N 
         WRITE (FO1560, 1560) M + 1 
         WRITE ( *, FO1560) I, (A (I, K, 0, 0), K = 0, M) 
   40 END DO 
      WRITE ( *, 1570) 
      WRITE (FO1555, 1555) M + 1 
      WRITE ( *, FO1555) (I, I = 0, M) 
      WRITE ( *, 1556) 
      WRITE (FO1560, 1560) M + 1 
      WRITE ( *, FO1560) 0, (A (0, K, 1, 0), K = 0, M) 
      WRITE ( *, FO1560) N, (A (N, K, 1, 0), K = 0, M) 
      WRITE ( *, 1580) 
      WRITE (FO1555, 1555) N + 1 
      WRITE ( *, FO1555) (I, I = 0, N) 
      WRITE ( *, 1556) 
      WRITE (FO1560, 1560) N + 1 
      WRITE ( *, FO1560) 0, (A (I, 0, 0, 1), I = 0, N) 
      WRITE ( *, FO1560) M, (A (I, M, 0, 1), I = 0, N) 
      WRITE ( *, 1590) A (0, 0, 1, 1), A (N, 0, 1, 1), A (0, M, 1, 1),  &
      A (N, M, 1, 1)                                                    
!                                                                       
      CALL BICSP1 (N, M, A, X, Y, F, IFEHL) 
!                                                                       
      IF (IFEHL.NE.0) THEN 
         WRITE ( *, 1500) 
         STOP 
      ENDIF 
!                                                                       
      WRITE ( *, 1595) 
      DO 50 IX = 0, KDIM 
         DO 60 IY = 0, LDIM 
            IF (IX.EQ.0.AND.IY.EQ.0) GOTO 60 
            WRITE ( *, 1600) IX, IY, IX, IY 
            WRITE (FO1555, 1555) M 
            WRITE ( *, FO1555) (I, I = 0, M - 1) 
            WRITE ( *, 1556) 
            DO 70 I = 0, N - 1 
               WRITE (FO1560, 1560) M 
               WRITE ( *, FO1560) I, (A (I, K, IX, IY), K = 0, M - 1) 
   70       END DO 
   60    END DO 
   50 END DO 
!                                                                       
!                                                                       
!     Spline coefficients have been found;                              
!     next we apply BSPVAL:                                             
!     ------------------------------------                              
!                                                                       
!                                                                       
      DO 80 I = 1, N 
         XMIT (I) = 0.5D0 * (X (I) + X (I - 1) ) 
   80 END DO 
      DO 90 K = 1, M 
         YMIT (K) = 0.5D0 * (Y (K) + Y (K - 1) ) 
   90 END DO 
      DO 100 I = 1, N 
         DO 100 K = 1, M 
            CALL BSPVAL (N, M, A, X, Y, XMIT (I), YMIT (K), ZMIT (I, K),&
            J)                                                          
            IF (J.NE.0) THEN 
               WRITE ( *, 1510) 
               STOP 
            ENDIF 
  100 CONTINUE 
      WRITE ( *, 1610) 
      WRITE (FO1555, 1555) M 
      WRITE ( *, FO1555) (I, I = 1, M) 
      WRITE ( *, 1556) 
      DO 110 I = 1, N 
         WRITE (FO1560, 1560) M 
         WRITE ( *, FO1560) I, (ZMIT (I, K), K = 1, M) 
  110 END DO 
      STOP 
 1500 FORMAT(1X, 'C[', T75, ']*', /,                                    &
     &       1X, 'C[ *** ERROR IN BICSP1 ***', T75, ']*')               
 1510 FORMAT(1X, 'C[', T75, ']*', /,                                    &
     &       1X, 'C[ *** ERROR IN BSPVAL ***', T75, ']*')               
 1520 FORMAT(1X, 'C[', T75, ']*', /,                                    &
     &       1X, 'C[ COMPUTE A BICUBIC SPLINE USING BICSP1',            &
     &           T75, ']*', /,                                          &
     &       1X, 'C[ ', 37('='), T75, ']*')                             
!1530  FORMAT('X COORDINATES OF THE NODES',/,1X,31('-'),/,'0   I',      
!     1 5X,'X(I)',/,1X,17('-'),/,1P,(I4,3X,D10.3))                      
 1530 FORMAT(1X, 'C[', T75, ']*', /,                                    &
     &       1X, 'C[ X COORDINATES OF THE NODES', T75, ']*', /,         &
     &       1X, 'C[ ', 26('-'), T75, ']*', /,                          &
     &       1X, 'C[', T75, ']*', /,                                    &
     &       1X, 'C[    I', 5X, 'X(I)', T75, ']*', /,                   &
     &       1X, 'C[ ', 17('-'), T75, ']*', /,                          &
     &      (1X, 'C[ ', 1P, I4,3X,D10.3, T75, ']*'))                    
 1540 FORMAT(1X, 'C[', T75, ']*', /,                                    &
     &       1X, 'C[ Y COORDINATES OF THE NODES', T75, ']*', /,         &
     &       1X, 'C[ ', 26('-'), T75, ']*', /,                          &
     &       1X, 'C[', T75, ']*', /,                                    &
     &       1X, 'C[    I', 5X, 'Y(I)', T75, ']*', /,                   &
     &       1X, 'C[ ', 17('-'), T75, ']*', /,                          &
     &      (1X, 'C[ ', 1P, I4,3X,D10.3, T75, ']*'))                    
 1550 FORMAT(1X, 'C[', T75, ']*', /,                                    &
     &       1X, 'C[ GIVEN FUNCTION VALUES A(I,K,0,0) = S( X(I)',       &
     &           ',Y(K) )', T75, ']*', /,                               &
     &       1X, 'C[ ', 49('-'), T75, ']*')                             
 1555 FORMAT('(1X, ''C[ '',', I2, '(8X,I4), T75, '']*'')') 
 1556 FORMAT(1X, 'C[ ', 70('-'), T75, ']*') 
 1560 FORMAT('(1X, ''C[ '', I4, 1P, ', I2, '(2X,D10.3), T75, '']*'')') 
 1570 FORMAT(1X, 'C[', T75, ']*', /,                                    &
     &       1X, 'C[ GIVEN END POINT DERIVATIVES', T75, ']*', /,        &
     &       1X, 'C[ A(I,K,1,0) = P(I,K) = DS/DX( X(I),Y(K) ) , I=0,N', &
     &           T75, ']*', /,                                          &
     &       1X, 'C[ ', 48('-'), T75, ']*')                             
 1580 FORMAT(1X, 'C[', T75, ']*', /,                                    &
     &       1X, 'C[ GIVEN END POINT DERIVATIVES', T75, ']*', /,        &
     &       1X, 'C[ A(I,K,0,1) = Q(I,K) = DS/DY( X(I),Y(K) ) , K=0,M', &
     &           T75, ']*', /,                                          &
     &       1X, 'C[ ', 48('-'), T75, ']*')                             
 1590 FORMAT(1X, 'C[', T75, ']*', /,                                    &
     &       1X, 'C[ GIVEN MIXED HIGHER DERIVATIVES',                   &
     &           T75, ']*',/,                                           &
     &       1X, 'C[ ', 30('-'), T75, ']*', /,                          &
     &       1X, 'C[', T75, ']*', /,                                    &
     &       1X, 'C[ A(0,0,1,1) = D2S/DXDY( X(0),Y(0) ) = ', 1PD10.3,   &
     &           T75, ']*', /,                                          &
     &       1X, 'C[ A(N,0,1,1) = D2S/DXDY( X(N),Y(0) ) = ', D10.3,     &
     &           T75, ']*', /,                                          &
     &       1X, 'C[ A(0,M,1,1) = D2S/DXDY( X(0),Y(M) ) = ',D10.3,      &
     &           T75, ']*', /,                                          &
     &       1X, 'C[ A(N,M,1,1) = D2S/DXDY( X(N),Y(M) ) = ',D10.3,      &
     &           T75, ']*')                                             
 1595 FORMAT(1X, 'C[', T75, ']*', /,                                    &
     &       1X, 'C[ COEFFICIENT ARRAYS A(I,J,K,L)', T75, ']*', /,      &
     &       1X, 'C[ ', 29('='), T75, ']*', /,                          &
     &       1X, 'C[ ( I IS THE ROW INDEX AND J IS THE COLUMN ',        &
     &           'INDEX )', T75, ']*')                                  
 1600 FORMAT(1X, 'C[', T75, ']*', /,                                    &
     &       1X, 'C[ COEFFICIENTS OF (X-X(I)) **', I3,                  &
     &           ' * (Y-Y(J)) **', I3, '  :  A(I,J,', I3, ',', I3,      &
     &           ') = ', T75, ']*', /,                                  &
     &       1X, 'C[ ', 70('-'), T75, ']*')                             
 1610 FORMAT(1X, 'C[', T75, ']*', /,                                    &
     &       1X, 'C[ EXAMPLE FOR USE OF BSPVAL:',T75, ']*', /,          &
     &       1X, 'C[ ', 26('='), T75, ']*', /,                          &
     &       1X, 'C[', T75, ']*', /,                                    &
     &       1X, 'C[ TABLE OF VALUES FOR S(X,Y) AT THE CENTERS (X,Y) ', &
     &           'OF THE RECTANGLES', T75, ']*', /,                     &
     &       1X, 'C[ FOR THE MESH, I. E., ',T75, ']*', /,               &
     &       1X, 'C[     X = ( X(I)+X(I-1) )/2 , I = 1(1)N',T75, ']*',/,&
     &       1X, 'C[     Y = ( Y(K)+Y(K-1) )/2 , K = 1(1)M', T75, ']*') 
      END PROGRAM TEST                              
!                                                                       
      DOUBLEPRECISION FUNCTION S (X, Y) 
!                                                                       
!*****************************************************************      
!                                                                *      
!  compute functional values                                            
!                                                                *      
!*****************************************************************      
!                                                                       
      DOUBLEPRECISION X, Y 
      S = X * X * DCOS (Y) 
      RETURN 
      END FUNCTION S                                
!                                                                       
      DOUBLEPRECISION FUNCTION DSDX (X, Y) 
!                                                                       
!*****************************************************************      
!                                                                *      
!  compute DS/DX                                                        
!                                                                *      
!*****************************************************************      
!                                                                       
      DOUBLEPRECISION X, Y 
      DSDX = 2.0D+00 * X * DCOS (Y) 
      RETURN 
      END FUNCTION DSDX                             
!                                                                       
      DOUBLEPRECISION FUNCTION DSDY (X, Y) 
!                                                                       
!*****************************************************************      
!                                                                *      
!  compute DS/DY                                                        
!                                                                *      
!*****************************************************************      
!                                                                       
      DOUBLEPRECISION X, Y 
      DSDY = X * X * ( - DSIN (Y) ) 
      RETURN 
      END FUNCTION DSDY                             
!                                                                       
      DOUBLEPRECISION FUNCTION D2SXY (X, Y) 
!                                                                       
!*****************************************************************      
!                                                                *      
!  compute D2S/DXDY                                                     
!                                                                *      
!*****************************************************************      
!                                                                       
      DOUBLEPRECISION X, Y 
      D2SXY = 2.D0 * X * ( - DSIN (Y) ) 
      RETURN 
      END FUNCTION D2SXY                            
