!                                                                       
!***********************************************************************
!   Test program for the subroutines BICSP2 and BSPVAL      85/03/29    
!                                                                       
!     ( Elmar Pohl )                                                    
!                                                                       
!                                                                       
!                                                                       
!     Test example for using BICSP2 and BSPVAL:                         
!     Compute a bicubic spline.                                         
!                                                                       
!     (The output is designed for M <= 10)                              
!                                                                       
![                                                                      
![ COMPUTE A BICUBIC SPLINE USING BICSP2                                
![ =====================================                                
![                                                                      
![ X COORDINATES OF THE NODES                                           
![ --------------------------                                           
![                                                                      
![    I     X(I)                                                        
![ -----------------                                                    
![    0    0.000D+00                                                    
![    1    1.000D+00                                                    
![    2    2.000D+00                                                    
![    3    3.400D+00                                                    
![    4    5.000D+00                                                    
![                                                                      
![ Y COORDINATES OF THE NODES                                           
![ --------------------------                                           
![                                                                      
![    I     Y(I)                                                        
![ -----------------                                                    
![    0   -1.500D+00                                                    
![    1    0.000D+00                                                    
![    2    1.000D+00                                                    
![    3    1.500D+00                                                    
![                                                                      
![ GIVEN FUNCTION VALUES A(I,K,0,0) = S( X(I),Y(K) )                    
![ -------------------------------------------------                    
![            0           1           2           3                     
![ ---------------------------------------------------------------------
![    0   0.000D+00   0.000D+00   0.000D+00   0.000D+00                 
![    1   7.074D-02   1.000D+00   5.403D-01   7.074D-02                 
![    2   2.829D-01   4.000D+00   2.161D+00   2.829D-01                 
![    3   8.177D-01   1.156D+01   6.246D+00   8.177D-01                 
![    4   1.768D+00   2.500D+01   1.351D+01   1.768D+00                 
![                                                                      
![ COEFFICIENT ARRAYS A(I,J,K,L)                                        
![ =============================                                        
![ ( I IS THE ROW INDEX AND J IS THE COLUMN INDEX )                     
![                                                                      
![ COEFFICIENTS OF (X-X(I)) **  0 * (Y-Y(J)) **  1  :  A(I,J,  0,  1) = 
![ ---------------------------------------------------------------------
![            0           1           2                                 
![ ---------------------------------------------------------------------
![    0   0.000D+00   0.000D+00   0.000D+00                             
![    1   9.433D-01   1.907D-02  -8.325D-01                             
![    2   3.773D+00   7.627D-02  -3.330D+00                             
![    3   1.090D+01   2.204D-01  -9.623D+00                             
![                                                                      
![ COEFFICIENTS OF (X-X(I)) **  0 * (Y-Y(J)) **  2  :  A(I,J,  0,  2) = 
![ ---------------------------------------------------------------------
![            0           1           2                                 
![ ---------------------------------------------------------------------
![    0   0.000D+00   0.000D+00   0.000D+00                             
![    1  -3.139D-02  -5.847D-01  -2.668D-01                             
![    2  -1.256D-01  -2.339D+00  -1.067D+00                             
![    3  -3.628D-01  -6.760D+00  -3.084D+00                             
![                                                                      
![ COEFFICIENTS OF (X-X(I)) **  0 * (Y-Y(J)) **  3  :  A(I,J,  0,  3) = 
![ ---------------------------------------------------------------------
![            0           1           2                                 
![ ---------------------------------------------------------------------
![    0   0.000D+00   0.000D+00   0.000D+00                             
![    1  -1.230D-01   1.060D-01   1.070D-01                             
![    2  -4.919D-01   4.239D-01   4.279D-01                             
![    3  -1.422D+00   1.225D+00   1.237D+00                             
![                                                                      
![ COEFFICIENTS OF (X-X(I)) **  1 * (Y-Y(J)) **  0  :  A(I,J,  1,  0) = 
![ ---------------------------------------------------------------------
![            0           1           2                                 
![ ---------------------------------------------------------------------
![    0   3.537D-02   5.000D-01   2.702D-01                             
![    1   1.327D-01   1.876D+00   1.013D+00                             
![    2   2.828D-01   3.997D+00   2.160D+00                             
![    3   4.943D-01   6.987D+00   3.775D+00                             
![                                                                      
![ COEFFICIENTS OF (X-X(I)) **  1 * (Y-Y(J)) **  1  :  A(I,J,  1,  1) = 
![ ---------------------------------------------------------------------
![            0           1           2                                 
![ ---------------------------------------------------------------------
![    0   4.716D-01   9.533D-03  -4.162D-01                             
![    1   1.769D+00   3.576D-02  -1.561D+00                             
![    2   3.770D+00   7.621D-02  -3.328D+00                             
![    3   6.591D+00   1.332D-01  -5.817D+00                             
![                                                                      
![ COEFFICIENTS OF (X-X(I)) **  1 * (Y-Y(J)) **  2  :  A(I,J,  1,  2) = 
![ ---------------------------------------------------------------------
![            0           1           2                                 
![ ---------------------------------------------------------------------
![    0  -1.569D-02  -2.924D-01  -1.334D-01                             
![    1  -5.887D-02  -1.097D+00  -5.004D-01                             
![    2  -1.255D-01  -2.337D+00  -1.066D+00                             
![    3  -2.193D-01  -4.086D+00  -1.864D+00                             
![                                                                      
![ COEFFICIENTS OF (X-X(I)) **  1 * (Y-Y(J)) **  3  :  A(I,J,  1,  3) = 
![ ---------------------------------------------------------------------
![            0           1           2                                 
![ ---------------------------------------------------------------------
![    0  -6.148D-02   5.299D-02   5.349D-02                             
![    1  -2.307D-01   1.988D-01   2.007D-01                             
![    2  -4.915D-01   4.236D-01   4.276D-01                             
![    3  -8.592D-01   7.406D-01   7.476D-01                             
![                                                                      
![ COEFFICIENTS OF (X-X(I)) **  2 * (Y-Y(J)) **  0  :  A(I,J,  2,  0) = 
![ ---------------------------------------------------------------------
![            0           1           2                                 
![ ---------------------------------------------------------------------
![    0   8.793D-03   1.243D-01   6.716D-02                             
![    1   8.852D-02   1.251D+00   6.761D-01                             
![    2   6.155D-02   8.701D-01   4.701D-01                             
![    3   8.953D-02   1.266D+00   6.839D-01                             
![                                                                      
![ COEFFICIENTS OF (X-X(I)) **  2 * (Y-Y(J)) **  1  :  A(I,J,  2,  1) = 
![ ---------------------------------------------------------------------
![            0           1           2                                 
![ ---------------------------------------------------------------------
![    0   1.173D-01   2.370D-03  -1.035D-01                             
![    1   1.180D+00   2.386D-02  -1.042D+00                             
![    2   8.208D-01   1.659D-02  -7.244D-01                             
![    3   1.194D+00   2.413D-02  -1.054D+00                             
![                                                                      
![ COEFFICIENTS OF (X-X(I)) **  2 * (Y-Y(J)) **  2  :  A(I,J,  2,  2) = 
![ ---------------------------------------------------------------------
![            0           1           2                                 
![ ---------------------------------------------------------------------
![    0  -3.902D-03  -7.269D-02  -3.316D-02                             
![    1  -3.928D-02  -7.318D-01  -3.339D-01                             
![    2  -2.731D-02  -5.088D-01  -2.321D-01                             
![    3  -3.973D-02  -7.401D-01  -3.377D-01                             
![                                                                      
![ COEFFICIENTS OF (X-X(I)) **  2 * (Y-Y(J)) **  3  :  A(I,J,  2,  3) = 
![ ---------------------------------------------------------------------
![            0           1           2                                 
![ ---------------------------------------------------------------------
![    0  -1.529D-02   1.317D-02   1.330D-02                             
![    1  -1.539D-01   1.326D-01   1.339D-01                             
![    2  -1.070D-01   9.222D-02   9.309D-02                             
![    3  -1.556D-01   1.341D-01   1.354D-01                             
![                                                                      
![ COEFFICIENTS OF (X-X(I)) **  3 * (Y-Y(J)) **  0  :  A(I,J,  3,  0) = 
![ ---------------------------------------------------------------------
![            0           1           2                                 
![ ---------------------------------------------------------------------
![    0   2.658D-02   3.757D-01   2.030D-01                             
![    1  -8.990D-03  -1.271D-01  -6.867D-02                             
![    2   6.663D-03   9.419D-02   5.089D-02                             
![    3  -1.693D-02  -2.393D-01  -1.293D-01                             
![                                                                      
![ COEFFICIENTS OF (X-X(I)) **  3 * (Y-Y(J)) **  1  :  A(I,J,  3,  1) = 
![ ---------------------------------------------------------------------
![            0           1           2                                 
![ ---------------------------------------------------------------------
![    0   3.544D-01   7.163D-03  -3.128D-01                             
![    1  -1.199D-01  -2.423D-03   1.058D-01                             
![    2   8.885D-02   1.796D-03  -7.842D-02                             
![    3  -2.257D-01  -4.563D-03   1.992D-01                             
![                                                                      
![ COEFFICIENTS OF (X-X(I)) **  3 * (Y-Y(J)) **  2  :  A(I,J,  3,  2) = 
![ ---------------------------------------------------------------------
![            0           1           2                                 
![ ---------------------------------------------------------------------
![    0  -1.179D-02  -2.197D-01  -1.002D-01                             
![    1   3.989D-03   7.432D-02   3.391D-02                             
![    2  -2.957D-03  -5.508D-02  -2.513D-02                             
![    3   7.511D-03   1.399D-01   6.384D-02                             
![                                                                      
![ COEFFICIENTS OF (X-X(I)) **  3 * (Y-Y(J)) **  3  :  A(I,J,  3,  3) = 
![ ---------------------------------------------------------------------
![            0           1           2                                 
![ ---------------------------------------------------------------------
![    0  -4.620D-02   3.982D-02   4.019D-02                             
![    1   1.563D-02  -1.347D-02  -1.360D-02                             
![    2  -1.158D-02   9.983D-03   1.008D-02                             
![    3   2.943D-02  -2.536D-02  -2.560D-02                             
![                                                                      
![ EXAMPLE FOR USE OF BSPVAL:                                           
![ ==========================                                           
![                                                                      
![ TABLE OF VALUES FOR S(X,Y) AT THE CENTERS (X,Y) OF THE RECTANGLES    
![ FOR THE MESH, I. E.,                                                 
![     X = ( X(I)+X(I-1) )/2 , I = 1(1)N                                
![     Y = ( Y(K)+Y(K-1) )/2 , K = 1(1)M                                
![            1           2           3                                 
![ ---------------------------------------------------------------------
![    1   2.325D-01   2.876D-01   1.040D-01                             
![    2   1.584D+00   1.959D+00   7.088D-01                             
![    3   5.143D+00   6.361D+00   2.302D+00                             
![    4   1.264D+01   1.564D+01   5.658D+00                             
!                                                                       
      PROGRAM TEST 
!***********************************************************************
!                                                                       
      IMPLICIT DOUBLEPRECISION (A - H, O - Z) 
!                                                                       
      PARAMETER (N = 4, M = 3, KDIM = 3, LDIM = 3) 
!                                                                       
      DIMENSION A (0:N, 0:M, 0:KDIM, 0:LDIM), X (0:N), Y (0:M), F (80), &
      XMIT (N), YMIT (N), ZMIT (N, M)                                   
!                                                                       
!     VariableS FOR FORMAT STATEMENTS                                   
!                                                                       
      CHARACTER FO1555 * 50, FO1560 * 50 
!                                                                       
! INITIALIZE MESH                                                       
!                                                                       
      DATA (X (I), I = 0, N) / 0.0D0, 1.0D0, 2.0D0, 3.4D0, 5.0D0 / 
      DATA (Y (I), I = 0, M) / - 1.5D0, 0.0D0, 1.0D0, 1.5D0 / 
                                                                        
!                                                                       
! compute function values                                               
!                                                                       
      DO 10 I = 0, N 
         DO 10 K = 0, M 
            A (I, K, 0, 0) = S (X (I), Y (K) ) 
   10 CONTINUE 
!                                                                       
      WRITE ( *, 1520) 
      WRITE ( *, 1530) (I, X (I), I = 0, N) 
      WRITE ( *, 1540) (I, Y (I), I = 0, M) 
      WRITE ( *, 1550) 
      WRITE (FO1555, 1555) M + 1 
      WRITE ( *, FO1555) (I, I = 0, M) 
      WRITE ( *, 1556) 
      DO 20 I = 0, N 
         WRITE (FO1560, 1560) M + 1 
         WRITE ( *, FO1560) I, (A (I, K, 0, 0), K = 0, M) 
   20 END DO 
      CALL BICSP2 (N, M, A, X, Y, F, IFEHL) 
      IF (IFEHL.NE.0) THEN 
         WRITE ( *, 1500) 
         STOP 
      ENDIF 
      WRITE ( *, 1595) 
      DO 30 IX = 0, KDIM 
         DO 40 IY = 0, LDIM 
            IF (IX.EQ.0.AND.IY.EQ.0) GOTO 40 
            WRITE ( *, 1600) IX, IY, IX, IY 
            WRITE (FO1555, 1555) M 
            WRITE ( *, FO1555) (I, I = 0, M - 1) 
            WRITE ( *, 1556) 
            DO 50 I = 0, N - 1 
               WRITE (FO1560, 1560) M 
               WRITE ( *, FO1560) I, (A (I, K, IX, IY), K = 0, M - 1) 
   50       END DO 
   40    END DO 
   30 END DO 
!                                                                       
!                                                                       
!     coefficients for the spline have been computed;                   
!     next use  BSPVAL:                                                 
!     -----------------------------------------------                   
!                                                                       
!                                                                       
      DO 80 I = 1, N 
         XMIT (I) = 0.5D0 * (X (I) + X (I - 1) ) 
   80 END DO 
      DO 90 K = 1, M 
         YMIT (K) = 0.5D0 * (Y (K) + Y (K - 1) ) 
   90 END DO 
      DO 100 I = 1, N 
         DO 100 K = 1, M 
            CALL BSPVAL (N, M, A, X, Y, XMIT (I), YMIT (K), ZMIT (I, K),&
            J)                                                          
            IF (J.NE.0) THEN 
               WRITE ( *, 1510) 
               STOP 
            ENDIF 
  100 CONTINUE 
      WRITE ( *, 1610) 
      WRITE (FO1555, 1555) M 
      WRITE ( *, FO1555) (I, I = 1, M) 
      WRITE ( *, 1556) 
      DO 110 I = 1, N 
         WRITE (FO1560, 1560) M 
         WRITE ( *, FO1560) I, (ZMIT (I, K), K = 1, M) 
  110 END DO 
      STOP 
 1500 FORMAT(1X, 'C[', T75, ']*', /,                                    &
     &       1X, 'C[ *** ERROR IN BICSP2 ***', T75, ']*')               
 1510 FORMAT(1X, 'C[', T75, ']*', /,                                    &
     &       1X, 'C[ *** ERROR IN BSPVAL ***', T75, ']*')               
 1520 FORMAT(1X, 'C[', T75, ']*', /,                                    &
     &       1X, 'C[ COMPUTE A BICUBIC SPLINE USING BICSP2',            &
     &           T75, ']*', /,                                          &
     &       1X, 'C[ ', 37('='), T75, ']*')                             
 1530 FORMAT(1X, 'C[', T75, ']*', /,                                    &
     &       1X, 'C[ X COORDINATES OF THE NODES', T75, ']*', /,         &
     &       1X, 'C[ ', 26('-'), T75, ']*', /,                          &
     &       1X, 'C[', T75, ']*', /,                                    &
     &       1X, 'C[    I', 5X, 'X(I)', T75, ']*', /,                   &
     &       1X, 'C[ ', 17('-'), T75, ']*', /,                          &
     &      (1X, 'C[ ', 1P, I4,3X,D10.3, T75, ']*'))                    
 1540 FORMAT(1X, 'C[', T75, ']*', /,                                    &
     &       1X, 'C[ Y COORDINATES OF THE NODES', T75, ']*', /,         &
     &       1X, 'C[ ', 26('-'), T75, ']*', /,                          &
     &       1X, 'C[', T75, ']*', /,                                    &
     &       1X, 'C[    I', 5X, 'Y(I)', T75, ']*', /,                   &
     &       1X, 'C[ ', 17('-'), T75, ']*', /,                          &
     &      (1X, 'C[ ', 1P, I4,3X,D10.3, T75, ']*'))                    
 1550 FORMAT(1X, 'C[', T75, ']*', /,                                    &
     &       1X, 'C[ GIVEN FUNCTION VALUES A(I,K,0,0) = S( X(I)',       &
     &           ',Y(K) )', T75, ']*', /,                               &
     &       1X, 'C[ ', 49('-'), T75, ']*')                             
 1555 FORMAT('(1X, ''C[ '',', I2, '(8X,I4), T75, '']*'')') 
 1556 FORMAT(1X, 'C[ ', 70('-'), T75, ']*') 
 1560 FORMAT('(1X, ''C[ '', I4, 1P, ', I2, '(2X,D10.3), T75, '']*'')') 
 1595 FORMAT(1X, 'C[', T75, ']*', /,                                    &
     &       1X, 'C[ COEFFICIENT ARRAYS A(I,J,K,L)', T75, ']*', /,      &
     &       1X, 'C[ ', 29('='), T75, ']*', /,                          &
     &       1X, 'C[ ( I IS THE ROW INDEX AND J IS THE COLUMN ',        &
     &           'INDEX )', T75, ']*')                                  
 1600 FORMAT(1X, 'C[', T75, ']*', /,                                    &
     &       1X, 'C[ COEFFICIENTS OF (X-X(I)) **', I3,                  &
     &           ' * (Y-Y(J)) **', I3, '  :  A(I,J,', I3, ',', I3,      &
     &           ') = ', T75, ']*', /,                                  &
     &       1X, 'C[ ', 70('-'), T75, ']*')                             
 1610 FORMAT(1X, 'C[', T75, ']*', /,                                    &
     &       1X, 'C[ EXAMPLE FOR USE OF BSPVAL:',T75, ']*', /,          &
     &       1X, 'C[ ', 26('='), T75, ']*', /,                          &
     &       1X, 'C[', T75, ']*', /,                                    &
     &       1X, 'C[ TABLE OF VALUES FOR S(X,Y) AT THE CENTERS (X,Y) ', &
     &           'OF THE RECTANGLES', T75, ']*', /,                     &
     &       1X, 'C[ FOR THE MESH, I. E., ',T75, ']*', /,               &
     &       1X, 'C[     X = ( X(I)+X(I-1) )/2 , I = 1(1)N',T75, ']*',/,&
     &       1X, 'C[     Y = ( Y(K)+Y(K-1) )/2 , K = 1(1)M', T75, ']*') 
      END PROGRAM TEST                              
!                                                                       
      DOUBLEPRECISION FUNCTION S (X, Y) 
!                                                                       
!*****************************************************************      
!                                                                *      
!  compute functional values                                            
!                                                                *      
!*****************************************************************      
!                                                                       
      DOUBLEPRECISION X, Y 
      S = X * X * DCOS (Y) 
      RETURN 
      END FUNCTION S                                
